#ifndef INCLUDED_MAPS_H
#define INCLUDED_MAPS_H


#include "game.h"


typedef struct PRE_CLUB_MAP
{
	unsigned char tile[CM_MAP_H][CM_MAP_W];

	unsigned char vent_x[MAX_CLUB_VENTS];
	unsigned char vent_y[MAX_CLUB_VENTS];
	unsigned char vent_type[MAX_CLUB_VENTS];

	int n_lights;
	LIGHT *light; /* Here light[n].data holds the parameters for 'create'. */

	int n_squirrels;

	int dog_time;
}
PRE_CLUB_MAP;


typedef struct MAP
{
	int vmw, vmh;
	unsigned char *vent_map;

	unsigned char hotspot_club[MAX_HOTSPOTS];
	unsigned char hotspot_vent[MAX_HOTSPOTS];
	unsigned char hotspot_dir[MAX_HOTSPOTS];

	int n_club_maps;
	PRE_CLUB_MAP *club_map;

	int club; /* If the player stars in the air vents, this is -1. */

	int pl_layer; /* Not used if the player starts in a club. */
	int plx, ply;
	int pl_dir;

	int n_balls;
}
MAP;


int start_map(void);
void resume_map(void);
void end_map(void);


#endif /* INCLUDED_MAPS_H */
