#include <string.h>
#include <allegro.h>

#include "main.h"
#include "game.h"
#include "themaps.h"
#include "maps.h"



int start_map(void)
{
	MAP *map = &the_map[game.map];

	int layer, x, y;
	unsigned char *ptr;

	game.vent_map = create_vent_map(map->vmw, map->vmh);

	if (!game.vent_map)
		return 1;

	memcpy(game.hotspot_club, map->hotspot_club, sizeof(map->hotspot_club));
	memcpy(game.hotspot_vent, map->hotspot_vent, sizeof(map->hotspot_vent));

	for (y = 0; y < map->n_club_maps; y++) {
		game.club_map[y] = create_club_map();

		if (!game.club_map[y]) {
			end_map();
			return 1;
		}

		memcpy(game.club_map[y]->tile, map->club_map[y].tile, sizeof(map->club_map[y].tile));

		memcpy(game.club_map[y]->vent_x, map->club_map[y].vent_x, sizeof(map->club_map[y].vent_x));
		memcpy(game.club_map[y]->vent_y, map->club_map[y].vent_y, sizeof(map->club_map[y].vent_y));
		memcpy(game.club_map[y]->vent_type, map->club_map[y].vent_type, sizeof(map->club_map[y].vent_type));

		game.club_map[y]->n_lights = map->club_map[y].n_lights;

		for (x = 0; x < map->club_map[y].n_lights; x++) {
			LIGHT *light = &game.club_map[y]->light[x];

			light->x = map->club_map[y].light[x].x;
			light->y = map->club_map[y].light[x].y;
			light->create = map->club_map[y].light[x].create;
			light->destroy = map->club_map[y].light[x].destroy;
			light->update = map->club_map[y].light[x].update;
			light->draw = map->club_map[y].light[x].draw;

			if (light->create)
				light->data = (*light->create)(light, map->club_map[y].light[x].data);
			else
				light->data = NULL;
		}

		game.club_map[y]->firstball = NULL;

		game.club_map[y]->n_squirrels = 0;

		for (x = 0; x < map->club_map[y].n_squirrels; x++)
			place_squirrel(game.club_map[y], &game.club_map[y]->squirrel[x]);

		for (; x < MAX_SQUIRRELS; x++)
			game.club_map[y]->squirrel[x].mode = SM_OFF;

		game.club_map[y]->dog_time =
		game.club_map[y]->dog_start_time = map->club_map[y].dog_time;
		game.club_map[y]->dog_y = DOG_START_Y;
		game.club_map[y]->dog_frame = rand() & 31;
	}

	ptr = map->vent_map;
	for (layer = 0; layer < 2; layer++) {
		for (y = 0; y < map->vmh; y++) {
			for (x = 0; x < map->vmw; x++) {
				int c = *ptr++;
				game.vent_map->layer[layer][y][x] = c;
				c -= VM_HOTSPOT;
				if (c >= 0) {
					int club = game.hotspot_club[c];
					int vent = game.hotspot_vent[c];
					int dir = map->hotspot_dir[c];
					game.club_map[club]->vent_vmx[vent] = x;
					game.club_map[club]->vent_vmy[vent] = y;
					game.club_map[club]->vent_vmdir[vent] = dir;
				}
			}
		}
	}

	game.resumeclub = game.club = map->club;

	if (game.club >= 0) {
		game.player.club.mode = CP_ON_FOOT;
		game.player.club.firecount = 0;
		game.player.club.x = map->plx << 16;
		game.player.club.y = map->ply << 16;
		game.player.club.yv = 0;
		game.player.club.dir = map->pl_dir;
		game.player.club.frame = 0;
	} else {
		game.player.vent.layer = map->pl_layer;
		game.player.vent.x = (map->plx << 16) | 0x8000l;
		game.player.vent.y = (map->ply << 16) | 0x8000l;
		game.player.vent.dir = map->pl_dir;
		game.player.vent.frame = 0;
	}
	game.resumeplayer = game.player;

	if (create_balls(map->n_balls)) {
		end_map();
		return 1;
	}

	game.mode = GM_ALIVE;

	game.clubheld = 1;

	play_midi(dat[MID_PIECE0 + (rand() % N_MID_PIECES)].dat, 1);

	return 0;
}



void resume_map(void)
{
	int n;
	CLUB_MAP *map = game.club_map[game.club];

	for (n = 0; n < MAX_SQUIRRELS; n++) {
		SQUIRREL *sq = &map->squirrel[n];

		if (sq->mode == SM_SUSPENDED)
			sq->mode = SM_ALIVE;
	}

	game.club = game.resumeclub;
	game.player = game.resumeplayer;
	game.mode = GM_ALIVE;
}



void end_map(void)
{
	int m, n;

	if (game.growl_v >= 0) {
		deallocate_voice(game.growl_v);
		game.growl_v = -1;
	}

	stop_midi();

	destroy_vent_map(game.vent_map);
	game.vent_map = NULL;

	for (n = 0; n < MAX_CLUB_MAPS; n++) {
		if (game.club_map[n]) {
			for (m = 0; m < game.club_map[n]->n_lights; m++) {
				LIGHT *light = &game.club_map[n]->light[m];
				if (light->destroy)
					(*light->destroy)(light->data);
			}
			destroy_club_map(game.club_map[n]);
			game.club_map[n] = NULL;
		}
	}

	destroy_balls();
}
