#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <allegro.h>

//#include "music.h"
#include "main.h"
#include "m_main.h"
#include "timeloop.h"
#include "icontrol.h"
#include "options.h"



DATAFILE *dat;

BITMAP *scrbuf;

RGB_MAP the_rgb_map;

//MUSIC *music;



#define CHEATBUFSIZE 14

char cheatbuf[CHEATBUFSIZE];

const char *cheatstr[N_CHEATS] = {
	"1337H4X0R",
	"FUCKMESIDEWAYS",
	"CANTGETME",
	"ELASTICITY"
};

unsigned char cheaton[N_CHEATS];



int cheat_entered(const char *cheat)
{
	int l = strlen(cheat);
	char *cbuf = &cheatbuf[CHEATBUFSIZE] - l;

	ASSERT(l <= CHEATBUFSIZE);

	while (l) {
		l--;
		if (cheat[l] != cbuf[l])
			return 0;
	}

	return 1;
}



void cheat_character(int k)
{
	int n;

	if (k == 0)
		return;

	memcpy(&cheatbuf[0], &cheatbuf[1], CHEATBUFSIZE - 1);
	cheatbuf[CHEATBUFSIZE - 1] = toupper(k);

	for (n = 0; n < N_CHEATS; n++) {
		if (cheat_entered(cheatstr[n])) {
			cheaton[n] ^= 1;
			/* Notify the player. */
			play_sample(dat[SFX_GRRRRRGL].dat, 128, 128, 1000, 0);
			break;
		}
	}
}



int main()
{
	srand(time(0));

	allegro_init();

	set_uformat(U_ASCII);

	set_config_file("ibiza.ini");

	load_options();

	install_timer();
	install_keyboard();

	/* Music takes up half the maximum magnitude.
	 * Remember, we're in a nightclub!
	 */
	set_volume_per_voice(1);

	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);

	initialise_timeloop();
	initialise_control();

	dat = load_datafile("ibiza.dat");
	if (!dat) {
		allegro_message("Failed to load ibiza.dat.\n");
		return 1;
	}

	if (set_gfx_mode(GFX_AUTODETECT, GFX_W, GFX_H, 0, 0)) {
		unload_datafile(dat);
		allegro_message("Failed to set graphics mode.\n%s\n", allegro_error);
		return 1;
	}

	scrbuf = create_bitmap(GFX_W, GFX_H);
	if (!scrbuf) {
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		unload_datafile(dat);
		allegro_message("Out of memory.\n");
		return 1;
	}

	set_palette(dat[THE_PALETTE].dat);

	create_rgb_table(&the_rgb_map, dat[THE_PALETTE].dat, NULL);
	rgb_map = &the_rgb_map;

	text_mode(-1);

	memset(cheaton, 0, sizeof(cheaton));
	memset(cheatbuf, 0, sizeof(cheatbuf));

	//music = start_music("c://music//01_BAR~1.MP3", 32);

	main_menu();

	//stop_music(music);

	destroy_bitmap(scrbuf);

	unload_datafile(dat);

	save_options();

	return 0;
}
END_OF_MAIN();
