#include <allegro.h>

#include "main.h"
#include "menu.h"
#include "menuproc.h"
#include "m_main.h"
#include "m_option.h"
#include "playgame.h"
#include "menuback.h"
#include "timeloop.h"



void update_menu_background(void);
void draw_menu_background(void);



int update_warning(void *data)
{
	update_menu_background();

	if (keypressed()) {
		readkey();
		return 1;
	}

	return 0;
}



/* The warning is important, so it will never be displayed in 1337. */

void draw_warning(void *data)
{
	(void)data;

	draw_menu_background();

	textout_centre(scrbuf, dat[THE_FONT].dat, "WARNING", GFX_W >> 1, 55, COL_WHITE);

	textout_centre(scrbuf, dat[THE_FONT].dat, "This game contains some scenes", GFX_W >> 1, 75, COL_WHITE);
	textout_centre(scrbuf, dat[THE_FONT].dat, "of strobe lighting.", GFX_W >> 1, 85, COL_WHITE);

	textout_centre(scrbuf, dat[THE_FONT].dat, "If you are sensitive to flashing", GFX_W >> 1, 105, COL_WHITE);
	textout_centre(scrbuf, dat[THE_FONT].dat, "lights, please disable strobe", GFX_W >> 1, 115, COL_WHITE);
	textout_centre(scrbuf, dat[THE_FONT].dat, "lighting in the options", GFX_W >> 1, 125, COL_WHITE);
	textout_centre(scrbuf, dat[THE_FONT].dat, "before you play the game.", GFX_W >> 1, 135, COL_WHITE);

	vsync();
	blit(scrbuf, screen, 0, 0, 0, 0, scrbuf->w, scrbuf->h);
}



void main_menu(void)
{
	BOMB_MENU menu[] = {
		/* option, draw, x, y, d, dp, d2, key, k, k2, kp */
		{0, &md_sprite     ,  40,  40,             0, dat[GFX_TITLE].dat, NULL, NULL       , 0, 0, NULL          },
		{1, &md_text_centre, 160, 130, COL_DARKGREEN, "Options"         , NULL, &mk_command, 0, 0, &mkc_options  },
		{1, &md_text_centre, 160, 140, COL_DARKGREEN, "Play Game"       , NULL, &mk_command, 0, 0, &mkc_play_game},
		{1, &md_text_centre, 160, 150, COL_DARKGREEN, "Exit"            , NULL, &mk_command, 0, 0, &mkc_exit     },
		{0, NULL           ,   0,   0,             0, NULL              , NULL, NULL       , 0, 0, NULL          }
	};

	initialise_menu_system();

	timeloop(
		BPS_TO_TIMER(100),
		10,
		NULL,
		&update_warning,
		&draw_warning
	);

	run_bomb_menu(menu, 2);

	shut_down_menu_system();
}
