#include <math.h>
#include <string.h>
#include <allegro.h>

#include "iris.h"



void draw_iris(BITMAP *bmp, float xc, float yc, float xr, float yr)
{
	int y;
	float yd;
	float ydinc;

	int ytop = ceil(yc - yr);
	int ybottom = ceil(yc + yr);

	int xleft;
	int xright;

	if (ybottom > bmp->h) ybottom = bmp->h;

	for (y = 0; y < ytop; y++)
		memset(bmp->line[y], 0, bmp->w);

	ydinc = xr / yr;
	yd = (y - yc) * ydinc;

	for (; y < ybottom; y++, yd += ydinc) {
		float xd = xr*xr - yd*yd;

		if (xd > 0) {
			xd = sqrt(xd);

			xleft = ceil(xc - xd);
			xright = ceil(xc + xd);

			if (xleft > 0)
				memset(bmp->line[y], 0, xleft);

			if (xright < bmp->w)
				memset(bmp->line[y] + xright, 0, bmp->w - xright);
		} else
			memset(bmp->line[y], 0, bmp->w);
	}

	for (; y < bmp->h; y++)
		memset(bmp->line[y], 0, bmp->w);
}
