#include <string.h>
#include <allegro.h>

#include "timeloop.h"
#include "icontrol.h"



#define FIFO_SIZE 16

static unsigned int keytime[N_CKEYS][FIFO_SIZE];
static int ktfirst[N_CKEYS];
static volatile int ktlast[N_CKEYS];



unsigned char ckey[N_CKEYS];



static int control_on = 0;



void record_key(int scancode)
{
	int ck;
	int next;

	switch (scancode & 127)
	{
		case KEY_LEFT:
			ck = CKEY_LEFT;
			break;
		case KEY_RIGHT:
			ck = CKEY_RIGHT;
			break;
		case KEY_UP:
			ck = CKEY_UP;
			break;
		case KEY_DOWN:
			ck = CKEY_DOWN;
			break;
		case KEY_ENTER:
			ck = CKEY_CLUB;
			break;
		case KEY_SPACE:
			ck = CKEY_FIRE;
			break;
		default:
			return;
	}

	next = (ktlast[ck] + 1) & (FIFO_SIZE - 1);

	if (next != ktfirst[ck]) {
		keytime[ck][ktlast[ck]] = true_game_time | ((scancode & 128) << 24);
		ktlast[ck] = next;
	}
}
END_OF_FUNCTION(record_key);



void poll_ckeys(void)
{
	int ck;

	if (!control_on)
		return;

	for (ck = 0; ck < N_CKEYS; ck++) {
		while (
			ktfirst[ck] != ktlast[ck] &&
			game_time >= (keytime[ck][ktfirst[ck]] & 0x7FFFFFFF)
		)
		{
			ckey[ck] = ~keytime[ck][ktfirst[ck]] >> 31;
			ktfirst[ck] = (ktfirst[ck] + 1) & (FIFO_SIZE - 1);
		}
	}
}



void start_control(void)
{
	memset(ktfirst, 0, sizeof(ktfirst));
	memset((/* non-volatile */ void *)ktlast, 0, sizeof(ktlast));

	memset(ckey, 0, sizeof(ckey));

	keyboard_lowlevel_callback = &record_key;

	control_on = 1;
}



void end_control(void)
{
	control_on = 0;

	keyboard_lowlevel_callback = NULL;
}



void initialise_control(void)
{
	LOCK_VARIABLE(keytime);
	LOCK_VARIABLE(ktfirst);
	LOCK_VARIABLE(ktlast);

	LOCK_FUNCTION(record_key);
}
