#ifndef INCLUDED_GAME_H
#define INCLUDED_GAME_H


#include "ball.h"
#include "clubmap.h"
#include "ventmap.h"
#include "clubplay.h"
#include "ventplay.h"


#define MAX_CLUB_MAPS 3

#define MAX_HOTSPOTS 11


#define GM_DEAD   0
#define GM_ALIVE  1
#define GM_ENDMAP 2

#define IRIS_START 400
#define IRIS_DELAY_TIME 40
#define IRIS_DELAY 50
#define RESUME_DELAY 50



union PLAYER
{
	VENT_PLAYER vent;
	CLUB_PLAYER club;
};



typedef struct GAME
{
	int score;
	int lives;
	int map;

	VENT_MAP *vent_map;
	CLUB_MAP *club_map[MAX_CLUB_MAPS];

	union PLAYER player;
	union PLAYER resumeplayer;

	int club; /* If the player is in the air vents, this is -1. */

	int resumeclub;

	/* The Hotspot Tables. These are used to map hotspots to clubs. */
	unsigned char hotspot_club[MAX_HOTSPOTS];
	unsigned char hotspot_vent[MAX_HOTSPOTS];

	int n_balls;
	BALL *ball;
	/* Balls are allocated in one block. The next pointers are used for
	 * stringing them together in a club, but not for memory allocation
	 * purposes.
	 */

	/* This list is used to hold balls that aren't in a club. */
	BALL *firstball;

	int mode;

	int iris;
	int delay;

	int paused;

	int clubheld;

	/* Sound voices. */
	int growl_v;
}
GAME;


extern GAME game;


int start_game(void);
int advance_game(void);
void end_game(void);


#endif /* INCLUDED_GAME_H */
