#include <allegro.h>

#include "main.h"
#include "leet.h"
#include "cutsproc.h"
#include "game.h"



void clear_scrbuf(void *data)
{
	(void)data;

	clear(scrbuf);
}



void *start_scrtext(void *param)
{
	TEXT_PLAYER *tp = malloc(sizeof(*tp));

	if (!tp)
		return NULL;

	tp->text = param;
	tp->y = scrbuf->h * 12;

	return tp;
}



void end_scrtext(void *tp)
{
	free(tp);
}



int update_scrtext(void *tp)
{
#define tp ((TEXT_PLAYER *)tp)
	tp->y--;
	return 0;
#undef tp
}



void draw_scrtext(void *tp)
{
#define tp ((TEXT_PLAYER *)tp)
	int y = tp->y / 12;
	char **text = tp->text;

	while (*text && y <= -10) {
		text++;
		y += 10;
	}

	while (*text && y < scrbuf->h) {
		textout_centre(scrbuf, dat[THE_FONT].dat, get1337(*text), scrbuf->w >> 1, y, COL_WHITE);
		text++;
		y += 10;
	}
#undef tp
}



void *start_cs_char(void *param)
{
	CS_CHAR *ch = malloc(sizeof(*ch));

	if (!ch)
		return NULL;

	*ch = *(CS_CHAR *)param;

	return ch;
}



void end_cs_char(void *data)
{
	free(data);
}



int update_cs_char(void *data)
{

#define data ((CS_CHAR *)data)

	data->x += data->xd;

	data->frame++;
	data->frame &= 31;

	return 0;

#undef data

}



void draw_cs_char(void *data)
{

#define data ((CS_CHAR *)data)

	draw_sprite(scrbuf, dat[data->datref[data->frame >> 2]].dat, data->x >> 1, data->y);

#undef data

}



void *start_cs_text(void *param)
{
	return param;
}



void draw_cs_text_centre(void *data)
{

#define data ((CS_TEXT *)data)

	textout_centre(scrbuf, dat[THE_FONT].dat, get1337(data->str), data->x, data->y, data->c);

#undef data

}



void *start_cs_sprite(void *param)
{
	return param;
}



void draw_cs_sprite(void *data)
{

#define data ((CS_SPRITE *)data)

	draw_sprite(scrbuf, dat[data->datref].dat, data->x, data->y);

#undef data

}
