#ifndef INCLUDED_CUTSCENE_H
#define INCLUDED_CUTSCENE_H


#define N_CUTSCENE_CHANNELS 11


/* Use an array of these to store a complete cutscene. */

typedef struct CUTSCENE
{
	/* In centiseconds; measured since last, not absolute. */
	/* A time of -1 causes the cutscene to hold until a key is pressed. */
	/* Update and draw functions are still called during this period. */
	int time;

	int channel; /* Negative channel to terminate the cutscene. */

	/* All functions NULL to end. */
	void *(*start)(void *param);
	void (*end)(void *data);
	int (*update)(void *data); /* Return 1 and end will be called. */
	void (*draw)(void *data);

	void *param; /* This is passed to start. */
}
CUTSCENE;


typedef struct CUTSCENE_CHANNEL
{
	void *data;
	void (*end)(void *data);
	int (*update)(void *data); /* Return 1 and end will be called. */
	void (*draw)(void *data);
}
CUTSCENE_CHANNEL;


typedef struct CUTSCENE_PLAYER
{
	CUTSCENE *scene;

	int time; /* Time left before next event occurs. */

	CUTSCENE_CHANNEL channel[N_CUTSCENE_CHANNELS];
}
CUTSCENE_PLAYER;


/* You should only need to use these directly when constructing recursive
 * cutscene structures.
 */
CUTSCENE_PLAYER *start_cutscene(CUTSCENE *scene);
void end_cutscene(CUTSCENE_PLAYER *sp);
int update_cutscene(CUTSCENE_PLAYER *sp);
void draw_cutscene(CUTSCENE_PLAYER *sp);


/* Use this function to run a cutscene. */

void run_cutscene(CUTSCENE *scene);


#endif /* INCLUDED_CUTSCENE_H */
