#include <stdlib.h>
#include <string.h>
#include <allegro.h>

#include "main.h"
#include "timeloop.h"
#include "icontrol.h"
#include "cutscene.h"



static int advance(CUTSCENE_PLAYER *sp)
{
	while (sp->time == 0) {

		CUTSCENE *scene = sp->scene;
		CUTSCENE_CHANNEL *channel;

		if (scene->channel < 0)
			return 1;

		channel = &sp->channel[scene->channel];

		if (channel->end)
			(*channel->end)(channel->data);

		channel->data = NULL;

		if (scene->start)
			channel->data = (*scene->start)(scene->param);

		channel->end = scene->end;
		channel->update = scene->update;
		channel->draw = scene->draw;

		sp->scene++;

		sp->time = sp->scene->time;
	}

	return 0;
}



CUTSCENE_PLAYER *start_cutscene(CUTSCENE *scene)
{
	CUTSCENE_PLAYER *sp;

	sp = malloc(sizeof(*sp));

	if (!sp)
		return NULL;

	memset(sp, 0, sizeof(*sp));

	sp->scene = scene;
	sp->time = scene->time;

	if (advance(sp)) {
		end_cutscene(sp);
		return NULL;
	}

	return sp;
}



void end_cutscene(CUTSCENE_PLAYER *sp)
{
	int n;

	for (n = 0; n < N_CUTSCENE_CHANNELS; n++) {
		CUTSCENE_CHANNEL *channel = &sp->channel[n];

		if (channel->end)
			(*channel->end)(channel->data);
	}

	free(sp);
}



int update_cutscene(CUTSCENE_PLAYER *sp)
{
	/* We use a semaphore to enable recursive cutscene structures. */
	static int semaphore = 0;

	int n;

	semaphore++;

	for (n = 0; n < N_CUTSCENE_CHANNELS; n++) {
		CUTSCENE_CHANNEL *channel = &sp->channel[n];

		if (channel->update) {
			if ((*channel->update)(channel->data)) {
				if (channel->end)
					(*channel->end)(channel->data);
				channel->data = NULL;
				channel->end = NULL;
				channel->update = NULL;
				channel->draw = NULL;
			}
		}
	}

	if (sp->time > 0)
		sp->time--;
	else if (keypressed())
		sp->time = 0;

	n = advance(sp);

	if (--semaphore == 0) {
		while (keypressed()) {
			int k = readkey();
			switch (k >> 8) {
				case KEY_ESC:
					return 1;
			}
		}
	}

	return n;
}



void draw_cutscene(CUTSCENE_PLAYER *sp)
{
	/* We use a semaphore to enable recursive cutscene structures. */
	static int semaphore = 0;

	int n;

	semaphore++;

	for (n = 0; n < N_CUTSCENE_CHANNELS; n++) {
		CUTSCENE_CHANNEL *channel = &sp->channel[n];

		if (channel->draw)
			(*channel->draw)(channel->data);
	}

	if (--semaphore == 0) {
		vsync();
		blit(scrbuf, screen, 0, 0, 0, 0, scrbuf->w, scrbuf->h);
	}
}



void run_cutscene(CUTSCENE *scene)
{
	CUTSCENE_PLAYER *sp = start_cutscene(scene);

	if (!sp)
		return;

	timeloop(
		BPS_TO_TIMER(100),
		10,
		sp,
		(int (*)(void *))&update_cutscene,
		(void (*)(void *))&draw_cutscene
	);

	end_cutscene(sp);
}
