#include <stdlib.h>
#include <string.h>
#include <allegro.h>

#include "main.h"
#include "cutscene.h"
#include "cutsproc.h"
#include "csmatrix.h"



typedef struct ROOFDATA
{
	int x, xd;
	int you_x, you_xd;
	int sq_x, sq_xd;
	int frame;
}
ROOFDATA;


static void *start_roof(void *param)
{
	ROOFDATA *roof = malloc(sizeof(*roof));

	if (!roof)
		return NULL;

	*roof = *(ROOFDATA *)param;

	return roof;
}


static void end_roof(void *data)
{
	free(data);
}


static int update_roof(void *data)
{
#define data ((ROOFDATA *)data)

	data->x += data->xd;
	data->you_x += data->you_xd;
	data->sq_x += data->sq_xd;

	data->frame++;
	data->frame &= 31;

	return 0;

#undef data
}


static void draw_roof(void *data)
{
#define data ((ROOFDATA *)data)

	int x = 160 - data->x;
	int y;

	/* The way these coordinates are arranged, the characters can move up and
	 * down between 80 and 140.
	 */
	V3D_f v3d[4] = {
		{x                   ,   0, 2,  0.01,   0.01, 0},
		{(x << 1) - 160      , 280, 1,  0.01, 255.99, 0},
		{(x << 1) - 256 - 160, 200, 1, 63.99, 255.99, 0},
		{x - 128             , -40, 2, 63.99,   0.01, 0}
	};

	for (; x < 320; x += 256) {
		v3d[2].x += 512;
		v3d[3].x += 256;
		quad3d_f(scrbuf, POLYTYPE_PTEX, dat[GFX_MATRIX_ROOF].dat,
			&v3d[0], &v3d[1], &v3d[2], &v3d[3]);
		if (x >= 320 - 64)
			break;
		v3d[0].x += 256;
		v3d[1].x += 512;
		quad3d_f(scrbuf, POLYTYPE_PTEX, dat[GFX_MATRIX_ROOF].dat,
			&v3d[3], &v3d[2], &v3d[1], &v3d[0]);
	}

	x = data->you_x & 255;
	y = (x * 60) >> 7;
	if (x & 0x80)
		y = 20 - 40 + y;
	else
		y = 140 - 40 - y;
	x = data->you_x - data->x;
	x = 150 + x + (x >> 1);

	draw_sprite(scrbuf, dat[GFX_CLUB_MAN0 + (data->frame >> 3)].dat, x, y);

	{
		float x, y;

		float xa, ya;
		float xb, yb;

		x = data->sq_x & 255;
		y = x * (60.0 / 128.0);

		/*
		328,102
		sqrt(328*328+102*102)=343.493813627
		328/343.493813627=0.9548934711126
		102/343.493813627=0.2969485794314
		*/
		if (data->sq_x & 0x80) {
			y = 20 + y;
			xa = 16 * 0.9548934711126;
			ya = 16 * 0.2969485794314;
			xb =-16 * 0.2969485794314;
			yb = 16 * 0.9548934711126;
		} else {
			y = 140 - y;
			xa = 16 * 0.9548934711126;
			ya =-16 * 0.2969485794314;
			xb = 16 * 0.2969485794314;
			yb = 16 * 0.9548934711126;
		}

		x = data->sq_x - data->x;
		x = 160 + x * 1.5;

		{
			V3D_f v3d[4] = {
				{x - xa - xb, y - ya - yb, 0,  0.01,  0.01, 0},
				{x - xa     , y - ya     , 0,  0.01, 31.99, 0},
				{x + xa     , y + ya     , 0, 63.99, 31.99, 0},
				{x + xa - xb, y + ya - yb, 0, 63.99,  0.01, 0}
			};

			quad3d_f(
				scrbuf,
				POLYTYPE_ATEX_MASK,
				dat[GFX_SQUIRREL0 + (data->frame >> 3)].dat,
				&v3d[0], &v3d[1], &v3d[2], &v3d[3]
			);
		}
	}

#undef data
}



typedef struct WALLDATA
{
	int x, xd;
	int y;
}
WALLDATA;


static void *start_wall(void *param)
{
	WALLDATA *wall = malloc(sizeof(*wall));

	if (!wall)
		return NULL;

	*wall = *(WALLDATA *)param;

	return wall;
}


static void end_wall(void *data)
{
	free(data);
}


static int update_wall(void *data)
{
#define data ((WALLDATA *)data)

	data->x += data->xd;

	return 0;

#undef data
}


static void draw_wall(void *data)
{
#define data ((WALLDATA *)data)

	int x, y;
	int x_end;

	x = data->x >> 2;
	x_end = x + 60;

	for (; x < x_end; x += 20)
		for (y = data->y; y < scrbuf->h; y += 20)
			blit(dat[GFX_MATRIX_BRICKS].dat, scrbuf, 0, 0, x, y, 20, 20);

#undef data
}



typedef struct MXWINDOWDATA
{
	int pos;
}
MXWINDOWDATA;


static void *start_mxwindow(void *param)
{
	MXWINDOWDATA *mxwindow = malloc(sizeof(*mxwindow));

	if (!mxwindow)
		return NULL;

	mxwindow->pos = 0;

	return mxwindow;
}


static void end_mxwindow(void *data)
{
	free(data);
}


static int update_mxwindow(void *data)
{
#define data ((MXWINDOWDATA *)data)

	data->pos++;

	return 0;

#undef data
}


static void draw_mxwindow(void *data)
{
#define data ((MXWINDOWDATA *)data)

	int x, y;

	x = (640 - data->pos) >> 1;
	if (x < 260) x = 260;

	if (data->pos <= 100)
		y = 76;
	else if (data->pos <= 112)
		y = 76 + 200 - (data->pos << 1);
	else
		y = 76 - 25;

	blit(dat[GFX_MATRIX_WINDOW].dat, scrbuf, 0, 0, x, y, 3, 24);

#undef data
}



static ROOFDATA roofdata[1] = {
	{
		 160, 1,
		   0, 2,
		-400, 3,
		0
	}
};



static WALLDATA walldata[] = {
	{0,  0, 60},
	{0, -1, 60},
	{1280, -2, 0},
	{1040,  0, 0}
};



static CS_CHAR yourdata[] = {
	{
		-40, 60 - 40,
		2,
		0,
		{
			GFX_CLUB_MAN1, GFX_CLUB_MAN1, GFX_CLUB_MAN2, GFX_CLUB_MAN2,
			GFX_CLUB_MAN3, GFX_CLUB_MAN3, GFX_CLUB_MAN4, GFX_CLUB_MAN4
		}
	},
	{
		 60, 60 - 40,
		1,
		0,
		{
			GFX_CLUB_MAN0, GFX_CLUB_MAN0, GFX_CLUB_MAN0, GFX_CLUB_MAN0,
			GFX_CLUB_MAN0, GFX_CLUB_MAN0, GFX_CLUB_MAN0, GFX_CLUB_MAN0
		}
	},
	{
		 90, 60 - 40,
		0,
		0,
		{
			GFX_CLUB_MAN0, GFX_CLUB_MAN0, GFX_CLUB_MAN0, GFX_CLUB_MAN0,
			GFX_CLUB_MAN0, GFX_CLUB_MAN0, GFX_CLUB_MAN0, GFX_CLUB_MAN0
		}
	},
	{
		 90, 60 - 40,
		-1,
		0,
		{
			GFX_CLUB_MAN2, GFX_CLUB_MAN2, GFX_CLUB_MAN1, GFX_CLUB_MAN1,
			GFX_CLUB_MAN4, GFX_CLUB_MAN4, GFX_CLUB_MAN3, GFX_CLUB_MAN3
		}
	},
	{
		 50, 60 - 40,
		0,
		0,
		{
			GFX_CLUB_MAN3, GFX_CLUB_MAN3, GFX_CLUB_MAN3, GFX_CLUB_MAN3,
			GFX_CLUB_MAN3, GFX_CLUB_MAN3, GFX_CLUB_MAN3, GFX_CLUB_MAN3
		}
	},
	{
		 50, 60 - 40,
		3,
		0,
		{
			GFX_CLUB_MAN3, GFX_CLUB_MAN4, GFX_CLUB_MAN1, GFX_CLUB_MAN2,
			GFX_CLUB_MAN3, GFX_CLUB_MAN4, GFX_CLUB_MAN1, GFX_CLUB_MAN2
		}
	}
};



typedef struct TORPEDO
{
	int pos;
	int y;
	int angle;
	int frame;
}
TORPEDO;


static void *start_torpedo(void *param)
{
	TORPEDO *torpedo = malloc(sizeof(*torpedo));

	if (!torpedo)
		return NULL;

	memset(torpedo, 0, sizeof(*torpedo));

	return torpedo;
}


static void end_torpedo(void *data)
{
	free(data);
}


static int update_torpedo(void *data)
{
#define data ((TORPEDO *)data)

	if (data->pos >= 410) {
		if (data->angle > 0) {
			data->angle -= 10;
			data->y += 4;
		}
		if (data->pos >= 460)
			data->y += data->pos - 460;
	} else if (data->pos < 360) {
		if (data->angle >= 200) {
			data->frame++;
			data->frame &= 15;
		} else
			data->angle++;
	}

	data->pos++;

	return 0;

#undef data
}


static void draw_torpedo(void *data)
{
#define data ((TORPEDO *)data)

	int pos = MIN(data->pos, 360);
	int x = 55 + (pos >> 1);
	int y = 60 - 40 + (pos >> 3) + (data->y >> 2);
	fixed angle = data->angle * (itofix(72) / 200);

	if (angle >= 200) {
		if (data->frame & 8)
			rotate_sprite_v_flip(scrbuf, dat[GFX_CLUB_MAN3].dat, x, y, angle + itofix(128));
		else
			rotate_sprite(scrbuf, dat[GFX_CLUB_MAN1].dat, x, y, angle);
	} else
		rotate_sprite(scrbuf, dat[GFX_CLUB_MAN4].dat, x, y, angle);

#undef data
}



typedef struct MXSQUIRRELDATA
{
	int x, y;
	int frame;
}
MXSQUIRRELDATA;


#define SQUIRREL_Y_FACTOR 512


static void *start_mxsquirrel(void *param)
{
	MXSQUIRRELDATA *data = malloc(sizeof(*data));

	if (!data)
		return NULL;

	data->x = -32;
	data->y = 60 * SQUIRREL_Y_FACTOR;
	data->frame = 0;

	return data;
}


static void end_mxsquirrel(void *data)
{
	free(data);
}


static int update_mxsquirrel(void *data)
{
#define data ((MXSQUIRRELDATA *)data)

	if (data->x >= 96) {
		if (data->x >= 360 + 48 - 16) {
			data->y += 4 * data->x - (96 + 95 + 94 + 93);
			data->x += 4;
		} else {
			data->y += data->x - 96;
			data->x++;
			data->frame = 24;
		}
	} else {
		data->x += 2;
		data->frame++;
		data->frame &= 31;
	}

	return 0;

#undef data
}


static void draw_mxsquirrel(void *data)
{
#define data ((MXSQUIRRELDATA *)data)

	float x, y;

	float xa, ya;
	float xb, yb;

	x = data->x * 0.5;
	y = data->y * (1.0 / SQUIRREL_Y_FACTOR);

	xa = 16;
	ya = 0;
	xb = 0;
	yb = 16;

	{
		V3D_f v3d[4] = {
			{x - xa - xb, y - ya - yb, 0,  0.01,  0.01, 0},
			{x - xa     , y - ya     , 0,  0.01, 31.99, 0},
			{x + xa     , y + ya     , 0, 63.99, 31.99, 0},
			{x + xa - xb, y + ya - yb, 0, 63.99,  0.01, 0}
		};

		quad3d_f(
			scrbuf,
			POLYTYPE_ATEX_MASK,
			dat[GFX_SQUIRREL0 + (data->frame >> 3)].dat,
			&v3d[0], &v3d[1], &v3d[2], &v3d[3]
		);
	}

#undef data
}



static CS_SPRITE bubbledata[] = {
	{65, 18, GFX_MATRIX_BUBBLE0},
	{74, 16, GFX_MATRIX_BUBBLE1},
	{83, 13, GFX_MATRIX_BUBBLE2},
	{95,  0, GFX_MATRIX_BUBBLE3}
};


static CS_TEXT dontpanic = {133, 6, 0, "Don't panic"};



CUTSCENE cs_matrix[] = {
	/* time, channel, start, end , update, draw         , param */

	/* Running along the roof. */
	{     0,       0, start_roof, end_roof, update_roof, draw_roof   , &roofdata[0]},

	/* Display the backdrop for the human torpedo scene. */
	{   320,       0, NULL      , NULL    , NULL       , clear_scrbuf, NULL        },

	/* Display the left-hand wall. */
	{     0,       1, start_wall, end_wall, update_wall, draw_wall   , &walldata[0]},

	/* Player comes on to the screen. */
	{     0,       2, start_cs_char, end_cs_char, update_cs_char, draw_cs_char, &yourdata[0]},
	{    50,       2, start_cs_char, end_cs_char, update_cs_char, draw_cs_char, &yourdata[1]},
	{    30,       2, start_cs_char, end_cs_char, update_cs_char, draw_cs_char, &yourdata[2]},

	/* Display a thought bubble with the words "Don't panic..." */
	{    50,       3, start_cs_sprite, NULL, NULL, draw_cs_sprite, &bubbledata[0]},
	{    10,       4, start_cs_sprite, NULL, NULL, draw_cs_sprite, &bubbledata[1]},
	{    10,       5, start_cs_sprite, NULL, NULL, draw_cs_sprite, &bubbledata[2]},
	{    10,       6, start_cs_sprite, NULL, NULL, draw_cs_sprite, &bubbledata[3]},
	{     0,       7, start_cs_text, NULL, NULL, draw_cs_text_centre, &dontpanic},

	{    70,       7, NULL, NULL, NULL, NULL, NULL},
	{     0,       6, NULL, NULL, NULL, NULL, NULL},
	{     5,       5, NULL, NULL, NULL, NULL, NULL},
	{     5,       4, NULL, NULL, NULL, NULL, NULL},
	{     5,       3, NULL, NULL, NULL, NULL, NULL},




	/* Player steps back a little, then runs forward. */
	{     0,       2, start_cs_char, end_cs_char, update_cs_char, draw_cs_char, &yourdata[3]},
	{    40,       2, start_cs_char, end_cs_char, update_cs_char, draw_cs_char, &yourdata[4]},
	{    20,       2, start_cs_char, end_cs_char, update_cs_char, draw_cs_char, &yourdata[5]},

	/* Left-hand wall starts to slide out of the picture. */
	{    20,       2, start_wall, end_wall, update_wall, draw_wall   , &walldata[1]},
	/* We initiate the human torpedo. Notice the channels have been swapped. */
	{     0,       1, start_torpedo, end_torpedo, update_torpedo, draw_torpedo, NULL},

	/* Let's not forget the squirrel! */
	{     0,       4, start_mxsquirrel, end_mxsquirrel, update_mxsquirrel, draw_mxsquirrel, NULL},

	/* Right-hand wall begins to appear, and with it, a window. */
	{   240,       2, start_wall, end_wall, update_wall, draw_wall   , &walldata[2]},
	{     0,       3, start_mxwindow, end_mxwindow, update_mxwindow, draw_mxwindow, NULL},

	/* Right-hand wall stops moving. */
	{   120,       2, start_wall, end_wall, update_wall, draw_wall   , &walldata[3]},

	{   160,       1, NULL , NULL, NULL  , NULL         , NULL  },
	{     0,       2, NULL , NULL, NULL  , NULL         , NULL  },
	{     0,       3, NULL , NULL, NULL  , NULL         , NULL  },
	{     0,       4, NULL , NULL, NULL  , NULL         , NULL  },

	{    50,      -1, NULL , NULL, NULL  , NULL         , NULL  }
};