#ifndef INCLUDED_CLUBPLAY_H
#define INCLUDED_CLUBPLAY_H


#include <math.h>

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#define MAX_ANGLE 36
#define ANGLE_UNIT ((M_PI / 3) / 36)
#define ANGLE_ERROR (3 * ANGLE_UNIT)

#define FIRECOUNT 5

#define CP_VENT     0
#define CP_ON_FOOT  1
#define CP_AIRBORNE 2

typedef struct CLUB_PLAYER
{
	int mode;

	int firecount;

	fixed x, y;
	fixed yv; /* Used when airborne. Also used as angle when aiming. */

	int dir;
	int frame;
}
CLUB_PLAYER;


void update_club_player(CLUB_MAP *map);


#endif /* INCLUDED_CLUBPLAY_H */
