#include <stdlib.h>
#include <allegro.h>

#include "icontrol.h"
#include "clubmap.h"
#include "clubplay.h"
#include "game.h"
#include "main.h"



#define PLAYER_SUPPORTED(y)											  \
(																	  \
	CM_IS_BLOCKED(map->tile[y][game.player.club.x >> 16]) ||		  \
	CM_IS_BLOCKED(map->tile[y][(game.player.club.x + 0xFFFFl) >> 16]) \
)



#define PLAYER_BLOCKED(x)												 \
(																		 \
	CM_IS_BLOCKED(map->tile[(game.player.club.y + 0xFFFFl) >> 16][x]) || \
	CM_IS_BLOCKED(map->tile[game.player.club.y >> 16][x]) ||			 \
	CM_IS_BLOCKED(map->tile[(game.player.club.y >> 16) - 1][x])			 \
)



#define TEST_AIR_VENT(n)									\
{															\
	int vent = map->tile[game.player.club.y >> 16]			\
		[(game.player.club.x >> 16) + n] - CM_VENT;			\
															\
	if (vent >= 0 && map->vent_type[vent] < CM_VENT_ROOF) { \
		game.player.club.x &= ~0xFFFFl;						\
		game.player.club.x += n * 0x10000l;					\
		game.player.club.y &= ~0xFFFFl;						\
		game.player.club.yv = 0;							\
		game.player.club.mode = CP_VENT;					\
		map->dog_y = DOG_START_Y;							\
		break;												\
	}														\
}



void update_club_player(CLUB_MAP *map)
{
	int vent = map->tile[game.player.club.y >> 16][game.player.club.x >> 16] - CM_VENT;

	int across, up;

	switch (game.player.club.mode) {
		case CP_AIRBORNE:
			if (game.player.club.yv < 0x2800l) game.player.club.yv += 0x100l;
			game.player.club.y += game.player.club.yv;

			if (PLAYER_SUPPORTED((game.player.club.y >> 16) - 1)) {
				game.player.club.yv = -game.player.club.yv;
				game.player.club.y += 0x10000l;
				game.player.club.y &= ~0xFFFFl;
			}

			if (PLAYER_SUPPORTED((game.player.club.y >> 16) + 1)) {
				game.player.club.y &= ~0xFFFFl;
				game.player.club.mode = CP_ON_FOOT;
				if (game.mode != GM_DEAD)
					game.player.club.frame = 0;
			}
			/* Fall through and process left and right controls. */
		case CP_ON_FOOT:
			if (game.mode == GM_DEAD) {
				across = (game.player.club.dir << 1) - 1;
				up = ((rand() & 63) == 0);
			} else {
				if (map->dog_time == 0) {
					if (!cheaton[CHEAT_INVULNERABLE]) {
						if (game.player.club.mode == CP_ON_FOOT)
							game.player.club.frame = 0;
						if (map->dog_y == 0) {
							kill_player_smoke();
							play_sample(dat[SFX_GRRRRRGL].dat, 128, CM_PAN(game.player.club.x), 1000, 0);
							map->dog_y = DOG_START_Y;
							map->dog_time = map->dog_start_time;
							break;
						}
					}
					if (map->dog_y <= -DOG_START_Y)
						map->dog_y = DOG_START_Y;
					map->dog_y--;
					if (!cheaton[CHEAT_INVULNERABLE])
						break;
				}
				across = ckey[CKEY_RIGHT] - ckey[CKEY_LEFT];
				up = ckey[CKEY_UP];
			}

			if (across < 0) {
				game.player.club.dir = 0;
				game.player.club.x -= 0x800l;
				if (PLAYER_BLOCKED(game.player.club.x >> 16)) {
					if (game.mode == GM_DEAD)
						game.player.club.dir ^= 1;
					else {
						TEST_AIR_VENT(0);
						if (game.player.club.mode == CP_ON_FOOT)
							game.player.club.frame = 0;
					}
					game.player.club.x += 0x10000l;
					game.player.club.x &= ~0xFFFFl;					
				} else if (game.mode != GM_DEAD && game.player.club.mode == CP_ON_FOOT) {
					game.player.club.frame += 0x800l - 1;
					game.player.club.frame &= 0xFFFFl;
					game.player.club.frame++;
				}
			} else if (across) {
				game.player.club.dir = 1;
				game.player.club.x += 0x800l;
				if (PLAYER_BLOCKED((game.player.club.x >> 16) + 1)) {
					if (game.mode == GM_DEAD)
						game.player.club.dir ^= 1;
					else {
						TEST_AIR_VENT(1);
						if (game.player.club.mode == CP_ON_FOOT)
							game.player.club.frame = 0;
					}
					game.player.club.x &= ~0xFFFFl;
				} else if (game.mode != GM_DEAD && game.player.club.mode == CP_ON_FOOT) {
					game.player.club.frame += 0x800l - 1;
					game.player.club.frame &= 0xFFFFl;
					game.player.club.frame++;
				}
			} else {
				if (game.mode == GM_DEAD) {
					if ((rand() & 63) == 0)
						game.player.club.dir ^= 1;
				} else if (game.player.club.mode == CP_ON_FOOT)
					game.player.club.frame = 0;
			}

			if (game.player.club.mode != CP_ON_FOOT) break;

			if (up) {
				game.player.club.yv = -0x2800l;
				game.player.club.mode = CP_AIRBORNE;
				if (game.mode != GM_DEAD)
					game.player.club.frame = 0x10000l;
			} else if (!PLAYER_SUPPORTED((game.player.club.y >> 16) + 1)) {
				game.player.club.yv = 0;
				game.player.club.mode = CP_AIRBORNE;
				if (game.mode != GM_DEAD)
					game.player.club.frame = 0x10000l;
			}

			break;
		default: /* CP_VENT */
			switch (map->vent_type[vent]) {
				case CM_VENT_ROOF:
					if (ckey[CKEY_LEFT] && !ckey[CKEY_RIGHT]) {
						if (game.player.club.yv < MAX_ANGLE)
							game.player.club.yv++;
					} else if (ckey[CKEY_RIGHT] && !ckey[CKEY_LEFT]) {
						if (game.player.club.yv > -MAX_ANGLE)
							game.player.club.yv--;
					}
					break;
				default:
					if (ckey[CKEY_UP] && !ckey[CKEY_DOWN]) {
						if (game.player.club.yv > -MAX_ANGLE)
							game.player.club.yv--;
					} else if (ckey[CKEY_DOWN] && !ckey[CKEY_UP]) {
						if (game.player.club.yv < MAX_ANGLE)
							game.player.club.yv++;
					}
			}

			/* Hmm, 100 balls a second... that might be just an incy wincy
			 * little bit too many... which is why we use firecount :P
			 */
			if (game.player.club.firecount)
				game.player.club.firecount--;
			else if (ckey[CKEY_FIRE] && game.firstball) {
				float angle;

				BALL *ball = game.firstball;
				game.firstball = ball->next;
				ball->next = map->firstball;
				map->firstball = ball;

				angle = game.player.club.yv * ANGLE_UNIT + rand() * (ANGLE_ERROR * 2 / RAND_MAX) - ANGLE_ERROR;

				switch (map->vent_type[vent]) {
					case CM_VENT_LEFT:
						ball->x = (game.player.club.x >> 16) + (1 + BALL_RADIUS);
						ball->y = (game.player.club.y >> 16) + 0.5;
						ball->xv = BALL_RADIUS * 0.9 * cos(angle);
						ball->yv = BALL_RADIUS * 0.9 * sin(angle);
						break;
					case CM_VENT_RIGHT:
						ball->x = (game.player.club.x >> 16) - BALL_RADIUS;
						ball->y = (game.player.club.y >> 16) + 0.5;
						ball->xv =-BALL_RADIUS * 0.9 * cos(angle);
						ball->yv = BALL_RADIUS * 0.9 * sin(angle);
						break;
					default: /* CM_VENT_ROOF */
						ball->x = (game.player.club.x >> 16) + 0.5;
						ball->y = (game.player.club.y >> 16) + (1 + BALL_RADIUS);
						ball->xv = BALL_RADIUS * 0.9 * sin(angle);
						ball->yv = BALL_RADIUS * 0.9 * cos(angle);
				}

				game.player.club.firecount = FIRECOUNT;

				{
					float v = (float)rand() / (RAND_MAX - 1) - 0.5;
					v = 1000.0 * pow(2.0, v);
					play_sample(dat[SFX_POP0].dat, 32, CM_PAN(game.player.club.x), (int)v, 0);
				}
			}

			switch (map->vent_type[vent]) {
				case CM_VENT_LEFT:
					if (ckey[CKEY_RIGHT] && !ckey[CKEY_LEFT]) {
						game.player.club.x += 0x10000l;
						game.player.club.yv = 0;
						game.player.club.mode = CP_AIRBORNE;
						game.player.club.dir = 1;
						game.player.club.frame = 0x10000l;
					}
					break;
				case CM_VENT_RIGHT:
					if (ckey[CKEY_LEFT] && !ckey[CKEY_RIGHT]) {
						game.player.club.x -= 0x10000l;
						game.player.club.yv = 0;
						game.player.club.mode = CP_AIRBORNE;
						game.player.club.dir = 0;
						game.player.club.frame = 0x10000l;
					}
					break;
			}
	}

	if (ckey[CKEY_CLUB]) {
		if (!game.clubheld) {
			if (game.player.club.mode == CP_VENT) {
				CLUB_MAP *map = game.club_map[game.club];
				int vent = map->tile
					[game.player.club.y >> 16]
					[game.player.club.x >> 16] - CM_VENT;
				game.resumeclub = game.club = -1;
				game.player.vent.layer = CM_VENT_LAYER(map->vent_type[vent]);
				game.player.vent.x = (map->vent_vmx[vent] << 16) + 0x8000l;
				game.player.vent.y = (map->vent_vmy[vent] << 16) + 0x8000l;
				game.player.vent.dir = map->vent_vmdir[vent];
				game.player.vent.frame = 0;
				game.resumeplayer.vent = game.player.vent;
			}
			game.clubheld = 1;
		}
	} else
		game.clubheld = 0;
}
