#ifndef INCLUDED_CLUBMAP_H
#define INCLUDED_CLUBMAP_H


#include "ball.h"
#include "squirrel.h"
#include "light.h"


#define CM_MAP_W 16
#define CM_MAP_H 10


#define CM_PAN(x) (68 + (x >> 13))


#define CM_BACKWALL   0
#define CM_BACKWINDOW 1
#define CM_SPEAKER    2
#define CM_FLOOR      3
#define CM_SIDEWALL   4
#define CM_VENT       5
/* Use (CM_VENT + n), where n is the index of the vent. Then the vent_vm*[]
 * arrays can be used to map vents back to coordinates in the vent map.
 */

#define CM_IS_BLOCKED(n) ((n) >= 2)
#define CM_LIGHT_BOTH_BLOCKED(m, n) ((m) >= 3 && (n) >= 3)


#define MAX_CLUB_VENTS 6


#define CM_VENT_LEFT  0 /* On the left, facing right. */
#define CM_VENT_RIGHT 1 /* On the right, facing left. */
#define CM_VENT_ROOF  2

/* Gets the layer for a type of vent. Used when returning to the vent map. */
#define CM_VENT_LAYER(n) ((n) >> 1)

/* 20 / 256 * DOG_START_Y * DOG_START_Y >= 170 */
#define DOG_START_Y 50

typedef struct CLUB_MAP
{
	unsigned char tile[CM_MAP_H][CM_MAP_W];

	unsigned char vent_x[MAX_CLUB_VENTS];
	unsigned char vent_y[MAX_CLUB_VENTS];
	unsigned char vent_type[MAX_CLUB_VENTS];
	unsigned char vent_vmx[MAX_CLUB_VENTS];
	unsigned char vent_vmy[MAX_CLUB_VENTS];
	unsigned char vent_vmdir[MAX_CLUB_VENTS];

	int n_lights;

	LIGHT light[MAX_LIGHTS];

	BALL *firstball;

	int n_squirrels;

	SQUIRREL squirrel[MAX_SQUIRRELS];

	int dog_start_time;
	int dog_time;
	int dog_y;
	int dog_frame;
}
CLUB_MAP;


extern const unsigned char lightclip[256];

#define LIGHTCLIP(rgb)		  \
{							  \
	rgb.r = lightclip[rgb.r]; \
	rgb.g = lightclip[rgb.g]; \
	rgb.b = lightclip[rgb.b]; \
}


CLUB_MAP *create_club_map(void);
void destroy_club_map(CLUB_MAP *map);

void kill_player_smoke(void);

void place_squirrel(CLUB_MAP *map, SQUIRREL *sq);

void update_club_map(CLUB_MAP *map, int player_here);


#define CM_TILE_W 20
#define CM_TILE_H 20

void draw_club_map(BITMAP *bmp, CLUB_MAP *map, float *plx, float *ply);


#endif /* INCLUDED_CLUBMAP_H */
