#include <math.h>
#include <stdlib.h>
#include <allegro.h>

#include "main.h"
#include "ball.h"
#include "squirrel.h"
#include "clubmap.h"
#include "game.h"



#define CRAZYBALL_BOOST 0.06



const unsigned char lightclip[256] = {
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
	16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31
};



CLUB_MAP *create_club_map(void)
{
	CLUB_MAP *map = malloc(sizeof(*map));

	return map;
}



void destroy_club_map(CLUB_MAP *map)
{
	free(map);
}



void kill_player_smoke(void)
{
	if (game.mode != GM_DEAD) {
		game.mode = GM_DEAD;
		game.player.club.dir = rand() & 1;
		game.player.club.frame = rand() & 7;
	}
}



void update_smoke(void)
{
	game.player.club.frame += 8;
	if (game.player.club.frame >= 16 * 8) {
		int newframe = rand() % 6;
		if (newframe >= 3)
			newframe++;
		if ((newframe & 3) >= (game.player.club.frame & 3))
			newframe++;
		game.player.club.frame = newframe;
	}
}



static void ball_map_collision(CLUB_MAP *map, BALL *ball)
{
	float xw = floor(ball->x);
	float yw = floor(ball->y);
	float xf = ball->x - xw;
	float yf = ball->y - yw;
	int x = (int)xw;
	int y = (int)yw;

	int collided = 0;

	if (xf < BALL_RADIUS && CM_IS_BLOCKED(map->tile[y][x-1])) {
		ball->x = xw + BALL_RADIUS;
		if (ball->xv < 0) ball->xv = -ball->xv;
		if (cheaton[CHEAT_CRAZYBALLS])
			ball->xv += CRAZYBALL_BOOST;
		collided = 1;
	} else if (xf > 1.0 - BALL_RADIUS && CM_IS_BLOCKED(map->tile[y][x+1])) {
		ball->x = xw + 1.0 - BALL_RADIUS;
		if (ball->xv > 0) ball->xv = -ball->xv;
		if (cheaton[CHEAT_CRAZYBALLS])
			ball->xv -= CRAZYBALL_BOOST;
		collided = 1;
	}

	if (yf < BALL_RADIUS && CM_IS_BLOCKED(map->tile[y-1][x])) {
		ball->y = yw + BALL_RADIUS;
		if (ball->yv < 0) ball->yv = -ball->yv;
		if (cheaton[CHEAT_CRAZYBALLS])
			ball->yv += CRAZYBALL_BOOST;
		collided = 1;
	} else if (yf > 1.0 - BALL_RADIUS && CM_IS_BLOCKED(map->tile[y+1][x])) {
		ball->y = yw + 1.0 - BALL_RADIUS;
		if (ball->yv > 0) ball->yv = -ball->yv;
		if (cheaton[CHEAT_CRAZYBALLS])
			ball->yv -= CRAZYBALL_BOOST;
		collided = 1;
	}

	if (collided)
		return;

	if ((x--, xf < BALL_RADIUS) || (xw++, x += 2, (--xf > -BALL_RADIUS))) {
		if ((y--, yf < BALL_RADIUS) || (yw++, y += 2, (--yf > -BALL_RADIUS))) {
			if (CM_IS_BLOCKED(map->tile[y][x])) {
				float d = xf * xf + yf * yf;
				if (d < BALL_RADIUS * BALL_RADIUS) {
					d = sqrt(d);
					xf /= d;
					yf /= d;
					d = BALL_RADIUS - d;
					ball->x += xf * d;
					ball->y += yf * d;
					d = ball->xv * xf + ball->yv * yf;
					if (d < 0) {
						d *= 2;
						if (cheaton[CHEAT_CRAZYBALLS])
							d += CRAZYBALL_BOOST;
						ball->xv += xf * d;
						ball->yv += yf * d;
					}
				}
			}
		}
	}
}



/*

Derivation for moving the balls back to the point where they only just touch:

x = xd + t * (ball1->xv - ball2->xv) = xd + t * xvd
y = yd + t * (ball1->yv - ball2->yv) = yd + t * yvd

x*x + y*y = BALL_RADIUS * BALL_RADIUS * 4 = r*r

t > 0

(xd + t * xvd)^2 +
(yd + t * yvd)^2 = r*r

xd*xd + 2*t*xvd*xd + t*t*xvd*xvd +
yd*yd + 2*t*yvd*yd + t*t*yvd*yvd = r*r

a*t*t + 2*b*t + c = 0

a = xvd*xvd + yvd*yvd
b = xvd*xd + yvd*yd
c = xd*xd + yd*yd - r*r

t = (-b +/- sqrt(b*b - a*c)) / a

Since t is positive:
t = (-b + sqrt(b*b - a*c)) / a

Then:

xd += t * xvd
yd += t * yvd

Although the equations gave good numerical results, this didn't work out.
This competition is hardly the time to work out why :)

*/

static inline void ball_ball_collision(float xd, float yd, float d, BALL *ball1, BALL *ball2)
{

#if 0

	float xvd = ball1->xv - ball2->xv;
	float yvd = ball1->yv - ball2->yv;

	float a = xvd*xvd + yvd*yvd;

	if (a >= 0.0001) {

		float b = xvd*xd + yvd*yd;
		float t;

		d -= BALL_RADIUS * BALL_RADIUS * 4;

		t = b*b - a*d;

		if (t <= 0)
			/* In this case, the balls didn't even touch, since there is no
			 * solution! Should never happen, but it's quick enough to check.
			 */
			return;

		t = (sqrt(t) - b) / a;

		xd += xvd * t;
		yd += yvd * t;

		ball1->x -= ball1->xv * t;
		ball1->y -= ball1->yv * t;

		ball2->x += ball2->xv * t;
		ball2->y += ball2->yv * t;

		d = BALL_RADIUS * 2;

	} else {
		d = sqrt(d);
		if (d < 0.01) d = 0.01;
	}

#else

	d = sqrt(d);
	if (d < 0.01) d = 0.01;

#endif

	xd /= d;
	yd /= d;
	d = BALL_RADIUS - 0.5 * d;
	ball1->x -= xd * d;
	ball1->y -= yd * d;
	ball2->x += xd * d;
	ball2->y += yd * d;
	d = (ball2->xv - ball1->xv) * xd + (ball2->yv - ball1->yv) * yd;
	if (d < 0) {
		if (cheaton[CHEAT_CRAZYBALLS])
			d -= CRAZYBALL_BOOST / 2.0;
		ball1->xv += xd * d;
		ball1->yv += yd * d;
		ball2->xv -= xd * d;
		ball2->yv -= yd * d;
	}
}



int squirrel_sorter(const void *e1, const void *e2)
{
	return (*(const SQUIRREL **)e1)->x - (*(const SQUIRREL **)e2)->x;
}



void update_balls(CLUB_MAP *map, int player_here)
{
	if (!map->firstball)
		return;

	/* Step 1: propagate velocities and positions. */
	{
		BALL *ball;
		for (ball = map->firstball; ball; ball = ball->next) {
			float d;
			ball->yv += 0.005;
			ball->xv *= 0.99;
			ball->yv *= 0.99;
			d =	ball->xv * ball->xv + ball->yv * ball->yv;
			if (d > BALL_RADIUS * BALL_RADIUS * 0.9 * 0.9) {
				d = BALL_RADIUS * 0.9 / sqrt(d);
				ball->xv *= d;
				ball->yv *= d;
			}
			ball->x += ball->xv;
			ball->y += ball->yv;
		}
	}

	/* Step 2: sort balls into order. */
	{
		BALL *headball;
		BALL *ball1;
		BALL *ball2;

		ball1 = map->firstball;
		ball1->prev = NULL;
		headball = ball1->next;
		if (headball) headball->prev = ball1;

		while (headball) {
			ball2 = headball;
			ball1 = headball->prev;
			headball = headball->next;
			if (headball) headball->prev = ball2;

			while (ball2->x < ball1->x) {
				/* Attach ball1 forward to the ball after ball2. */
				ball1->next = ball2->next;
				if (ball1->next) ball1->next->prev = ball1;
				/* Attach ball2 back to the ball before ball1. */
				ball2->prev = ball1->prev;
				if (ball2->prev) ball2->prev->next = ball2;
				/* Attach ball2 forward to ball1. */
				ball2->next = ball1;
				ball1->prev = ball2;
				/* Reset ball1 to the ball now before ball2. */
				ball1 = ball2->prev;
				/* If ball2 is now the first ball, update the first pointer. */
				if (!ball1) {
					map->firstball = ball2;
					break;
				}
			}
		}
	}

	/* Step 3: test balls against squirrels. */
	{
		BALL *ball;
		BALL *backball;
		BALL *headball;

		SQUIRREL *sq[MAX_SQUIRRELS];

		int m, n;

		for (m = n = 0; n < MAX_SQUIRRELS; n++)
			if (map->squirrel[n].mode == SM_ALIVE)
				sq[m++] = &map->squirrel[n];

		qsort(sq, m, sizeof(*sq), &squirrel_sorter);

		backball = map->firstball;

		for (n = 0; n < m; n++) {
			while (fixtof(sq[n]->x) - backball->x >= SQUIRREL_RADIUS + BALL_RADIUS) {
				backball = backball->next;
				if (!backball) goto done;
			}

			headball = backball;
			while (headball->x - fixtof(sq[n]->x) < SQUIRREL_RADIUS + BALL_RADIUS) {
				headball = headball->next;
				if (!headball) break;
			}

			for (ball = backball; ball != headball; ball = ball->next) {
				float xd = ball->x - fixtof(sq[n]->x);
				float yd = ball->y - fixtof(sq[n]->y);
				float d = xd * xd + yd * yd;
				if (d < (SQUIRREL_RADIUS + BALL_RADIUS) * (SQUIRREL_RADIUS + BALL_RADIUS)) {
					if (ball->xv * ball->xv + ball->yv * ball->yv >= SQUIRREL_DEATH_SPEED * SQUIRREL_DEATH_SPEED) {
						sq[n]->yv = 0;
						sq[n]->mode = SM_DEAD;
						sq[n]->frame = rand() & 3;
						map->n_squirrels--;
					}
					d = sqrt(d);
					xd /= d;
					yd /= d;
					d = xd * ball->xv + yd * ball->yv;
					if (d < 0) {
						d *= 2;
						ball->xv -= xd * d;
						ball->yv -= yd * d;
					}
					goto next;
				}
			}

			next:
		}

		done:
	}

	/* Step 4: process collisions between balls. */
	{
		BALL *backball;
		BALL *ball1;
		BALL *ball2;

		backball = map->firstball;
		ball2 = backball->next;

		while (ball2) {
			while (ball2->x - backball->x >= BALL_RADIUS * 2)
				backball = backball->next;

			for (ball1 = backball; ball1 != ball2; ball1 = ball1->next) {
				float xd = ball2->x - ball1->x;
				float yd = ball2->y - ball1->y;
				float d = xd * xd + yd * yd;

				if (d < BALL_RADIUS * BALL_RADIUS * 4) {
					ball_map_collision(map, ball1);
					ball_map_collision(map, ball2);
					ball_ball_collision(xd, yd, d, ball1, ball2);
				}
			}

			ball2 = ball2->next;
		}
	}

	/* Step 5: process collisions with the tile map. */
	{
		BALL *ball;

		for (ball = map->firstball; ball; ball = ball->next)
			ball_map_collision(map, ball);
	}

	/* Step 6: if the player is here, return balls to him appropriately. */
	if (game.mode == GM_ALIVE && player_here && game.player.club.mode != CP_VENT) {
		BALL **ballp;
		BALL *ball;

		for (ballp = &map->firstball; *ballp; ) {
			ball = *ballp;
			if (
				ball->x >= fixtof(game.player.club.x) &&
				ball->x < fixtof(game.player.club.x) + 1.0 &&
				ball->y >= fixtof(game.player.club.y) - 1.0 &&
				ball->y < fixtof(game.player.club.y) + 1.0
			)
			{
				*ballp = ball->next;
				ball->next = game.firstball;
				game.firstball = ball;
			} else
				ballp = &ball->next;
		}
	}
}



void place_squirrel(CLUB_MAP *map, SQUIRREL *sq)
{
	int x, y;

	int n = 0;

	for (y = 0; y < CM_MAP_H; y++) {
		for (x = 0; x < CM_MAP_W - 1; x++) {
			if (
				CM_IS_BLOCKED(map->tile[y][x]) !=
				CM_IS_BLOCKED(map->tile[y][x+1])
			) {
				if ((rand() % ++n) == 0) {
					sq->x = (x + 1) << 16;
					sq->y = (y << 16) | 0xFFFFl;
				}
			}
		}
	}

	for (x = 0; x < CM_MAP_W; x++) {
		for (y = 0; y < CM_MAP_H - 1; y++) {
			if (
				CM_IS_BLOCKED(map->tile[y][x]) !=
				CM_IS_BLOCKED(map->tile[y+1][x])
			) {
				if ((rand() % ++n) == 0) {
					sq->x = (x << 16) | 0xFFFFl;
					sq->y = (y + 1) << 16;
				}
			}
		}
	}

	if (n == 0) {
		sq->mode = SM_OFF;
		return;
	}

	sq->mode = SM_ALIVE;

	sq->x &= rand() | ~0xFFFFl;
	sq->y &= rand() | ~0xFFFFl;

	sq->dir = rand() & SD_RIGHT;
	sq->count = rand() % (50 + (rand() & 127));

	sq->xv = 0;

	sq->frame = rand() & 31;

	map->n_squirrels++;
}



void update_squirrel(CLUB_MAP *map, SQUIRREL *sq, int player_here)
{
	fixed v;

	if (sq->mode == SM_OFF)
		return;

	if (sq->mode == SM_DEAD) {
		if (sq->yv < 0x2800l)
			sq->yv += 0x100l;

		sq->y += sq->yv;

		if (
			CM_IS_BLOCKED(map->tile[sq->y >> 16][sq->x >> 16]) &&
			CM_IS_BLOCKED(map->tile[sq->y >> 16][(sq->x - 1) >> 16])
		) {
			sq->y &= ~0xFFFFl;
			sq->yv = 0;
		}

		if (game.mode == GM_ALIVE && player_here && game.player.club.mode != CP_VENT &&
			sq->x >= game.player.club.x &&
			sq->x <= game.player.club.x + 0x10000l &&
			sq->y >= game.player.club.y - 0x10000l &&
			sq->y <= game.player.club.y + 0x10000l
		) {
			/* What a reward for one's efforts :) */
			game.score++;
			sq->mode = SM_OFF;
		}

		return;
	}

	if (sq->dir & SD_FALLING) {
		/* Squirrel is falling. */

		if (sq->yv < 0x2800l)
			sq->yv += 0x0100l;

		sq->y += sq->yv;

		if (CM_IS_BLOCKED(map->tile[sq->y >> 16][sq->x >> 16])) {
			v = sq->y & ~0xFFFFl;
			if (sq->yv < 0) {
				sq->y = -sq->y;
				sq->y += (v << 1) + 0x1FFFFl;
				sq->yv = -sq->yv;
			} else {
				sq->y = v;
				sq->dir = rand() & SD_RIGHT;
				sq->count = 0;
				sq->frame = 8;
			}
		}

		if (sq->dir & SD_FALLING) {

			sq->x += sq->xv;

			if (CM_IS_BLOCKED(map->tile[sq->y >> 16][sq->x >> 16])) {
				v = sq->x & ~0xFFFFl;
				if (sq->xv < 0)
					v += 0x10000l;
				if (rand() & 1) {
					sq->x = v;
					sq->xv = (sq->xv < 0 ? sq->yv : -sq->yv);
					sq->dir = rand() & SD_RIGHT;
					sq->count = 0;
					sq->frame = 8;
				} else {
					sq->x = -sq->x;
					sq->x += (v << 1) - 1;
					sq->xv = -sq->xv;
				}
			}

			if (sq->dir & SD_FALLING)
				goto end;
		}
	}

	if (sq->count <= 0) {
		sq->dir ^= 1;
		sq->count = rand() % (50 + (rand() & 127));
	}

	sq->count--;

	sq->frame = (sq->frame + 1) & 31;

	v = (sq->dir & SD_RIGHT) ? 0x2000l : -0x2000l;

	if (sq->xv < v) {
		sq->xv += 0x40;
		if (sq->xv > v)
			sq->xv = v;
	} else {
		sq->xv -= 0x40;
		if (sq->xv < v)
			sq->xv = v;
	}

	v = sq->xv;

	while (v < 0) {
		if ((sq->x & 0xFFFFl) == 0) {
			if (
				CM_IS_BLOCKED(map->tile[sq->y >> 16][sq->x >> 16]) &&
				!CM_IS_BLOCKED(map->tile[sq->y >> 16][(sq->x >> 16) - 1])
			) {
				/* Squirrel is moving down the right-hand wall. */
				if (0x10000l - (sq->y & 0xFFFFl) < -v) {
					v += 0x10000l - (sq->y & 0xFFFFl);
					sq->y += 0x10000l;
					sq->y &= ~0xFFFFl;
					continue;
				}
				sq->y -= v;
				v = 0;

				if ((rand() & 127) == 0) {
					sq->dir |= SD_FALLING;
					sq->yv = -sq->xv;
					sq->xv = -0x1000l - (rand() & 0xFFFl);
					sq->x--;
				}

				break;
			}
			if (
				CM_IS_BLOCKED(map->tile[(sq->y - 1) >> 16][(sq->x >> 16) - 1]) &&
				!CM_IS_BLOCKED(map->tile[(sq->y - 1) >> 16][sq->x >> 16])
			) {
				/* Squirrel is moving up the left-hand wall. */
				if (((sq->y - 1) & 0xFFFFl) + 1 < -v) {
					sq->y--;
					v += (sq->y & 0xFFFFl) + 1;
					sq->y &= ~0xFFFFl;
					continue;
				}
				sq->y += v;
				v = 0;

				if ((rand() & 127) == 0) {
					sq->dir |= SD_FALLING;
					sq->yv = sq->xv;
					sq->xv = 0x1000l + (rand() & 0xFFFl);
				}

				break;
			}
		}
		if ((sq->y & 0xFFFFl) == 0) {
			if (
				CM_IS_BLOCKED(map->tile[sq->y >> 16][(sq->x - 1) >> 16]) &&
				!CM_IS_BLOCKED(map->tile[(sq->y >> 16) - 1][(sq->x - 1) >> 16])
			) {
				/* Squirrel is moving leftwards along the floor. */
				if (((sq->x - 1) & 0xFFFFl) + 1 < -v) {
					sq->x--;
					v += (sq->x & 0xFFFFl) + 1;
					sq->x &= ~0xFFFFl;
					continue;
				}
				sq->x += v;
				v = 0;

				if ((sq->xv <= -0x2000l || sq->xv >= 0x2000l) && (rand() & 63) == 0) {
					sq->dir |= SD_FALLING;
					sq->yv = -0x1000l - (rand() & 0xFFFl);
					sq->y--;
				}

				break;
			}
			if (
				CM_IS_BLOCKED(map->tile[(sq->y >> 16) - 1][sq->x >> 16]) &&
				!CM_IS_BLOCKED(map->tile[sq->y >> 16][sq->x >> 16])
			) {
				/* Squirrel is moving rightwards along the ceiling. */
				if (0x10000l - (sq->x & 0xFFFFl) < -v) {
					v += 0x10000l - (sq->x & 0xFFFFl);
					sq->x += 0x10000l;
					sq->x &= ~0xFFFFl;
					continue;
				}
				sq->x -= v;
				v = 0;

				if ((rand() & 63) == 0) {
					sq->dir |= SD_FALLING;
					sq->xv = -sq->xv;
					sq->yv = 0;
				}

				break;
			}
		}
		v = 0;
		break;
	}

	while (v) {
		if ((sq->x & 0xFFFFl) == 0) {
			if (
				CM_IS_BLOCKED(map->tile[(sq->y - 1) >> 16][sq->x >> 16]) &&
				!CM_IS_BLOCKED(map->tile[(sq->y - 1) >> 16][(sq->x >> 16) - 1])
			) {
				/* Squirrel is moving up the right-hand wall. */
				if (((sq->y - 1) & 0xFFFFl) + 1 < v) {
					sq->y--;
					v -= (sq->y & 0xFFFFl) + 1;
					sq->y &= ~0xFFFFl;
					continue;
				}
				sq->y -= v;
				v = 0;

				if ((rand() & 127) == 0) {
					sq->dir |= SD_FALLING;
					sq->yv = -sq->xv;
					sq->xv = -0x1000l - (rand() & 0xFFFl);
					sq->x--;
				}

				break;
			}
			if (
				CM_IS_BLOCKED(map->tile[sq->y >> 16][(sq->x >> 16) - 1]) &&
				!CM_IS_BLOCKED(map->tile[sq->y >> 16][sq->x >> 16])
			) {
				/* Squirrel is moving down the left-hand wall. */
				if (0x10000l - (sq->y & 0xFFFFl) < v) {
					v += 0x10000l - (sq->y & 0xFFFFl);
					sq->y += 0x10000l;
					sq->y &= ~0xFFFFl;
					continue;
				}
				sq->y += v;
				v = 0;

				if ((rand() & 127) == 0) {
					sq->dir |= SD_FALLING;
					sq->yv = sq->xv;
					sq->xv = 0x1000l + (rand() & 0xFFFl);
				}

				break;
			}
		}
		if ((sq->y & 0xFFFFl) == 0) {
			if (
				CM_IS_BLOCKED(map->tile[sq->y >> 16][sq->x >> 16]) &&
				!CM_IS_BLOCKED(map->tile[(sq->y >> 16) - 1][sq->x >> 16])
			) {
				/* Squirrel is moving rightwards along the floor. */
				if (0x10000l - (sq->x & 0xFFFFl) < v) {
					v += 0x10000l - (sq->x & 0xFFFFl);
					sq->x += 0x10000l;
					sq->x &= ~0xFFFFl;
					continue;
				}
				sq->x += v;
				v = 0;

				if ((sq->xv <= -0x2000l || sq->xv >= 0x2000l) && (rand() & 63) == 0) {
					sq->dir |= SD_FALLING;
					sq->yv = -0x1000l - (rand() & 0xFFFl);
					sq->y--;
				}

				break;
			}
			if (
				CM_IS_BLOCKED(map->tile[(sq->y >> 16) - 1][(sq->x - 1) >> 16]) &&
				!CM_IS_BLOCKED(map->tile[sq->y >> 16][(sq->x - 1) >> 16])
			) {
				/* Squirrel is moving leftwards along the ceiling. */
				if (((sq->x - 1) & 0xFFFFl) + 1 < v) {
					sq->x--;
					v -= (sq->x & 0xFFFFl) + 1;
					sq->x &= ~0xFFFFl;
					continue;
				}
				sq->x -= v;
				v = 0;

				if ((rand() & 63) == 0) {
					sq->dir |= SD_FALLING;
					sq->xv = -sq->xv;
					sq->yv = 0;
				}

				break;
			}
		}
		v = 0;
		break;
	}

	end:

	if (!cheaton[CHEAT_INVULNERABLE] &&
		player_here && game.player.club.mode != CP_VENT &&
		sq->x >= game.player.club.x &&
		sq->x <= game.player.club.x + 0x10000l &&
		sq->y >= game.player.club.y - 0x10000l &&
		sq->y <= game.player.club.y + 0x10000l
	) {
		/* Uh, what a reward for one's efforts indeed :P */
		sq->mode = SM_SUSPENDED;
		kill_player_smoke();
	}
}



void update_club_map(CLUB_MAP *map, int player_here)
{
	int n;

	for (n = 0; n < map->n_lights; n++)
		if (map->light[n].update)
			(*map->light[n].update)(&map->light[n], map->light[n].data);

	if (game.mode == GM_ALIVE) {
		if (map->dog_time <= 0) {
			map->dog_frame++;
			map->dog_frame &= 31;
		} else if (map->n_squirrels == 0)
			map->dog_time--;
	}

	if (game.mode == GM_DEAD)
		update_smoke();

	update_balls(map, player_here);

	for (n = 0; n < MAX_SQUIRRELS; n++)
		update_squirrel(map, &map->squirrel[n], player_here);
}
