#include <string.h>
#include <math.h>
#include <allegro.h>

#include "main.h"
#include "clubmap.h"
#include "game.h"
#include "leet.h"



void draw_smoke(BITMAP *bmp, int xs, int ys)
{
	int datref = GFX_SMOKE0 + (game.player.club.frame & 3);

	xs -= CM_TILE_W >> 1;
	ys -= CM_TILE_H;

	if (game.player.club.frame & 4)
		draw_sprite_h_flip(bmp, dat[datref].dat, xs, ys);
	else
		draw_sprite(bmp, dat[datref].dat, xs, ys);
}



void draw_squirrel(BITMAP *bmp, CLUB_MAP *map, SQUIRREL *sq)
{
	int datref = GFX_SQUIRREL0;
	float x = fixtof(sq->x) * CM_TILE_W;
	float y = fixtof(sq->y) * CM_TILE_H;

	float xa, ya;
	float xb, yb;

	if (sq->mode == SM_DEAD) {

		if (sq->xv < 0)
			xa = -16.0;
		else
			xa = 16.0;
		ya = 0;

		xb = 0;
		yb = -16.0;

		y -= 0.55 * 16;

		datref += sq->frame;

	} else if (sq->dir & SD_FALLING) {

		float d;

		xa = sq->xv;
		ya = sq->yv;

		d = xa * xa + ya * ya;

		if (d < 0.0001) {
			xa = 0;
			ya = -16.0;
		} else {
			d = 16.0 / sqrt(d);
			xa *= d;
			ya *= d;
		}

		if (xa < 0) {
			xb = ya;
			yb = -xa;
		} else {
			xb = -ya;
			yb = xa;
		}

		x += 0.35 * xb;
		y += 0.35 * yb;

		datref += 3;

	} else {

		xa = sq->x & 0xFFFFl;
		ya = sq->y & 0xFFFFl;

		xb = 0;
		yb = 0;

		if (CM_IS_BLOCKED(map->tile[(sq->y - 0x8000l) >> 16][(sq->x - 0x8000) >> 16])) { xb -= 8; yb -= 8; }
		if (CM_IS_BLOCKED(map->tile[(sq->y - 0x8000l) >> 16][(sq->x + 0x7FFF) >> 16])) { xb += 8; yb -= 8; }
		if (CM_IS_BLOCKED(map->tile[(sq->y + 0x7FFFl) >> 16][(sq->x - 0x8000) >> 16])) { xb -= 8; yb += 8; }
		if (CM_IS_BLOCKED(map->tile[(sq->y + 0x7FFFl) >> 16][(sq->x + 0x7FFF) >> 16])) { xb += 8; yb += 8; }

		if (xb != 0 && yb != 0) {
			float d;
			xb *= ABS(xa - 0x8000l);
			yb *= ABS(ya - 0x8000l);
			d = 16.0 / sqrt(xb * xb + yb * yb);
			xb *= d;
			yb *= d;
		}

		if (sq->dir & SD_RIGHT) {
			xa = yb;
			ya = -xb;
		} else {
			xa = -yb;
			ya = xb;
		}

		datref += sq->frame >> 3;
	}

	{
		V3D_f v3d[4] = {
			{x - xa - xb, y - ya - yb, 0,  0.01,  0.01, 0},
			{x - xa     , y - ya     , 0,  0.01, 31.99, 0},
			{x + xa     , y + ya     , 0, 63.99, 31.99, 0},
			{x + xa - xb, y + ya - yb, 0, 63.99,  0.01, 0}
		};

		quad3d_f(
			bmp,
			POLYTYPE_ATEX_MASK,
			dat[datref].dat,
			&v3d[0], &v3d[1], &v3d[2], &v3d[3]
		);
	}
}



typedef union RGBHACK
{
	int i;
	RGB rgb;
}
RGBHACK;

#define RGBMASK 0x1F1F1F1Ful

#define DO_LIGHT(v, rgb) v = rgb_map->data \
	[(pal[v].r * rgb.r) >> 6] \
	[(pal[v].g * rgb.g) >> 6] \
	[(pal[v].b * rgb.b) >> 6]

void apply_lighting(BITMAP *bmp, CLUB_MAP *map)
{
	unsigned char *bptr;
	static RGB lightgrid[51][81];
	RGB (*lptr)[81];

	int x, y;
	int n;

	RGB *pal = dat[THE_PALETTE].dat;

	memset(lightgrid, 8, sizeof(lightgrid));

	for (n = 0; n < map->n_lights; n++)
		(*map->light[n].draw)(map, &map->light[n], map->light[n].data, lightgrid);

	for (y = 0; y < 50; y++) {
		RGBHACK a, b, c;
		lptr = &lightgrid[y];

		bptr = bmp->line[y<<2];
		a.rgb = lptr[0][0];
		for (x = 1; x < 81; x++) {
			b.rgb = lptr[0][x];
			b.i += (~a.i & 0x7F7F7F7Fl) + 0x01010101l;
			b.i += (b.i >> 5) & 0x03030303l;
			b.i >>= 2;
			b.i &= RGBMASK;
			DO_LIGHT(bptr[0], a.rgb); a.i += b.i; a.i &= RGBMASK;
			DO_LIGHT(bptr[1], a.rgb); a.i += b.i; a.i &= RGBMASK;
			DO_LIGHT(bptr[2], a.rgb); a.i += b.i; a.i &= RGBMASK;
			DO_LIGHT(bptr[3], a.rgb); a.i += b.i; a.i &= RGBMASK;
			bptr += 4;
		}

		bptr = bmp->line[(y<<2)+1];
		a.rgb = lptr[0][0];
		b.rgb = lptr[1][0];
		b.i += (~a.i & 0x7F7F7F7Fl) + 0x01010101l;
		b.i += (b.i >> 5) & 0x03030303l;
		a.i += b.i >> 2;
		a.i &= RGBMASK;
		for (x = 1; x < 81; x++) {
			b.rgb = lptr[0][x];
			c.rgb = lptr[1][x];
			c.i += (~b.i & 0x7F7F7F7Fl) + 0x01010101l;
			c.i += (c.i >> 5) & 0x03030303l;
			b.i += c.i >> 2;
			b.i &= RGBMASK;
			b.i += (~a.i & 0x7F7F7F7Fl) + 0x01010101l;
			b.i += (b.i >> 5) & 0x03030303l;
			b.i >>= 2;
			b.i &= RGBMASK;
			DO_LIGHT(bptr[0], a.rgb); a.i += b.i; a.i &= RGBMASK;
			DO_LIGHT(bptr[1], a.rgb); a.i += b.i; a.i &= RGBMASK;
			DO_LIGHT(bptr[2], a.rgb); a.i += b.i; a.i &= RGBMASK;
			DO_LIGHT(bptr[3], a.rgb); a.i += b.i; a.i &= RGBMASK;
			bptr += 4;
		}

		bptr = bmp->line[(y<<2)+2];
		a.rgb = lptr[0][0];
		b.rgb = lptr[1][0];
		b.i += (~a.i & 0x7F7F7F7Fl) + 0x01010101l;
		b.i += (b.i >> 5) & 0x01010101l;
		a.i += b.i >> 1;
		a.i &= RGBMASK;
		for (x = 1; x < 81; x++) {
			b.rgb = lptr[0][x];
			c.rgb = lptr[1][x];
			c.i += (~b.i & 0x7F7F7F7Fl) + 0x01010101l;
			c.i += (c.i >> 5) & 0x01010101l;
			b.i += c.i >> 1;
			b.i &= RGBMASK;
			b.i += (~a.i & 0x7F7F7F7Fl) + 0x01010101l;
			b.i += (b.i >> 5) & 0x03030303l;
			b.i >>= 2;
			b.i &= RGBMASK;
			DO_LIGHT(bptr[0], a.rgb); a.i += b.i; a.i &= RGBMASK;
			DO_LIGHT(bptr[1], a.rgb); a.i += b.i; a.i &= RGBMASK;
			DO_LIGHT(bptr[2], a.rgb); a.i += b.i; a.i &= RGBMASK;
			DO_LIGHT(bptr[3], a.rgb); a.i += b.i; a.i &= RGBMASK;
			bptr += 4;
		}

		bptr = bmp->line[(y<<2)+3];
		a.rgb = lptr[1][0];
		b.rgb = lptr[0][0];
		b.i += (~a.i & 0x7F7F7F7Fl) + 0x01010101l;
		b.i += (b.i >> 5) & 0x03030303l;
		a.i += b.i >> 2;
		a.i &= RGBMASK;
		for (x = 1; x < 81; x++) {
			b.rgb = lptr[1][x];
			c.rgb = lptr[0][x];
			c.i += (~b.i & 0x7F7F7F7Fl) + 0x01010101l;
			c.i += (c.i >> 5) & 0x03030303l;
			b.i += c.i >> 2;
			b.i &= RGBMASK;
			b.i += (~a.i & 0x7F7F7F7Fl) + 0x01010101l;
			b.i += (b.i >> 5) & 0x03030303l;
			b.i >>= 2;
			b.i &= RGBMASK;
			DO_LIGHT(bptr[0], a.rgb); a.i += b.i; a.i &= RGBMASK;
			DO_LIGHT(bptr[1], a.rgb); a.i += b.i; a.i &= RGBMASK;
			DO_LIGHT(bptr[2], a.rgb); a.i += b.i; a.i &= RGBMASK;
			DO_LIGHT(bptr[3], a.rgb); a.i += b.i; a.i &= RGBMASK;
			bptr += 4;
		}
	}
}



void draw_club_map(BITMAP *bmp, CLUB_MAP *map, float *plx, float *ply)
{
	unsigned char *ptr;

	int xs, ys;

#if CM_VENT != 5
#error map_datref array needs changing
#endif

	static int map_datref[] = {
		GFX_CM_BACKWALL,
		GFX_CM_BACKWINDOW,
		GFX_CM_SPEAKER,
		GFX_CM_FLOOR,
		GFX_CM_WALL		
	};

	*plx = fixtof(game.player.club.x) * CM_TILE_W;
	*ply = fixtof(game.player.club.y) * CM_TILE_H;

	ptr = &map->tile[0][0];

	for (ys = 0; ys < CM_MAP_H * CM_TILE_H; ys += CM_TILE_H) {
		for (xs = 0; xs < CM_MAP_W * CM_TILE_W; xs += CM_TILE_W) {
			unsigned char c = *ptr++;
			if (!CM_IS_BLOCKED(c))
				blit(dat[map_datref[c]].dat, bmp, 0, 0, xs, ys, CM_TILE_W, CM_TILE_H);
		}
	}

	if (map->dog_time == 0 && game.player.club.mode != CP_VENT) {
		xs = floor(*plx);
		ys = floor(*ply - (CM_TILE_H >> 1) + 0.5 + (CM_TILE_H / 256.0) * (map->dog_y * map->dog_y));
		draw_sprite(bmp, dat[GFX_DOG0 + (map->dog_frame >> 3)].dat, xs, ys);
	}

	ptr = &map->tile[0][0];

	for (ys = 0; ys < CM_MAP_H * CM_TILE_H; ys += CM_TILE_H) {
		for (xs = 0; xs < CM_MAP_W * CM_TILE_W; xs += CM_TILE_W) {
			unsigned char c = *ptr++;
			if (c >= CM_VENT)
				blit(dat[GFX_CM_VENT].dat, bmp, 0, 0, xs, ys, CM_TILE_W, CM_TILE_H);
			else if (CM_IS_BLOCKED(c))
				blit(dat[map_datref[c]].dat, bmp, 0, 0, xs, ys, CM_TILE_W, CM_TILE_H);
		}
	}

	{
		BALL *ball;

		for (ball = map->firstball; ball; ball = ball->next) {
			xs = floor(ball->x * CM_TILE_W + 0.5);
			ys = floor(ball->y * CM_TILE_H + 0.5);
			draw_sprite(bmp, dat[GFX_BALL0].dat, xs - 4, ys - 4);
		}
	}

	xs = floor(*plx + 0.5);
	ys = floor(*ply + 0.5);

	*plx += CM_TILE_W >> 1;
	if (game.player.club.mode == CP_VENT)
		*ply += CM_TILE_H >> 1;

	if (game.mode == GM_ALIVE) {
		if (game.player.club.mode == CP_VENT) {
			float xa, ya;
			int vent = map->tile
				[game.player.club.y >> 16]
				[game.player.club.x >> 16] - CM_VENT;
			float angle = game.player.club.yv * ANGLE_UNIT;
			switch (map->vent_type[vent]) {
				case CM_VENT_LEFT:
					draw_sprite(bmp, dat[GFX_CM_VMAN_L0].dat, xs, ys);
					xa = cos(angle);
					ya = sin(angle);
					xs += CM_TILE_W;
					ys += CM_TILE_H >> 1;
					break;
				case CM_VENT_RIGHT:
					draw_sprite_h_flip(bmp, dat[GFX_CM_VMAN_L0].dat, xs - 4, ys);
					xa =-cos(angle);
					ya = sin(angle);
					ys += CM_TILE_H >> 1;
					break;
				default: /* CM_VENT_ROOF */
					draw_sprite(bmp, dat[GFX_CM_VMAN_H0].dat, xs, ys);
					xa = sin(angle);
					ya = cos(angle);
					xs += CM_TILE_W >> 1;
					ys += CM_TILE_H;
			}
			draw_sprite(bmp, dat[GFX_RHRBL_CROSS].dat, xs + (int)floor(12 * xa - 2.5), ys + (int)floor(12 * ya - 2.5));
		} else
			if (game.player.club.dir)
				draw_sprite(bmp, dat[((GFX_CLUB_MAN0 << 14) + 0x3FFFl + game.player.club.frame) >> 14].dat, xs, ys - CM_TILE_H);
			else
				draw_sprite_h_flip(bmp, dat[((GFX_CLUB_MAN0 << 14) + 0x3FFFl + game.player.club.frame) >> 14].dat, xs, ys - CM_TILE_H);
	} else
		draw_smoke(bmp, xs, ys);

	{
		int n;
		for (n = 0; n < MAX_SQUIRRELS; n++) {
			SQUIRREL *sq = &map->squirrel[n];
			if (sq->mode != SM_OFF && sq->mode != SM_SUSPENDED)
				draw_squirrel(bmp, map, sq);
		}
	}

	apply_lighting(bmp, map);

	if (game.mode == GM_ALIVE && map->n_squirrels == 0 && map->dog_time > 0) {
		textout_right(bmp, dat[THE_FONT].dat, printf1337("Dog Time: ", (map->dog_time + 99) / 100), 180, bmp->h >> 2, COL_WHITE);
		textout_right(bmp, dat[THE_FONT].dat, printf1337("%d", (map->dog_time + 99) / 100), 180 + 2 * NUMBER_WIDTH, bmp->h >> 2, COL_WHITE);
	}
}
