#include <allegro.h>

#include "main.h"
#include "leet.h"
#include "cutscene.h"
#include "cutsproc.h"
#include "cameo.h"



#define MARIO_SKY COL_CYAN



static void draw_backdrop(void *data)
{
	int x;

	(void)data;

	rectfill(scrbuf, 0, 0, 319, 199 - 32, MARIO_SKY);

	for (x = 0; x < 320; x += 16)
		blit(dat[GFX_MARIO_GROUND].dat, scrbuf, 0, 0, x, 200 - 32, 16, 32);
}



typedef struct CAMEO_TEXT
{
	int x, y;
	const char *text;
}
CAMEO_TEXT;


static void *start_cameo_text(void *param)
{
	return param;
}


static void draw_cameo_text(void *data)
{

#define data ((CAMEO_TEXT *)data)

	const char *text1337 = get1337(data->text);

	int x = data->x, y = data->y;
	int w = text_length(dat[THE_FONT].dat, text1337);
	int h = text_height(dat[THE_FONT].dat);

	rectfill(scrbuf, x, y, x + w, y + h, 0);
	textout(scrbuf, dat[THE_FONT].dat, text1337, x + 1, y + 1, COL_WHITE);

#undef data

}


static void draw_cameo_text_right(void *data)
{

#define data ((CAMEO_TEXT *)data)

	const char *text1337 = get1337(data->text);

	int x = data->x, y = data->y;
	int w = text_length(dat[THE_FONT].dat, text1337);
	int h = text_height(dat[THE_FONT].dat);

	rectfill(scrbuf, x - 1 - w, y, x - 1, y + h, 0);
	textout_right(scrbuf, dat[THE_FONT].dat, text1337, x, y + 1, COL_WHITE);

#undef data

}



static CS_CHAR yourdata[3] = {
	{
		-40, 200 - 32 - 40,
		1,
		0,
		{
			GFX_CLUB_MAN1, GFX_CLUB_MAN1, GFX_CLUB_MAN2, GFX_CLUB_MAN2,
			GFX_CLUB_MAN3, GFX_CLUB_MAN3, GFX_CLUB_MAN4, GFX_CLUB_MAN4
		}
	},
	{
		240, 200 - 32 - 40,
		0,
		0,
		{
			GFX_CLUB_MAN0, GFX_CLUB_MAN0, GFX_CLUB_MAN0, GFX_CLUB_MAN0,
			GFX_CLUB_MAN0, GFX_CLUB_MAN0, GFX_CLUB_MAN0, GFX_CLUB_MAN0
		}
	},
	{
		240, 200 - 32 - 40,
		1,
		0,
		{
			GFX_CLUB_MAN1, GFX_CLUB_MAN1, GFX_CLUB_MAN2, GFX_CLUB_MAN2,
			GFX_CLUB_MAN3, GFX_CLUB_MAN3, GFX_CLUB_MAN4, GFX_CLUB_MAN4
		}
	}
};


static CS_CHAR mariodata[3] = {
	{
		640, 200 - 32 - 27 + 1,
		-1,
		0,
		{
			GFX_MARIO0, GFX_MARIO0, GFX_MARIO1, GFX_MARIO1,
			GFX_MARIO2, GFX_MARIO2, GFX_MARIO1, GFX_MARIO1
		}
	},
	{
		360, 200 - 32 - 27 + 1,
		0,
		0,
		{
			GFX_MARIO0, GFX_MARIO0, GFX_MARIO0, GFX_MARIO0,
			GFX_MARIO0, GFX_MARIO0, GFX_MARIO0, GFX_MARIO0
		}
	},
	{
		360, 200 - 32 - 27 + 1,
		-1,
		0,
		{
			GFX_MARIO0, GFX_MARIO0, GFX_MARIO1, GFX_MARIO1,
			GFX_MARIO2, GFX_MARIO2, GFX_MARIO1, GFX_MARIO1
		}
	}
};


static CS_CHAR luigidata[3] = {
	{
		640, 200 - 32 - 27 + 1,
		-1,
		0,
		{
			GFX_LUIGI0, GFX_LUIGI0, GFX_LUIGI1, GFX_LUIGI1,
			GFX_LUIGI2, GFX_LUIGI2, GFX_LUIGI1, GFX_LUIGI1
		}
	},
	{
		400, 200 - 32 - 27 + 1,
		0,
		0,
		{
			GFX_LUIGI0, GFX_LUIGI0, GFX_LUIGI0, GFX_LUIGI0,
			GFX_LUIGI0, GFX_LUIGI0, GFX_LUIGI0, GFX_LUIGI0
		}
	},
	{
		400, 200 - 32 - 27 + 1,
		-1,
		0,
		{
			GFX_LUIGI0, GFX_LUIGI0, GFX_LUIGI1, GFX_LUIGI1,
			GFX_LUIGI2, GFX_LUIGI2, GFX_LUIGI1, GFX_LUIGI1
		}
	}
};



static CAMEO_TEXT cameo_text[] = {
	{165, 100, "Hey ... Pa?"},
	{165, 110, "Is that really you?"},
	{155, 100, "Whoa, do I know"},
	{155, 110, "you guys?"},
	{165,  50, "Hey it is you! Remember?"},
	{165,  60, "You'd be real proud of us"},
	{165,  70, "now. We're not just"},
	{165,  80, "plumbers any more. It's"},
	{165,  90, "our job to keep the evil"},
	{165, 100, "Koopas from taking over"},
	{165, 110, "the Mushroom Kingdom!"},
	{155,  90, "What the fuck is this?"},
	{155, 100, "You bastards on fucking"},
	{155, 110, "drugs or summat?!"},
	{165, 100, "Pa? What's the matter?"},
	{165, 110, "Don't you remember?"},
	{155, 110, "Fuck off!"},
	{165, 100, "Come on Mario, he doesn't"},
	{165, 110, "remember us. Let's go."},
	{155, 100, "Yeah, piss off, you"},
	{155, 110, "fucking weirdos!"}
};



CUTSCENE cs_cameo[] = {
	/* time, channel, start, end , update, draw          , param */
	{     0,       0, NULL , NULL, NULL  , &draw_backdrop, NULL  },

	/* Characters walk in from the sides. */
	{     0,       1, start_cs_char, end_cs_char, update_cs_char, draw_cs_char, &mariodata[0]},
	{    80,       3, start_cs_char, end_cs_char, update_cs_char, draw_cs_char, &luigidata[0]},
	{     0,       2, start_cs_char, end_cs_char, update_cs_char, draw_cs_char, &yourdata[0]},

	/* Mario and Luigi stop moving at 360 and 400 respectively. */
	{   200,       1, start_cs_char, end_cs_char, update_cs_char, draw_cs_char, &mariodata[1]},
	{    40,       3, start_cs_char, end_cs_char, update_cs_char, draw_cs_char, &luigidata[1]},
	/* At this point, you are at x = 200. */

	/* You stop moving at x = 240. */
	{    40,       2, start_cs_char, end_cs_char, update_cs_char, draw_cs_char, &yourdata[1]},

	/* Dialogue. */
	{    50,       4, start_cameo_text, NULL, NULL, draw_cameo_text      , &cameo_text[0]},
	{     5,       5, start_cameo_text, NULL, NULL, draw_cameo_text      , &cameo_text[1]},
	{    -1,       4, NULL, NULL, NULL, NULL, NULL},
	{     5,       5, NULL, NULL, NULL, NULL, NULL},
	{     5,       4, start_cameo_text, NULL, NULL, draw_cameo_text_right, &cameo_text[2]},
	{     5,       5, start_cameo_text, NULL, NULL, draw_cameo_text_right, &cameo_text[3]},
	{    -1,       4, NULL, NULL, NULL, NULL, NULL},
	{     5,       5, NULL, NULL, NULL, NULL, NULL},
	{     5,       4, start_cameo_text, NULL, NULL, draw_cameo_text      , &cameo_text[4]},
	{     5,       5, start_cameo_text, NULL, NULL, draw_cameo_text      , &cameo_text[5]},
	{     5,       6, start_cameo_text, NULL, NULL, draw_cameo_text      , &cameo_text[6]},
	{     5,       7, start_cameo_text, NULL, NULL, draw_cameo_text      , &cameo_text[7]},
	{     5,       8, start_cameo_text, NULL, NULL, draw_cameo_text      , &cameo_text[8]},
	{     5,       9, start_cameo_text, NULL, NULL, draw_cameo_text      , &cameo_text[9]},
	{     5,      10, start_cameo_text, NULL, NULL, draw_cameo_text      , &cameo_text[10]},
	{    -1,       4, NULL, NULL, NULL, NULL, NULL},
	{     5,       5, NULL, NULL, NULL, NULL, NULL},
	{     5,       6, NULL, NULL, NULL, NULL, NULL},
	{     5,       7, NULL, NULL, NULL, NULL, NULL},
	{     5,       8, NULL, NULL, NULL, NULL, NULL},
	{     5,       9, NULL, NULL, NULL, NULL, NULL},
	{     5,      10, NULL, NULL, NULL, NULL, NULL},
	{     5,       4, start_cameo_text, NULL, NULL, draw_cameo_text_right, &cameo_text[11]},
	{     5,       5, start_cameo_text, NULL, NULL, draw_cameo_text_right, &cameo_text[12]},
	{     5,       6, start_cameo_text, NULL, NULL, draw_cameo_text_right, &cameo_text[13]},
	{    -1,       4, NULL, NULL, NULL, NULL, NULL},
	{     5,       5, NULL, NULL, NULL, NULL, NULL},
	{     5,       6, NULL, NULL, NULL, NULL, NULL},
	{     5,       4, start_cameo_text, NULL, NULL, draw_cameo_text      , &cameo_text[14]},
	{     5,       5, start_cameo_text, NULL, NULL, draw_cameo_text      , &cameo_text[15]},
	{    -1,       4, NULL, NULL, NULL, NULL, NULL},
	{     5,       5, NULL, NULL, NULL, NULL, NULL},
	{     5,       4, start_cameo_text, NULL, NULL, draw_cameo_text_right, &cameo_text[16]},
	{    -1,       4, NULL, NULL, NULL, NULL, NULL},
	{     5,       4, start_cameo_text, NULL, NULL, draw_cameo_text      , &cameo_text[17]},
	{     5,       5, start_cameo_text, NULL, NULL, draw_cameo_text      , &cameo_text[18]},
	{    -1,       4, NULL, NULL, NULL, NULL, NULL},
	{     5,       5, NULL, NULL, NULL, NULL, NULL},
	{     5,       4, start_cameo_text, NULL, NULL, draw_cameo_text_right, &cameo_text[19]},
	{     5,       5, start_cameo_text, NULL, NULL, draw_cameo_text_right, &cameo_text[20]},
	{    -1,       4, NULL, NULL, NULL, NULL, NULL},
	{     5,       5, NULL, NULL, NULL, NULL, NULL},

	/* Mario, you and Luigi walk off. */
	{    20,       1, start_cs_char, end_cs_char, update_cs_char, draw_cs_char, &mariodata[2]},
	{    20,       2, start_cs_char, end_cs_char, update_cs_char, draw_cs_char, &yourdata[2]},
	{    20,       3, start_cs_char, end_cs_char, update_cs_char, draw_cs_char, &luigidata[2]},

	{   352,       1, NULL , NULL, NULL  , NULL          , NULL  },
	{    28,       2, NULL , NULL, NULL  , NULL          , NULL  },
	{    52,       3, NULL , NULL, NULL  , NULL          , NULL  },

	{    50,       0, NULL , NULL, NULL  , &clear_scrbuf , NULL  },
	{    50,      -1, NULL , NULL, NULL  , NULL          , NULL  }
};