#include <stdlib.h>
#include <allegro.h>

#include "ball.h"
#include "game.h"



int create_balls(int n_balls)
{
	int n;

	game.n_balls = n_balls;

	game.ball = malloc(n_balls * sizeof(*game.ball));

	if (!game.ball)
		return 1;

	game.firstball = game.ball;

	for (n = 1; n < n_balls; n++)
		game.ball[n - 1].next = &game.ball[n];

	game.ball[n_balls - 1].next = NULL;

	return 0;
}



void destroy_balls(void)
{
	free(game.ball);

	game.ball = NULL;
	game.firstball = NULL;
}
