#include <stdio.h>
#include <string.h>
#include "matrix.h"             // Pour la gestion des matrices et vecteurs

typedef unsigned char byte;

#define SURFACE_FLAT            0x0     // Surface FLAT
#define SURFACE_GOUR            0x1     // Surface GOURAUD
#define SURFACE_TEXT            0x2     // Surface TEXTURE
#define SURFACE_DIFFUSE         0x4     // Surface DIFFUSE
#define SURFACE_SPECULAR        0x8     // Surface SPECULAR

struct VERTEX           // Structure pour les faces
{
   int P[3];    // Sommets du triangle
   float u1,v1; // Coordonnes de texture
   float u2,v2;
   float u3,v3;
   VECTOR N;    // Normale
   byte SurfID; // Identifiant de surface
};

struct SURFACE          // Structure pour les donnes de surface
{
   int c;               // Couleur
   BITMAP *TexID;       // Texture
   int SType;           // Type de surface
   byte Diffuse;        // Proportion diffuse/specular si les deux actifs
};

class MESH              // Classe pour les objets
{
private:
   SURFACE *Surf;       // Surfaces
   int NbSurf;          // Nombre de surfaces
   int NbPoint;         // Nombre de points
   int NbVertex;        // Nombre de faces
   POINTF *Point;        // Points
   VECTOR *N;           // Normales
   VERTEX *Vertex;      // Faces

public:

   MESH()               // Constructeur
   {
      Surf=(SURFACE*) malloc(sizeof(SURFACE)*256);
      Point=NULL;
      N=NULL;
      Vertex=NULL;
      NbPoint=0;
      NbVertex=0;

                // Dfini la surface par dfaut
      NbSurf=1;
      Surf[0].c=makecol24(255,255,0);
      Surf[0].TexID=NULL;
      Surf[0].SType=SURFACE_GOUR;
      Surf[0].Diffuse=0;
   }

   ~MESH()              // Destructeur
   {
      if(Surf!=NULL) free(Surf);
      if(Point!=NULL) free(Point);
      if(N!=NULL) free(N);
      if(Vertex!=NULL) free(Vertex);
      NbPoint=0;
      NbVertex=0;
   }

   int get_nbpoint()    // Renvoie le nombre de points
   {
      return NbPoint;
   }

   void destroy()       // Procdure de remise  zro
   {
      if(Point!=NULL) free(Point);
      if(N!=NULL) free(N);
      if(Vertex!=NULL) free(Vertex);
      Point=NULL;
      N=NULL;
      Vertex=NULL;
      NbPoint=0;
      NbVertex=0;
      NbSurf=1;
      Surf[0].c=makecol24(255,255,0);
      Surf[0].TexID=NULL;
      Surf[0].SType=SURFACE_GOUR;
      Surf[0].Diffuse=0;
   }

   void normal_maj()    // Recalcule les normales
   {
      if(NbVertex>0 && NbPoint>0) {
         for(int i=0;i<NbVertex;i++) {  // Normales des faces
            POINTF A,B,C;
            A=Point[Vertex[i].P[0]];
            B=Point[Vertex[i].P[1]];
            C=Point[Vertex[i].P[2]];
            Vertex[i].N=(A>>B)*(A>>C);
            Vertex[i].N.Unit();
            }
         for(i=0;i<NbPoint;i++)     // Normales des points
            N[i].x=N[i].y=N[i].z=0.0f;
         for(i=0;i<NbVertex;i++) {
            N[Vertex[i].P[0]]+=Vertex[i].N;
            N[Vertex[i].P[1]]+=Vertex[i].N;
            N[Vertex[i].P[2]]+=Vertex[i].N;
            }
         for(i=0;i<NbPoint;i++)
            N[i].Unit();
         }
   }

   void transform(POINTF *RPoint,POINTF *TPoint,VECTOR *RN,MATRIX M,MATRIX MR,int w,int h) // Transforme l'objet
   {                                            // Version fixed
      set_projection_viewport(0,0,w,h);
      float T=(float)h/w;
      MATRIX MScale=identity_matrix;
      MScale.v[0][0]=ftofix(T);
      M=M*MScale;

      fixed x,y;

      if(NbPoint>0)
      for(int i=0;i<NbPoint;i++) {
         if(RPoint!=NULL) {
            RPoint[i]=Point[i]*M;
            TPoint[i].z=RPoint[i].z;
            persp_project(ftofix(RPoint[i].x),ftofix(RPoint[i].y),ftofix(RPoint[i].z),&x,&y);
            TPoint[i].x=fixtof(x);
            TPoint[i].y=fixtof(y);
            }
         if(RN!=NULL)
            RN[i]=N[i]*MR;
         }
   }

   void transform(POINTF *RPoint,POINTF *TPoint,VECTOR *RN,MATRIX_f M,MATRIX_f MR,int w,int h)     // Transforme l'objet
   {                                            // Version float
      set_projection_viewport(0,0,w,h);
      float T=(float)h/w;
      MATRIX_f MScale=identity_matrix_f;
      MScale.v[0][0]=T;
      M=M*MScale;
      
      if(NbPoint>0)
      for(int i=0;i<NbPoint;i++) {
         if(RPoint!=NULL) {
            RPoint[i]=Point[i]*M;
            TPoint[i].z=RPoint[i].z;
            persp_project_f(RPoint[i].x,RPoint[i].y,RPoint[i].z,&TPoint[i].x,&TPoint[i].y);
            }
         if(RN!=NULL)
            RN[i]=N[i]*MR;
         }
   }

   void drawZ(POINTF *TPoint,POINTF *RPoint,BITMAP *bmp,MATRIX_f M)// Dessine l'objet
   {
      V3D_f P[3];
      VECTOR N;
      int PolyMode;
      if(TPoint==NULL) TPoint=Point;

      set_trans_blender(0,0,0,0);

	  float zmin=0xFFFFF,zmax=-0xFFFFF;

	  for(int i=0;i<NbPoint;i++) {
		  if(TPoint[i].z>zmax) zmax=TPoint[i].z;
		  if(TPoint[i].z<zmin) zmin=TPoint[i].z;
		}

	  float coef=255.0f/(zmax-zmin);
      
      if(NbVertex>0 && NbPoint>0)
		  for(i=0;i<NbVertex;i++) {
			 P[0].x=TPoint[Vertex[i].P[0]].x;
			 P[0].y=TPoint[Vertex[i].P[0]].y;
			 P[0].z=TPoint[Vertex[i].P[0]].z;
			 P[1].x=TPoint[Vertex[i].P[1]].x;
			 P[1].y=TPoint[Vertex[i].P[1]].y;
			 P[1].z=TPoint[Vertex[i].P[1]].z;
			 P[2].x=TPoint[Vertex[i].P[2]].x;
			 P[2].y=TPoint[Vertex[i].P[2]].y;
			 P[2].z=TPoint[Vertex[i].P[2]].z;

			 N=Vertex[i].N*M;
			 if(N.z>0.0f) continue;

			 PolyMode=POLYTYPE_GCOL;

			 P[0].c=-(P[0].z-zmin)*coef;
			 P[1].c=-(P[1].z-zmin)*coef;
			 P[2].c=-(P[2].z-zmin)*coef;

			 triangle3d_f(bmp,PolyMode|POLYTYPE_ZBUF,NULL,&P[0],&P[1],&P[2]);
			 }
   }
   
   void load_asc(char *filename,float size)		// Charge un fichier au format *.ASC
   {

   destroy();

   float *coor[3];
     coor[0]=(float *) malloc(100000*sizeof(float));
     coor[1]=(float *) malloc(100000*sizeof(float));
     coor[2]=(float *) malloc(100000*sizeof(float));
   int *face[3];
     face[0]=(int *) malloc(100000*sizeof(int));
     face[1]=(int *) malloc(100000*sizeof(int));
     face[2]=(int *) malloc(100000*sizeof(int));

   if(coor[0]==NULL || coor[1]==NULL || coor[2]==NULL
   || face[0]==NULL || face[1]==NULL || face[2]==NULL) {
      if(coor[0]!=NULL) free(coor[0]);
      if(coor[1]!=NULL) free(coor[1]);
      if(coor[2]!=NULL) free(coor[2]);
      if(face[0]!=NULL) free(face[0]);
      if(face[1]!=NULL) free(face[1]);
      if(face[2]!=NULL) free(face[2]);
      return;
      }

   long nbp=0,nbf=0;

   FILE  *fichier;
   char  chaine[200];
   char  *fin;
   long  i,j;
   char  temp[50];
   float x,y,z;
   int   decalage=0;
   int nbpt;
   int test;
   float dx,dy,dz;
   float xmin=0xFFFFFF,ymin=0xFFFFFF,zmin=0xFFFFFF,
         xmax=-0xFFFFFF,ymax=-0xFFFFFF,zmax=-0xFFFFFF;
  
   int StructD[255];     // Donnes pour la restitution de la structure
   int NbStruct=0;
      
   nbpt=0;
   test=0;
   nbf=0;
   nbp=0;

   if ((fichier = fopen(filename,"rt"))==NULL)
   {
     perror("Impossible d'ouvrir le fichier en lecture");
     exit(-2);
   }

   do
   {
     // On lit le fichier contenant les informations sur l'objet
     fin=fgets(chaine,100,fichier);
	 strupr(chaine);
     if (!strncmp(chaine,"VERTEX",6))
     {
       if (strncmp(chaine,"VERTEX LIST",11))
       {
 	// Lecture des coordonnes d'un point
 	i=6;

 	while(chaine[i]!='X') i++;
 	i+=2;
 	while(chaine[i]==' ') i++;
 	sscanf(chaine+i,"%f",&x);

 	while(chaine[i]!='Y') i++;
 	i+=2;
 	while(chaine[i]==' ') i++;
 	sscanf(chaine+i,"%f",&y);

 	while(chaine[i]!='Z') i++;
 	i+=2;
 	while(chaine[i]==' ') i++;
 	sscanf(chaine+i,"%f",&z);

 	coor[0][nbp]=x;
 	coor[1][nbp]=y;
 	coor[2][nbp]=z;

         if(x<xmin) xmin=x;
         if(x>xmax) xmax=x;
         if(y<ymin) ymin=y;
         if(y>ymax) ymax=y;
         if(z<zmin) zmin=z;
         if(z>zmax) zmax=z;

 	nbp++;
       }
     }

     else
     {
       if (!strncmp(chaine,"FACE",4))
       {
 	if (strncmp(chaine,"FACE LIST",9))
 	{
 	  // Lecture d'une facette
 	  i=j=4;
 	  while(chaine[i]!='A') i++;
 	  i+=2;
	  while(chaine[i]==' ') i++;
 	  j=i;
 	  while(chaine[j]!=' ') j++;
 	  strncpy(temp,chaine+i,j-i);
 	  temp[j-i]=0;
 	  face[0][nbf]=atoi(temp)+decalage;

 	  while(chaine[i]!='B') i++;
 	  i+=2;
 	  while(chaine[i]==' ') i++;
 	  j=i;
 	  while(chaine[j]!=' ') j++;
 	  strncpy(temp,chaine+i,j-i);
 	  temp[j-i]=0;
 	  face[1][nbf]=atoi(temp)+decalage;

 	  while(chaine[i]!='C') i++;
 	  i+=2;
 	  while(chaine[i]==' ') i++;
 	  j=i;
 	  while(chaine[j]!=' ') j++;
 	  strncpy(temp,chaine+i,j-i);
 	  temp[j-i]=0;
 	  face[2][nbf]=atoi(temp)+decalage;

 	  nbf++;
 	  }
 	}
       else
 	if (!strncmp(chaine,"NAMED OBJECT",12)) {
 		  decalage=nbp;
          StructD[NbStruct++]=nbf;
          }
     }
   } while(fin!=NULL);

   fclose(fichier);

   NbPoint = nbp;
   NbVertex = nbf;
   Point=(POINTF*) malloc(sizeof(POINTF)*NbPoint);
   N=(VECTOR*) malloc(sizeof(VECTOR)*NbPoint);
   Vertex=(VERTEX*) malloc(sizeof(VERTEX)*NbVertex);

   dx=-(xmin+xmax)*0.5f;
   dy=-(ymin+ymax)*0.5f;
   dz=-(zmin+zmax)*0.5f;
   xmin=xmax-xmin;
   ymin=ymax-ymin;
   zmin=zmax-zmin;
   xmax=sqrt(xmin*xmin+ymin*ymin+zmin*zmin);
   size=size/xmax;

   for(i=0;i<nbp;i++) {
      Point[i].x = (coor[0][i]+dx)*size;
      Point[i].y = (coor[1][i]+dy)*size;
      Point[i].z = (coor[2][i]+dz)*size;
      }

   for(i=0;i<NbStruct;i++)
      Surf[i]=Surf[0];

   NbSurf=NbStruct;

   int CSub=0;

   for(i=0;i<nbf;i++) {
      if(i>=StructD[CSub+1]&&CSub+1<NbStruct) CSub++;
      Vertex[i].P[0] = face[0][i];
      Vertex[i].P[1] = face[1][i];
      Vertex[i].P[2] = face[2][i];
      Vertex[i].SurfID = CSub;
      }

   normal_maj();        // Met  jour les normales

   free(coor[0]);
   free(coor[1]);
   free(coor[2]);
   free(face[0]);
   free(face[1]);
   free(face[2]);
   }
   /*void load_asc(char *filename,float size)
   {

   destroy();

   float *coor[3];
     coor[0]=(float *) malloc(100000*sizeof(float));
     coor[1]=(float *) malloc(100000*sizeof(float));
     coor[2]=(float *) malloc(100000*sizeof(float));
   int *face[3];
     face[0]=(int *) malloc(100000*sizeof(int));
     face[1]=(int *) malloc(100000*sizeof(int));
     face[2]=(int *) malloc(100000*sizeof(int));

   if(coor[0]==NULL || coor[1]==NULL || coor[2]==NULL
   || face[0]==NULL || face[1]==NULL || face[2]==NULL) {
      if(coor[0]!=NULL) free(coor[0]);
      if(coor[1]!=NULL) free(coor[1]);
      if(coor[2]!=NULL) free(coor[2]);
      if(face[0]!=NULL) free(face[0]);
      if(face[1]!=NULL) free(face[1]);
      if(face[2]!=NULL) free(face[2]);
      return;
      }

   long nbp=0,nbf=0;

   FILE  *fichier;
   char  chaine[200];
   char  *fin;
   long  i,j;
   char  temp[50];
   float x,y,z;
   int   a,b,c;
   int   decalage=0;
   int nbpt;
   int test;
   float dx,dy,dz;
   float xmin=0xFFFFFF,ymin=0xFFFFFF,zmin=0xFFFFFF,
         xmax=-0xFFFFFF,ymax=-0xFFFFFF,zmax=-0xFFFFFF;
  
   int StructD[255];     // Donnes pour la restitution de la structure
   int NbStruct=0;
      
   nbpt=0;
   test=0;
   nbf=0;
   nbp=0;

   if ((fichier = fopen(filename,"rt"))==NULL)
   {
     perror("Impossible d'ouvrir le fichier en lecture");
     exit(-2);
   }

   do
   {
     // On lit le fichier contenant les informations sur l'objet
     fin=fgets(chaine,100,fichier);
     if (!strncmp(chaine,"Vertex",6))
     {
       if (strncmp(chaine,"Vertex list",11))
       {
 	// Lecture des coordonnes d'un point
 	i=0;

 	while(chaine[i]!='X') i++;
 	i+=2;
 	while(chaine[i]==' ') i++;
 	sscanf(chaine+i,"%f",&x);

 	while(chaine[i]!='Y') i++;
 	i+=2;
 	while(chaine[i]==' ') i++;
 	sscanf(chaine+i,"%f",&y);

 	while(chaine[i]!='Z') i++;
 	i+=2;
 	while(chaine[i]==' ') i++;
 	sscanf(chaine+i,"%f",&z);

 	coor[0][nbp]=x;
 	coor[1][nbp]=y;
 	coor[2][nbp]=z;

         if(x<xmin) xmin=x;
         if(x>xmax) xmax=x;
         if(y<ymin) ymin=y;
         if(y>ymax) ymax=y;
         if(z<zmin) zmin=z;
         if(z>zmax) zmax=z;

 	nbp++;
       }
     }

     else
     {
       if (!strncmp(chaine,"Face",4))
       {
 	if (strncmp(chaine,"Face list",9))
 	{
 	  // Lecture d'une facette
 	  i=j=0;
 	  while(chaine[i]!='A') i++;
 	  i+=2;
 	  j=i;
 	  while(chaine[j]!=' ') j++;
 	  strncpy(temp,chaine+i,j-i);
 	  temp[j-i]=0;
 	  face[0][nbf]=atoi(temp)+decalage;

 	  while(chaine[i]!='B') i++;
 	  i+=2;
 	  j=i;
 	  while(chaine[j]!=' ') j++;
 	  strncpy(temp,chaine+i,j-i);
 	  temp[j-i]=0;
 	  face[1][nbf]=atoi(temp)+decalage;

 	  while(chaine[i]!='C') i++;
 	  i+=2;
 	  j=i;
 	  while(chaine[j]!=' ') j++;
 	  strncpy(temp,chaine+i,j-i);
 	  temp[j-i]=0;
 	  face[2][nbf]=atoi(temp)+decalage;

 	  nbf++;
 	  }
 	}
       else
 	if (!strncmp(chaine,"Named object",12)) {
 	  decalage=nbp;
          StructD[NbStruct++]=nbf;
          }
     }
   } while(fin!=NULL);

   fclose(fichier);

   NbPoint = nbp;
   NbVertex = nbf;
   Point=(POINTF*) malloc(sizeof(POINTF)*NbPoint);
   N=(VECTOR*) malloc(sizeof(VECTOR)*NbPoint);
   Vertex=(VERTEX*) malloc(sizeof(VERTEX)*NbVertex);

   dx=-(xmin+xmax)*0.5f;
   dy=-(ymin+ymax)*0.5f;
   dz=-(zmin+zmax)*0.5f;
   xmin=xmax-xmin;
   ymin=ymax-ymin;
   zmin=zmax-zmin;
   xmax=sqrt(xmin*xmin+ymin*ymin+zmin*zmin);
   size=size/xmax;

   for(i=0;i<nbp;i++) {
      Point[i].x = (coor[0][i]+dx)*size;
      Point[i].y = (coor[1][i]+dy)*size;
      Point[i].z = (coor[2][i]+dz)*size;
      }

   for(i=0;i<NbStruct;i++)
      Surf[i]=Surf[0];

   NbSurf=NbStruct;

   int CSub=0;

   for(i=0;i<nbf;i++) {
      Vertex[i].P[0] = face[0][i];
      Vertex[i].P[1] = face[1][i];
      Vertex[i].P[2] = face[2][i];
      Vertex[i].SurfID = CSub;
      if(i>=StructD[CSub+1]&&CSub+1<NbStruct) CSub++;
      }

   normal_maj();        // Met  jour les normales

   free(coor[0]);
   free(coor[1]);
   free(coor[2]);
   free(face[0]);
   free(face[1]);
   free(face[2]);
   }*/
};
