#include <allegro.h>
#include "3Deng.h"

volatile int Utimer=0;

void UTimer()            // procdure UTimer
{
	Utimer++;
}

END_OF_FUNCTION(UTimer);

void main()
{
allegro_init();

install_timer();
install_mouse();
install_keyboard();

LOCK_VARIABLE(Utimer);
LOCK_FUNCTION(UTimer);

install_int_ex(UTimer,1);

int c,h,w;
c=GFX_AUTODETECT_WINDOWED;
w=640;
h=480;

set_gfx_mode(GFX_AUTODETECT_WINDOWED,320,200,0,0);

if (!gfx_mode_select(&c, &w, &h)) {
	allegro_exit();
	exit(0);
	}

set_color_depth(8);

set_gfx_mode(c,w,h,0,0);

show_video_bitmap(screen);

RGB Pal[256];

for(int i=0;i<256;i++) {
	Pal[i].r=0;
	Pal[i].g=i>>2;
	Pal[i].b=0;
	}

set_palette(Pal);

BITMAP *TCol=create_bitmap(w>>3,h>>3);
for(int y=0;y<(*TCol).h;y++)
	for(int x=0;x<(*TCol).w;x++)
		TCol->line[y][x]=0;

bool done=false;

BITMAP *buf=create_bitmap(w,h);

char s[2];
s[1]=0;

				// Pour la mesh
MESH MyMesh;
MyMesh.load_asc("shipB.asc",500.0f);

POINTF *PBuf;
PBuf=(POINTF*) malloc(sizeof(POINTF)*MyMesh.get_nbpoint());

POINTF *PBuf2;
PBuf2=(POINTF*) malloc(sizeof(POINTF)*MyMesh.get_nbpoint());

MATRIX_f Cam,Rot,Cam2;

float r1,r2,r3;
r1=64.0f;
r2=0.0f;
r3=0.0f;

get_camera_matrix_f(&Cam2,0.0f,0.0f,-600.0f,0.0f,0.0f,1.0f,0.0f,-1.0f,0.0f,32,0.75f);

get_rotation_matrix_f(&Rot,r1,r2,r3);

Cam=Rot*Cam2;

BITMAP *MeshBuf=create_bitmap(w>>3,h>>3);
ZBUFFER *zbuf=create_zbuffer(MeshBuf);

set_zbuffer(zbuf);

float Dt=0.0f;
int DTimer=Utimer;
float Conv=1.0f/BPS_TO_TIMER(1.0f);
char tmp[10];
float FPS;

do
{

	Dt=(Utimer-DTimer)*Conv;
	DTimer=Utimer;
	
	clear_bitmap(buf);

	clear_to_color(MeshBuf,128);
	clear_zbuffer(zbuf,0);

	r1+=25.6f*Dt;
	r2+=128.0f*Dt;
	r3+=85.0f*Dt;

	get_rotation_matrix_f(&Rot,r1,r2,r3);

	Cam=Rot*Cam2;

	MyMesh.transform(PBuf,PBuf2,NULL,Cam,Rot,(*TCol).w,(*TCol).h);

	MyMesh.drawZ(PBuf2,PBuf,MeshBuf,Rot);

	int X=rand()%(*TCol).w;
	TCol->line[0][X]=127+(rand()%128);

	for(int x=0;x<(*TCol).w;x++) {
		for(int y=(*TCol).h-1;y>0;y--)
			if(TCol->line[y-1][x]>TCol->line[y][x])
				TCol->line[y][x]=TCol->line[y-1][x]--;
			else if(TCol->line[y][x]>0)
				TCol->line[y][x]--;
		if(TCol->line[0][x]>0)
			TCol->line[0][x]--;
			
		for(y=(*TCol).h-1;y>=0;y--)
			MeshBuf->line[y][x]=MeshBuf->line[y][x]*TCol->line[y][x]>>8;
		}

	srand(Utimer);

	for(y=0;y<(*TCol).h;y++)
		for(x=0;x<(*TCol).w;x++) {
			if(!MeshBuf->line[y][x]) continue;
			srand(rand());
			s[0]=rand()%256;
			textout(buf,font,s,x<<3,y<<3,MeshBuf->line[y][x]);
			}

					// Affiche le compteur d'images par seconde
	if(Dt!=0.0f)
		FPS=1.0f/Dt;
	else
		FPS=-1.0f;

	itoa(FPS,tmp,10);
	textout(buf,font,tmp,5,5,0xFF);

	blit(buf,screen,0,0,0,0,w,h);

	if(key[KEY_ESC]) done=true;

}while(!done);

destroy_zbuffer(zbuf);
destroy_bitmap(buf);
destroy_bitmap(MeshBuf);
destroy_bitmap(TCol);

free(PBuf);

free(PBuf2);

allegro_exit();
}

END_OF_MAIN();