#ifndef ___EPREUVE2___
#define ___EPREUVE2___

#include "../audio/sample.h"
#include "screenshoot.h"
#include "../bitmap/jeu.h"
#include "../epreuve/epr2_pis.h"
#include "../epreuve/epr1_per.h"
#include "../epreuve/epr2_per.h"
#include "introd.h"
#include "accessoire.h"
#include "chrono.h"
#include "math.h"
#include "stdio.h"

//classe piste pour le saut en longueur
class piste_long{
private:
  BITMAP * ima;               //l'image de la piste
  DATAFILE * jeu;             //les fichiers dat
  DATAFILE * pis;
  DATAFILE * fon;
  int dist;                   //distance parcourue
  int aff_score1,aff_score2;  //pour l'affichage du panneau des scores
  int debut_sable;            //pour l"affichage du sable
public:

  //constructeur
  piste_long();

  //destructeur
  ~piste_long(){destroy_bitmap(ima);}

  //accesseur sur l'image
  BITMAP   * image  () {return ima;}
  DATAFILE * dat_fon() {return fon;}
  DATAFILE * dat_jeu() {return jeu;}
  int distance      () {return dist;}

  //la piste avance de a pixels
  bool avance(int a);
};

//constructeur
piste_long::piste_long(){
  pis=load_datafile("epreuve/epr2_pis.dat");
  jeu=load_datafile("bitmap/jeu.dat");
  fon=load_datafile("font/font.dat");
  ima=create_bitmap(640,480);clear_to_color(ima,12);
  for(int i=0;i<640;i++)blit((BITMAP*)pis[EP2_ELA].dat,ima,0,0,i,350,1,36);
  blit((BITMAP*)jeu[CHAISE].dat,ima,0,0,100,200,49,69);
  blit((BITMAP*)jeu[CHAISE].dat,ima,0,0,590,150,49,69);
  dist=0;debut_sable=0;aff_score1=false;aff_score2=0;
}


//la piste avance de a pixels
bool piste_long::avance(int a){
  int taille_elan=1000;
  if(dist<taille_elan+640){
    BITMAP * temp=create_bitmap(640,480);
    blit(ima,temp,a,0,0,0,640-a,480);clear_to_color(ima,12);
    blit(temp,ima,0,0,0,0,640-a,480);
    if(dist>taille_elan+380){score(ima,640-a-aff_score2,140,"LONGUEUR\0","0m00\0",jeu,fon);aff_score1=true;aff_score2+=a;}
    for(int i=0;i<a;i++){
      dist++;
      if(dist<taille_elan)blit((BITMAP*)pis[EP2_ELA].dat,ima,0,0,640-a+i,350,1,36);
      else if(debut_sable<639){blit((BITMAP*)pis[EP2_SAB].dat,ima,debut_sable,0,640-a+i,299,1,111);debut_sable++;}
    }
    destroy_bitmap(temp);
  }
  return true;
}


/************************************************************************/

//classe personnage
class longper{
private:
  int x,y;              //position a l'ecran
  BITMAP * mvt[12];     //les imgaes pour l'animation
  BITMAP * sau[10];
  int num;              //indice de nemero de images
  int num_sau;
  bool  start;
  bool tombe;           //a vrai si le personnage est tombe dans le sable
  int dernier_a,dist;   //pour le faire sauter

public:
  //constructeur
  longper(athlete &,int,int);

  //le personnage courre
  void avance(int a,int l);

  //accesseur d'image
  BITMAP * image(int a){
    if   (!start)    return sau[0];
    else if(tombe)   return sau[9];
    else if(a<1500)  return mvt[num];
    else if(a>=1500) return sau[num_sau];
    return sau[0];
  }

  int posx(){return x;}
  int posy(){return y;}

  ~longper(){
    for(int i=0;i<12;i++)destroy_bitmap(mvt[i]);
    for(int i=0;i<10;i++)destroy_bitmap(sau[i]);
  }
  void part  (){ start=true;}
  bool partit(){ return start;}

  //remise  zero des variables privee
  void RaZ();
};


 longper::longper(athlete &a,int ix,int iy){
    start=false;

    x=ix;y=iy;num=0;num_sau=0;
    dist=0;dernier_a=-1;tombe=false;
    DATAFILE * jeu=load_datafile("bitmap/jeu.dat"); charge(1,jeu);
    DATAFILE * data=load_datafile("epreuve/epr1_per.dat");
    DATAFILE * ep2=load_datafile("epreuve/epr2_per.dat");

    charge(2,jeu);
    //le perso qui courre
    int indmvt[12]={EP1_COU1,EP1_COU2,EP1_COU3,EP1_COU4,EP1_COU5,EP1_COU6,
                    EP1_COU7,EP1_COU8,EP1_COU9,EP1_COU10,EP1_COU11,EP1_COU12};
    for(int i=0;i<12;i++){
      mvt[i]=create_bitmap(200,200);
      blit((BITMAP *)data[indmvt[i]].dat,mvt[i],0,0,0,0,200,200);
    }
    charge(3,jeu);
    //le perso en train de sauter
    int indsau[10]={EP2_SA0,EP2_SA1,EP2_SA2,EP2_SA3,EP2_SA4,EP2_SA5,EP2_SA6,
                    EP2_SA7,EP2_SA8,EP2_SA9};
    for(int i=0;i<10;i++){
      sau[i]=create_bitmap(200,200);
      blit((BITMAP *)ep2[indsau[i]].dat,sau[i],0,0,0,0,200,200);
    }
    //correction des couleurs
    charge(4,jeu);
    floodbitmap(sau,"config/epr2.cfg",a.chev(),a.peau(),a.mail(),a.shor(),a.chau());

    floodbitmap(mvt,"config/epr1.cfg",a.chev(),a.peau(),a.mail(),a.shor(),a.chau());
    charge(5,jeu);
  }


//le personnage avance --> incrementation des indices
void longper::avance(int a,int l){
  if(a<1450)num=(num+1)%12;
  else {
    if(num_sau!=8)num_sau++;
    if(dernier_a!=a)dernier_a=a;
    else {
      if(x<l)x+=10;
      if(x>l-120 && y<260){y+=5;tombe=true;}
    }
  }
}

//remise a zero des variables
void longper::RaZ(){
  x=50;y=195;num=0;
  start=false;
  num=0;num_sau=0;tombe=false;dernier_a=-1;
  dist=0;
}

/******************************************************************************/

//calcul la distance en fonction du saut et de la vitesse
void calcul_distance(int &dist,int ang,int &vit,int  planche){
  if(ang>29)ang=29-(ang-29);
  dist=2*(5*ang+4*vit);
  if(planche>122)planche=122-(planche-122);
  planche=122-planche;
  dist=dist-(3*planche);
  dist+=aleat(2);
  dist-=60;
}


int longueur(longper & lp3,DATAFILE*jeu,DATAFILE*fon,DATAFILE*pis,DATAFILE * bruit,int *keyboard,int & etal,int numessai){
   clear_keybuf();
  /*********  les sauts
   265      6m50
   297      7m
   330      7m50
   362      8m
   395      8m50
   425      9m
   ********************/
  int dist=650;               //la distance saute par l'athlete en cm
  bool fin=false;             //fin de laboucle
  bool fin_saut=false;        //a vrai si le saut est fini
  bool fin_barre_saut=false;
  bool space_pressed=false;   //a vrai si la barre ESPACE est pressee
  int compte=0,touche;        //pour les touche;
  int cpt_vit=0;              //vitesse du personnage
  int planche=0;
  int cpt=-1;                 //pour l'affichage de la performance
  int cptessai=0;             //a 1 quand le paneau du debut est descendu
  int ang=20;                 //angle de saut
  int drap[2]={DRAP_BLANC,DRAP_ROUGE},reussi=0; //pour l'affichage du drapeau rouge ou blanc
  char * perf_saut=new char[10];

  piste_long p;
  //l'image qui sera a l'ecran
  BITMAP * buffer=create_bitmap(640,480);clear_to_color(buffer,12);

  //boucle de jeu
  while(!fin){
    //affichage de la piste dans le buffer image
    blit(p.image(),buffer,0,0,0,0,640,480);

    //la barre de vitesse
    rect(buffer,149,30,391,47,0);
    for(int i=0;i<cpt_vit*3;i++)blit((BITMAP*)jeu[BARRE].dat,buffer,0,0,150+i,31,1,16);

    //la barre qui gere le saut
    rect(buffer,149,65,391,82,0);if(p.distance()>800 && planche<235 && !fin_barre_saut){planche+=4;}
    floodfill(buffer,151,66,35);
    rectfill(buffer,240,66,281,81,79);
    rect(buffer,273,66,274,81,215);
    blit((BITMAP*)jeu[BARRE].dat,buffer,0,0,150+planche,66,1,16);

    //affichage de l'angle
    angle(ang,fon,buffer,420,20);

    //affichage du personnage dans le buffer image
    masked_blit(lp3.image(p.distance()),buffer,0,0,lp3.posx(),lp3.posy(),200,200);

    //affichage du panneau avec le numero de l'essai  sauter
    if(cptessai==0){
      BITMAP * bitessai=create_bitmap(205,100);clear_to_color(bitessai,12);
      switch(numessai){
       case 0:score(bitessai,0,1,"ESSAI 1\0","LONGUEUR\0",jeu,fon);break;
       case 1:score(bitessai,0,1,"ESSAI 2\0","LONGUEUR\0",jeu,fon);break;
       case 2:score(bitessai,0,1,"ESSAI 3\0","LONGUEUR\0",jeu,fon);break;
      }
      //le panneau monte
      blit(buffer,screen,0,0,0,0,640,480);
      for(int i=479;i>384;i--){blit(bitessai,screen,0,0,217,i,205,479-i);rest(5);}
      //pause
      rest(600);
      //le panneau descend
      for(int i=384;i<479;i++){blit(bitessai,screen,0,0,217,i,205,479-i);rest(5);}
      cptessai=1;
      destroy_bitmap(bitessai);
      clear_keybuf();
    }

    if(key[KEY_ENTER])lp3.part();


    if(keypressed()){
       touche=readkey();
       //la premiere touche est presse
       if(((touche&0xff) == keyboard[0]) && compte==1){
         compte=0;
         if(p.distance()<1450)cpt_vit++;
       }
       //la deuxieme touche est presse
       else if(((touche&0xff) == keyboard[1]) && compte==0){
         compte=1;
         if(!lp3.partit())lp3.part();
         if(p.distance()<1450)cpt_vit++;
       }
    }
    //on appuie sur la barre d'espace
    if(key[KEY_SPACE] && planche!=0){
      ang++;                     //on augemente l'angle
      fin_barre_saut=true;
      space_pressed=true;
    }

    //on relache la barre d'espace et on calcul le saut effectu
    if(!key[KEY_SPACE] && space_pressed){
      if(cpt==-1)     calcul_distance(dist,ang,cpt_vit,planche);
      if(planche>130 || planche<92){reussi=1;dist=0;}
      if(cpt<100)cpt++;
    }

    if(planche>130)space_pressed=true;

    //capture d'ecran
    if(key[KEY_F10])screenshoot();

    //le personnage avance
    if(lp3.partit()){lp3.avance(p.distance(),dist*0.44);if(!p.avance(20))fin=true;}
    if(cpt==59)fin_saut=true;

    //affichage du resultat
    if(fin_saut==true){
      int metre=dist/100;
      if(cpt==59){
        if(dist>710)play_sample((SAMPLE*)bruit[GOAL].dat,255,128,1000,0);
        if(dist<550)play_sample((SAMPLE*)bruit[DECU].dat,255,128,1000,0);
      }
      if(reussi==0)sprintf(perf_saut,"%dm%2d",metre,dist-metre*100);
      else sprintf(perf_saut,"%s","MORDU\0");
      blit((BITMAP*)jeu[drap[reussi]].dat,buffer,0,0,10,10,100,100);
      score(buffer,400,140,"LONGUEUR\0",perf_saut,p.dat_jeu(),p.dat_fon());
    }

    //on quitte avant d'avoir fini le saut
    if(key[KEY_ESC]){
      fin=true;
      if(cpt==-1)dist=0;
    }

    //affichage  l'ecran du buffer image
    blit(buffer,screen,0,0,0,0,640,480);
    if(cpt==99){fin=true;}
    rest(etal);
  }

  delete []perf_saut;
  destroy_bitmap(buffer);
  return dist;
}

//renvoi une performance en focntion du niveau de difficulte
int perf_ordi_long(int & diff){
  int max[3]={680,720,755};
  int min[3]={550,620,715};
  int res=aleat(max[diff]-min[diff]);
  res=min[diff]+res;
  return res;
}

//calcul des points en fonction de la performance
int calcul_perf_long(int dist){
  int res=0;
  if(dist!=0){
    double po1=dist-220,po2=pow(po1,1.4);
    po1=0.14354*po2;
    res=int(po1);
  }
  return res;
}

//on saute en longueur
void play_longueur(athlete * ath,int *keyboard,int & diff,int & etal){
  clear_to_color(screen,0);
  DATAFILE * pis=load_datafile("epreuve/epr2_pis.dat");
  DATAFILE * jeu=load_datafile("bitmap/jeu.dat");
  DATAFILE * fon=load_datafile("font/font.dat");
  DATAFILE * bruit=load_datafile("audio/sample.dat");
  set_palette((PALETTE)pis[EP2P_PAL].dat);
  presente(2);
  charge(0,jeu);
  //creation du personnage
  longper lp3(ath[3],50,195);

  //contient la valeur des 3 sauts
  int perf[3]={0,0,0};
  ready();

  clear_to_color(screen,0);
  debut_musique((SAMPLE*)bruit[PUBLIC].dat,120);
  //les 3 sauts
  for(int i=0;i<3;i++){
    perf[i]=longueur(lp3,jeu,fon,pis,bruit,keyboard,etal,i);
    lp3.RaZ();
  }
  //saut maximal
  int dist=maximum(perf,3);

  //affectation des points en fonction de la performance
  char *perf_long=new char[10];
  int metre=dist/100;
  sprintf(perf_long,"%dm%2d",metre,dist-metre*100);
  if(perf_long[2]==' ')perf_long[2]='0';
  ath[3].fini_epreuve(1,perf_long,calcul_perf_long(dist));

  //performance pour les personnages de l'ordinateur
  for(int i=0;i<6;i++)
    if(i!=3){
      int ordi=perf_ordi_long(diff);
      metre=ordi/100;
      sprintf(perf_long,"%dm%2d",metre,ordi-metre*100);
      if(perf_long[2]==' ')perf_long[2]='0';
      ath[i].fini_epreuve(1,perf_long,calcul_perf_long(ordi));
    }

  delete [] perf_long;
  fin_musique((SAMPLE*)bruit[PUBLIC].dat,120);
}

#endif
