#ifndef ___EPREUVE1___
#define ___EPREUVE1___

#include "athlete.h"
#include "accessoire.h"
#include "screenshoot.h"
#include "../epreuve/epr1_per.h"
#include "../epreuve/epr1_pis.h"
#include "../font/font.h"
#include "../bitmap/jeu.h"
#include "stdlib.h"
#include "introd.h"
#include "chrono.h"
#include "math.h"
#include "stdio.h"

#define EP1_VM   27             //vitesse maximal de la course
#define DEB_ARR         4900    //indice d'arrive

class piste{
private:
  BITMAP * ima;        //image de la piste
  BITMAP * temp;       //buffer temporaire
  int x;
  int d;               //distance parcourue
  DATAFILE * data;     //datafile sur la piste
  int nombre,cpt;      //les compteur
  int * chi;           //indice des images sur les distances
  int met,posi;
public:

  //constructeur
  piste(int *);
  //reaffectation
  piste operator=(piste & pi);
  //fonction qui fait avancer l'image de la piste
  void avance(int a) ;
  //retourne le pointeur sur l'imgage de la piste
  BITMAP * image(){return ima;}
  //retourne la distance parourue
  int pos(){return d;}
  //destructeur
  ~piste(){destroy_bitmap(ima);destroy_bitmap(temp);}
};

//reaffectation
piste piste::operator=(piste & pi){
    blit(pi.ima, ima,0,0,0,0,640,480);
    blit(pi.temp,temp,0,0,0,0,640,480);
    x=pi.x;d=pi.d;
    nombre=pi.nombre;cpt=pi.cpt;
    met=pi.met;posi=pi.posi;
    return  * this;
  }

//constructeur
piste::piste(int * fd){
   x=396;d=-50;nombre=0;cpt=0;
   data=load_datafile("epreuve/epr1_pis.dat");
   set_palette((PALETTE)data[EP1I_PAL].dat);
   ima=create_bitmap(640,480);clear(ima);
   chi=new int[10];
   chi[0]=EP1_100;chi[1]=EP1_90;chi[2]=EP1_80;chi[3]=EP1_70;chi[4]=EP1_60;
   chi[5]=EP1_50;chi[6]=EP1_40;chi[7]=EP1_30;chi[8]=EP1_20;chi[9]=EP1_10;
   met=0;posi=265;
   temp=create_bitmap(640,480);clear(temp);
   blit((BITMAP *)data[EP1_FOND].dat,ima,0,0,0,0,400,65);
   blit((BITMAP *)data[EP1_TOU].dat,ima,0,0,0,65,204,377);
   blit((BITMAP *)data[EP1_HER].dat,ima,0,0,400,0,240,65);
   blit((BITMAP *)data[EP1_HER].dat,ima,0,0,0,442,240,38);
   blit((BITMAP *)data[EP1_HER].dat,ima,0,0,240,442,240,38);
   blit((BITMAP *)data[EP1_HER].dat,ima,0,0,480,442,240,38);
   blit((BITMAP *)data[EP1_PIS].dat,ima,0,0,204,65,600,377);
   BITMAP * num_coul=create_bitmap(50,50);
   DATAFILE * fon=load_datafile("font/font.dat");
   int carton[3]={EP1_CJA,EP1_COR,EP1_CRO};
   //afichage des plots
   for(int i=0;i<6;i++){
     clear_to_color(num_coul,0);
     masked_blit((BITMAP *)data[EP1_PLO].dat,ima,0,0,-40+i*10,40+i*62,66,59);
     textprintf(num_coul,(FONT*)fon[FONT3].dat,0,0,43,"%d",i+1);
     masked_blit(num_coul,ima,0,0,-20+i*10,45+i*62,50,50);
     masked_blit((BITMAP *)data[EP1_STA].dat,ima,0,0,19+i*10,72+i*62,120,50);
     if(fd[i]>0) blit((BITMAP *)data[carton[fd[i]-1]].dat,ima,0,0,-24+i*10,43+i*62,33,8);
   }
   destroy_bitmap(num_coul);
   blit(ima,temp,0,0,0,0,640,480);
  }

//fonction qui fait avancer l'image de la piste
void piste::avance(int a){
    blit(temp,ima,a,0,0,0,640-a,480);
    if(x+a>600){
        blit((BITMAP *)data[EP1_PIS].dat,ima,x,0,640-a,65,600-x,377);
        blit((BITMAP *)data[EP1_PIS].dat,ima,0,0,640-a+600-x,65,a-(600-x),377);
    }
    else blit((BITMAP *)data[EP1_PIS].dat,ima,x,0,640-a,65,a,377);
    x=(x+a)%600;
    d+=a;
    //AFFICHAGE DES PANNEAUX DE PUBLICITE
    if(d>700 && d<1100) {
      if(nombre==0){nombre=d;cpt=1;}
      blit((BITMAP *)data[EP1_JAM].dat,ima,0,0,640-(d-nombre),0,d-nombre,65);
    }
    if(cpt==1 && d>1100)nombre=0;
    if(d>2300 && d<2700){
      if(nombre==0){nombre=d;cpt=2;}
      blit((BITMAP *)data[EP1_MAI].dat,ima,0,0,640-(d-nombre),0,d-nombre,65);
    }
    if(cpt==2 && d>2700)nombre=0;
    if(d>3800 && d<4200){
      if(nombre==0){nombre=d;cpt=3;}
      blit((BITMAP *)data[EP1_SYD].dat,ima,0,0,640-(d-nombre),0,d-nombre,65);
    }
    if(cpt==3 && d>4200)nombre=0;
    if(d>DEB_ARR && d<DEB_ARR+400){
      if(nombre==0){nombre=d;cpt=4;}
      blit((BITMAP *)data[EP1_ARR1].dat,ima,0,0,640-(d-nombre),0,d-nombre,65);
    }
    if(cpt==4 && d>DEB_ARR+400)nombre=0;
    if(d>DEB_ARR+400 && d<DEB_ARR+800){
      if(nombre==0){nombre=d;cpt=5;}
      blit((BITMAP *)data[EP1_ARR2].dat,ima,0,0,640-(d-nombre),0,d-nombre,65);
    }
    if(cpt==5 && d>DEB_ARR+800)nombre=0;
    if(d>DEB_ARR+800 && d<DEB_ARR+1200){
      if(nombre==0){nombre=d;cpt=6;}
      blit((BITMAP *)data[EP1_ARR3].dat,ima,0,0,640-(d-nombre),0,d-nombre,65);
    }

    //AFFICHAGE DES NUMEROS
    if(met<10)blit((BITMAP*)data[chi[met]].dat,ima,0,0,posi,447,50,35);
    posi-=a;
    if(posi<0){posi+=600;met++;}


    blit(ima,temp,0,0,0,0,640,480);
  }


/*********************************************************************/


class centper{
private:
  BITMAP * mvt[12];      //les sprites a l'ecran
  BITMAP * dep[2];       //les sprites du depart
  int x,y,z;             //la position sur l'ecran
  int f;                 //force variant de 1  5 avec 1 le plus faible
  int num,cpt;           //indice sur les image du pesonnage
  int p;
  int t;
  bool s;
  int numero;
  int dic,sec;           //chrono du personnage ayant termin
  athlete at;          //athlete associe
public:
  centper(athlete,int,int,int,int,int);
  void avance(){if(cpt<f)cpt++;}

  void courre(centper  &c,piste & pis){
    int tr=cpt+random()/(RAND_MAX/6)-3;
    avance();
    num=(num+1)%12;
    if(t==0){
      p+=tr;at=c.at;
      if(p>=5000)s=true;
      x=c.x-(c.p-p)-(c.z-z);
    }
  }

  void recour(int v){p+=v;}
  //accesseurs sur le chrono du peronnage
  int dixieme(){return dic;}
  int seconde(){return sec;}

  //accesseurs sur les image du personnage
  BITMAP * image(){return mvt[num];}
  BITMAP * pret(){return dep[0];}
  BITMAP * partez(){return dep[1];}
  void affiche(){blit(mvt[num],screen,0,0,x,y,200,200);}
  int force(){return f;}

  //reaffecteur
  centper operator=(const centper & c);


  //destructeur
  ~centper(){
    for(int i=0;i<2;i++)
      destroy_bitmap(dep[i]);
    for(int i=0;i<12;i++)
      destroy_bitmap(mvt[i]);
  }

  int pos(){return p;}
  bool arrive(){return s;}
  //le personnage est arrive, donc on saisit les valeurs du chonometre
  void fini(int a,int b){s=true;sec=a;dic=b;}

  //fait ralentir le personnage
  void ralenti(){f--;}

  //accesseurs sur les coordonnes de l'imge du personnage
  int posx(){return x;}
  int posy(){return y;}

  //retourne l'athlete associ
  athlete mon_ath(){return at;}
};


//reaffecteur
centper centper::operator=(const centper & c){
  x=c.x;y=c.y;z=c.z;t=c.t;f=c.f;num=c.num;cpt=c.cpt;p=c.p;s=c.s;
  numero=c.numero;dic=c.dic;sec=c.sec;at=c.at;
  for(int i=0;i<12;i++)
    blit(c.mvt[i],mvt[i],0,0,0,0,200,200);
  for(int i=0;i<2;i++)
    blit(c.dep[i],dep[i],0,0,0,0,200,200);
  return * this;
}


//constructeur du personnage
centper::centper(athlete a=athlete(1,1,1,1,1),int ix=0,int iy=0,int it=1,int fo=3,int truc=0):
  x(ix),y(iy),z(x),f(fo),num(0),cpt(0),p(-50),
  t(it),s(false),numero(truc),dic(0),sec(0),at(a)
{
    DATAFILE * data=load_datafile("epreuve/epr1_per.dat");

    int i;
    for(i=0;i<12;i++){mvt[i]=create_bitmap(200,200);clear(mvt[i]);}
    for(i=0;i<2;i++) {dep[i]=create_bitmap(200,200);clear(dep[i]);}

    //chargement des images
    int ind[14]={EP1_COU1,EP1_COU2,EP1_COU3,EP1_COU4,EP1_COU5,EP1_COU6,EP1_COU7,
                 EP1_COU8,EP1_COU9,EP1_COU10,EP1_COU11,EP1_COU12,EP1_COUPR,EP1_COUPA};
    for(i=0;i<12;i++)
       blit((BITMAP *)data[ind[i]].dat,mvt[i],0,0,0,0,200,200);
    for(i=0;i<2;i++)
       blit((BITMAP *)data[ind[i+12]].dat,dep[i],0,0,0,0,200,200);

     //coloriage des images en fonction des caracteristiques
    floodbitmap(mvt,"config/epr1.cfg",   a.chev(),a.peau(),a.mail(),a.shor(),a.chau());
    floodbitmap(dep,"config/epr1dep.cfg",a.chev(),a.peau(),a.mail(),a.shor(),a.chau());

  }

/*****************************************************************************************/

//calcule le nombre de point en fonction de la performance realise sur cent metre
void calc_100(int s,int  d,athlete & ath){
  char * charscore=new char[10];
  double po1,po2;
  sprintf(charscore,"%2d:%2d",s,d);
  if(charscore[3]==' ')charscore[3]='0';
  po1=double(18)-((100*double(s)+double(d))/double(100));
  po2=pow(po1,1.81);
  double point=25.4347*po2;
  if((s==0 && d==0) || s>=18)point=0;
  ath.fini_epreuve(0,charscore,int(point));
  delete charscore;
}


//affiche la barre de vitesse
void barre_vitesse(BITMAP * b,int v,DATAFILE * jeu){
  rect(b,10,451,10+EP1_VM*5+1,468,0);
  for(int i=0;i<v*5;i++)blit((BITMAP*)jeu[BARRE].dat,b,0,0,11+i,452,1,16);
}

//calcul un temps pour l'ordinateur en fonction du niveau de difficulte
void temp_ordi_100(athlete & a,int & diff){
  int min[3]={1150,1110,1075};
  int max[3]={1250,1160,1120};
  int tp=min[diff]+aleat(max[diff]-min[diff]);//temps aleatoire
  int sm=tp/100;   //dixiemes
  calc_100(sm,tp-sm*100,a);
}

/*********************************************************************************/

void play_cent_metres(athlete a[6],int &diff,int *keyboard,int etal){
  //lance la presentation
  presente(1);
  //chargement des datafile
  DATAFILE * jeu=load_datafile    ("bitmap/jeu.dat");         charge(0,jeu);
  DATAFILE * bruit=load_datafile  ("audio/sample.dat");       charge(1,jeu);
  DATAFILE * dat_chr=load_datafile("epreuve/epr1_pis.dat");   charge(2,jeu);

  bool start=false,fin=false;
  int cpt_start=0;
  int touche=0;
  //char * charscore=new char[10];
  charge(3,jeu);
  int * faux_depart=new int[6];
  for(int i=0;i<6;i++)faux_depart[i]=0;  //pour les faux depart
  int compte=0;           //compteur pour les touches--> pour ne pas tricher
  int vitesse=0;          //vitesse de notre personnage
  int cpt_vit=0;
  charge(4,jeu);

  //creation de notre coureur
  centper cp3(a[3],40,116,1,5,3);               charge(5,jeu);


  ready();
  fade_out(5);               //fondu
  debut_musique((SAMPLE*)bruit[PUBLIC].dat,120);
  clear_to_color(screen,0);
  piste p(faux_depart);
  BITMAP * buffer=create_bitmap(640,480); clear_to_color(buffer,0);
  demarre_chrono2();   //demarre le chrono de temporisation

  //boucle principale
  while(!fin){
    RaZ2();//remet le chrono de temporisation  0
    blit(p.image(),buffer,0,0,0,0,640,480);
    barre_vitesse(buffer,vitesse,jeu);

    //l'arbitre e dit "partez"
    if(cpt_start>=98){
       if(!start){start=true;RaZ1();demarre_chrono1();}
       masked_blit(cp3.image(),buffer,0,0,cp3.posx(),cp3.posy(),200,200);
    }
    //on est dans les starting-block
    else if(cpt_start<97){
       masked_blit(cp3.pret(),buffer,0,0,cp3.posx(),cp3.posy(),200,200);
       if(cpt_start==10) play_sample((SAMPLE*)bruit[AVM].dat,255,128,1000,0);
       if(cpt_start==60) play_sample((SAMPLE*)bruit[PRT].dat,255,128,1000,0);
       if(cpt_start==90) {
         clear_keybuf();
         play_sample((SAMPLE*)bruit[PAR].dat,255,128,1000,0);
       }
    }

    //on affiche l'image dans le buffer
     else if(cpt_start<63)
       masked_blit(cp3.partez(),buffer,0,0,cp3.posx(),cp3.posy(),200,200);

     //F10 ---> capture d'ecran est sauvegarde de l'image sous screenshoot.pcx
     if(key[KEY_F10])screenshoot();

     //la premiere touche est pressee
     if(keypressed()){
       cpt_vit=0;
       touche=readkey();
       if(((touche&0xff) == keyboard[0]) && compte==1){
         if(start && !cp3.arrive()){
             cp3.courre(cp3,p);cp3.recour(vitesse);
             compte=0;
             if(vitesse<EP1_VM )vitesse++;
         }
       }

       //la deuxieme touche est pressee
       else if(((touche&0xff) == keyboard[1]) && compte==0){
         if(start && !cp3.arrive()){
             cp3.courre(cp3,p);cp3.recour(vitesse);
             compte=1;
             if(vitesse<EP1_VM )vitesse++;
         }
       }
       //fin du jeu
       if((touche&0xff) == 27)fin=true;
     }
     //si on ne touche  rien, on decremente la vitesse
     else{
       cpt_vit++;
       if(cpt_vit%2==0 && vitesse!=0)  vitesse--;
       if(vitesse!=0)                  cp3.courre(cp3,p);
     }

     //on incremente le compteur de l'image du personnage
     if(start) p.avance(vitesse);

    //le personnage est arrive donc on stoque le chrono on
    if(p.pos()>=6100 && !cp3.arrive())
        cp3.fini(se1,di1);

    //on affiche le chrono dans le buffer image
    masked_blit((BITMAP *)dat_chr[EP1_CHR].dat,buffer,0,0,560,0,76,104);
    test_chrono();
    affiche_chrono(buffer,598,45,215);
    if(cp3.arrive() && se1-cp3.seconde()>3){fin=true;fade_out(5);}

    blit(buffer,screen,0,0,0,0,640,480);
    if(cpt_start==1)rest(1000);
    if(cpt_start<100){rest(13);cpt_start++;}
    else rest (etal);
  }
  //fin de la boucle principale

  clear_to_color(screen,0);
  //on calcul les points correspondant  la performance
  calc_100(cp3.seconde(),cp3.dixieme(),a[3]);

  for(int i=0;i<6;i++)
    if(i!=3)temp_ordi_100(a[i],diff);

  //petit decord qui affiche la performance de l'athlete
  panneau_score(a[3],1);

//  delete charscore;
  delete faux_depart;
  fin_musique((SAMPLE*)bruit[PUBLIC].dat,120);
  destroy_bitmap(buffer);
}

#endif
