#ifndef ___ATHLETE___
#define ___ATHLETE___

#include "../bitmap/drapeaux.h"
#include "aleat.h"
#include <fstream.h>

/**************************************/
//les codes des couleurs
//couleur de peau
#define BLANC    173
#define NOIR     8
#define CAFE     94

//couleur des cheveux
#define BLOND   107
#define ROUX    53
#define CHATAIN 51
#define BRUN    43

//les autres couleurs
#define JAUNE1   143
#define JAUNE2   35
#define VERT1    60
#define VERT2    54
#define BLEU1    200
#define BLEU2    186
#define ROUGE1   47
#define ROUGE2   4
#define VIOLET1  160
#define VIOLET2  111
#define ORANGE1  23
#define ORANGE2  17
#define GRIS1    172
#define GRIS2    129
#define BLANCHE  215
#define FONCE    43

/**************************************/





//retourne le code correspondant au petit drapeau (pallete 1)
int code_drapeaux_petit(int a){
  if(a<0)a=0;if(a>24)a=24;
  int code[25]={AFS2,ALG2,ALL2,ANG2,ARG2,AUS2,BRE2,CAM2,CAN2,CHI2,CUB2,ESP2,ETA2,
                FIN2,FRA2,GRE2,ITA2,JAP2,KEN2,MAR2,NIG2,POR2,RUS2,SUE2,UKR2};
  return code[a];
}

//retourne le code correspondant au petit drapeau (pallete 2)
int code_drapeaux_petit2(int a){
  if(a<0)a=0;if(a>24)a=24;
  int code[25]={AFS3,ALG3,ALL3,ANG3,ARG3,AUS3,BRE3,CAM3,CAN3,CHI3,CUB3,ESP3,ETA3,
                FIN3,FRA3,GRE3,ITA3,JAP3,KEN3,MAR3,NIG3,POR3,RUS3,SUE3,UKR3};
  return code[a];
}
//retourne le libelle du pays
char* lib_pays(int a){
  if(a<0)a=0;if(a>24)a=24;
  char* lib[25];
  for(int i=0;i<25;i++)lib[i]=new char[25];
  lib[0]= "Afrique du Sud\0";      lib[1]= "Algerie\0";      lib[2]= "Allemagne\0";
  lib[3]= "Angleterre\0";          lib[4]= "Argentine\0";    lib[5]= "Australie\0";
  lib[6]= "Bresil\0";              lib[7]= "Cameroun\0";     lib[8]= "Canada\0";
  lib[9]= "Chine\0";               lib[10]="Cuba\0";         lib[11]="Espagne\0";
  lib[12]="Etats-Unis\0";          lib[13]="Finlande\0";     lib[14]="France\0";
  lib[15]="Grece\0";               lib[16]="Italie\0";       lib[17]="Japon\0";
  lib[18]="Kenya\0";               lib[19]="Maroc\0";        lib[20]="Nigeria\0";
  lib[21]="Portugal\0";            lib[22]="Russie\0";       lib[23]="Suede\0";
  lib[24]="Ukraine\0";
  return lib[a];
}

//retourne le nom de l'athelte en fonction de son pays
char* nom_pays(int a){
  if(a<0)a=0;if(a>24)a=24;
  char * nom[25];
  for(int i=0;i<25;i++)nom[i]=new char[15];
  nom[0]="Moussa\0";     nom[1]="Youssef\0"; nom[2]="Dirke\0";
  nom[3]="Steve\0";      nom[4]="Diego\0";   nom[5]="Larry\0";
  nom[6]="Carlos\0";     nom[7]="Check\0";   nom[8]="Martin\0";
  nom[9]="Li\0";         nom[10]="Pedro\0";  nom[11]="Javier\0";
  nom[12]="John\0";      nom[13]="Mika\0";   nom[14]="Stephane\0";
  nom[15]="Nichos\0";    nom[16]="Mario\0";  nom[17]="Keiji\0";
  nom[18]="Ngombe\0";    nom[19]="Imad\0";   nom[20]="Mogomba\0";
  nom[21]="Miguel\0";    nom[22]="Igor\0";   nom[23]="Magnus\0";
  nom[24]="Sergei\0";
  return nom[a];
}
/******************************************************************************/
//Code aleatoire d'un pays
int has_pay(int a){
  int code[25]={0,1,19,7,20,   //afraicain
               4,6,8,10,12,   //Amerique
               5,9,17,18,24,  //asie russie kenya
               2,3,11,13,15,    //europe
               14,16,21,22,23};

   return code[a*5+aleat(5)];
}

//Code aleatoire pour les cheveux
int has_che(){
  int col[4]={BLOND,BRUN,CHATAIN,ROUX};
  return col[aleat(4)];
}
//Code aleatoire pour la peau
int has_pea(){
  int col[3]={BLANC,CAFE,NOIR};
  return col[aleat(3)];
}
//Code aleatoire pour les habits
int has_col(){
  int col[16]={JAUNE1,JAUNE2,ROUGE2,ROUGE1,BLEU1,BLEU2,VIOLET1,VIOLET2,
               ORANGE1,ORANGE2,FONCE,BLANCHE,GRIS1,GRIS2,VERT1,VERT2};
  return col[aleat(16)];
}

/******************************************************************************/

//CLasse athelte stoquant toutes les caractristique d'un athelete
class athlete{
private:
  int ind_p,     //indice pays
      col_p,     //couleur peau
      col_m,     //couleur maillot
      col_s,     //couleur short
      col_c,     //couleur chaussure
      col_h;     //couleur cheveux*
  char* n;      //le nom de l'athlete
  int * poi;     //contenant les points de chaque epreuve
  char * per[10];  //les performances de chaque epreuve
public:
   //constructeur
   athlete(int h=BLOND,int p=BLANC,int m=BLEU1,int s=ROUGE1,int c=VERT1,int a=0);

   //constructeur par copie
   athlete(const athlete &a);

   //reaffecteur
   athlete operator =(const athlete &a);

   //destructeur
  ~athlete(){delete []poi;delete[]n;for(int i=0;i<10;i++)delete per[i];}

  //acceseurs sur champs
  int peau(){return col_p;}     //retourne le code couleur de la peau
  int shor(){return col_s;}     //retourne le code couleur du short
  int mail(){return col_m;}     //retourne le code couleur du maillot
  int chau(){return col_c;}     //retourne le code couleur des chaussures
  int chev(){return col_h;}     //retourne le code couleur des cheveux
  int pays(){return ind_p;}     //retourne le code du pays
  char* nom(){return n;}       //retourne le nom

  //saisie un nouveau nom
  void nom(char * no){delete []n;n=new char [15];strcpy(n,no);}

  //renvoi le total de points de l'athlete
  int total(){
      int toto=0;
      for(int i=0;i<10;i++)if(poi[i]!=-1)toto+=poi[i];
      return toto;
  }

  //les points de l'epreuve a
  int poi_epr  (int a){if(a<0 || a>9)a=0;return poi[a];}
  //la performance de l'epreuve a
  char* lib_per(int a){if(a<0 || a>9)a=0;return per[a];}

  //fonction de conservation des performance d'avant
  void fini_epreuve(int n,char *lib,int m){
    strcpy(per[n],lib);       //libelle du resultat
    poi[n]=m;                 //nombre de point correspondant
  }

};

/*************************************************************************************/

 //constructeur
athlete::athlete(int h=BLOND,int p=BLANC,int m=BLEU1,int s=ROUGE1,int c=VERT1,int a=0):
   ind_p(a),col_p(p),col_m(m),col_s(s),col_c(c),col_h(h)
   {
     n=new char[15];strcpy(n,nom_pays(ind_p));
     poi=new int[10];
     for(int i=0;i<10;i++){poi[i]=-1;per[i]=new char[10];per[i]="   \0";}
   }

//constructeur par copie
   athlete::athlete(const athlete &a):ind_p(a.ind_p),col_p(a.col_p),col_m(a.col_m),
                                      col_s(a.col_s),col_c(a.col_c),col_h(a.col_h)
   {
     n=new char[15];strcpy(n,a.n);
     poi=new int[10];
     for(int i=0;i<10;i++){poi[i]=a.poi[i];per[i]=new char[10];strcpy(per[i],a.per[i]);}
   }

//reaffecteur
athlete athlete::operator =(const athlete &a){
   delete []n;n=new char[15];strcpy(n,a.n);
   ind_p=a.ind_p;
   col_p=a.col_p;col_c=a.col_c;col_h=a.col_h;
   col_m=a.col_m;col_s=a.col_s;
   for(int i=0;i<10;i++){
     poi[i]=a.poi[i];
     delete per[i];per[i]=new char[10];
     strcpy(per[i],a.per[i]);
   }
   return * this;
}



//boucle qui colorie un bout de l'image bmp[i]
void remplissage(fstream & f,int & nb,BITMAP *bmp,int  &coul){
  int x,y;
  for(int j=0;j<nb;j++){
     f>>x>>y;
     floodfill(bmp,x,y,coul);
  }
}

//coloriage des images en fonction des caracteristiques
void floodbitmap(BITMAP * bmp[],char * filename,int c,int p,int m,int s,int h){
   //notre flot
   fstream f(filename,ios::in);
   if(!f){
     allegro_exit();
     cout<<"Le fichier "<<filename<<" n'existe pas...\n";
     exit(50);
   }

   int nbimg;   //nombre d'images  remplir
   f>>nbimg;
   int nb;      //nombre de point  cliquer pour une couleur

   for(int i=0;i<nbimg;i++){
      //remplissage des cheveux
      f>>nb;remplissage(f,nb,bmp[i],c);
      //remplissage de la peau
      f>>nb;remplissage(f,nb,bmp[i],p);
      //remplissage du maillot
      f>>nb;remplissage(f,nb,bmp[i],m);
      //remplissage du short
      f>>nb;remplissage(f,nb,bmp[i],s);
      //remplissage des chaussures
      f>>nb;remplissage(f,nb,bmp[i],h);
   }
   f.close();
}



#endif




