#ifndef ___INTRODUCTION___
#define ___INTRODUCTION___

#include <allegro.h>
#include "iostream.h"
#define FACILE      0
#define MOYEN       1
#define DIFFICILE   2

#include "../audio/bronzeski.h"
#include "../bitmap/intro.h"
#include "../audio/sample.h"
#include "../bitmap/chargement.h"
#include "../font/font.h"
#include "../bitmap/menu.h"
#include "../bitmap/drapeaux.h"
#include "athlete.h"
#include "screenshoot.h"

//pototypes

void bloc_note(DATAFILE * menu);
void presentation();
void presente(int num);
void ready();
void rectangle_colore(int iche,int ipea,int imai,int isho,int icha);
void vestiaire(athlete & a,DATAFILE * menu,DATAFILE * bruit);
void credits(DATAFILE * menu,DATAFILE * bruit,DATAFILE * fon);
void config(athlete & a,int & etal);
bool menu(int & diff,int *touche,athlete & ath,int & etal);
void podium(athlete * ath);

/********************************************************************************/

//presentation du jeu   (minime)
void presentation(){
  clear_keybuf();
  DATAFILE * data=load_datafile("bitmap/intro.dat");
  set_palette((PALETTE)data[DEC_PAL].dat);
  clear_to_color(screen,255);
  blit((BITMAP *)data[DEC].dat,screen,0,0,57,203,525,74);
  readkey();
  fade_out(4);
  set_palette((PALETTE)data[SYD_PAL].dat);
  clear_to_color(screen,255);
  blit((BITMAP *)data[SYD].dat,screen,0,0,176,175,288,131);
  readkey();
  fade_out(4);
  clear_to_color(screen,0);
}

/********************************************************************************/

void presente(int num){
  text_mode(255);
  DATAFILE * data=load_datafile("bitmap/chargement.dat");
  DATAFILE * menu=load_datafile("bitmap/menu.dat");
  DATAFILE * fon=load_datafile("font/font.dat");
  set_palette((PALETTE)menu[OPT_PAL ].dat);
  bloc_note(menu);
  int code[3]={IM1,IM2,IM3};//,IM4,IM5,IM5,IM7,IM8,IM9,IM10};
  //affiche de l'image  l'ecran en fonction du numero de l'epreuve
  blit((BITMAP *)data[code[num-1]].dat,screen,0,0,195,148,200,200);
  char * nom[10];for(int i=0;i<10;i++)nom[i]=new char[15];
    nom[0]="100m\0";       nom[1]="Longueur\0";
    nom[2]="Poids\0";      nom[3]="Hauteur\0";
    nom[4]="400m\0";       nom[5]="110m Haies\0";
    nom[6]="Disque\0";     nom[7]="Perche\0";
    nom[8]="Javelot\0";    nom[9]="1500m\0";
  textprintf_centre(screen,(FONT*)fon[FONT2].dat,291,350,1,nom[num-1]);
  blit((BITMAP*)menu[CHARGEMENT].dat,screen,0,0,173,384,78,15);
  rect(screen,171,400,292,417,0);
  delete []nom;
  text_mode(0);
}


//indique  l'utilisateur que l'on est pret
void ready(){
   bool fin=false;
   clear_keybuf();
   DATAFILE * menu=load_datafile("bitmap/menu.dat");
   blit((BITMAP*)menu[PRESSEZ].dat,screen,0,0,279,382,172,15);
   while(!fin){
    if(key[KEY_F10])screenshoot();
    if(keypressed())fin=true;
   }
}



/******************************************************************************/


void bloc_note(DATAFILE * menu){
   set_palette((PALETTE)menu[OPT_PAL].dat);
   for(int i=0;i<4;i++)
     for(int j=0;j<6;j++)
       blit((BITMAP*)menu[OPT_BOIS].dat,screen,0,0,j*126,i*126,126,126);
   masked_blit((BITMAP*)menu[OPT_CRAY].dat,screen,0,0,10,180,54,218);
   masked_blit((BITMAP*)menu[OPT_CHRO].dat,screen,0,0,558,208,82,206);
   masked_blit((BITMAP*)menu[OPT_DECA].dat,screen,0,0,197,0,443,101);
   masked_blit((BITMAP*)menu[OPT_BLOC].dat,screen,0,0,135,110,316,330);
}


//affiche les rectangles colors
void rectangle_colore(int iche,int ipea,int imai,int isho,int icha){
  rectfill(screen,350,179,370,199,iche);
  rectfill(screen,350,214,370,234,ipea);
  rectfill(screen,350,249,370,269,imai);
  rectfill(screen,350,284,370,304,isho);
  rectfill(screen,350,319,370,339,icha);
}

//permet de modifier les caracteristiques (pays, cheveux...) de notre personnage
void vestiaire(athlete & a,DATAFILE * menu,DATAFILE * bruit){
  clear_keybuf();
  BITMAP * temp=create_bitmap(255,279);clear_to_color(temp,255);
  //chargement des datafiles
  DATAFILE * fon=load_datafile("font/font.dat");
  DATAFILE * drap=load_datafile("bitmap/drapeaux.dat");
  blit(screen,temp,165,142,0,0,255,279);
  rectfill(screen,167,142,167+255,142+279,255);
  //tableaux comprenant le code des couleurs
  int che[3]={CHATAIN,BRUN,BLOND};
  int pea[3]={BLANC,CAFE,NOIR};
  int col[8]={JAUNE2,ROUGE2,BLEU2,VIOLET2,FONCE,BLANCHE,GRIS2,VERT2};
  int che2[3]={157,18,166};
  int pea2[3]={237,189,91};
  int col2[8]={165,115,57,153,15,253,169,61};
  //indice pour les tableaux
  int iche=0,ipea=0,imai=1,isho=2,icha=4,ipay=14;
  bool fin=false;
  int indice=0;
  text_mode(255);
  textprintf(screen,(FONT*)fon[FONT2].dat,221,350,0,"Quitter");
  masked_blit((BITMAP*)menu[CHAUSSURE].dat,screen,0,0,165,150+indice*35,50,50);

  //carre colori  la bonne couleur
  rectangle_colore(che2[iche],pea2[ipea],col2[imai],col2[isho],col2[icha]);
  //affiche le drapeaux
  blit((BITMAP*)drap[code_drapeaux_petit2(ipay)].dat,screen,0,0,370,143,32,20);

  //boucle principale
  while(!fin){
    textprintf(screen,(FONT*)fon[FONT2].dat,221,140,0,lib_pays(ipay));
    textprintf(screen,(FONT*)fon[FONT2].dat,221,175,che2[iche],"Cheveux");
    textprintf(screen,(FONT*)fon[FONT2].dat,221,210,pea2[ipea],"Peau");
    textprintf(screen,(FONT*)fon[FONT2].dat,221,245,col2[imai],"Maillot");
    textprintf(screen,(FONT*)fon[FONT2].dat,221,280,col2[isho],"Short");
    textprintf(screen,(FONT*)fon[FONT2].dat,221,315,col2[icha],"Chaussures");
    if(key[KEY_UP] && indice!=0){
      play_sample((SAMPLE *)bruit[TIC].dat,255,128,1000,0);
      masked_blit((BITMAP*)menu[OPT_BLOC].dat,screen,170,192,165,150+indice*35,50,50);
      indice--;
      masked_blit((BITMAP*)menu[CHAUSSURE].dat,screen,0,0,165,150+indice*35,50,50);
    }
    if(key[KEY_DOWN] && indice!=6){
      play_sample((SAMPLE *)bruit[TIC].dat,255,128,1000,0);
      masked_blit((BITMAP*)menu[OPT_BLOC].dat,screen,170,192,165,150+indice*35,50,50);
      indice++;
      masked_blit((BITMAP*)menu[CHAUSSURE].dat,screen,0,0,165,150+indice*35,50,50);
    }
    //on change un parametre du personnage
    if(key[KEY_ENTER] || key[KEY_LEFT]){
      switch(indice){
        case 0:ipay=(ipay+1)%25;rectfill(screen,221,140,400,174,255);
        blit((BITMAP*)drap[code_drapeaux_petit2(ipay)].dat,screen,0,0,370,143,32,20);break;
        case 1:iche=(iche+1)%3;break;
        case 2:ipea=(ipea+1)%3;break;
        case 3:imai=(imai+1)%8;break;
        case 4:isho=(isho+1)%8;break;
        case 5:icha=(icha+1)%8;break;
      }
      rectangle_colore(che2[iche],pea2[ipea],col2[imai],col2[isho],col2[icha]);
    }
    //on quitte les vestiaires
    if(key[KEY_ENTER] && indice==6)fin=true;
    //on change un parametre mais dans
    if(key[KEY_RIGHT]){
      switch(indice){
        case 0:ipay--;if(ipay<0)ipay=24;rectfill(screen,221,140,400,174,255);
        blit((BITMAP*)drap[code_drapeaux_petit2(ipay)].dat,screen,0,0,370,143,32,20);break;
        case 1:iche--;if(iche<0)iche=2;break;
        case 2:ipea--;if(ipea<0)ipea=2;break;
        case 3:imai--;if(imai<0)imai=7;break;
        case 4:isho--;if(isho<0)isho=7;break;
        case 5:icha--;if(icha<0)icha=7;break;
      }
      rectangle_colore(che2[iche],pea2[ipea],col2[imai],col2[isho],col2[icha]);
    }
    if(key[KEY_F10])screenshoot();
    rest(100);
  }
  //reaffectation de notre athlete
  a=athlete(che[iche],pea[ipea],col[imai],col[isho],col[icha],ipay);
  a.nom("1UP\0");
  blit(temp,screen,0,0,165,142,255,279);
  destroy_bitmap(temp);
}


//affiche les cresits du jeu
void credits(DATAFILE * menu,DATAFILE * bruit,DATAFILE * fon){
  BITMAP * temp;
  temp=create_bitmap(255,279);clear_to_color(temp,255);
  blit(screen,temp,167,142,0,0,255,279);
  rectfill(screen,167,142,167+255,142+279,255);
  text_mode(255);
  textprintf_centre(screen,(FONT*)fon[FONT2].dat,167+128,142+5,109,"Decathlon version demo");
  textprintf(screen,(FONT*)fon[FONT2].dat,167+10,142+40,52,"Programmation");
  textprintf(screen,(FONT*)fon[FONT1].dat,167+173,142+47,57,"A.Thomas");
  textprintf(screen,(FONT*)fon[FONT2].dat,167+10,142+75,52,"Graphisme");
  textprintf(screen,(FONT*)fon[FONT1].dat,167+173,142+82,57,"A.Thomas");
  textprintf(screen,(FONT*)fon[FONT2].dat,167+10,142+110,52,"Conception");
  textprintf(screen,(FONT*)fon[FONT1].dat,167+173,142+117,57,"A.Thomas");
  textprintf_centre(screen,(FONT*)fon[FONT2].dat,167+128,142+160,109,"Merci a");
  textprintf_centre(screen,(FONT*)fon[FONT1].dat,167+128,142+200,57,"Allegro, FX, Cauch, Xavier");
  textprintf_centre(screen,(FONT*)fon[FONT1].dat,167+128,142+215,57,"Mr Monot, DAC REIMS");
  blit((BITMAP*)menu[PRESSEZ].dat,screen,0,0,220,380,172,15);
  clear_keybuf();
  readkey();
  blit(temp,screen,0,0,167,142,255,279);
  destroy_bitmap(temp);
}

//permet de choisir les touches que l'on desire
void choix_touche(int *touche,DATAFILE*menu){
  BITMAP * temp=create_bitmap(255,279);clear_to_color(temp,255);
  blit(screen,temp,167,142,0,0,255,279);
  rectfill(screen,167,142,167+255,142+279,255);
  clear_keybuf();
  blit((BITMAP*)menu[PRESSEZ].dat,screen,0,0,220,350,172,15);
  blit((BITMAP*)menu[PTC].dat,screen,0,0,194,240,172,57);
  touche[0]=readkey()&0xFF;clear_keybuf();
  rectfill(screen,194,240,194+172,240+57,255);
  blit((BITMAP*)menu[DTC].dat,screen,0,0,186,240,189,58);
  touche[1]=readkey()&0xFF;clear_keybuf();
  blit(temp,screen,0,0,167,142,255,279);
  destroy_bitmap(temp);
}



#include "centmetres.h"
//lance la configuration
void config(athlete & a,int & etal,DATAFILE * fon){
   etal=2;
   BITMAP * temp=create_bitmap(640,480);
   blit(screen,temp,0,0,0,0,640,480);
   fade_out(5);
   BITMAP * buf=create_bitmap(640,480);

   DATAFILE * data=load_datafile("epreuve/epr1_pis.dat");
   set_palette((PALETTE)data[EP1I_PAL].dat);
   clear_to_color(buf,makecol(0,0,0));
   textprintf_centre(buf,(FONT*)fon[FONT4].dat,320,30,10,"Petite page de coonfiguration");
   line(buf,40,60,600,60,11);
   textprintf_centre(buf,(FONT*)fon[FONT1].dat,320,100,10,"Vous allez voir une epreuve du 100 metres se derouler ,");
   textprintf_centre(buf,(FONT*)fon[FONT1].dat,320,130,10,"et vous devez etalonner le jeu pour que le personnage aille");
   textprintf_centre(buf,(FONT*)fon[FONT1].dat,320,160,10,"a une vitesse coherente par rapport a l'epreuve.");
   textprintf_centre(buf,(FONT*)fon[FONT1].dat,320,190,10,"Utilisez les fleches HAUT et BAS.");
   blit(buf,screen,0,0,0,0,640,480);
   clear_keybuf();
   readkey();

   //obliger de passer un int * pour construire une piste
   int * faux_depart=new int[6];
   for(int i=0;i<6;i++)faux_depart[i]=0;
   piste p(faux_depart);
   centper cp3(a,40,116,1,5,3);
   int vitesse=27;

   text_mode(-1);
   while(!key[KEY_ESC] ){
     blit(p.image(),buf,0,0,0,0,640,480);
     masked_blit(cp3.image(),buf,0,0,cp3.posx(),cp3.posy(),200,200);
     cp3.courre(cp3,p);cp3.recour(vitesse);
     p.avance(vitesse);

     textprintf_centre(buf,(FONT*)fon[FONT2].dat,320,10,makecol(255,255,255),"Utilisez les fleches HAUT et BAS pour etalonner");
     textprintf_centre(buf,(FONT*)fon[FONT2].dat,320,30,makecol(255,255,255),"le jeu a la bonne vitesse");
     textprintf(buf,(FONT*)fon[FONT2].dat,10,450,makecol(255,255,255),"ESC pour quitter");
     textprintf(buf,(FONT*)fon[FONT2].dat,600,450,makecol(255,255,255),"%d",etal);

     if(key[KEY_UP])   {etal++;clear_keybuf();}
     if(key[KEY_DOWN]) {if(etal>2)etal--;clear_keybuf();}

     blit(buf,screen,0,0,0,0,640,480);
     rest(etal);
   }


   blit(temp,screen,0,0,0,0,640,480);
   destroy_bitmap(temp);
   destroy_bitmap(buf);

   //ecriture de l'etalonnage dans le fichier pour pouvoir le recuperer la prochaine fois
   fstream f("config/config.cfg",ios::out);
   f<<etal;
   f.close();
   clear_keybuf();
}




//menu de choix (renvoi false si on desire quitter)
bool menu(int & diff,int *touche,athlete & ath,int & etal){
   //chargement des fichiers datafile
   DATAFILE * menu=load_datafile  ("bitmap/menu.dat");
   DATAFILE * bruit=load_datafile ("audio/sample.dat");
   DATAFILE * fon=load_datafile   ("font/font.dat");
   bloc_note(menu);
   text_mode(-1);
   textprintf(screen,(FONT*)fon[FONT2].dat,490,450,58,"F1   CONFIG");
   int iordi=0;
   int ordi[2]=  {OPT_ORD1,OPT_ORD2};
   int niveau[3]={OPT_FAC,OPT_MOY,OPT_DIF};
   int indice=0;
   blit((BITMAP*)menu[MENU_TEXTE].dat,screen,0,0,221,179,159,197);
   //affichage de la chaussure
   masked_blit((BITMAP*)menu[CHAUSSURE].dat,screen,0,0,171,184+indice*35,50,50);
   blit((BITMAP*)menu[niveau[diff]].dat,screen,0,0,325,279,82,32);//le niveau

   bool res=true;
   bool fin=false;

   while(!fin){
     if(key[KEY_ESC])fin=true;
     if(key[KEY_F10])screenshoot();  //capture d'ecran
     if(key[KEY_F1]){config(ath,etal,fon);set_palette((PALETTE)menu[OPT_PAL].dat);}
     if(key[KEY_ENTER]){
       switch(indice){
         case 0:play_sample((SAMPLE *)bruit[TIC].dat,255,128,1000,0);fin=true;break;
         case 1:play_sample((SAMPLE *)bruit[TIC].dat,255,128,1000,0);vestiaire(ath,menu,bruit);
                break;
         case 2:play_sample((SAMPLE *)bruit[TIC].dat,255,128,1000,0);
                choix_touche(touche,menu);break;
         case 3:diff=(diff+1)%3;blit((BITMAP*)menu[niveau[diff]].dat,screen,0,0,325,279,82,32);
                play_sample((SAMPLE *)bruit[TIC].dat,255,128,1000,0);break;
         case 4:play_sample((SAMPLE *)bruit[TIC].dat,255,128,1000,0);credits(menu,bruit,fon);clear_keybuf();break;
         case 5:fin=true;res=false;play_sample((SAMPLE *)bruit[TIC].dat,255,128,1000,0);break;
       }
     }
     if(key[KEY_LEFT] && indice==3){
       diff=(diff+1)%3;blit((BITMAP*)menu[niveau[diff]].dat,screen,0,0,325,279,82,32);
       play_sample((SAMPLE *)bruit[TIC].dat,255,128,1000,0);
     }
     if(key[KEY_RIGHT] && indice==3){
       diff--;if(diff<0)diff=2;blit((BITMAP*)menu[niveau[diff]].dat,screen,0,0,325,279,82,32);
       play_sample((SAMPLE *)bruit[TIC].dat,255,128,1000,0);
     }
     if(key[KEY_UP] && indice!=0){
       play_sample((SAMPLE *)bruit[TIC].dat,255,128,1000,0);
       masked_blit((BITMAP*)menu[OPT_BLOC].dat,screen,170,192,171,184+indice*35,50,50);
       indice--;
       //affichage de la chaussure
       masked_blit((BITMAP*)menu[CHAUSSURE].dat,screen,0,0,171,184+indice*35,50,50);
     }
     if(key[KEY_DOWN] && indice!=5){
       play_sample((SAMPLE *)bruit[TIC].dat,255,128,1000,0);
       masked_blit((BITMAP*)menu[OPT_BLOC].dat,screen,170,192,171,184+indice*35,50,50);
       indice++;
       //affichage de la chaussure
       masked_blit((BITMAP*)menu[CHAUSSURE].dat,screen,0,0,171,184+indice*35,50,50);
     }
     blit((BITMAP*)menu[ordi[iordi]].dat ,screen,0,0,360,312,32,31);
     iordi=(iordi+1)%2;
     rest(100);
   }
   text_mode(0);

   //test si on a configurer
   if(res){
     fstream f("config/config.cfg",ios::in);
     int valcfg;
     f>>valcfg;
     //si on a jamais configurer, il faut le faire au moins une fois
     if(valcfg==-1)
       {config(ath,etal,fon);set_palette((PALETTE)menu[OPT_PAL].dat);}
     f.close();
   }
   return res;
}


//affiche l'image de presentation avant d'entrer dans une epreuve


//le podium de fin
void podium(athlete * ath){
  //DATAFILE * drap=load_datafile("bitmap/drapeaux.dat");
  DATAFILE * data=load_datafile("bitmap/chargement.dat");
  DATAFILE * menu=load_datafile("bitmap/menu.dat");
  set_palette((PALETTE)menu[OPT_PAL ].dat);
  bloc_note(menu);
  blit((BITMAP *)data[PODIUM].dat,screen,0,0,183,137,230,198);
  athlete * tri=new athlete[6];
  for(int i=0;i<6;i++)tri[i]=ath[i];
  tri_athlete(tri);           //tri les athletes par ordre de points maximal
  bool fin=false;
  int xn[3]={298,225,375};
  int yn[3]={347,361,368};
  text_mode(-1);
  for(int i=0;i<3;i++){
    textprintf_centre(screen,font,xn[i],yn[i],0,tri[i].nom());
    textprintf_centre(screen,font,xn[i],yn[i]+15,0,"%dpts",tri[i].total());
  }
  blit((BITMAP*)menu[PRESSEZ].dat,screen,0,0,220,405,172,15);
  clear_keybuf();
  while(!fin){
    if(keypressed())fin=true;
    if(key[KEY_F10])screenshoot();
  }
  delete [] tri;
}


#endif
