#ifndef ___ACCESSOIRE___
#define ___ACCESSOIRE___

#include "allegro.h"
#include "string.h"
#include "../font/font.h"
#include "../bitmap/jeu.h"
#include "../epreuve/epr1_pis.h"
#include "athlete.h"


//permet de centrer le texte dans le panneau d'affichage
int centre_text(char * mot){
  int res=strlen(mot);
  if(res==9)res=0;
  else if(res>=7)res=1;
  else if(res>=5)res=2;
  else if(res>=3)res=3;
  else if(res>=1)res=4;
  return res;
}

//renvoi l'element maximal du tableau tab
int maximum(int* tab,int t){
  int res=tab[0];
  for(int i=0;i<t;i++)
    if(tab[i]>res)res=tab[i];
  return res;
}

//affiche dans la bmp, le panneau d'affichage avec les phrases correspondantes
void score(BITMAP*b,int x,int y,char * epr, char* perf,DATAFILE *jeu,DATAFILE * fon){
  set_palette((PALETTE)jeu[JEU_PAL].dat);
  text_mode(0);
  BITMAP * temp=create_bitmap(180,25);
  blit((BITMAP*)jeu[SCORE].dat,b,0,0,x,y,205,95);
  clear_to_color(temp,0);
  int centrage=centre_text(epr);
  for(int i=0;i<int(strlen(epr));i++)
    textprintf(temp,(FONT*)fon[FONT6].dat,centrage*19+i*19,0,29,"%c",epr[i]);
  masked_blit(temp,b,0,0,x+18,y+16,180,25);

  clear_to_color(temp,0);
  centrage=centre_text(perf);
  for(int i=0;i<int(strlen(perf));i++)
    textprintf(temp,(FONT*)fon[FONT6].dat,centrage*19+i*19,0,29,"%c",perf[i]);
  masked_blit(temp,b,0,0,x+18,y+45,180,25);
  destroy_bitmap(temp);
}

//barre de chargement
void charge(int n,DATAFILE*jeu){
  for(int i=0;i<20;i++)
  blit((BITMAP*)jeu[BARRE2].dat,screen,0,0,172+n*20+i,401,1,16);
}

//decord apres le 100 metres(ca ne sert un peu a rien)
void panneau_score(athlete & a,int num_epreuve){
  DATAFILE * jeu=load_datafile("bitmap/jeu.dat");
  DATAFILE * ep1=load_datafile("epreuve/epr1_pis.dat");
  DATAFILE * fon=load_datafile("font/font.dat");
  clear_to_color(screen,12);
  set_palette((PALETTE)ep1[EP1I_PAL ].dat);
  blit((BITMAP*)ep1[EP1_FOND].dat,screen,0,0,0,295,120,65);
  blit((BITMAP*)ep1[EP1_TOU].dat, screen,0,0,0,360,204,120);
  blit((BITMAP*)ep1[EP1_PIS].dat, screen,0,0,204,360,436,120);
  blit((BITMAP*)ep1[EP1_SYD].dat, screen,0,0,240,280,300,25);
  blit((BITMAP*)jeu[BD_SYD2].dat, screen,0,0,252,275,276,5);
  blit((BITMAP*)jeu[CHAISE].dat,screen,0,0,100,200,49,69);
  blit((BITMAP*)jeu[CHAISE].dat,screen,0,0,160,202,49,69);
  blit((BITMAP*)jeu[CHAISE].dat,screen,0,0,500,150,49,69);
  score(screen,200,100,a.nom(),a.lib_per(num_epreuve-1),jeu,fon);
  rest(2000);
  fade_out(5);
}

//affiche une image correpondant  l'angle pass
void angle(int ang,DATAFILE * fon,BITMAP * b,int x,int y){
  rect(b,x,y,x+100,y+60,215);rect(b,x+1,y+1,x+99,y+59,215);
  rectfill(b,x+2,y+2,x+98,y+58,0);
  textprintf_centre(b,(FONT*)fon[FONT3].dat,x+50,y+2,215,"%d",ang);
}


#endif
