#include "globals.h"
#include "particle_engine.h"

PARTICLE_ENGINE::PARTICLE_ENGINE()
{
	init();
}
PARTICLE_ENGINE::~PARTICLE_ENGINE()
{
	destroy();
}

void PARTICLE_ENGINE::setup(char *cImages, int iItems, int W, int H, int delay)
{
	bArray = load_bitmap_check(cImages, NULL);
	bItems = iItems;
	w = W;
	h = H;
	update_timer = ticks;
	update_delay = delay;
}

void PARTICLE_ENGINE::explode(int Count, int cx, int cy, int sx, int sy, float fCompact, float fGravity, float iSpeed, float iSpeed_Diff, int iLife)
{
	explode(Count, cx, cy, sx, sy, fCompact, fGravity, iSpeed, iSpeed_Diff, iLife, 1.0);
}

void PARTICLE_ENGINE::explode(int Count, int cx, int cy, int sx, int sy, float fCompact, float fGravity, float iSpeed, float iSpeed_Diff, int iLife, float ftrans)
{
	BITMAP *bTemp;
	int tx, ty, angle, x_pos;
	float tvx, tvy, sDiff;
	
	center_x = cx;
	center_y = cy;
	spread_x = sx;
	spread_y = sy;
	compact = fCompact;
	gravity = fGravity;
	speed = iSpeed;
	pCount = Count;

	bTemp = create_bitmap_check(w,h);

	if(ftrans > 1.0) ftrans = 1.0;
	if(ftrans < 0.0) ftrans = 0.0;
	
	for(int i = 0; i < pCount; i++)
	{
		if(pParticles[i] == NULL) pParticles[i] = new PARTICLE;
		else 
		{
			pCount++;
			if(pCount > MAX_PARTICLES) pCount = MAX_PARTICLES;
			continue;
		}
		if(bItems != 0) x_pos = (rand() % bItems) * w;
		else x_pos = 0;
		rectfill(bTemp, 0, 0, bTemp->w, bTemp->h, MASK);
		masked_blit(bArray, bTemp, x_pos, 0, 0, 0, w, h);
		tx = cx + rand() % int(sx * fCompact) - rand() % int(sx * fCompact);
		ty = cy + rand() % int(sy * fCompact) - rand() % int(sy * fCompact);
		if(tx > cx)
		{
			if(ty < cy) angle = 90 + rand() % 90;
			else angle = rand() % 90;
		}
		else
		{
			if(ty < cy) angle = 180  + rand() % 90;
			else angle = 180 + 90 + rand() % 90;
		}
		tvx = fixtof(fixsin(itofix((int)angle/1.40625))) * iSpeed;
		tvy = fixtof(fixcos(itofix((int)angle/1.40625))) * iSpeed;				
		if(iSpeed_Diff > 0.0) sDiff = float(rand() % int(iSpeed_Diff * 100)) - float(rand() % int(iSpeed_Diff * 100));
		else sDiff = 0.0;
		pParticles[i]->create(bTemp, tx, ty, tvx, tvy, fGravity, iLife + rand() % 10 - rand() % 10, iSpeed + sDiff, ftrans);
	}

	destroy_bitmap(bTemp);
}

void PARTICLE_ENGINE::destroy()
{
	if(bArray != NULL) destroy_bitmap(bArray);
	for(int i = 0; i < MAX_PARTICLES; i++)
		if(pParticles[i] != NULL)
			pParticles[i]->destroy();
}

void PARTICLE_ENGINE::draw(BITMAP *bDisplay)
{
	debug("PE draw() called!\n");
	if(pCount > 0)
	{	
		for(int i = 0; i < pCount; i++)
			if(pParticles[i] != NULL)
				pParticles[i]->draw(bDisplay);
		
	}
	debug("PE draw() DONE!\n");
}

void PARTICLE_ENGINE::update()
{
	debug("PE update() called!\n", 2);
	bool found = false;

	if(abs(ticks - update_timer) > update_delay)
	{
		for(int i = 0; i < pCount; i++)
		{
			if(pParticles[i] != NULL)
			{
				found = true;
				pParticles[i]->update();
				if(!pParticles[i]->visible)
				{
					pParticles[i]->destroy();
					pParticles[i] = NULL;
				}
			}
			
		}
		if(found == false) pCount = 0;
		update_timer = ticks;
	}
	debug("PE update() DONE!\n", 3);
}

void PARTICLE_ENGINE::clear()
{
	for(int i = 0; i < pCount; i++)
		if(pParticles[i] != NULL)
		{
			delete pParticles[i];
			pParticles[i] = NULL;
		}
}
	



void PARTICLE_ENGINE::init()
{
	for(int i = 0; i < MAX_PARTICLES; i++)
		pParticles[i] = NULL;
	center_x = 0;
	center_y = 0;
	spread_x = 0;
	spread_y = 0;
	compact = 0.0;

	pCount = 0;

	bArray = NULL;
	bItems = 0;
	w = 0;
	h = 0;
	update_delay = 0;
	update_timer = 0;
}