#include "globals.h"
#include "particle.h"

PARTICLE::PARTICLE()
{

}

PARTICLE::~PARTICLE()
{

}

void PARTICLE::create(BITMAP *bPic, float X, float Y, float VX, float VY, float fGravity, int iLife, int delay, float ftrans)
{
	x = X;
	y = Y;
	vx = VX;
	vy = VY;
	update_delay = delay;
	life = iLife;
	max_life = life;
	visible = true;
	g = fGravity;
	fTransparency = ftrans;

	bImage = create_bitmap_check(bPic->w, bPic->h);
	bTemp = create_bitmap_check(bImage->w, bImage->h);
	rectfill(bImage, 0, 0, bImage->w, bImage->h, MASK);
	draw_sprite(bImage, bPic, 0, 0);
}

void PARTICLE::destroy()
{
	if(bImage != NULL) destroy_bitmap(bImage);
	if(bTemp != NULL) destroy_bitmap(bTemp);
}

void PARTICLE::draw(BITMAP *bDisplay)
{
	if(visible)
	{
		angle += 2;
		if(angle > 360) angle = 0;		
	
		set_trans_blender(0,0,0, 255.0 * ((life) / float(max_life) * fTransparency));
		rectfill(bTemp, 0, 0, bTemp->w, bTemp->h, MASK);
		rotate_sprite(bTemp, bImage, 0, 0, itofix((int)angle/1.40625));
		draw_trans_sprite(bDisplay, bTemp, x, y);
		
	}
}

void PARTICLE::update()
{
	debug("PARTICLE update() called!\n", 5);
	if(visible && abs(ticks - update_timer) > update_delay)
	{
		x += vx;
		y += vy;
		vy += g;
		life--;
		if(life <= 0) visible = false;
		update_timer = ticks;
	}
	debug("PARTICLE update() DONE!\n", 5);
}
	



void PARTICLE::init()
{
	x = 0.0;
	y = 0.0;
	vx = 0.0;
	vy = 0.0; 
	g = 0.0;
	angle = 0;

	visible = false;
	iClear = 0;

	life = 0;
	max_life = 1;
	update_timer = 0;
	update_delay = 0;

	bImage = NULL;
	bTemp = NULL;

}
