#include "globals.h"
#include "allegro.h"
#include "allegro_joystick.h"

JOY::JOY()
{
	int i;

	for(i = 0; i < MAX_MAPPING; i++)
	{
		joy_mapping[i] = 0;
		joy_value_mapping[i] = 0;
	}
}

JOY::~JOY()
{

}

void JOY::map(int iIndex, int iType, int iValue)
{
	if(iIndex < 0 || iIndex >= MAX_MAPPING) return;
	joy_mapping[iIndex] = iType;
	joy_value_mapping[iIndex] = iValue;
}

bool JOY::MAP(int iValue) { return MAP(0, iValue);}

bool JOY::MAP(int mPID, int iValue)
{
	int iTest = 0;

	if(iValue < 0 || iValue >= MAX_MAPPING) return false;
	if(joy_mapping[iValue] == 0) return false;

	//poll_joystick();
	if(joy_mapping[iValue] == 1)
		iTest = joy[mPID].button[joy_value_mapping[iValue]].b;
		
	if(joy_mapping[iValue] == 2)
		iTest = joy[mPID].stick[joy_value_mapping[iValue]].axis[0].d1; //left

	if(joy_mapping[iValue] == 3)
		iTest = joy[mPID].stick[joy_value_mapping[iValue]].axis[0].d2;

	if(joy_mapping[iValue] == 4)
		iTest = joy[mPID].stick[joy_value_mapping[iValue]].axis[1].d1;

	if(joy_mapping[iValue] == 5)
		iTest = joy[mPID].stick[joy_value_mapping[iValue]].axis[1].d2;

	if(iTest) return true;
	return false;	
}	