#include "globals.h"
#include "lightning.h"

LIGHTNING::LIGHTNING()
{
	init();
}

LIGHTNING::~LIGHTNING()
{
	destroy();
}

void LIGHTNING::setup(int X, int Y, int B1, int B2, int B3, int B4)
{
	int tcolor;
	cx = X;
	cy = Y;
	b1 = B1;
	b2 = B2;
	b3 = B3; 
	b4 = B4;
	alive = true;
	iTransparency = 200;
	iLine_Trans = 200;
	life = 25;
	iCSize = 0;	
	
	for(int i = 0; i < MAX_BOLTS; i++)
	{
		tcolor = rand() % 50 + 200;
		if(rand() % 100 > 50)
			bBoltsUP[i]->setup(cx, cy, b2, 20, UPRIGHT, makecol(0, tcolor, 0), 10);
		else
			bBoltsUP[i]->setup(cx, cy, b1, 20, UPLEFT, makecol(0, tcolor, 0), 10);
		if(rand() % 100 > 50)
			bBoltsDOWN[i]->setup(cx, cy, b2, 420, DOWNRIGHT, makecol(tcolor, tcolor, 0), 10);
		else
			bBoltsDOWN[i]->setup(cx, cy, b1, 420, DOWNLEFT, makecol(tcolor, tcolor, 0), 10);

		if(rand() % 100 > 50)
			bBoltsLEFT[i]->setup(cx, cy, 0, b3, UPLEFT, makecol(tcolor, tcolor, 0), 10);
		else
			bBoltsLEFT[i]->setup(cx, cy, 0, b4, DOWNLEFT, makecol(tcolor, tcolor, 0), 10);

		if(rand() % 100 > 50)
			bBoltsRIGHT[i]->setup(cx, cy, 420, b3, UPRIGHT, makecol(tcolor, tcolor, 0), 10);
		else
			bBoltsRIGHT[i]->setup(cx, cy, 420, b4, DOWNRIGHT, makecol(tcolor, tcolor, 0), 10);
	}
	
}

void LIGHTNING::destroy()
{	
	for(int i = 0; i < MAX_BOLTS; i++)
	{
		if(bBoltsUP[i] != NULL) delete bBoltsUP[i];
		if(bBoltsLEFT[i] != NULL) delete bBoltsLEFT[i];
		if(bBoltsRIGHT[i] != NULL) delete bBoltsRIGHT[i];
		if(bBoltsDOWN[i] != NULL) delete bBoltsDOWN[i];
	}

}


void LIGHTNING::draw(BITMAP *bDisplay)
{	
	if(!alive) return;

	if(iTransparency > 0)
	{
		set_trans_blender(255,255,255, iTransparency);
		draw_lit_sprite(bDisplay, bDisplay, 0, 0, iTransparency);
	}

	if(iLine_Trans > 0)
	{
		set_trans_blender(0,0,0, iLine_Trans);
		drawing_mode(DRAW_MODE_TRANS, bDisplay, 0, 0);		
		rectfill(bDisplay, cx - 5, 0, cx + 5, cy, WHITE);
		circlefill(bDisplay, cx, cy, iCSize, WHITE);
		drawing_mode(DRAW_MODE_SOLID, bDisplay, 0, 0);
	}
	set_trans_blender(0,0,0, 255.0 * float(life) / 25.0);
	drawing_mode(DRAW_MODE_TRANS, bDisplay, 0, 0);
	for(int i = 0; i < MAX_BOLTS; i++)
	{
		if(bBoltsUP[i] != NULL)
			bBoltsUP[i]->draw(bDisplay);

	
		if(bBoltsLEFT[i] != NULL)
			bBoltsLEFT[i]->draw(bDisplay);

	
		if(bBoltsRIGHT[i] != NULL)
			bBoltsRIGHT[i]->draw(bDisplay);

	
		if(bBoltsDOWN[i] != NULL)
			bBoltsDOWN[i]->draw(bDisplay);
	}
	drawing_mode(DRAW_MODE_SOLID, bDisplay, 0, 0);
}

void LIGHTNING::update()
{
	debug("LIGHTNING update() called!\n", 2);
	if(!alive) return;

	if(abs(ticks - flash_timer) > 3)
	{
		iTransparency -= 25;
		iLine_Trans -= 20;
		iCSize += 5;
		flash_timer = ticks;
		life--;
	}
	for(int i = 0; i < MAX_BOLTS; i++)
	{
		if(bBoltsUP[i] != NULL)
			bBoltsUP[i]->update();				
		if(bBoltsLEFT[i] != NULL)
			bBoltsLEFT[i]->update();	
		if(bBoltsRIGHT[i] != NULL)
			bBoltsRIGHT[i]->update();	
		if(bBoltsDOWN[i] != NULL)
			bBoltsDOWN[i]->update();
	}
	generate();	

	if(life <= 0)
		alive = false;
	debug("LIGHTNING update() DONE!\n", 2);
}


void LIGHTNING::generate()
{
	for(int i = 0; i < MAX_BOLTS - (life / 5); i++)
	{      
			generate_up(i);				
			generate_down(i);			
			generate_left(i);			
			generate_right(i);
	}
}
void LIGHTNING::generate_up(int i)
{
	int tcolor;
	if(bBoltsUP[i]->complete())
	{
		tcolor = rand() % 50 + 200;
		if(bBoltsUP[i]->dDirection == UPRIGHT)
			bBoltsUP[i]->setup(bBoltsUP[i]->cx, bBoltsUP[i]->cy, b1, 20, UPLEFT, makecol(tcolor / 2,tcolor,tcolor/2), rand() % 15 + 5);
		else if(bBoltsUP[i]->dDirection == UPLEFT)
			bBoltsUP[i]->setup(bBoltsUP[i]->cx, bBoltsUP[i]->cy, b2, 20, UPRIGHT, makecol(tcolor / 2,tcolor,tcolor/2), rand() % 15 + 5);

		bBoltsUP[i]->complete();
	}
	
}
		
void LIGHTNING::generate_down(int i)
{
	int tcolor;
	
	if(bBoltsDOWN[i]->complete())
	{
		tcolor = rand() % 50 + 200;
		if(bBoltsDOWN[i]->dDirection == DOWNRIGHT)
			bBoltsDOWN[i]->setup(bBoltsDOWN[i]->cx, bBoltsDOWN[i]->cy, b1, 420, DOWNLEFT, makecol(tcolor/2,tcolor,tcolor/2), rand() % 25 + 5);
		else if(bBoltsDOWN[i]->dDirection == DOWNLEFT)
			bBoltsDOWN[i]->setup(bBoltsDOWN[i]->cx, bBoltsDOWN[i]->cy, b2, 420, DOWNRIGHT, makecol(tcolor/2,tcolor,tcolor/2), rand() % 25 + 5);
	}
	bBoltsDOWN[i]->complete();

}


void LIGHTNING::generate_left(int i)
{
	int tcolor;
	
	if(bBoltsLEFT[i]->complete())
	{
		tcolor = rand() % 50 + 200;
		if(bBoltsLEFT[i]->dDirection == DOWNLEFT)
			bBoltsLEFT[i]->setup(bBoltsLEFT[i]->cx, bBoltsLEFT[i]->cy, 20, b3, UPLEFT, makecol(tcolor/2,tcolor,tcolor/2), rand() % 15 + 5);
		else if(bBoltsLEFT[i]->dDirection == UPLEFT)
			bBoltsLEFT[i]->setup(bBoltsLEFT[i]->cx, bBoltsLEFT[i]->cy, 20, b4, DOWNLEFT, makecol(tcolor/2,tcolor,tcolor/2), rand() % 15 + 5);
	}

	bBoltsLEFT[i]->complete();

}

void LIGHTNING::generate_right(int i)
{
	int tcolor;
	
	if(bBoltsRIGHT[i]->complete())
	{
		tcolor = rand() % 50 + 200;
		if(bBoltsRIGHT[i]->dDirection == DOWNRIGHT)
			bBoltsRIGHT[i]->setup(bBoltsRIGHT[i]->cx, bBoltsRIGHT[i]->cy, 420, b3, UPRIGHT, makecol(tcolor/2,tcolor,tcolor/2), rand() % 15 + 5);
		else if(bBoltsRIGHT[i]->dDirection == UPRIGHT)
			bBoltsRIGHT[i]->setup(bBoltsRIGHT[i]->cx, bBoltsRIGHT[i]->cy, 420, b4, DOWNRIGHT, makecol(tcolor/2,tcolor,tcolor/2), rand() % 15 + 5);

		bBoltsRIGHT[i]->complete();
	}

}


void LIGHTNING::init()
{
	iCSize = 0;
	cx = 0;
	cy = 0;
	b1 = 0;
	b2 = 0;
	b3 = 0;
	b4 = 0;

	alive = false;

	iTransparency = 0;
	flash_timer = 0;

	iLine_Trans = 0;

	for(int i = 0; i < MAX_BOLTS; i++)
	{
		bBoltsUP[i] = new SINGLE_BOLT;
		bBoltsDOWN[i] = new SINGLE_BOLT;
		bBoltsLEFT[i] = new SINGLE_BOLT;
		bBoltsRIGHT[i] = new SINGLE_BOLT;		
	}

	life = 0;

}