/**************************************************
*  FILE:  toggle.h		                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  7/15/2006                               *
*                                                 *
*  Handles the toggle object, which moves up and  *
*  down when mouse is over it.                    *
**************************************************/

#ifndef _TOGGLE_H_
#define _TOGGLE_H_


//#include "water.h"
//#include "board.h"
#define WATER_SHIFT 2
#define TIMER_WATER_SHIFT 15
#define FIRST_COMBO 10
#define SECOND_COMBO 25
#define THIRD_COMBO 45
#define FOURTH_COMBO 70
#define MBUFFER 3
typedef class WATER water;
typedef class games GAMES;
//typedef class BOARD board;
//typedef struct game GAMES;

class TOGGLE
{
public:
	int x,y;
	
	TOGGLE();
	~TOGGLE();

	//void setup(games gCurrent_Game, char *cpath, char *cpath1, char *cpath2, int X, int Y, int W, int H, bool bVisible, int iDifficulty);
	//void setup(games gCurrent_Game);
	void setup(int X, int Y, int W, int H, bool bVisible, int iDifficulty);

	void destroy();
	void update(int mx, int my);
	void draw(BITMAP *bDisplay);

	bool is_visible();
	bool is_floating();
	void toggle(int mx, int my);
	void ripple_water(WATER *wToggles_Water);
	int iType();

	void toggle_down();
	bool mouse_over(int mx, int my);
	bool loose_mouse_over(int mx, int my);


private:
	int w,h;
	RGB col;
	BITMAP *bImage, *bPiece;	
	BITMAP *bTransfer;
	int rType;
	int rUpdate;
	int rCount;

	int water_float;
	bool moving_up;
	int water_time;
	int toggle_timer;
	bool visible;
	bool lock;
	int type;
	int difficulty;

	int freq;

	bool up_or_down;  // 0 for down, 1 for up

	float fIntensity, fGlow;
	bool bFlash_Dir;
	int flash_timer, glow_timer;

	bool bToggle_Animate;
	bool bToggle_Animate_Direction;
    int toggle_animate_timer;
	int iTransparency;
		
	

    void init();
	void combos();
	void update_image();
	void choose_type();
	void random_type();
	void float_on_water();
	void flash_animate();
	void glow_animate(int mx, int my);
	void toggle_animate();
	//void create_message(char *s);

};

#endif /* End of _TOGGLE_H_ */
