/**************************************************
*  FILE:  globals.h		                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE: 03/30/2007                               *
*                                                 *
*  Home of all the helper functions declared in   *
*  the global spectrum.                           *
**************************************************/

#ifndef _GLOBALS_H_
#define _GLOBALS_H_

#include "allegro.h"
#include "allegro_color.h"
#include "allegro_input.h"
#include "game.h"
#include <vector>
using namespace std;

#define GFX_W 320
#define GFX_H 240
extern BITMAP *buffer;
extern games GAME;


// ******* Timer Setup ********
extern volatile int draw_ticks;
extern volatile int ticks;
extern volatile int framerate;
extern volatile int system_time;
extern int iTimer_Speed;
void timer1(void);
void timer2(void);

int seconds(int iTime);
bool dTime(int iTime);

extern FILE *flog;

extern bool iFrameRate;

void init();
void shutdown();
BITMAP *create_bitmap_check(int width, int height);
BITMAP *create_sub_bitmap_check(BITMAP *bParent, int x, int y, int width, int height);
BITMAP *load_bitmap_check(char *cpath, RGB *pal);
void destroy_bitmap_check(BITMAP *b);
bool screen_fade_in(int iTime);
bool screen_fade_out(int iTime);
int distance_squared(int x1, int y1, int x2, int y2);
void rrect(BITMAP *bDisplay, int x1, int y1, int x2, int y2, int r, int col);
void rrectfill(BITMAP *bDisplay, int x1, int y1, int x2, int y2, int r, int col);
void create_message(char *s);
void debug(char *msg);
void debug(char *msg, int level);

static void fblend_trans_32(BITMAP *src, BITMAP *dst, int src_x, int src_y, int dst_x, int dst_y, int w, int h, int fact) 
{
	if(GAME.configuration->bpp != 32)
	{
		draw_trans_sprite(dst, src, dst_x, dst_y);
		return;
	}

	if (fact == 128 || fact == 127) {
	   	int i, j;
    	
		for (j = 0; j < h; j++) {

			unsigned long *s, *d;
			unsigned long color1, color2;
		
			/* Read src line */			
			bmp_select(dst);
			s = (unsigned long*)(src->line[src_y + j] + src_x * sizeof(long));
			d = (unsigned long*)(bmp_write_line(dst, dst_y + j) + dst_x * sizeof(long));
		    
			for (i = w; i; i--) {
 
				/* Read data, 1 pixel at a time */
				color2 = *s;
				color1 = *d;

				if (color2 == MASK_COLOR_32) {
					s++;
					d++;
					continue;
				}

				color1 =  ((color1 & 0xFEFEFE) >> 1)
						+ ((color2 & 0xFEFEFE) >> 1)
						+ (color1 & color2 & 0x010101);

	 			/* Write the data */
				s++;
				bmp_write32((unsigned long)d, color1);
				d++;
			}
		}
	}
	else {
    	int i, j;

		for (j = 0; j < h; j++) {

			unsigned long *s, *d;
			unsigned long color1, color2;
	
			/* Read src line */
			
			bmp_select(dst);
			s = (unsigned long*)(src->line[src_y + j] + src_x * sizeof(long));
			d = (unsigned long*)(bmp_write_line(dst, dst_y + j) + dst_x * sizeof(long));
	    
			for (i = w; i; i--) {
				unsigned long temp1, temp2;
 
				/* Read data, 1 pixel at a time */
				color2 = *s;
				color1 = *d;
				
				if (color2 == MASK_COLOR_32) {
					s++;
					d++;
					continue;
				}
				
				/* Mutiply by the factor */
				temp2 = color1 & 0xFF00FF;
				temp1 = (color2 & 0xFF00FF) - temp2;
				temp1 = (((temp1 * fact) >> 8) + temp2) & 0xFF00FF;
				color1 &= 0xFF00;
				color2 &= 0xFF00;
				temp2 = ((((color2 - color1) * fact) >> 8) + color1) & 0xFF00;

	 			/* Write the data */
				s++;
				bmp_write32((unsigned long)d, temp1 | temp2);
				d++;
			}
		}
	}
	
	return;
}



#endif /* End of _GLOBALS_H_ */

