/**************************************************
*  FILE:  allegro_input.h                         *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  5/07/2006                               *
*                                                 *
*  Configures a dynamic mapping of all input,     *
*  either keyboard or joystick, to main input.    *
**************************************************/

#ifndef _ALLEGRO_INPUT_H_
#define _ALLEGRO_INPUT_H_

#define MAX_MAPPING 50
typedef class INPUT input;


#include "allegro_keyboard.h"
#include "allegro_joystick.h"

/*  Quick key associations  */
#define ACCEPT 0
#define ACTION_1 1
#define ACTION_2 2
#define CANCEL 3
#define LEFT 4
#define RIGHT 5
#define UP 6
#define DOWN 7

extern int input_timer;

class INPUT
{
public:
	JOY *JOYSTICK;
	myKEY *KEYBOARD;
	INPUT();
	~INPUT();


	void map(int iIndex, int iType, int iValue, int jType);

	/*  Checks if the key or joystick mapped to iValue has been accepted.  */
	bool MAP(int iValue);

	/*  Checks if the key or joystick mapped to iValue has been accepted with a 
	cool down timer set to iTimer_Delay  */
	bool MAP(int iValue, int iTimer_Delay);

	/*  Checks if the key or joystick[mPID] mapped to iValue has been accepted with a 
	cool down timer set to iTimer_Delay  */
	bool MAP(int mPID, int iValue, int iTimer_Delay);
};

#endif /* End of _ALLEGRO_INPUT_H_*/
