#include "globals.h"
#include "toggle.h"
#include "game.h"
#include <string.h>
#include <math.h>


TOGGLE::TOGGLE()
{
	init();
}

TOGGLE::~TOGGLE()
{

}

void TOGGLE::init()
{
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	bImage = NULL;
	up_or_down = false;  
	moving_up = false;
	water_float = 0;
	water_time = 0;
	toggle_timer = 0;
	visible = false;
	lock = false;
/*	bType[0] = NULL;
	bType[1] = NULL;
	bType[2] = NULL;*/
	bTransfer = NULL;
	rType = 0;
	rUpdate = 0;
	rCount = 0;

	fIntensity = 0.0;
	fGlow = 0.0;
	bFlash_Dir = false;
	flash_timer = 0;
	glow_timer = 0;

	bToggle_Animate = false;
	bToggle_Animate_Direction = false;
    toggle_animate_timer = 0;
	iTransparency = 0;

	bPiece = load_bitmap("./data/images/toggle_piece.pcx", NULL);
	col.r = 255;
	col.g = 255;
	col.b = 255;

	freq = 1000;
}


void TOGGLE::setup(int X, int Y, int W, int H, bool bVisible, int iDifficulty)
{
	if(bImage != NULL) destroy_bitmap(bImage);
	if(bTransfer != NULL) destroy_bitmap(bTransfer);

	bImage = create_bitmap_check(W, H);	
	bTransfer = create_bitmap_check(W + (WATER_SHIFT * 2), H  + (WATER_SHIFT * 2));

	x = X;
	y = Y;
	w = W;
	h = H;
	up_or_down = true;
	
	visible = true;
	bToggle_Animate = true;	
		
	if(bVisible)
	{
		bToggle_Animate_Direction = false;
		iTransparency = 0;
	}
	else
	{
		iTransparency = 255;
		bToggle_Animate_Direction = true;
	}
		

	bFlash_Dir = true;
	fIntensity = rand() % 250 / 255.0;
    
	water_float = (rand() % WATER_SHIFT + 1) - (rand() % WATER_SHIFT + 1);
	water_time = rand() % (TIMER_WATER_SHIFT + 35);
	if(rand() % 100 > 50)
		moving_up = true;
	else moving_up = false;
	difficulty = iDifficulty;

	choose_type();
	
	update_image();
}




void TOGGLE::update_image()
{
	int iPrimary = 255 * fIntensity;
	float iGlow = 255 * fGlow * 0.85;


	if(fIntensity > 1.0) fIntensity = 1.0;
	if(bToggle_Animate_Direction == true)
	{
		rectfill(bImage, 0, 0, bImage->w, bImage->h, BLACK);		
		type = 2;
		GAME.bBoard->draw_type(bImage, type, 0,0,0, 1.0);		
		return;
	}
	
	if(type == 1)
	{			
		rectfill(bImage, 0, 0, bImage->w, bImage->h, makecol(iGlow, iPrimary, iGlow));
		GAME.bBoard->draw_type(bImage, type - 1, iGlow, iPrimary, iGlow, fIntensity);
	}
	else if(type == 2)
	{		
		rectfill(bImage, 0, 0, bImage->w, bImage->h, makecol(iPrimary, iGlow * 0.5, iGlow * 0.5));
		GAME.bBoard->draw_type(bImage, type - 1, iPrimary, iGlow * 0.5, iGlow * 0.5, fIntensity);
	}
	else if(type == 3)
		GAME.bBoard->draw_type(bImage, type - 1, iGlow, iGlow, iGlow, 0);
	else if(type == 4)
		GAME.bBoard->draw_type(bImage, rType, iGlow, iGlow, iGlow, 0);
	else
	{
		//New type!
		rectfill(bImage, 0, 0, bImage->w, bImage->h, makecol(iGlow * 0.5, iGlow * 0.5, iPrimary));
		GAME.bBoard->draw_type(bImage, 3, iGlow * 0.5, iGlow * 0.5, iPrimary, fIntensity);
	}
		
}

void TOGGLE::choose_type()
{
	float fTemp;
	type = 1;	
	GAME.bBoard->generate_bonus(difficulty, x, y);

	if(rand() % 100 == 1)
		type = 5;	

	if(difficulty < 6) 
		return;
		
	if(difficulty >= 6)
	{
		fTemp = (((difficulty) / 100.0) - 0.05) * 0.5;
		if(fTemp > 0.1) fTemp = 0.1;
		if(rand() % 100 < 100 * fTemp)
		{		
			type = 2;
		}
	}
	if(difficulty >= 8)
	{
		fTemp = (((difficulty) / 100.0) - 0.07) * 0.5;
		if(fTemp > 0.15) fTemp = 0.15;
		if(rand() % 100 < 100 * fTemp)
		{		
			type = 4;
		}
	}
	if(difficulty >= 10)
	{
		fTemp = (((difficulty) / 100.0) - 0.09) * 0.5;
		if(fTemp > 0.08) fTemp = 0.08;
		if(rand() % 100 < 100 * fTemp)
			type = 3;
	}
}

void TOGGLE::destroy()
{
	if(bImage != NULL) {destroy_bitmap(bImage); bImage = NULL;}
	if(bTransfer != NULL) {destroy_bitmap(bTransfer); bTransfer = NULL;}	
}

void TOGGLE::update(int mx, int my)
{	
	debug("TOGGLE update() called!\n", 2);
	toggle(mx, my);
	if(!is_visible()) return;
	float_on_water();
	random_type();

	
	flash_animate();
	glow_animate(mx, my);
	
	toggle_animate();	
	debug("TOGGLE update() DONE!\n", 3);
}

void TOGGLE::glow_animate(int mx, int my)
{
	if(abs(ticks - glow_timer) > 0)
	{
		glow_timer = ticks;
		if(pow(mx - (x+w/2),2) + pow(my - (y+h/2),2) < pow(w*3,2))
		{
			fGlow += 0.05;
			fIntensity += 0.2;
			bFlash_Dir = false;			
			
			if(fGlow > 1.0) 
				fGlow = 1.0;
			if(fIntensity > 1.0) 
				fIntensity = 1.0;
		}
		else
		{
			fGlow -= 0.021;
			if(fGlow < 0.0)		
				fGlow = 0.0;
		}
	}

}

void TOGGLE::toggle_animate()
{
	if(bToggle_Animate)
	{
		if(abs(ticks - toggle_animate_timer) > 4)
		{
			if(!bToggle_Animate_Direction)
			{
				iTransparency += 51;
				water_float--;
				if(water_float <= (WATER_SHIFT * -1)) water_float++;
				if(iTransparency >= 255)
				{					
					iTransparency = 255;
					bToggle_Animate = false;					
				}
			}
			else
			{
				iTransparency -= 51;
				water_float++;
				if(iTransparency <= 0)
				{
					float convert_x = (GAME.wToggles_Water->iWidth) / 365.0;
					float convert_y = (GAME.wToggles_Water->iHeight) / 365.0;

					iTransparency = 0;
					bToggle_Animate = false;
					visible = false;
					freq = 1000;
					GAME.wToggles_Water->submerge(bImage, x * convert_x, (y + 5) * convert_y, bImage->w * convert_x, bImage->h * convert_y);
				}
			}
			toggle_animate_timer = ticks;
		}
	}

}

void TOGGLE::flash_animate()
{
	if(abs(ticks - flash_timer) > 2)
	{
		if(bFlash_Dir)
		{
			fIntensity += 0.05;
			if(fIntensity >= 1.0) 
			{
				fIntensity = 1.0;
				bFlash_Dir = false;
			}
		}
		else
		{
			fIntensity -= 0.02;
			if(fIntensity <= 0.4) 
			{
				fIntensity = 0.4;
				bFlash_Dir = true;
			}
			if(fGlow > 0.0 && fIntensity < fGlow) fIntensity = fGlow;
		}
		flash_timer = ticks;
	}
}


void TOGGLE::random_type()
{
	if(type != 4) return;

	if(abs(ticks - rUpdate) > 5)
	{
		rType++;
		if(rType > 2) rType = 0;
		rUpdate = ticks;
		rCount++;
		if(rCount >= 50 + (rand() % 2) ) type = rType + 1;
	}
}


void TOGGLE::float_on_water()
{
	if(abs(ticks - water_time) > TIMER_WATER_SHIFT)
	{
		if(visible)
		{
			if(moving_up)
			{
				water_float--;
				if(water_float <= (WATER_SHIFT * -1)) moving_up = false;
			}
			else
			{
				water_float++;
				if(water_float >= WATER_SHIFT) 
				{
					moving_up = true;
					ripple_water(GAME.wToggles_Water);
				}
			}
		}

		water_time = ticks;
	}

}

void TOGGLE::draw(BITMAP *bDisplay)
{
	debug("TOGGLE draw() called!\n");
	if(visible == true)
	{
		if(strcmp(GAME.configuration->level, "LOW") != 0)
		{
			update_image();
			rectfill(bTransfer, 0, 0, bTransfer->w, bTransfer->h, MASK);
			
			stretch_sprite(bTransfer, bImage, WATER_SHIFT + water_float, WATER_SHIFT + water_float, bImage->w - water_float * 2, bImage->h - water_float * 2);
			

			if(bToggle_Animate)
			{
				set_trans_blender(0,0,0, iTransparency);							
				draw_trans_sprite(bDisplay, bTransfer, x, y);	
			}
			else	
				draw_sprite(bDisplay, bTransfer, x, y);

		}		
		else
		{
			update_image();
			draw_sprite(bDisplay, bImage, x, y);
		}
		
	}
	debug("TOGGLE draw() DONE!\n");
}

bool TOGGLE::is_visible()
{
	return visible;
}

bool TOGGLE::is_floating()
{
	if(visible && bToggle_Animate_Direction == true)
		return false;
	return visible;
}

void TOGGLE::toggle(int mx, int my)
{
	if(mouse_over(mx,my))
	{
		if(lock == false)
		{
			if(visible) 
			{
				if(type != 3)
				{
										
					combos();

					if(bToggle_Animate_Direction && bToggle_Animate)
					{
						GAME.audio.play_sfx(15, freq);
						freq += 300;
						//GAME.peCombo->explode(5, mx,my, 100, 100, 0.5, 0.28, 5.0, 0.05, 15);					
						GAME.peZip_Stars->explode(10, x +(w), y +(h), 50, 50, 0.5, 0.01, 5.05, 0.05, 15);
						//create_message("z");
					}
					else
						GAME.audio.play_sfx(7);
				}
				/* Type 1 is the only time you have a successful toggle when visible,
				or you can force toggle through toggle_down function */
				if(type == 1 || type == 5)
				{														
					bToggle_Animate = true;
					bToggle_Animate_Direction = true;
				}
				else if(type == 2)									
					type = 1;				
				else if(type == 4)
					type = rType + 1;				
				
			}
			else 
			{				
				GAME.gScore->subtract(50 * (GAME.level / 5 + 1));
				GAME.bBoard->iConsecutive = 0;
				GAME.bBoard->iConsistent = 0;
				GAME.bBoard->iIncrement = 10;
				visible = true;
				choose_type();		
				bToggle_Animate = true;
				bToggle_Animate_Direction = false;
			}
			lock = true;
		}
	}
	else
		lock = false;
}

void TOGGLE::toggle_down()
{
	//float convert_x = float(GAME.wToggles_Water->iWidth) / 365.0;
	//float convert_y = float(GAME.wToggles_Water->iHeight) / 365.0;
	
	if(visible) 
	{
		//visible = false;
		//gCurrent_Game.wToggles_Water->submerge(bImage, x * convert_x, (y + 5) * convert_y, bImage->w * convert_x, bImage->h * convert_y);
		GAME.gScore->add(1 + (GAME.level / 5));
		bToggle_Animate = true;
		bToggle_Animate_Direction = true;		
	}
	
}

bool TOGGLE::mouse_over(int mx, int my)
{
	if(mx > WATER_SHIFT + x + water_float - MBUFFER && mx < WATER_SHIFT + x + w + MBUFFER - water_float
		&& my > WATER_SHIFT + y + water_float - MBUFFER && my < WATER_SHIFT + y - water_float + h + MBUFFER)
	{
		return true;
	}
    
	return false;
}

bool TOGGLE::loose_mouse_over(int mx, int my)
{
	if(mx > WATER_SHIFT + x + water_float - 8 && mx < WATER_SHIFT + x + w + 8 - water_float
		&& my > WATER_SHIFT + y + water_float - 8 && my < WATER_SHIFT + y - water_float + h + 8)
	{
		return true;
	}
    
	return false;
}




void TOGGLE::combos()
{
	if(type == 5)
		GAME.bBoard->combo(10);
	else							
		GAME.bBoard->combo(1);

	// ******************************************
	// *        Combos removed from v2.0+       *
	// ******************************************

}

int TOGGLE::iType()
{
	return type;
}

void TOGGLE::ripple_water(WATER *wToggles_Water)
{
	int wsize = 1000;
	float convert_x = (GAME.wToggles_Water->iWidth) / 365.0;
	float convert_y = (GAME.wToggles_Water->iHeight) / 365.0;
	
	wToggles_Water->Drop(x * convert_x, (y + water_float) * convert_y, wsize);
	wToggles_Water->Drop((x + w) * convert_x, (y + water_float) * convert_y, wsize);
	wToggles_Water->Drop(x * convert_x, (y + water_float + h) * convert_y, wsize);
	wToggles_Water->Drop((x + w) * convert_x, (y + water_float + h) * convert_y, wsize);
}

