/**************************************************
*  FILE:  title.h		                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  8/23/2006                               *
*                                                 *
*  This singleton object handles all the menu     *
*  control at the title screen.                   *
**************************************************/

#ifndef _TITLE_H_
#define _TITLE_H_

#define MAX_OPTIONS 220



#include "water.h"
#include "pump.h"
#include "option.h"
typedef class WATER water;
typedef class PUMP pump;
typedef class OPTION option;

class TITLE
{
public:
	WATER *wWater;
	TITLE();
	~TITLE();

	void setup();
	void draw(BITMAP *bTitle);
	void update();	
	void reset();
	void change_menu(int iValue);

private:
	int iMenu;
	int iNew, change_timer, change_delay, iBar;
	BITMAP *bImage, *bTransfer, *bPool, *bBack_Ground, *bStretch;
	
	PUMP *p1;
	PUMP *p2;
	OPTION *oOptions[MAX_OPTIONS];
	
	void load_options();

	
	void options_update();

	void destroy();
	void init();
	void menu_branching(int iSelect);
};

#endif /* End of _TITLE_H_ */
