#include "globals.h"
#include "game.h"
#include "title.h"
#include "data3.h"
#include<string.h>

TITLE::TITLE()
{
	init();
}
TITLE::~TITLE()
{

}

void TITLE::reset()
{
	ticks = 0;
	system_time = 0;
	change_menu(0);
}

void TITLE::setup()
{
	char cTemp[30];
	strcpy(cTemp, "");
	char cTemp2[30];
	strcpy(cTemp2, "");
	bImage = create_bitmap_check(GAME.configuration->w, GAME.configuration->h);
	bStretch = create_bitmap_check(GAME.configuration->w, GAME.configuration->h);
	wWater = new WATER;
	wWater->load("./data/images/border.pcx", "./data/images/vortec.pcx");
	wWater->Setup(GAME.configuration->wwidth, GAME.configuration->wheight, 6, 3, 85);
	wWater->mixture(70);

	bPool = load_bitmap_check("./data/images/border.pcx", NULL);
	bBack_Ground = (BITMAP *) GAME.dat3[TITLE2].dat;
	bTransfer = create_bitmap_check(540, 350);

	p1 = new PUMP;
	p1->setup(100, 0, 110, 20, 140, 50, 80);

	p2 = new PUMP;
	p2->setup(500, 0, 510, 20, 540, 50, 80);

	for(int i = 0; i < 46; i++)
		oOptions[i] = new OPTION;

	oOptions[0]->setup( "New Game", 0, 140, 120, 230, 50, 1, 0);	
	oOptions[1]->setup("High Scores", 0, 140, 175, 260, 50, 2, 30);	
	oOptions[2]->setup("Options", 0, 140, 230, 220, 50, 3,60);	
	oOptions[3]->setup("Credits", 0, 140, 285, 220, 50, 4,90);	
	oOptions[4]->setup("Help", 0, 140, 340, 200, 50, 5,120);	
	oOptions[5]->setup("Quit", 0, 140, 395, 200, 50, 6,150);	

	oOptions[6]->setup("", 1, MULTI_LINE, 70, 120, 500, 270, 7,0);	
	oOptions[6]->set_vlength(3300);
	oOptions[7]->setup("", 1, BUTTON, 420, 390, 150, 45, 8,30);	
	oOptions[7]->set_button_text("Local", 0);
	oOptions[7]->set_button_text("Online", 1);
	if(GAME.configuration->allow_online == 1)
		oOptions[7]->set_index(1);	
	oOptions[8]->setup("", 1, BUTTON, 220, 390, 200, 45, 9,0);	
	oOptions[8]->set_button_text("Main Menu", 0);	
	oOptions[9]->setup("", 1, BUTTON, 70, 390, 150, 45, 10,0);	
	oOptions[9]->set_button_text("Update", 0);	

	oOptions[10]->setup("Mode: ", 2, STABLE, 70, 120, 220, 35, 100,0);	
	oOptions[11]->setup( "", 2, BUTTON, 295, 120, 255, 35, 11,0);	
	oOptions[11]->set_button_text("Windowed", 0);	
	oOptions[11]->set_button_text("Full Screen", 1);	
	if(GAME.configuration->MODE == GFX_AUTODETECT_FULLSCREEN)
		oOptions[11]->set_index(1);
	oOptions[12]->setup("Graphics:", 2, STABLE, 70, 155, 220, 35, 100,0);	
	oOptions[13]->setup("", 2, BUTTON, 295, 155, 255, 35, 12,0);	
	oOptions[13]->set_button_text("High", 0);	
	oOptions[13]->set_button_text("Medium", 1);	
	oOptions[13]->set_button_text("Low", 2);	
	if(strcmp(GAME.configuration->level, "HIGH") == 0)
		oOptions[13]->set_index(0);	
	else if(strcmp(GAME.configuration->level, "MEDIUM") == 0)
		oOptions[13]->set_index(1);	
	else
		oOptions[13]->set_index(2);	

	sprintf(cTemp, "SFX: %d", int(100.0 * (float(GAME.audio.sfx_volume) / 255.0)));
	strcpy(cTemp2, "%%");	
	strcat(cTemp, cTemp2);	
	oOptions[14]->setup(cTemp, 2, STABLE, 70, 190, 220, 35, 100,0);	
	oOptions[15]->setup("", 2, SLIDE_BAR, 295, 190, 255, 35, 110,0);	
	oOptions[15]->set_bar(float(GAME.audio.sfx_volume) / 255.0);	
	sprintf(cTemp, "Music: %d", int(100.0 * (float(GAME.audio.volume) / 255.0)));
	strcpy(cTemp2, "%%");	
	strcat(cTemp, cTemp2);
	oOptions[16]->setup(cTemp, 2, STABLE, 70, 225, 220, 35, 100,0);	
	oOptions[17]->setup("", 2, SLIDE_BAR, 295, 225, 255, 35, 111,0);	
	oOptions[17]->set_bar(float(GAME.audio.volume) / 255.0);
	oOptions[18]->setup("", 2, BUTTON, 70, 400, 150, 45, 13,0);	
	oOptions[18]->set_button_text("Save", 0);	
	oOptions[19]->setup("", 2, BUTTON, 400, 400, 150, 45, 14,0);	
	oOptions[19]->set_button_text("Cancel", 0);
	sprintf(cTemp, "Mouse: %d", int(100.0 * GAME.configuration->mouse_speed));
	strcpy(cTemp2, "%%");	
	strcat(cTemp, cTemp2);	
	oOptions[20]->setup(cTemp, 2, STABLE, 70, 260, 220, 35, 100, 0);
	oOptions[21]->setup("", 2, SLIDE_BAR, 295, 260, 255, 35, 112,0);
	oOptions[21]->set_bar(GAME.configuration->mouse_speed / 5.0);	
	oOptions[22]->setup("Mouse Support: ", 2, STABLE, 70, 295, 220, 35, 100,0);	
	oOptions[23]->setup( "", 2, BUTTON, 295, 295, 255, 35, 120,0);	
	oOptions[23]->set_button_text("Hardware", 0);	
	oOptions[23]->set_button_text("Software", 1);	
	if(GAME.configuration->mouse_icon == 0)
		oOptions[23]->set_index(1);
	oOptions[24]->setup("Online: ", 2, STABLE, 70, 330, 220, 35, 100,0);	
	oOptions[25]->setup( "", 2, BUTTON, 295, 330, 255, 35, 121,0);	
	oOptions[25]->set_button_text("Allow", 0);	
	oOptions[25]->set_button_text("Disconnected", 1);	
	if(GAME.configuration->allow_online == 0)
		oOptions[25]->set_index(1);
	

	load_options();
	//if(GAME.configuration->start_online == 1)
	//GAME.gHSC->get_online();	
}

void TITLE::load_options()
{
	char cText[1024], cType[1024], cButton[3][1024];
	int iMenu, iX, iY, iW, iH, iCommand, iFont, iButton_Count, iAlignment;
	int iMax_Button_Count = 3;
	int i = 26;
	PACKFILE *fp = pack_fopen("./data/pf_help.dat", "r");	
	if(!fp) return;
	while(!pack_feof(fp))
	{
		pack_fread(&cType, sizeof(char) * 1024, fp);		
		//allegro_message("%s", cType);
		if(strcmp(cType, "STABLE") == 0)
		{			
			pack_fread(&cText, sizeof(char) * 1024, fp);		
			pack_fread(&iMenu, sizeof(int), fp);
			pack_fread(&iX, sizeof(int), fp);
			pack_fread(&iY, sizeof(int), fp);
			pack_fread(&iW, sizeof(int), fp);
			pack_fread(&iH, sizeof(int), fp);
			pack_fread(&iCommand, sizeof(int), fp);		
			pack_fread(&iFont, sizeof(int), fp);
			pack_fread(&iAlignment, sizeof(int), fp);
			
			
			oOptions[i] = new OPTION;
			oOptions[i]->setup(cText, iMenu, STABLE, iX + 50, iY + 100, iW, iH, iCommand, 0);
			oOptions[i]->set_font(iFont);
			if(iAlignment != 0)
			{
				oOptions[i]->set_align(0);
				oOptions[i]->set_wrap();
			}

		}
		else if(strcmp(cType, "BUTTON") == 0)
		{				
			pack_fread(&iMenu, sizeof(int), fp);
			pack_fread(&iX, sizeof(int), fp);
			pack_fread(&iY, sizeof(int), fp);
			pack_fread(&iW, sizeof(int), fp);
			pack_fread(&iH, sizeof(int), fp);
			pack_fread(&iCommand, sizeof(int), fp);		
			pack_fread(&iFont, sizeof(int), fp);		
			pack_fread(&iButton_Count, sizeof(int), fp);		
			for(int k = 0; k < iButton_Count && k < iMax_Button_Count; k++)
				pack_fread(&cButton[k], sizeof(char) * 100, fp);		

			oOptions[i] = new OPTION;
			oOptions[i]->setup("", iMenu, BUTTON, iX + 50, iY + 100, iW, iH, iCommand, 0);
			oOptions[i]->set_font(iFont);
			for(int z = 0; z < iButton_Count && z < iMax_Button_Count; z++)
				oOptions[i]->set_button_text(cButton[z], z);
		}
		else if(strcmp(cType, "PICTURE") == 0)
		{			
			pack_fread(&cText, sizeof(char) * 1024, fp);		
			pack_fread(&iMenu, sizeof(int), fp);
			pack_fread(&iX, sizeof(int), fp);
			pack_fread(&iY, sizeof(int), fp);
			pack_fread(&iW, sizeof(int), fp);
			pack_fread(&iH, sizeof(int), fp);
			pack_fread(&iCommand, sizeof(int), fp);		
			pack_fread(&iFont, sizeof(int), fp);						
			oOptions[i] = new OPTION;
			oOptions[i]->setup("", iMenu, BUTTON, iX + 50, iY + 100, iW, iH, iCommand, 0);
			oOptions[i]->set_picture(cText);			
		}
		
		
		i++;
	}
	
	pack_fclose(fp);
}

void TITLE::menu_branching(int iSelect)
{
	char cTemp[30];
	strcpy(cTemp, "");
	char cTemp2[30];
	strcpy(cTemp2, "");
	
	switch(iSelect)
	{
	case 0:				//Nothing
		break;
	case 1:				//Play Game
		GAME.gHSC->get_online_version();
		GAME.gHSC->get_local();
		GAME.state = PLAY_GAME;
		GAME.audio.stop();
		GAME.setup();
		GAME.level_init();
		break;
	case 2:										// Go to High Scores
		GAME.gHSC->get_online();
		change_menu(1);
		break;
	case 3:										// Go to Options
		
		change_menu(2);
		break;
	case 4:										// Go to Credits
		change_menu(3);
		break;
	case 5:										// Go to Help
		change_menu(7);
		break;
	case 6:										// Quit		
		GAME.quit = true;
		break;
	case 8:										// High Scores Toggle Button
		if(oOptions[7]->button_value() == 0)
		{
			oOptions[6]->set_vlength(3300);
			GAME.view_online = true;			
		}
		else
		{
			oOptions[6]->set_vlength(750);
			GAME.view_online = false;			
		}		
		break;
	case 9:
		if(GAME.state == PAUSED)
		{
			GAME.state = PLAY_GAME;
			GAME.audio.stop();
			ticks = GAME.pause_ticks;
			system_time = GAME.pause_system;
		}
		else
			change_menu(0);
		break;
	case 10:
		if(GAME.view_online)
			GAME.gHSC->get_online();
		else
			GAME.gHSC->get_local();
		break;
	case 11:
		if(oOptions[11]->button_value() == 0)
			GAME.configuration->MODE = GFX_AUTODETECT_FULLSCREEN;			
		else
			GAME.configuration->MODE = GFX_AUTODETECT_WINDOWED;
		break;	
	case 12:
		if(oOptions[13]->button_value() == 0)
			strcpy(GAME.configuration->level, "MEDIUM");	
		else if(oOptions[13]->button_value() == 1)
			strcpy(GAME.configuration->level, "LOW");
		else
			strcpy(GAME.configuration->level, "HIGH");
		break;

	case 13:
		GAME.configuration->write();
		change_menu(0);
		break;
	case 14:
		GAME.audio.adjust_sfx_volume(GAME.configuration->sfx_volume);
		GAME.audio.adjust_volume(GAME.configuration->music_volume);
		oOptions[15]->set_bar(float(GAME.audio.sfx_volume) / 255.0);
		oOptions[17]->set_bar(float(GAME.audio.volume) / 255.0);
		change_menu(0);
		break;
	case 15:
	case 18:
	case 21:
	case 24:	change_menu(0);		break;
	case 16:	change_menu(4);		break;
	case 17:	change_menu(3);		break;
	case 19:	change_menu(5);		break;
	case 20:	change_menu(4);		break;
	case 22:	change_menu(6);		break;
	case 23:	change_menu(5);		break;	
	case 25:	change_menu(8);		break;
	case 26:	change_menu(30);	break;
	case 27:	change_menu(35);	break;
	case 28:	change_menu(36);	break;
	case 29:	change_menu(39);	break;
	case 30:	change_menu(9);		break;
	case 31:	change_menu(11);	break;
	case 32:	change_menu(12);	break;
	case 33:	change_menu(13);	break;
	case 34:	change_menu(14);	break;
	case 35:	change_menu(20);	break;
	case 36:	change_menu(26);	break;
	case 37:	change_menu(10);	break;
	case 38:	change_menu(9);		break;
	case 39:	change_menu(15);	break;
	case 40:	change_menu(16);	break;
	case 41:	change_menu(17);	break;
	case 42:	change_menu(18);	break;
	case 43:	change_menu(19);	break;
	case 44:	change_menu(21);	break;
	case 45:	change_menu(22);	break;
	case 46:	change_menu(23);	break;
	case 47:	change_menu(24);	break;
	case 48:	change_menu(25);	break;
	case 49:	change_menu(27);	break;
	case 50:	change_menu(28);	break;
	case 51:	change_menu(29);	break;
	case 52:	change_menu(31);	break;
	case 53:	change_menu(32);	break;
	case 54:	change_menu(33);    break;
	case 55:	change_menu(34);	break;
	case 56:	change_menu(37);	break;
	case 57:	change_menu(38);	break;
	case 58:	change_menu(40);    break;
	case 59:	change_menu(41);	break;
	case 60:	change_menu(42);	break;
	case 110:
		iBar = 110;
		GAME.audio.adjust_sfx_volume(oOptions[15]->get_bar() * 255);
		sprintf(cTemp, "SFX: %d", int(100.0 * (float(GAME.audio.sfx_volume) / 255.0)));
		strcpy(cTemp2, "%%");	
		strcat(cTemp, cTemp2);
		oOptions[14]->change_text(cTemp);
	
		break;
	case 111:
		iBar = 111;
		GAME.audio.adjust_volume(oOptions[17]->get_bar() * 255);	
		sprintf(cTemp, "Music: %d", int(100.0 * (float(GAME.audio.volume) / 255.0)));
		strcpy(cTemp2, "%%");	
		strcat(cTemp, cTemp2);
		oOptions[16]->change_text(cTemp);
	
		break;
	case 112:
		iBar = 112;
		GAME.configuration->mouse_speed = oOptions[21]->get_bar() * 5.0;
		if(GAME.configuration->mouse_speed < 0.1) GAME.configuration->mouse_speed = 0.1;
		if(GAME.configuration->mouse_icon == 1)
			set_mouse_speed(int(1.0 / GAME.configuration->mouse_speed), int(1.0 / GAME.configuration->mouse_speed));	
		sprintf(cTemp, "Mouse: %d", int(100.0 * GAME.configuration->mouse_speed));
		strcpy(cTemp2, "%%");	
		strcat(cTemp, cTemp2);
		oOptions[20]->change_text(cTemp);
		break;	
	case 120:
		if(oOptions[23]->button_value() == 0)
		{
			show_mouse(NULL);
			GAME.configuration->mouse_icon = 0;			
		}
		else
		{			
			show_mouse(screen);
			GAME.configuration->mouse_icon = 1;
		}
		break;	
	case 121:
		if(oOptions[25]->button_value() == 1)
			GAME.configuration->allow_online = 1;			
		else
			GAME.configuration->allow_online = 0;
		break;	
	
	default:
		break;
	}
}

void TITLE::change_menu(int iValue)
{
	int gTime = 0;
	for(int i = 0; i < MAX_OPTIONS; i++)
	{
		if(oOptions[i] != NULL && oOptions[i]->is_menu(iMenu))
			oOptions[i]->force_submerge();
		
		if(oOptions[i] != NULL && oOptions[i]->is_menu(iValue))
		{
			gTime += 30;
			oOptions[i]->set_sky(gTime);
		}

	}
	change_delay = 30;
	change_timer = ticks;    
	iNew = iValue;
}

void TITLE::draw(BITMAP *bDisplay)
{
	debug("TITLE draw() called!\n");
	clear(bImage);
	rectfill(bImage, 0, 0, bImage->w, bImage->h, GRAY);
	draw_sprite(bImage, bBack_Ground, 0, 0);
	
	//rectfill(bImage, 0, 0, bImage->w, bImage->h, MASK);
	stretch_sprite(bImage, bPool, 50, 100, bTransfer->w, bTransfer->h);
	
	wWater->draw(bTransfer);
	stretch_sprite(bImage, bTransfer, 60, 110, bTransfer->w - 20, bTransfer->h - 20);

	draw_sprite(bDisplay, bImage, 0, 0);
	p1->draw(bDisplay);
	p2->draw(bDisplay);

	for(int i = 0; i < MAX_OPTIONS; i++)
	{

		if(oOptions[i] != NULL && oOptions[i]->is_menu(iMenu))
			oOptions[i]->draw(bDisplay, bStretch);
	}
		
	debug("TITLE draw() DONE!\n");
}

void TITLE::update()
{
	debug("TITLE update() called!\n", 2);
	int ix, iy;
	float convert_x = (wWater->iWidth) / 540.0;
	float convert_y = (wWater->iHeight) / 350.0;
	
	wWater->Drop(GAME.fMX * convert_x - 20, GAME.fMY * convert_y - 50, 100000);	
	p1->update();
	ix = p1->drop_at_x();
	iy = p1->drop_at_y();
	if(ix != 0 && iy != 0)
		wWater->Drop(ix * convert_x - 20, iy * convert_y - 50,  50000);
	//wWater->Update();

	p2->update();
	ix = p2->drop_at_x();
	iy = p2->drop_at_y();
	if(ix != 0 && iy != 0)
		wWater->Drop(ix * convert_x - 20, iy * convert_y - 50,  50000);
	if(strcmp(GAME.configuration->level, "LOW") != 0) wWater->Update();	

	options_update();
	debug("TITLE update() DONE!\n", 3);
}

void TITLE::options_update()
{
	bool no_click = false;
	if(abs(ticks - change_timer) > change_delay && iNew != -1)
	{
		change_delay = INT_MAX;
		change_timer = ticks;
		iMenu = iNew;
		wWater->clear_under_water();
		iNew = -1;
	}

	for(int i = 0; i < MAX_OPTIONS; i++)
		if(oOptions[i] != NULL && oOptions[i]->is_menu(iMenu))
		{
			if(no_click == false) no_click = oOptions[i]->bar_has_focus();
            oOptions[i]->update();
		}

	if(!no_click)
	{
		int iSelect = 0;
		iBar = 0;
		for(int i = 0; i < MAX_OPTIONS; i++)
		{
			if(oOptions[i] != NULL && iSelect == 0 && oOptions[i]->is_menu(iMenu))
				iSelect = oOptions[i]->click();
			
		}	
		menu_branching(iSelect);
	}
	else
		menu_branching(iBar);

}


void TITLE::destroy()
{
	if(bImage != NULL) { destroy_bitmap(bImage); bImage = NULL; }
	if(wWater != NULL) { wWater->destroy(); wWater = NULL; }
	if(bPool != NULL){ destroy_bitmap(bPool); bPool = NULL; }
	if(bTransfer != NULL){ destroy_bitmap(bTransfer); bTransfer = NULL; }
	if(bTransfer != NULL){ destroy_bitmap(bTransfer); bTransfer = NULL; }	
	if(p1 != NULL) { delete p1; p1 = NULL;}
	if(p2 != NULL) { delete p2; p2 = NULL;}

	for(int i = 0; i < MAX_OPTIONS; i++)
		if(oOptions[i] != NULL)
			delete oOptions[i];

    
    
}

void TITLE::init()
{
	bImage = NULL;
	wWater = NULL;
	bBack_Ground = NULL;
	bPool = NULL;
	bTransfer = NULL;
	bStretch = NULL;
	p1 = NULL;
	p2 = NULL;

	change_timer = 0;
	change_delay = INT_MAX;
	iNew = -1;

	iMenu = 0;


	for(int i = 0; i < MAX_OPTIONS; i++)
		oOptions[i] = NULL;

    
}

