/**************************************************
*  FILE:  simple_gui.h		                      *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  7/13/2006                               *
*                                                 *
*  A simple gui container.  Maintains engraved    *
*  widgets that have no functionality.  Good for  *
*  quickly setting up design without learning an  *
*  advanced gui.                                  *
**************************************************/

#ifndef _SIMPLE_GUI_H_
#define _SIMPLE_GUI_H_




#define MAX_IMAGES 30

typedef struct object
{
	BITMAP *bImage;
	int x;
	int y;
	char cpath[30];

	bool none;
	
	char cName[30];
	int iValue;
	bool draw_name;
} OBJECT;

class SIMPLE_GUI
{
public:
	SIMPLE_GUI();
	~SIMPLE_GUI();

	void create_object(int iIndex, char *Name, int Value, int X, int Y);
	void create_object(int iIndex, char *Name, int Value, int X, int Y, int W, int H);
	void create_object(int iIndex, int iParent, char *Name, int Value, int X, int Y, int W, int H);
	void create_object(int iIndex, char *Name, char *cpath, int Value, int X, int Y, int W, int H);
	void create_none_object(int iIndex, char *Name, char *cpath, int Value, int X, int Y, int W, int H);
	void update_object(int iIndex, char *cChange);
	void update_object(int iIndex, int iChange);
	void update();
	void draw(BITMAP *bDisplay);
	void draw_object(int iIndex);
	void draw_object(int iIndex, BITMAP *bDraw, int x, int y);
	void draw_solid_object(int iIndex, BITMAP *bDraw, int x, int y);
	void draw_stretch_object(int iIndex, BITMAP *bDraw, int x, int y);
	void draw_rectangle(int iIndex, int x, int y, int w, int h, int color);
	void draw_rectangle_fill(int iIndex, int x, int y, int w, int h, int color);

	void set_draw_name(int iIndex, bool value);
	void set_colors(int R, int G, int B);


	void Setup(char *cBackGround, int w, int h);
	void destroy();

private:
	int ir, ig, ib;
	int back_segw, back_segh;
	int bax, bay;
	int background_update_timer;
	BITMAP *bBackground;
	BITMAP *bBackground_Animation;
	BITMAP *bImage;
	BITMAP *bText;
	OBJECT *oImages[MAX_IMAGES];

	void init();
	void draw_back_color(int iIndex);

};

#endif /* End of _SIMPLE_GUI_H_*/
