#include "globals.h"
#include "game.h"
#include "simple_gui.h"
#include <string.h>

SIMPLE_GUI::SIMPLE_GUI()
{
	init();
}

SIMPLE_GUI::~SIMPLE_GUI()
{
	destroy();
}

void SIMPLE_GUI::init()
{
	bBackground = NULL;
	bImage = NULL;
	bText = NULL;
	ir = 0;
	ig = 0;
	ib = 0;
	back_segw = 0;
	back_segh = 0;
	bax = 0;
	bay = 0;
	background_update_timer = 0;
	
	for(int i = 0; i < MAX_IMAGES; i++)
		oImages[i] = NULL;
}

void SIMPLE_GUI::set_draw_name(int iIndex, bool value)
{
	oImages[iIndex]->draw_name = value;
}

void SIMPLE_GUI::destroy()
{	
	for(int i = 0; i < MAX_IMAGES; i++)
		if(oImages[i] != NULL) 
		{
			if(oImages[i]->bImage != NULL) destroy_bitmap(oImages[i]->bImage);
			delete oImages[i];
		}

	if(bBackground != NULL) destroy_bitmap(bBackground);
	if(bBackground_Animation != NULL) destroy_bitmap(bBackground_Animation);
	if(bImage != NULL) destroy_bitmap(bImage);
	if(bText != NULL) destroy_bitmap(bText);
	
}

void SIMPLE_GUI::Setup(char *cBackGround, int w, int h)
{
	bImage = create_bitmap_check(w, h);
	bText = create_bitmap_check(w, h);
	
	rectfill(bText, 0, 0, bText->w, bText->h, MASK);
	bBackground_Animation = load_bitmap_check(cBackGround, NULL);
	back_segw = bBackground_Animation->w;
	back_segh = bBackground_Animation->h;
	bax = -back_segw;
	bay = -back_segh;
	bBackground = create_bitmap_check(w,h);
	rectfill(bBackground, 0, 0, 640, 480, MASK);	
}

void SIMPLE_GUI::create_object(int iIndex, char *Name, int Value, int X, int Y)
{
	OBJECT *oNew = new OBJECT;

	if(oImages[iIndex] != NULL || iIndex < 0 || iIndex > MAX_IMAGES) return;
	oNew->bImage = NULL;
	strcpy(oNew->cName, Name);
	strcpy(oNew->cpath, "");
	oNew->x = X;
	oNew->y = Y;
	oNew->iValue = Value;
	oNew->none = false;
	oNew->draw_name = false;
	oImages[iIndex] = oNew;
}

void SIMPLE_GUI::create_object(int iIndex, char *Name, int Value, int X, int Y, int W, int H)
{
	OBJECT *oNew = new OBJECT;

	if(oImages[iIndex] != NULL || iIndex < 0 || iIndex > MAX_IMAGES) return;
	strcpy(oNew->cName, Name);
	strcpy(oNew->cpath, "");
	oNew->bImage = create_sub_bitmap_check(bBackground, X, Y, W, H);
	//oNew->bImage = create_bitmap_check(W, H);
	clear(oNew->bImage);
	oNew->x = X;
	oNew->y = Y;
	oNew->iValue = Value;
	oNew->none = false;
	oNew->draw_name = false;
	oImages[iIndex] = oNew;
}

void SIMPLE_GUI::create_object(int iIndex, int iParent, char *Name, int Value, int X, int Y, int W, int H)
{
	OBJECT *oNew = new OBJECT;

	if(oImages[iIndex] != NULL || oImages[iParent] == NULL || iIndex < 0 || iIndex > MAX_IMAGES) return;
	strcpy(oNew->cName, Name);
	strcpy(oNew->cpath, "");
	oNew->bImage = create_sub_bitmap_check(oImages[iParent]->bImage, X, Y, W, H);
	//oNew->bImage = create_bitmap_check(W, H);
	clear(oNew->bImage);
	rectfill(oNew->bImage, 0, 0, 365, 365, BLUE);
	oNew->x = X;
	oNew->y = Y;
	oNew->iValue = Value;
	oNew->none = false;
	oNew->draw_name = false;
	oImages[iIndex] = oNew;
}



void SIMPLE_GUI::create_object(int iIndex, char *Name, char *cpath, int Value, int X, int Y, int W, int H)
{
	OBJECT *oNew = new OBJECT;
	BITMAP *bTemp;

	if(oImages[iIndex] != NULL || iIndex < 0 || iIndex > MAX_IMAGES) return;
	
	strcpy(oNew->cName, Name);
	oNew->x = X;
	oNew->y = Y;
	oNew->iValue = Value;
	strcpy(oNew->cpath, cpath);
	oNew->bImage = create_sub_bitmap_check(bBackground, X, Y, W, H);
	bTemp = load_bitmap_check(cpath, NULL);
	stretch_sprite(oNew->bImage, bTemp, 0,0, oNew->bImage->w, oNew->bImage->h);
	//for(int r = 0; r < 10; r++)
	//	rrect(oNew->bImage, 0, 0, oNew->bImage->w, oNew->bImage->h, r, MASK);
		
	rect(oNew->bImage, 0,0, oNew->bImage->w, oNew->bImage->h,DARKGREEN);
	rect(oNew->bImage, 1,1, oNew->bImage->w - 1, oNew->bImage->h - 1,LIGHTGREEN);
	rect(oNew->bImage, 2,2, oNew->bImage->w - 2, oNew->bImage->h - 2,SADDLEBROWN);

	oNew->none = false;
	oNew->draw_name = false;
	oImages[iIndex] = oNew;

	destroy_bitmap(bTemp);

}

void SIMPLE_GUI::create_none_object(int iIndex, char *Name, char *cpath, int Value, int X, int Y, int W, int H)
{
	OBJECT *oNew = new OBJECT;
	BITMAP *bTemp;

	if(oImages[iIndex] != NULL || iIndex < 0 || iIndex > MAX_IMAGES) return;
	
	strcpy(oNew->cName, Name);
	oNew->x = X;
	oNew->y = Y;
	oNew->iValue = Value;
	strcpy(oNew->cpath, cpath);
	oNew->bImage = create_bitmap_check(W, H);
	bTemp = load_bitmap_check(cpath, NULL);
	rectfill(oNew->bImage, 0, 0, oNew->bImage->w, oNew->bImage->h, MASK);
	stretch_sprite(oNew->bImage, bTemp, 0,0, oNew->bImage->w, oNew->bImage->h);
	oNew->none = true;
	oNew->draw_name = false;

	oImages[iIndex] = oNew;


	destroy_bitmap(bTemp);

}


void SIMPLE_GUI::update_object(int iIndex, char *cChange)
{
	if(oImages[iIndex] == NULL || iIndex < 0 || iIndex > MAX_IMAGES) return;
	strcpy(oImages[iIndex]->cName, cChange);
}

void SIMPLE_GUI::update_object(int iIndex, int iChange)
{
	if(oImages[iIndex] == NULL || iIndex < 0 || iIndex > MAX_IMAGES) return;
	oImages[iIndex]->iValue = iChange;
}

void SIMPLE_GUI::update()
{
	debug("GUI update() called!\n", 2);
	if(abs(ticks - background_update_timer) > 2 && GAME.configuration->still_background == 0)
	{
		bax++;
		bay++;
		if(bax == 0) bax = -back_segw;
		if(bay == 0) bay = -back_segh;
		background_update_timer = ticks;
	}
	debug("GUI update() DONE!\n", 3);
}

void SIMPLE_GUI::draw(BITMAP *bDisplay)
{
	debug("GUI draw() called!\n");
	for(int x = bax; x < 640 + bBackground_Animation->w; x += bBackground_Animation->w)
		for(int y = bay; y < 480 + bBackground_Animation->h; y += bBackground_Animation->h)
			draw_sprite(bImage, bBackground_Animation, x, y);
	
	draw_sprite(bImage, bBackground, 0, 0);
	
	for(int i = 0; i < MAX_IMAGES; i++)
		if(oImages[i] != NULL && oImages[i]->none)
		{			
			draw_sprite(bImage, oImages[i]->bImage, oImages[i]->x, oImages[i]->y);			
		}
	
	draw_sprite(bDisplay, bImage, 0, 0);
	debug("GUI draw() DONE!\n");
}

void SIMPLE_GUI::set_colors(int R, int G, int B)
{
    ir = R;
	ig = G;
	ib = B;
}

void SIMPLE_GUI::draw_back_color(int iIndex)
{
	int iSeg_Count = GAME.configuration->segments;
	int iR = ir, iG = ig, iB = ib;
	int shade = GAME.configuration->shade + 5;
	int hop = 5;
	
	if(strcmp(GAME.configuration->level, "MEDIUM") == 0) iSeg_Count = 50;
	if(strcmp(GAME.configuration->level, "LOW") == 0) iSeg_Count = 5;
	for(int i = 0; i < iSeg_Count; i += hop)
	{
		rectfill(oImages[iIndex]->bImage, 0, oImages[iIndex]->bImage->h * ((i) / float(iSeg_Count)), oImages[iIndex]->bImage->w, oImages[iIndex]->bImage->h * ((i + hop) / float(iSeg_Count)), rgb(iR, iG, iB));
		iR -= shade; if(iR < 0) iR = 0;		if(iR > 255) iR = 255;
		iG -= shade; if(iG < 0) iG = 0;		if(iG > 255) iG = 255;
		iB -= shade; if(iB < 0) iB = 0;		if(iB > 255) iB = 255;		
	}
}


void SIMPLE_GUI::draw_object(int iIndex, BITMAP *bDraw, int x, int y)
{
	if(oImages[iIndex] == NULL || iIndex < 0 || iIndex > MAX_IMAGES) return;
	//rectfill(oImages[iIndex]->bImage, 0,0, oImages[iIndex]->bImage->w, oImages[iIndex]->bImage->h, BLACK);
	draw_back_color(iIndex);
			
	draw_sprite(oImages[iIndex]->bImage, bDraw, x, y);

	for(int r = 0; r < 10; r++)
		rrect(oImages[iIndex]->bImage, 0, 0, oImages[iIndex]->bImage->w, oImages[iIndex]->bImage->h, r, MASK);
		
	rrect(oImages[iIndex]->bImage, 0,0, oImages[iIndex]->bImage->w, oImages[iIndex]->bImage->h, 7,SKYBLUE);
	rrect(oImages[iIndex]->bImage, 1,1, oImages[iIndex]->bImage->w - 1, oImages[iIndex]->bImage->h - 1, 6,LIGHTSKYBLUE);
	
	
	if(oImages[iIndex]->draw_name)
	{
		set_palette((RGB *) GAME.score_palette);
		textprintf_ex(oImages[iIndex]->bImage, GAME.score_font, 5, oImages[iIndex]->bImage->h / 2 - 15, -1, -1, "%s", oImages[iIndex]->cName);
	}
}

void SIMPLE_GUI::draw_solid_object(int iIndex, BITMAP *bDraw, int x, int y)
{
	if(oImages[iIndex] == NULL || iIndex < 0 || iIndex > MAX_IMAGES) return;
			
	draw_sprite(oImages[iIndex]->bImage, bDraw, x, y);
}


void SIMPLE_GUI::draw_object(int iIndex)
{
	if(oImages[iIndex] == NULL || iIndex < 0 || iIndex > MAX_IMAGES) return;
	//rectfill(oImages[iIndex]->bImage, 0,0, oImages[iIndex]->bImage->w, oImages[iIndex]->bImage->h, BLACK);	
	draw_back_color(iIndex);
	for(int r = 0; r < 10; r++)
		rrect(oImages[iIndex]->bImage, 0, 0, oImages[iIndex]->bImage->w, oImages[iIndex]->bImage->h, r, MASK);
	
	rrect(oImages[iIndex]->bImage, 0,0, oImages[iIndex]->bImage->w - 1, oImages[iIndex]->bImage->h - 1, 7,SKYBLUE);
	rrect(oImages[iIndex]->bImage, 1,1, oImages[iIndex]->bImage->w - 2, oImages[iIndex]->bImage->h - 2, 5,LIGHTSKYBLUE);
	
	if(oImages[iIndex]->draw_name)
	{

		set_palette((RGB *) GAME.score_palette);
		textprintf_ex(oImages[iIndex]->bImage, GAME.score_font, 5, oImages[iIndex]->bImage->h / 2 - 15, -1, -1, "%s", oImages[iIndex]->cName);
	}
}


void SIMPLE_GUI::draw_stretch_object(int iIndex, BITMAP *bDraw, int x, int y)
{
	if(oImages[iIndex] == NULL || iIndex < 0 || iIndex > MAX_IMAGES) return;	
	stretch_sprite(oImages[iIndex]->bImage, bDraw, x, y, oImages[iIndex]->bImage->w, oImages[iIndex]->bImage->h);
}

void SIMPLE_GUI::draw_rectangle(int iIndex, int x, int y, int w, int h, int color)
{
	if(oImages[iIndex] == NULL || iIndex < 0 || iIndex > MAX_IMAGES) return;
	rrect(oImages[iIndex]->bImage, x, y, w, h, 5, color);

}

void SIMPLE_GUI::draw_rectangle_fill(int iIndex, int x, int y, int w, int h, int color)
{
	if(oImages[iIndex] == NULL || iIndex < 0 || iIndex > MAX_IMAGES) return;
	rrectfill(oImages[iIndex]->bImage, x, y, w, h, 5, color);

}
