#include "globals.h"
#include "game.h"
#include "message.h"
#include<string.h>

MESSAGE::MESSAGE()
{
	init();
}


MESSAGE::MESSAGE(char *s, int t, int X, int Y)
{
	init();
	finished = false;
	kill_timer = ticks;
	iTime = t;
	strcpy(cText, s);
	x = X;
	y = Y;
}

MESSAGE::~MESSAGE()
{
	
}


void MESSAGE::update()
{
	debug("MESSAGE update() called!\n", 2);
	if(abs(ticks - update_timer) > 1)
	{
		update_timer = ticks;
		y--;
	}

	if(abs(ticks - kill_timer) > iTime)
		finished = true;
	debug("MESSAGE update() DONE!\n", 3);
}

void MESSAGE::draw(BITMAP *bDisplay)
{
	debug("MESSAGE draw() called!\n");
	if(!finished)
	{
		set_palette((RGB *) GAME.msg_palette);			
		textprintf_centre_ex(bDisplay, GAME.msg_font, x,y, -1, -1, cText);
	}
	debug("MESSAGE draw() DONE!\n");
	
}

void MESSAGE::destroy()
{}

void MESSAGE::init()
{
	x = 0;
	y = 0;
	kill_timer = 0;
	finished = false;
	strcpy(cText, "");
	update_timer = 0;
	iTime = 0;
}
