/*----------------------------------- LIST.H ---------------------------------------------------------
  -  AUTHOR:  Steven P. Silvey																		 -
  -  DATE CREATED:  2/7/2004																		 -
  -  DATE MODIFIED: 4/15/2004																		 -
  -  PURPOSE:  Public interface for the list structure.  List is a linked-list data structure		 -
  -            allowing one data item and a link per each structure.								 -
  -    *MODIFICATION (4/15/2005) - Added Sort_List to sort the list efficiently						 -
  ----------------------------------------------------------------------------------------------------*/

#ifndef _LIST_H_
#define _LIST_H_

//#include<iostream>
#include <stdio.h>

typedef struct linked LIST;

typedef struct linked
{
	int ikey, ikey2;
	char ckey[30];
	void *data;

	LIST *next;
} LIST;

/*************************************************************************************************
*										CONSTRUCTORS											 *
*************************************************************************************************/
/*  PURPOSE:  To create the LIST structure which connects information together in a list.
	PARAMETERS:  NONE
	RETURN:  The newly dynamically allocated LIST structure.							*/
extern LIST *Create_List();

/*  PURPOSE:  To copy a List item and return it with out it's link connections
	PARAMETERS:  copy - the node being copied
	RETURN:  The copied node															*/
extern LIST *Copy_List(LIST *copy);

/*************************************************************************************************
*										DESTRUCTORS												 *
*************************************************************************************************/
/*  PURPOSE:  To free a linked list
	PARAMETERS:  traverse - the list to destroy
	RETURN:  NONE																		*/	
extern void Destroy_List(LIST *traverse);

/*************************************************************************************************
*										 DISPLAYERS												 *
*************************************************************************************************/
/*  PURPOSE:  To display all the information of one list structure to the monitor.
	PARAMETERS:  display - the list structure to display
	RETURN:  NONE																		*/
extern void Display_List_Item(LIST *display);

/*  PURPOSE:  To display all the information of one list structure to the monitor
	PARAMETERS:  display - the list structure to display
	RETURN:  NONE																		*/
extern void Display_List_Item(LIST *display, FILE *fdir);


/*  PURPOSE:  To display all the information of an entire list to the specified direction of
			  output.
	PARAMETERS:  begin - the first item in the entire list
				 fdir - the direction of output for the display to take place
	RETURN:  NONE																		*/
extern void Display_List(LIST *begin, FILE *fdir);

/*  PURPOSE:  To display all the information of an entire list to the monitor.			  
	PARAMETERS:  begin - the first item in the entire list				 
	RETURN:  NONE																		*/
extern void Display_List(LIST *begin);

/*************************************************************************************************
*										  MUTATORS												 *
*************************************************************************************************/
/*  PURPOSE:  To add a premade LIST item to a linked list
	PARAMETERS:  traverse - the list to add to				 
				 add - the item to add
	RETURN:  The new updated list														*/	
extern LIST *Add_List(LIST *Begin, LIST *Add);

/*  PURPOSE:  To add an item to a linked list 
	PARAMETERS:  traverse - the list to add to
				 data - the item to add to the list
				 ID - the quickinfo index of the new list element
	RETURN:  The new updated list														*/	
extern LIST *Add_List(LIST *traverse, void *data, int ID);

/*  PURPOSE:  To add an item to a linked list (with char ID)
	PARAMETERS:  traverse - the list to add to
				 data - the item to add to the list
				 cID - the quickinfo index of the new list element
	RETURN:  The new updated list														*/	
extern LIST *Add_List(LIST *traverse, void *data, char *cID);

/*  PURPOSE:  To search for an item in a list based on an index
	PARAMETERS:  traverse - the list to search through
	             ID - the string to look for
	RETURN:  The LIST node that contains the cID.  NULL if no node found.				*/
extern LIST *Search_List(LIST *traverse, int iID);


/*  PURPOSE:  To search for an item in a list based on a string
	PARAMETERS:  traverse - the list to search through
	             cID - the string to look for
	RETURN:  The LIST node that contains the cID.  NULL if no node found.				*/
extern LIST *Search_List(LIST *traverse, const char *cID);

/*  PURPOSE:  To sort the list by its ikey value in ascending order
	PARAMETERS:  traverse - the list to sort
	RETURN:  The sorted LIST															*/
LIST *Sort_List(LIST *traverse);

/* PURPOSE:  To take a node that's out of place and put it in its correct location
   PARAMETERS:  begin - the list we are sorting
				fix - the node that is out of place
   RETURN:  The "more" sorted list														*/
LIST *Fix_List(LIST *begin, LIST *fix);



//#include "list.cpp" /* Because this is a C file! */

#endif /* End of _LIST_H_ */
