#include "globals.h"
#include "game.h"
#include "hsc.h"
#include <string.h>
#include <limits.h>

HSC::HSC()
{
	init();	
}
HSC::~HSC()
{
	destroy();
}

void HSC::destroy()
{
	if(bImage != NULL) destroy_bitmap(bImage);
	delete oCom;

	for(int f = 0; f < MAX_FIREWORKS; f++)
		if(fWorks[f] != NULL)
			delete fWorks[f];
}

void HSC::get_local()
{
	int iIndex, j;
	PACKFILE *f = pack_fopen("./data/hsc", "r");

	clear_local();
	if(f)
	{
		char cName[CHAR_SIZE];
		int iScore;
		int iLevel;
		float iVersion;
		int iLow_Score = INT_MAX;

		GAME.low_score = INT_MAX;

		while(!pack_feof(f))
		{
			pack_fread(&cName, sizeof(char) * CHAR_SIZE, f);
			pack_fread(&iScore, sizeof(int), f);
			pack_fread(&iVersion, sizeof(float), f);
			pack_fread(&iLevel, sizeof(int), f);

			//find the lowest score
			iIndex = -1;
			iLow_Score = INT_MAX;
			for(j = 0; j < MAX_STATS; j++)
			{
				if(lStats[j].points < iLow_Score)
				{
					iIndex = j;
					iLow_Score = lStats[j].points;
				}
			}
			
			//push high score
			if(iIndex != -1 && iScore > lStats[iIndex].points - 10)
			{
				if(iScore < GAME.low_score)
					GAME.low_score = iScore;
				lStats[iIndex].points = iScore;
				lStats[iIndex].version = iVersion;
				lStats[iIndex].level = iLevel;
				strcpy(lStats[iIndex].cName, cName);				
			}
		}		

		pack_fclose(f);
	}
	
	sort();
}

int HSC::get_low()
{
	int iLow_Score = INT_MAX;
	int i;

	get_local();
	get_online();

	for(i = 0; i < MAX_STATS; i++)
		if(lStats[i].points < iLow_Score)
			iLow_Score = lStats[i].points;

	for(i = 0; i < MAX_ONLINE_STATS; i++)
		if(oStats[i].points < iLow_Score)
			iLow_Score = oStats[i].points;

	return iLow_Score;

}


void HSC::sort()
{
	int iIndex = 0;
	int iScore;

	//Find the highest score
	for(int j = 0; j < MAX_STATS; j++)
	{
		iScore = lStats[j].points;
		iIndex = j;
		for(int i = j; i < MAX_STATS; i++)
		{
			if(lStats[i].points > iScore)
			{
				iIndex = i;
				iScore = lStats[i].points;
			}
		}		
		if(iIndex != j) hsc_flip(lStats[j], lStats[iIndex]);
	}	

}


void HSC::hsc_flip(STATS &s1, STATS &s2)
{
	STATS sTemp;

	sTemp.level = s1.level;
	sTemp.points = s1.points;
	sTemp.version = s1.version;
	strcpy(sTemp.cName, s1.cName);

	s1.level = s2.level;
	s1.points = s2.points;
	s1.version = s2.version;
	strcpy(s1.cName, s2.cName);

	s2.level = sTemp.level;
	s2.points = sTemp.points;
	s2.version = sTemp.version;
	strcpy(s2.cName, sTemp.cName);
}

void HSC::draw(BITMAP *bDisplay, int y, int S)
{
	debug("HSC draw() called!\n");
	set_palette((RGB *) GAME.score_palette);
	rectfill(bImage, 0, 0, bImage->w, bImage->h, MASK);
	textprintf_ex(bImage, GAME.score_font, 10, 10, -1, -1, "Rank");
	textprintf_ex(bImage, GAME.score_font, 80, 10, -1, -1, "Name");					
	textprintf_ex(bImage, GAME.score_font, 400, 10, -1, -1, "Score");					

	if(y < -1100) y = -1100;

	for(int i = 0; i < MAX_STATS; i++)
	{
		if(lStats[i].points != 0)
		{
			textprintf_ex(bImage, GAME.score_font, 10, (i + 2) * 32, -1, -1, "%d.", i + 1);
			textprintf_ex(bImage, GAME.score_font, 80, (i + 2) * 32, -1, -1, "%s", lStats[i].cName);					
			textprintf_right_ex(bImage, GAME.score_font, 490, (i + 2) * 32, -1, -1, "%d", lStats[i].points);					
		}
	}
	
	stretch_sprite(bDisplay, bImage, 0, y, bDisplay->w - S, bImage->h - S);
	debug("HSC draw() DONE!\n");
}

void HSC::draw_online(BITMAP *bDisplay, int y, int S)
{
	debug("HSC draw_online() called!\n");
	set_palette((RGB *) GAME.score_palette);
	rectfill(bImage, 0, 0, bImage->w, bImage->h, MASK);
	textprintf_ex(bImage, GAME.score_font, 10, 10, -1, -1, "Rank");					
	textprintf_ex(bImage, GAME.score_font, 80, 10, -1, -1, "Name");					
	textprintf_ex(bImage, GAME.score_font, 400, 10, -1, -1, "Score");					
	
	for(int i = 0; i < MAX_ONLINE_STATS; i++)
	{
		
		if(oStats[i].points != 0 && strcmp(oStats[i].cName, "Toggles_Version") != 0)
		{
			
			textprintf_ex(bImage, GAME.score_font, 10, (i + 2) * 32, -1, -1, "%d.", i + 1);
			textprintf_ex(bImage, GAME.score_font, 80, (i + 2) * 32, -1, -1, "%s", oStats[i].cName);					
			if(strcmp(oStats[i].cName, "") != 0)
			textprintf_right_ex(bImage, GAME.score_font, 490, (i + 2) * 32, -1, -1, "%d", oStats[i].points);							
		}
	}
	
	stretch_sprite(bDisplay, bImage, 0, y, bDisplay->w - S, bImage->h - S);	
	debug("HSC draw_online() DONE!\n");
}

bool HSC::local_update()
{
	int i = 0;
	bool quit = false;
	char cTemp[CHAR_SIZE];
	float iVersion = 1.9;

	strcpy(cTemp, "Computer");

	PACKFILE *f = pack_fopen("./data/hsc", "w");
	if(f)
	{
	
		for(i = 0; i < MAX_STATS; i++)
		{
			pack_fwrite(&lStats[i].cName, sizeof(char) * CHAR_SIZE, f);
			pack_fwrite(&lStats[i].points, sizeof(int), f);
			pack_fwrite(&lStats[i].version, sizeof(float), f);
			pack_fwrite(&lStats[i].level, sizeof(int), f);
				
			if(quit != true && GAME.gScore->points > lStats[i].points)
			{
				quit = true;
			
				pack_fwrite(&GAME.cName, sizeof(char) * CHAR_SIZE, f);
				pack_fwrite(&GAME.gScore->points, sizeof(int), f);
				pack_fwrite(&iVersion, sizeof(float), f);
				pack_fwrite(&GAME.level, sizeof(int), f);
				
			}
		}
		pack_fclose(f);
	}
	return quit;
}

bool HSC::online_check()
{
	bool quit = false;
	int i  = 0;

	while(i < MAX_ONLINE_STATS && quit != true)
	{
		// If the current score is greater than any listed
		// online stats, then we need to write to the file.
		if(GAME.gScore->points > oStats[i].points)
			quit = true;
		
		i++;
	}

	return quit;
}


long HSC::calculateCode(const char *name, int score)
{
	long sum = 0;
	for(unsigned int i = 0; i < strlen(name); i++)
		sum += name[i] * (1 << i);
	
	sum ^= ((score + score) << 8);
	sum &= 0x7fffffff;

	return sum;
}

void HSC::online_submit()
{
	char http[150];
	char action[20];
	char name[CHAR_SIZE];
	int score, level;
	char version[10];
	char url_buf[256];

	if(!submit_ok)
	{		
		oCom->err("Version incompatibility.  Please go to http://www.solo-games.org to get the most recent version.");
		return;
	}

	strcpy(http, "http://www.solo-games.org/games/toggles/highscore.php");
	strcpy(action, "submit");
	strcpy(name, GAME.cName);
	if(strlen(name) >= CHAR_SIZE) name[CHAR_SIZE - 1] = 0;
	for(unsigned int i = 0; i < strlen(name); i++)
		if(name[i] == ' ') name[i] = '_';
	if(strcmp(name, "") == 0) strcpy(name, "bad_data");
	score = GAME.gScore->points;
	if(score < 0) score = 0;
	strcpy(version, VERSION);
	level = GAME.level;
	sprintf(url_buf, "%s?action=%s&name=%s&score=%d&version=%s&level=%d&code=%d&best=%d", http, action, name, score, version, level, calculateCode(name,score), GAME.bBoard->iHConsecutive);
	oCom->upload(url_buf);

	return;
}

/*static char *dl_buf;
size_t get_hsc(void *ptr, size_t size, size_t nmemb, void *stream)
{
	dl_buf = (char *) malloc((strlen((char *) ptr) + 1) * sizeof(char));
	strcpy(dl_buf, (char *) ptr);
	return size * nmemb;
	//return strlen((char *) ptr) + 1;
}*/

void HSC::update()
{
	debug("HSC update() called!\n", 2);

	char *cData;
	if(oCom->downloading())
	{
		cData = oCom->get_dl_buffer();
		if(cData != NULL)
		{
			if(downloading)
			{
				set_online(cData);
				downloading = false;
			}

			if(get_version)
			{
				get_version = false;	
				cData[5] = '\0';	
				if(strcmp(cData, VERSION) == 0)
					submit_ok = true;
				else		
					submit_ok = false;
			}
			oCom->complete();
		}
	}

	if(abs(ticks - cursor_timer) > cursor_delay)
	{
		cursor_timer = ticks;
		if(cursor_flash)
		{
			cursor_flash = false;
			cursor_delay = 5;
		}
		else
		{
			cursor_flash = true;
			cursor_delay = 30;
		}
	}

	if(GAME.state == HIGHSCORES)
		highscore();

	debug("HSC update() DONE!\n", 3);
}

void HSC::highscore()
{
	int oh = 0, lh = 0;

	for(int f = 0; f < MAX_FIREWORKS; f++)
		if(!fWorks[f]->dead())
			fWorks[f]->update();
			
		
	if(GAME.score_case > 0 && abs(ticks - fireworks_timer) > 50)
		//abs(ticks - fireworks_timer) > 50)
	{		
		int i = 0;
		while(i < MAX_FIREWORKS && !fWorks[i]->dead())
			i++;
		if(i < MAX_FIREWORKS)
			fWorks[i]->create();

		fireworks_timer = ticks;
		//GAME.peCombo->explode(20, rand() % GAME.configuration->w, rand() % GAME.configuration->h, 100, 100, 0.5, 0.28, 5.0, 0.05, 15);					
		
	}
	if((oh = GAME.gHSC->online_highscore(GAME.gScore->points)) != -1)
		GAME.score_case = 2;		
	else if((lh = GAME.gHSC->local_highscore(GAME.gScore->points)) != -1)
		GAME.score_case = 1;
	else
		GAME.score_case = 0;
	
	switch(GAME.score_case)
	{			
		case 1: GAME.high_index = lh; break;
		case 2: GAME.high_index = oh; break;
		default: GAME.high_index  = 0; break;
	}

	if(abs(ticks - high_timer) > 10)
	{
		if(GAME.high_pos + 1000 < GAME.high_index * 32)
			GAME.high_pos += 100;
		else if(GAME.high_pos + 500 < GAME.high_index * 32)
			GAME.high_pos += 50;
		else if(GAME.high_pos + 175 < GAME.high_index * 32)
			GAME.high_pos += 10;
		
		high_timer = 0;
	}

	input();

}

void HSC::input()
{
	int val = 0;
	if(key[KEY_ENTER])
	{
		clear_keybuf();		
		GAME.state = TITLE_SCREEN;
		GAME.MainMenu->reset();
		GAME.audio.stop();

		if(GAME.score_case != 0)
		{
			GAME.gHSC->local_update();
			GAME.gHSC->get_local();

			if(GAME.gHSC->online_check())
				GAME.gHSC->online_submit();
		}

		for(int f = 0; f < MAX_FIREWORKS; f++)
			if(!fWorks[f]->dead())
				fWorks[f]->kill();			
		
	}

	if(GAME.score_case != 0 && keypressed())
	{		
		val = readkey() & 0xff;
		if(val != 8)
		{	
			if(GAME.cName_Index < CHAR_SIZE - 1 && val != 13 && val != 27) 
			{
				GAME.cName[GAME.cName_Index++] = val;
				GAME.cName[GAME.cName_Index] = '\0';
				GAME.audio.play_sfx(13);
			}
		}
		else
		{
			GAME.cName_Index = MID(0, GAME.cName_Index - 1, CHAR_SIZE - 1);
			GAME.cName[GAME.cName_Index] = '\0';
			GAME.audio.play_sfx(13);
		}		
		
	}

}

void HSC::draw_highscore(BITMAP *bDisplay)
{
	debug("HSC draw_highscore() called!\n");
	for(int f = 0; f < MAX_FIREWORKS; f++)
		if(!fWorks[f]->dead())
			fWorks[f]->draw(bDisplay);
	if(GAME.score_case > 0)
			GAME.peCombo->draw(buffer);
		
	set_trans_blender(0,0,0,0);
	draw_lit_sprite(buffer, buffer, 0, 0, 184);		

	for(int f = 0; f < MAX_FIREWORKS; f++)
		if(!fWorks[f]->dead())
			fWorks[f]->draw_flash(bDisplay);
	
		
	set_palette((RGB *) GAME.blue_palette);		
	rectfill(GAME.bHigh_Score, 0, 0, GAME.bHigh_Score->w, GAME.bHigh_Score->h, MASK);
	if(GAME.score_case == 2)
	{
		textprintf_ex(buffer, GAME.score_font, 10+70, 10+60, -1, -1, "Rank");					
		textprintf_ex(buffer, GAME.score_font, 80+67, 10+60, -1, -1, "Name");					
		textprintf_ex(buffer, GAME.score_font, 400+70, 10+60, -1, -1, "Score");					
		textprintf_centre_ex(buffer, GAME.score_font, GAME.configuration->w / 2+2, 10+2, -1, -1, "You got an Online High Score!");					
		textprintf_centre_ex(buffer, GAME.score_font, GAME.configuration->w / 2, 445, -1, -1, "Type your name.  Press Enter to submit score!");		

		set_palette((RGB *) GAME.msg_palette);
		textprintf_centre_ex(buffer, GAME.score_font, GAME.configuration->w / 2, 10, -1, -1, "You got an Online High Score!");										
		GAME.gHSC->draw_online(GAME.bHigh_Score, GAME.high_pos * -1, 30, GAME.high_index);
	}
	else if(GAME.score_case == 1)
	{			
		textprintf_ex(buffer, GAME.score_font, 10+70, 10+60, -1, -1, "Rank");					
		textprintf_ex(buffer, GAME.score_font, 80+67, 10+60, -1, -1, "Name");					
		textprintf_ex(buffer, GAME.score_font, 400+70, 10+60, -1, -1, "Score");					
		textprintf_centre_ex(buffer, GAME.score_font, GAME.configuration->w / 2, 445, -1, -1, "Type your name.  Press Enter to submit score!");					

		set_palette((RGB *) GAME.msg_palette);
		textprintf_centre_ex(buffer, GAME.score_font, GAME.configuration->w / 2, 10, -1, -1, "You got a Local High Score!");									
		GAME.gHSC->draw(GAME.bHigh_Score, GAME.high_pos * -1, 30, GAME.high_index);
	}
	else
	{			
		set_palette((RGB *) GAME.msg_palette);
		textprintf_centre_ex(buffer, GAME.score_font, GAME.configuration->w / 2, GAME.configuration->h / 2 - 30, -1, -1, "Game Over!");					
		textprintf_centre_ex(buffer, GAME.score_font, GAME.configuration->w / 2, GAME.configuration->h / 2 + 30, -1, -1, "Keep trying.  Press Enter to continue...");								
	}
	debug("HSC draw_highscore() DONE!\n");
		
}

void HSC::get_online()
{
	char url_buf[256];
	char http[150];
	char action[20];

	fireworks_timer = ticks;
	

	textprintf_ex(screen, font, 1, 1, WHITE, -1, "Loading High Scores...");


	strcpy(http, "http://www.solo-games.org/games/toggles/highscore.php");
	strcpy(action, "get");
	sprintf(url_buf, "%s?action=%s", http, action);
	downloading = oCom->download(url_buf);		
}

int HSC::get_online_version()
{
	char url_buf[256];
	char http[150];
	char action[20];	


	textprintf_ex(screen, font, 1, 1, WHITE, -1, "Loading Version...");

		
	strcpy(http, "http://www.solo-games.org/games/toggles/version.php");
	strcpy(action, "version");
	sprintf(url_buf, "%s?action=%s", http, action);

	get_version = oCom->download(url_buf);		
	return 0;
}

void HSC::store(char *cData)
{		
	oCom->store(cData);
}

void HSC::set_online(char *cData)
{
	int iIndex = 0, iparameter = 0;
	char *ctemp, *cnext;
	char ccurrent[256];
	unsigned int i = 0;

	ctemp = new char[(strlen(cData) + 1) * sizeof(char)];
	strcpy(ctemp, cData);
	cnext = ctemp;
	
	while(ctemp[i] != '\0' && i < strlen(cData) && iIndex < MAX_ONLINE_STATS)
	{
		if(ctemp[i] == '/')
		{
			cnext = ctemp + i + 1;
			ctemp[i] = '\0';
			strcpy(ccurrent, ctemp);
			
			switch(iparameter)
			{
				case 0:	
					strcpy(oStats[iIndex].cName, ccurrent); 
					break;
				case 1: 
					strcpy(oStats[iIndex].cversion, ccurrent); 
					break;
				case 2: oStats[iIndex].level = atoi(ccurrent); break;
				case 3: oStats[iIndex++].points = atoi(ccurrent); break;
			}			
			iparameter++;
			if(iparameter > 3) iparameter = 0;
			ctemp = cnext;
			i = 0;
		}
		i++;
	}	
}

STATS *HSC::get_ostats()
{
	return oStats;
}

STATS *HSC::get_lstats()
{
	return lStats;
}

int HSC::online_highscore(int points)
{
	int oh = 0; 
	while(oh < MAX_ONLINE_STATS && points < oStats[oh].points)
		oh++;

	if(oh < MAX_ONLINE_STATS && submit_ok)		// We've scored an online highscore!*/
		return oh;
	return -1;
}
	
int HSC::local_highscore(int points)
{
	int lh = 0; 
	while(lh < MAX_STATS && points < lStats[lh].points)
		lh++;

	if(lh < MAX_STATS)		// We've scored an local highscore!*/
		return lh;
	return -1;
}

void HSC::draw(BITMAP *bDisplay, int y, int S, int index)
{
	debug("HSC draw() called!\n");
	int offset = 1;
	set_palette((RGB *) GAME.msg_palette);
	rectfill(bImage, 0, 0, bImage->w, bImage->h, MASK);

	if(y < -1100) y = -1100;

	for(int i = 0; i < MAX_STATS; i++)
	{
		if(i == index)
		{			
			set_palette((RGB *) GAME.score_palette);
			textprintf_ex(bImage, GAME.score_font, 10, (i + offset) * 32, -1, -1, "%d.", i + offset);			
			textprintf_ex(bImage, GAME.score_font, 80, (i + offset) * 32, -1, -1, "%s", GAME.cName);					
			textprintf_right_ex(bImage, GAME.score_font, 490, (i + offset) * 32, -1, -1, "%d", GAME.gScore->points);							
			if(cursor_flash)
			{
				line(bImage, text_length(GAME.score_font, GAME.cName) + 80, (i + offset) * 32, text_length(GAME.score_font, GAME.cName) + 80, (i + offset + 1) * 32, GREEN);
				line(bImage, text_length(GAME.score_font, GAME.cName) + 81, (i + offset) * 32, text_length(GAME.score_font, GAME.cName) + 81, (i + offset + 1) * 32, GREEN);
			}
			offset++;
			set_palette((RGB *) GAME.msg_palette);
		}

		if(lStats[i].points != 0)
		{
			textprintf_ex(bImage, GAME.score_font, 10, (i + offset) * 32, -1, -1, "%d.", i + offset);
			textprintf_ex(bImage, GAME.score_font, 80, (i + offset) * 32, -1, -1, "%s", lStats[i].cName);					
			textprintf_right_ex(bImage, GAME.score_font, 490, (i + offset) * 32, -1, -1, "%d", lStats[i].points);					
		}
	}
	
	stretch_sprite(bDisplay, bImage, 0, y, bDisplay->w - S, bImage->h - S);
	debug("HSC draw_() DONE!\n");
}

void HSC::draw_online(BITMAP *bDisplay, int y, int S, int index)
{
	debug("HSC draw_online() called!\n");
	int offset = 2;
	set_palette((RGB *) GAME.msg_palette);
	rectfill(bImage, 0, 0, bImage->w, bImage->h, MASK);
	
	for(int i = 0; i < MAX_ONLINE_STATS - 1; i++)
	{
		if(i == index)
		{			
			set_palette((RGB *) GAME.score_palette);
			textprintf_ex(bImage, GAME.score_font, 10, (i + offset) * 32, -1, -1, "%d.", i + offset - 1);			
			textprintf_ex(bImage, GAME.score_font, 80, (i + offset) * 32, -1, -1, "%s", GAME.cName);					
			textprintf_right_ex(bImage, GAME.score_font, 490, (i + offset) * 32, -1, -1, "%d", GAME.gScore->points);							
			if(cursor_flash)
			{
				line(bImage, text_length(GAME.score_font, GAME.cName) + 80, (i + offset) * 32, text_length(GAME.score_font, GAME.cName) + 80, (i + offset + 1) * 32, GREEN);
				line(bImage, text_length(GAME.score_font, GAME.cName) + 81, (i + offset) * 32, text_length(GAME.score_font, GAME.cName) + 81, (i + offset + 1) * 32, GREEN);
			}
			offset++;
			set_palette((RGB *) GAME.msg_palette);
		}

		if(oStats[i].points != 0 && strcmp(oStats[i].cName, "Toggles_Version") != 0)
		{			
			textprintf_ex(bImage, GAME.score_font, 10, (i + offset) * 32, -1, -1, "%d.", i + offset - 1);
			textprintf_ex(bImage, GAME.score_font, 80, (i + offset) * 32, -1, -1, "%s", oStats[i].cName);					
			if(strcmp(oStats[i].cName, "") != 0)
				textprintf_right_ex(bImage, GAME.score_font, 490, (i + offset) * 32, -1, -1, "%d", oStats[i].points);							
		}
	}
	
	stretch_sprite(bDisplay, bImage, 0, y, bDisplay->w - S, bImage->h - S);	
	debug("HSC draw_online() DONE!\n");
}





void HSC::init()
{
	clear();
	bImage = create_bitmap_check(500, 3300);
	oCom = new ONLINE;
	downloading = false;
	get_version = false;
	submit_ok = true;
	cursor_timer = 0;
	cursor_delay = 0;
	cursor_flash = false;	

	high_timer = 0;
	fireworks_timer = 0;
	for(int f = 0; f < MAX_FIREWORKS; f++)
		fWorks[f] = new FIREWORK();
}

void HSC::clear()
{
	clear_local();
	clear_online();
}

void HSC::clear_local()
{

	for(int i = 0; i < MAX_STATS; i++)
	{
		lStats[i].level = 0;
		lStats[i].points = 0;
		lStats[i].version = 0.0;
		strcpy(lStats[i].cName, "");		
	}
}

void HSC::clear_online()
{
	for(int i = 0; i < MAX_ONLINE_STATS; i++)
	{
		oStats[i].level = 0;
		oStats[i].points = INT_MAX;
		strcpy(oStats[i].cversion, "");
		strcpy(oStats[i].cName, "");
	}
}

