#include "globals.h"
#include "game.h"
#include "test.h"
#include "data3.h"
#include "data2.h"
#include "string.h"

void games::logo_screen(bool status)
{
	BITMAP *bAllegro;
	BITMAP *bSolo;
	BITMAP *bTransfer;	

	int transparency;

	// To skip the logo screen
	if(!status) return;



	bAllegro = load_bitmap_check("./data/images/allegro.pcx", NULL);			
	bSolo = (BITMAP *) dat3[SOLOGAMES].dat;
	bTransfer = create_bitmap_check(buffer->w, buffer->h);	

	clear(buffer);
	transparency = 0;
	set_trans_blender(0,0,0,0);
	ticks = 1;		
	
	while(ticks < seconds(3) && !key[KEY_ESC])
	{
		while(system_time > 0)
		{
			ticks++;
			if(transparency < 255 && dTime(5))
			{				
				transparency += 10;
				set_trans_blender(0,0,0, transparency);
			}			
			stretch_sprite(bTransfer, bAllegro, 0, 0, buffer->w, buffer->h);
			system_time--;	
		
		}	
		
		draw_ticks++;		
		draw_trans_sprite(buffer, bTransfer, 0, 0);				
		draw_sprite(screen, buffer, 0, 0);
		
	}
	while(key_pressed(KEY_ESC)){}

	set_trans_blender(0,0,0,0);
	transparency = 0;
	ticks = 1;

	while(ticks < seconds(3) && !key[KEY_ESC])
	{
		while(system_time > 0)
		{
			ticks++;
			if(transparency < 255 && dTime(5))
			{				
				transparency += 10;
				set_trans_blender(0,0,0, transparency);
			}
			stretch_sprite(bTransfer, bSolo, 0, 0, buffer->w, buffer->h);
			textprintf_centre_ex(bTransfer, font, configuration->w / 2, 10, BLACK, -1, "http://www.solo-games.org");											
			system_time--;
		}

		draw_ticks++;
		draw_trans_sprite(buffer, bTransfer, 0, 0);
		draw_sprite(screen, buffer, 0, 0);
		
	}

	ticks = 1;	
	transparency = 0;
	while(transparency < 255)
	{
		clear(bSolo);
		while(system_time > 0)
		{
			ticks++;
			if(dTime(5))
			{				
				transparency += 10;
				set_trans_blender(0,0,0, transparency);
			}
			stretch_sprite(bTransfer, bSolo, 0, 0, buffer->w, buffer->h);
			system_time--;
		}
		draw_trans_sprite(buffer, bTransfer, 0, 0);
		draw_sprite(screen, buffer, 0, 0);
		
	}

	while(key_pressed(KEY_ESC)){}

	
	destroy_bitmap(bAllegro);	
	destroy_bitmap(bTransfer);
	
	
}


void games::play_game()
{	
	if(configuration->framerate == 1)
		iFrameRate = true;
	else
		iFrameRate = false;
	system_time = 0;
	ticks = 0;
	init();

	
	audio.add_to_playlist("./data/music/Right On!.ogg");
	audio.add_to_playlist("./data/music/ToggleMe.ogg");
	audio.set_loop();
	//Title_Screen();	
	gHSC->get_local();
	
		audio.stop();
		while(!gInput.MAP(CANCEL,5) && !quit)
		{
			while(system_time)
			{
				system_time--;
				ticks++;
				update();				
			}		
				
			draw_ticks++;
			draw();
			if(system_time)			//Share the computer
				rest(1);

			//printf("%d\n", system_time);
			
		}
		audio.stop();		
	
	audio.breakdown();
	shutdown();

}
int iSizeSet;

void games::init()
{	
	BITMAP *bTemp2;

	debugger = false;

	fMX = 0.0;
	fMY = 0.0;

	dat2 = load_datafile("./data/sfx/s.dat");
	if(!dat2)
	{
		allegro_message("ERROR:  Couldn't open dat2.dat file.");
		exit(0);
	}

		
	dat4 = load_datafile("./data/images/bp.dat");
	if(!dat4)
	{
		allegro_message("ERROR:  Couldn't open dat4.dat file.");
		exit(0);
	}

	mydat = load_datafile("./data/fonts.dat");
	if(!mydat)
	{
		allegro_message("Couldn't open dat file.");
		return;
	}

	score_font = (FONT *)mydat[Tog_Font].dat;
	if(!score_font)
		allegro_message("ERROR:  Could not read font file.");		
	score_palette = (PALETTE *)mydat[Tog_Palette].dat;
	if(!score_palette)
		allegro_message("ERROR: Could not load Palette for fonts.");
	
	help_font = (FONT *)mydat[My_Help].dat;
	if(!help_font)
		allegro_message("ERROR:  Could not read font file.");		
	help_palette = (PALETTE *)mydat[My_Help_Palette].dat;
	if(!help_palette)
		allegro_message("ERROR: Could not load Palette for fonts.");
	
	msg_font = (FONT *)mydat[Msg_Font].dat;
	if(!help_font)
		allegro_message("ERROR:  Could not read font file.");		
	msg_palette = (PALETTE *)mydat[Msg_Palette].dat;
	if(!msg_palette)
		allegro_message("ERROR: Could not load Palette for fonts.");
	blue_palette = (PALETTE *)mydat[Blue_Palette].dat;
	if(!blue_palette)
		allegro_message("ERROR: Could not load Palette for fonts.");
	
	gScore = new SCORE;

	

	
	gHSC = new HSC;
	version = fVERSION;
	strcpy(cName, "");
	bMouse = load_bitmap("./data/images/mouse.bmp", NULL);
	if(configuration->mouse_icon == 1)
		show_mouse(screen);
	
	sToggles_Screen = new SIMPLE_GUI;
	sToggles_Screen->Setup("./data/images/back2.pcx", buffer->w, buffer->h);
	sToggles_Screen->create_object(0, "Board Container", "./data/images/border.pcx", 0, 10, 10, 400, 400);
	sToggles_Screen->create_object(1, 0, "Board", 0, 15, 15, 365, 365);
	sToggles_Screen->create_object(2, "Toggle Progress", 0, 10, 420, 400, 50);
	sToggles_Screen->create_object(3, "Score", 0, 420, 10, 210, 45);	
	sToggles_Screen->set_draw_name(3, true);
	gScore->setup(210, 50);
	sToggles_Screen->create_object(4, "Level", 0, 420, 60, 210, 55);	
	sToggles_Screen->set_draw_name(4, true);
	bLevel = create_bitmap_check(210, 50);
	sToggles_Screen->create_object(5, "Time", 0, 420, 160, 210, 25);	
	sToggles_Screen->create_object(15, "Time", 0, 420, 120, 100, 40);	
	sToggles_Screen->set_draw_name(15, true);
	sToggles_Screen->create_object(18, "Time Display", 0, 530, 120, 100, 40);	
	
	
	bTemp2 = load_bitmap_check("./data/images/slot.pcx", NULL);
	sToggles_Screen->create_object(13, "Multiplier", 0, 420, 250, 210, 45);
	sToggles_Screen->set_draw_name(13, true);	
	sToggles_Screen->create_object(16, "Best", 0, 420, 300, 210, 45);
	sToggles_Screen->set_draw_name(16, true);
	sToggles_Screen->create_object(17, "Current", 0, 420, 350, 210, 45);
	sToggles_Screen->set_draw_name(17, true);

	char f1[30];
	char f2[30];
	strcpy(f1, "./data/images/"); strcat(f1, configuration->wunder_water);
	strcpy(f2, "./data/images/"); strcat(f2, configuration->wwater_surface);
	wToggles_Water = new WATER(f1, f2);		
	bBoard = new BOARD;	
	bBoard->setup(365, 365, 0);
	
	pTime_Progress = new PROGRESS_BAR;
	
	
	peToggle_Stars = new PARTICLE_ENGINE;
	peToggle_Stars->setup("./data/images/fluff.bmp", 0, 8, 8, 2);
	peZip_Stars = new PARTICLE_ENGINE;
	peZip_Stars->setup("./data/images/zip.bmp", 0, 8, 8, 0);
	peCombo  = new PARTICLE_ENGINE;
	peCombo->setup("./data/images/stars.pcx", 4, 16, 16, 0);
	peFire  = new PARTICLE_ENGINE;
	peFire->setup("./data/images/fire.bmp", 4, 16, 16, 0);

	bWater = create_bitmap_check(400, 400);
	iTemp = 200;	
	ticks = 0;

	lLightning = new LIGHTNING;

	pPenalty_Screen = new PENALTY;
	pPenalty_Screen->setup();
		
	audio.setup(configuration->music_volume, 
					 configuration->sfx_volume, 
					 configuration->pan, 
					 configuration->mspeed);
	audio.load_sfx(1,BONUS_WAV);
	audio.load_sfx(2,COMPLETE_WAV);
	audio.load_sfx(3,DING_WAV);
	audio.load_sfx(4,HEART_WAV);
	audio.load_sfx(5,LIGHTNING_WAV);
	audio.load_sfx(6,TIME_WAV);
	audio.load_sfx(7,TOGGLE_WAV);
	audio.load_sfx(9,ULTIMA_WAV);
	audio.load_sfx(10,BOMB_WAV);
	audio.load_sfx(11,COMBO1);
	audio.load_sfx(12,X_WAV);
	audio.load_sfx(13,TYPE_WAV);
	audio.load_sfx(14,OPTION_WAV);
	audio.load_sfx(15,ZIP_WAV);
	
	for(int m = 0; m < MAX_MESSAGES; m++)
		cMessages[m] = NULL;
	
	MainMenu = new TITLE;
	MainMenu->setup();
	state = TITLE_SCREEN;

	high_index = 0;
	high_pos = 0;	
	cName_Index = 0;
	score_case = 0;
	bHigh_Score = create_bitmap_check(500, 320);
	bTemp = create_bitmap_check(configuration->w, configuration->h);	
	
	pCurrent_Penalty = NO_PENALTY;		

	if(configuration->allow_online)
		view_online = true;
	else
		view_online = false;
	destroy_bitmap(bTemp2);		
}

void games::setup()
{	
	system_time = 0;
	ticks = 0;
	
	bBoard->iHConsecutive = 0;
	level = 0;
	iRows_Temp = 5;
	secs = 30;	
	percent = 0.70;
	difficulty = 1;	
	bBoard->set_difficulty(difficulty);	
	bBoard->reset_bonuses();
	gScore->reset();	
	if(configuration->mouse_icon == 1)
		set_mouse_speed(int(1.0 / configuration->mouse_speed), int(1.0 / configuration->mouse_speed));
	

	peCombo->clear();
	peToggle_Stars->clear();
	peZip_Stars->clear();
		
}

void games::level_init()
{
	int iClear, iMix;

	if(configuration->no_water_change == 1 && level > 1)
	{
		iClear = configuration->wclear_init;
		iMix = 50;
	}
	else
	{
		iClear = MID(0, configuration->wclear_init - (level * 2), 255);
		iMix = MID(50, 50 + (level * 3), 255);
		wToggles_Water->Setup(configuration->wwidth, 
							   configuration->wheight,
							   configuration->wdamper, 
							   configuration->wsmooth, 
							   iClear);
		wToggles_Water->mixture(iMix);
	}

	
	pTime_Progress->setup(210, 50, DARKRED, MASK, 1.0, true);
	pTime_Progress->set_progress(0.0);


	if(++level % 5 == 0) 
	{
		iRows_Temp++;		
		if(iRows_Temp > 30) iRows_Temp = 30;
			
		secs -= 3;
		if(secs < 5) secs = 5;

		percent += 0.02;
		if(percent > 1.0) percent = 1.0;
	}
	difficulty++;
	
	
	//bBoard->setup(GAME, iRows_Temp, 365, 365, 0, percent, seconds(secs));	
	bBoard->resetup(iRows_Temp, percent, seconds(secs)); 
	bBoard->set_difficulty(difficulty);	
	over = false;
	next_level = false;
	pPenalty_Screen->place(-400, 40);
	bBoard->reset_clock();
}

void games::level_finish()
{
	pPenalty_Screen->update();
	if((pCurrent_Penalty = pPenalty_Screen->done()) != NO_PENALTY)
	{
		pPenalty_Screen->move(700, 40);		
		if(pPenalty_Screen->position() > 640)
		{
			next_level = true;
			pPenalty_Screen->unlock();
			//bBoard->destroy();

			switch(pCurrent_Penalty)
			{
				case TIME_INCREASE: secs++; break;
				case PERCENT_DECREASE: percent -= 0.01; break;

				case TIME_DECREASE: secs--; break;
				case TIME_DECREASE_2: secs -= 2; break;
				case TIME_DECREASE_4: secs -= 4; break;
				case PERCENT_INCREASE: percent += 0.01; break;
				case PERCENT_INCREASE_2: percent += 0.02; break;
				case PERCENT_INCREASE_3: percent += 0.03; break;
				case ROW_INCREASE: iRows_Temp++; break;
				case ROW_INCREASE_2:  iRows_Temp += 2;
				case BONUS_PACKAGE:	gScore->add(3000);
				default: break;
			}
			if(iRows_Temp > 30) iRows_Temp = 30;			
		}
	}
}

void games::update()
{
	debug("******** GAME updating *********\n", 1);
	gHSC->update();
	if(state == TITLE_SCREEN || state == PAUSED)
	{
		audio.update(1);
		MainMenu->update();	
	}
	else if(state == HIGHSCORES)
	{		
		// The High Score code is poorly written.  However, it gets the job done...kind of.
		// Apologies for this nonsense, as it uses several variables located in the main
		// GAME structure (which it shouldn't).  Oh well, eh?
		peCombo->update();	
	}
	else
	{
		audio.update(0);

		//Quits current game...
		if(key[KEY_Q])
		{
			clear_keybuf();			
			state = TITLE_SCREEN;
			audio.stop();
			MainMenu->change_menu(0);
		}
		
		
		if(strcmp(configuration->level, "LOW") != 0) 
		{
			wToggles_Water->Update();
			peToggle_Stars->update();
			peZip_Stars->update();
			peCombo->update();
			peFire->update();
		}

		lLightning->update();
		if(strcmp(configuration->level, "LOW") != 0)sToggles_Screen->update();			

		
		if((!bBoard->complete() && !bBoard->ultima))
		{	
			level_finish();
			if(next_level)
				level_init();			
		}
		else
		{
			bBoard->update();
			pTime_Progress->set_progress(bBoard->fTime);
			pTime_Progress->update();
		}
	}

	
	// Update the global messages!
	for(int m = 0; m < MAX_MESSAGES; m++)
	{
		if(cMessages[m] != NULL)
		{
			cMessages[m]->update();
			if(cMessages[m]->finished)
			{
				delete cMessages[m];
				cMessages[m] = NULL;
			}
		}
	}

	if(configuration->mouse_icon != 1)
	{
		int tx, ty;
		get_mouse_mickeys(&tx, &ty);
		fMX += tx * configuration->mouse_speed;
		fMY += ty * configuration->mouse_speed;
		position_mouse(fMX, fMY);
	}
	else
	{
		fMX = mouse_x;
		fMY = mouse_y;
	}	
	debug("******** GAME updating complete*********\n", 1);
}

void games::draw()
{
	debug("******** GAME drawing *********\n", 1);
	int time_remaining;
	if(state == TITLE_SCREEN || state == PAUSED)
	{
		MainMenu->draw(buffer);
	}
	else if(state == HIGHSCORES)
	{
		draw_sprite(buffer, bTemp, 0, 0);
		gHSC->draw_highscore(buffer);
		draw_sprite(buffer, bHigh_Score, 70, 100);
	}
	else
	{
		wToggles_Water->draw(bWater);
		bBoard->draw();		
		sToggles_Screen->draw_solid_object(1, bBoard->image(), 0, 0);
		
		// Drawing the Score
		gScore->draw();
		sToggles_Screen->draw_object(3, gScore->image(), 0, 0);
		
		

		//***************************** NOTE ******************************************
		//This section of code is very Hacky-ish, and I did it when I first started this
		//project.  It could OBVIOUSLY be better.  ;)
		sToggles_Screen->set_colors(configuration->R, configuration->G, configuration->B);
		// Drawing the Level
		rectfill(bLevel, 0, 0, bLevel->w, bLevel->h, MASK);
		set_palette((RGB *) score_palette);
		textprintf_right_ex(bLevel, score_font, bLevel->w - 10, 10, -1, -1, "%d", level);					
		sToggles_Screen->draw_object(4, bLevel, 0, 0);	
		
		sToggles_Screen->draw_object(15);
		rectfill(bLevel, 0, 0, bLevel->w, bLevel->h, MASK);
		time_remaining = secs - (bBoard->iCurrent_Time / iTimer_Speed);
		if(time_remaining <= 5)
			set_palette((RGB *) msg_palette);
		textprintf_centre_ex(bLevel, score_font, 50, 10, -1, -1, "%d sec.", time_remaining);
		sToggles_Screen->draw_object(18, bLevel, 0, 0);	
		
		set_palette((RGB *) score_palette);
		sToggles_Screen->set_colors(0, 128, 0);
		set_palette((RGB *) score_palette);
		rectfill(bLevel, 0, 0, bLevel->w, bLevel->h, MASK);
		textprintf_right_ex(bLevel, score_font, bLevel->w - 10, 10, -1, -1, "%d", (level / 5 + 1));
		sToggles_Screen->draw_object(13, bLevel, 0, 0);			
		rectfill(bLevel, 0, 0, bLevel->w, bLevel->h, MASK);
		textprintf_right_ex(bLevel, score_font, bLevel->w - 10, 10, -1, -1, "%d", bBoard->iHConsecutive);
		sToggles_Screen->draw_object(16, bLevel, 0, 0);	
		rectfill(bLevel, 0, 0, bLevel->w, bLevel->h, MASK);
		textprintf_right_ex(bLevel, score_font, bLevel->w - 10, 10, -1, -1, "%d", bBoard->iConsecutive);
		sToggles_Screen->draw_object(17, bLevel, 0, 0);	

		
		
		
		sToggles_Screen->set_colors(configuration->R, configuration->G, configuration->B);
		
		pTime_Progress->draw();
		sToggles_Screen->set_colors(0, 0, 0);
		sToggles_Screen->draw_object(5, pTime_Progress->bDraw(), 0, 0);
		sToggles_Screen->set_colors(configuration->R, configuration->G, configuration->B);
		/*sToggles_Screen->draw_rectangle(5, 0, 0, 129, 49, LIGHTGOLDENRODYELLOW);
		sToggles_Screen->draw_rectangle(5, 1, 1, 128, 48, LIGHTGOLDENROD);*/

		sToggles_Screen->draw_object(6);

		//**********************************************************************************
		
		sToggles_Screen->draw(buffer);	
		bBoard->draw_buttons(buffer);		
		bBoard->draw_bonuses(buffer);		
		if(strcmp(configuration->level, "LOW") != 0) 
		{
			peToggle_Stars->draw(buffer);
			peZip_Stars->draw(buffer);		
			peCombo->draw(buffer);
			peFire->draw(buffer);
		}
		lLightning->draw(buffer);
		

		if(!bBoard->complete() && !bBoard->ultima)
		{
			set_trans_blender(0,0,0,0);
			draw_lit_sprite(buffer, buffer, 0, 0, 150);
			pPenalty_Screen->draw(buffer);			
		}
		if(bBoard->ultima)
		{
			set_trans_blender(0,255,0,0);
			draw_lit_sprite(buffer, buffer, 0, 0, bBoard->ultima_trans /2);
		}
	}

	for(int m = 0; m < MAX_MESSAGES; m++)
		if(cMessages[m] != NULL)			
			cMessages[m]->draw(buffer);
		
	//poll_mouse();
	if(configuration->mouse_icon == 0) draw_sprite(buffer, bMouse, fMX, fMY);
	else scare_mouse();	
	//draw_sprite(screen, buffer, 0, 0);	
	if(iFrameRate) 
	{
		set_trans_blender(0,0,0,100);
		rect(buffer, 0, GAME.configuration->h - 32, 230, GAME.configuration->h, BLUE);
		drawing_mode(DRAW_MODE_TRANS, buffer, 0,0);
		rectfill(buffer, 0, GAME.configuration->h - 32, 230, GAME.configuration->h, DARKBLUE);
		drawing_mode(DRAW_MODE_SOLID, buffer, 0,0);

		set_palette((RGB *) black_palette);
		textprintf_ex(buffer, score_font, 9, GAME.configuration->h - 29, -1, -1, "Framerate:  %dfps", framerate);
		textprintf_ex(buffer, score_font, 11, GAME.configuration->h - 31, -1, -1, "Framerate:  %dfps", framerate);
		set_palette((RGB *) msg_palette);
		textprintf_ex(buffer, score_font, 10, GAME.configuration->h - 30, -1, -1, "Framerate:  %dfps", framerate);					
	}
			
	acquire_screen();
	blit(buffer, screen, 0, 0, 0, 0, configuration->w, configuration->h);
	release_screen();
	if(configuration->mouse_icon == 1) unscare_mouse();
	
	debug("******** GAME drawing complete *********\n", 1);
}

void games::shutdown()
{
	if(bBoard != NULL) bBoard->destroy();
	if(sToggles_Screen != NULL) sToggles_Screen->destroy(); //delete sToggles_Screen;
	if(wToggles_Water != NULL) wToggles_Water->destroy(); //delete wToggles_Water;	
	gHSC->destroy();

	delete(peToggle_Stars);
	delete(peZip_Stars);
	delete(peCombo);
	delete(peFire);

	//destroy_bitmap(bDim);
	destroy_bitmap(bHigh_Score);
	destroy_bitmap(bTemp);
	destroy_bitmap(bLevel);
	unload_datafile(mydat);			
	unload_datafile(dat2);	
	unload_datafile(dat3);	
	unload_datafile(dat4);		

	destroy_bitmap(buffer);
	allegro_exit();
}



