#ifndef _DJ_H_
#define _DJ_H_

#include "alogg.h"
#include "list.h"


// NOTES:  Still need to include alogg.lib in project
// play(cSong) is only currently (theoritically) working function
#define MAX_SAMPLES 20

typedef struct song
{
	char *cTitle;
	int iNumber;
} SONG;

class DJ
{
public:
	LIST *playlist;
	LIST *lSong;
	int iMax_Songs;
	bool repeat;
	bool power;
	int volume;
	int sfx_volume;
	int pan;
	int speed;
	int music_timer;

	// Samples are used for sound effects
	SAMPLE *sfx[MAX_SAMPLES];

	// Used to open an OGG file
	FILE *fOgg;
	ALOGG_OGG *current;
	unsigned int len;
	char *data;

	DJ();
	~DJ();

	void setup();
	void setup(int V, int SV, int P, int S);
	void breakdown();
	void add_to_playlist(char *cSong);
	void add_to_playlist(char *cSong, int iNumber);
	void shuffle();
	void shuffle_on();
	void set_loop();
	void play();
	void play(char *cSong);
	void play(int iNumber);
	void stop();
	void update();
	void update(int i);
	bool fade_out(int iTime);
	void adjust_volume(int v);
	void adjust_sfx_volume(int v);

	void play_sfx(int index);
	void play_sfx(int index, int freq);
	void load_sfx(int index, char *cpath);
	void load_sfx(int index, int iOffset);


private:
	void solo(char *cSong);	
	bool shuffler;
	bool loop;

};

#endif /* End of _DJ_H_ */
