#include "globals.h"
#include "game.h"
#include "board.h"
#include "string.h"
#include "data3.h"


BOARD::BOARD()
{
	init();
}

BOARD::~BOARD()
{

}

void BOARD::set_difficulty(int iValue)
{
	iDifficulty = iValue;
}


void BOARD::resetup(int Row_Count, float fPercent, int iTime)
{
	int bx, by;

	if(Row_Count > MAX_ROWS) Row_Count = MAX_ROWS;
	iRow_Count = MID(0, Row_Count, 30);
	arrange_tiles(iWidth, iPadding, Row_Count);

	bx = iSpace + iPadding;
	by = iSpace + iPadding;
	iConsecutive = 0;	
	iConsistent = 0;
	iIncrement = 10;
	

	alive = true;

	fPCurrent_Max = fPercent;
	fPMax = fPercent;

	
	pToggle_Progress->resetup(GREEN, MASK, fPCurrent_Max);	
	pToggle_Progress->set_bar(fPCurrent_Max);
	pToggle_Progress->set_progress(0.0);

	bParticle_Effect = true;
	ultima = false;
	ultima_timer = 0;
	ultima_size = 0;
	ultima_trans = 0;
	ultima_complete = false;

	iTimer = iTime;	
	reset_clock();

	clear_bonuses();

	

	// Re-setup Toggle-specific data...
	for(int j = 0; j < Row_Count; j++)
	{
		if(j != 0) bx += iSize + iSpace;
		by = iSpace + iPadding;
		for(int k = 0; k < Row_Count; k++)
		{			
			if(k != 0) by += iSize + iSpace;
			
			if(rand() % 100 > 80) 
				tToggles[j][k]->setup(bx, by, iSize, iSize, false, iDifficulty);
			else
				tToggles[j][k]->setup(bx, by, iSize, iSize, true, iDifficulty);
		}
	}

	setup_clocks(Row_Count);
	iTimer_Offset = ticks;
}

void BOARD::setup_clocks(int Row_Count)
{
	// Change Bonuses
	int iClock_Count = GAME.level / CLOCKS_PER_LEVEL;
	int i = 0, k = 0;
	int trow, tcolumn, tx, ty, bcount;
	if(iClock_Count > 0)								//Need a clock
	{
		while(i < MAX_BONUSES && bGift[i]->visible)		//Find the first non-visible bonus
			i++;
		if(i < MAX_BONUSES)
		{
			bcount = 0;
			while(i < MAX_BONUSES && bcount < iClock_Count)	//Add how ever many need clocks
			{
				trow = rand() % Row_Count;
				tcolumn = rand() % Row_Count;
				tx = tToggles[trow][tcolumn]->x;
				ty = tToggles[trow][tcolumn]->y;				
				if(tToggles[trow][tcolumn]->is_floating())		//Found a visible toggle
				{
					//Search to see if a bonus is already on this toggle
					k = 0;
					while(k < MAX_BONUSES && bGift[k]->visible && abs(bGift[0]->x - tx) > iSize && abs(bGift[0]->y - ty) > iSize)
						k++;

					//Add the clock!
					if(k >= MAX_BONUSES || !bGift[k]->visible)
					{
						bGift[i] = new BONUS;
						bGift[i++]->reset(CLOCK, "./data/images/clock.pcx", tx+(iSize/5),ty+(iSize/5), 32, 32, 12, iSize);
						bcount++;
					}
				}
			}
		}		
	}

}

void BOARD::draw_type(BITMAP *bDisplay, int index, float r, float g, float b, float fIntensity)
{	
	if(index != 2)
	{
		set_trans_blender(r,g,b,0);
		draw_lit_sprite(bType[index], bPiece, 13, 12, 255 * fIntensity);
	}
			
	
	stretch_sprite(bDisplay, bType[index], 0, 0, bDisplay->w, bDisplay->h);
	rect(bDisplay, 0, 0, bDisplay->w-1, bDisplay->h-1, makecol(0,0,0));
	rect(bDisplay, 1, 1, bDisplay->w-2, bDisplay->h-2, makecol(r/4,g/4,b/4));
}


void BOARD::setup(int W, int H, int Padding)
{


	bPiece = load_bitmap("./data/images/toggle_piece.pcx", NULL);
	bType[0] = load_bitmap_check("./data/images/toggle8.pcx", NULL);
	bType[1] = load_bitmap_check("./data/images/toggle10.pcx", NULL);
	bType[2] = load_bitmap_check("./data/images/toggle3.pcx", NULL);	
	bType[3] = load_bitmap_check("./data/images/toggle9.pcx", NULL);	

	iWidth = W;
	iHeight = H;
	bImage = create_bitmap_check(W, H);
	iPadding = Padding;
		
	pToggle_Progress = new PROGRESS_BAR;
	pToggle_Progress->setup(400, 50, false, true);

	oHelp_Button = new OPTION;
	oHelp_Button->setup("", 101, BUTTON, 440, 410, 190, 60, 101, 0);
	oHelp_Button->set_button_text("Help", 0);	
	oHelp_Button->highlight_only();
	
	

	for(int j = 0; j < MAX_ROWS; j++)
		for(int k = 0; k < MAX_COLUMNS; k++)		
			tToggles[j][k] = new TOGGLE;

	for(int b = 0; b < MAX_BONUSES; b++)
		bGift[b] = new BONUS;
		
	
}


void BOARD::destroy_bonuses()
{
	for(int i = 0; i < MAX_BONUSES; i++)
		if(bGift[i] != NULL)
		{
			bGift[i]->destroy();			
			bGift[i] = NULL;
		}

	for(int h = 0; h < MAX_SLOTS; h++)
		bSlots[h] = NULL;
}

void BOARD::reset_bonuses()
{
	for(int h = 0; h < MAX_SLOTS; h++)
		bSlots[h] = NULL;
}


void BOARD::destroy()
{
	if(bImage != NULL) destroy_bitmap(bImage);
	if(bType[0] != NULL) {destroy_bitmap(bType[0]); bType[0] = NULL;}
	if(bType[1] != NULL) {destroy_bitmap(bType[1]); bType[1] = NULL;}
	if(bType[2] != NULL) {destroy_bitmap(bType[2]); bType[2] = NULL;}
	if(bStars != NULL) {destroy_bitmap(bStars); bStars = NULL;}

	destroy_bitmap(bPiece);
	if(oHelp_Button != NULL) {oHelp_Button->destroy(); oHelp_Button = NULL;}
	if(pToggle_Progress != NULL) pToggle_Progress->destroy();

	for(int j = 0; j < iRow_Count; j++)
		for(int k = 0; k < iRow_Count; k++)
			if(tToggles[j][k] != NULL) 
			{
				tToggles[j][k]->destroy();
				tToggles[j][k] = NULL;
			}
	for(int i = 0; i < MAX_BONUSES; i++)
		if(bGift[i] != NULL)
		{
			bGift[i]->destroy();
			bGift[i] = NULL;
		}

	for(int h = 0; h < MAX_SLOTS; h++)
		bSlots[h] = NULL;

}


void BOARD::clear_bonuses()
{
	for(int i = 0; i < MAX_BONUSES; i++)
		if(bGift[i] != NULL && bGift[i]->visible)
					bGift[i]->visible = false;		
}

void BOARD::slide_bonuses()
{
	BONUS *bTemp;

	if(bSlots[0] != NULL)bSlots[0]->place(bSlots_X[MAX_SLOTS - 1], bSlots_Y[MAX_SLOTS - 1]);
	bTemp = bSlots[0];
	for(int i = 0; i < MAX_SLOTS - 1; i++)
	{
		if(bSlots[i+1] != NULL) bSlots[i+1]->place(bSlots_X[i], bSlots_Y[i]);
		bSlots[i] = bSlots[i + 1];
	}
	bSlots[MAX_SLOTS - 1] = bTemp;

}
void BOARD::update()
{
	debug("BOARD update() called!\n", 2);
	int iCount = 0;	
	bool status;
	input();
	
	status = true;
//	poll_mouse();
	for(int j = 0; j < iRow_Count; j++)
		for(int k = 0; k < iRow_Count; k++)
		{
			tToggles[j][k]->update(GAME.fMX - 20, GAME.fMY - 20);	
			if(ultima_complete) tToggles[j][k]->toggle_down();
			if(tToggles[j][k]->is_visible() != true) 
				iCount++;
			else
				if(tToggles[j][k]->iType() != 3)
					status = false;
		}	

	// Got 100% of Toggles down!!!!!!!!!!
	if(status) 
	{
		alive = false;
		if(!ultima)
			GAME.gScore->add(500 * GAME.level);
		GAME.audio.play_sfx(2);
		GAME.pPenalty_Screen->move(120, 40);
	}
	
	for(int i = 0; i < MAX_BONUSES; i++)
		if(bGift[i] != NULL) 
		{
			bGift[i]->update(GAME.fMX - 20, GAME.fMY - 20);
			if(ultima) 
			{
				clear_bonuses();				
			}
		}
	fPercentage = (iCount) / float(iRow_Count * iRow_Count);	
	iCurrent_Time = ticks - iTimer_Offset;
	fTime = (iCurrent_Time) / float(iTimer);

	pToggle_Progress->set_progress(fPercentage);	
	pToggle_Progress->update();

	if(pToggle_Progress->finished() && bParticle_Effect)
	{	
		pToggle_Progress->color_change(BLUE);
		GAME.gScore->add(50);
		GAME.audio.play_sfx(3);
		GAME.peToggle_Stars->explode(150, 210, 445, 200, 25, 1.0, 0.01, 1.0, 0.05, 60);
		bParticle_Effect = false;
	}
	if(GAME.pTime_Progress->finished())
	{
        alive = false;
		if(!pToggle_Progress->finished()) 
			board_game_over();			
		else
		{
			if(!ultima)
			{
			GAME.audio.play_sfx(2);
			GAME.pPenalty_Screen->move(120, 40);
			}
		}
	}
	
	if(ultima && !ultima_complete && abs(ticks - ultima_timer) > 2)
	{
		ultima_trans += 6;
		if(ultima_trans > 255) 
		{
			ultima_trans = 255;
			ultima_complete = true;
			GAME.peToggle_Stars->explode(MAX_PARTICLES, 200, 200, 200, 200, 1.0, 0.01, 1.0, 0.05, 100, 0.5);
		}
		ultima_size += 7;
		ultima_timer = ticks;
	}
	if(ultima_complete && abs(ticks - ultima_timer) > 2)
	{
		ultima_trans -= 10;
		if(ultima_trans < 0)
		{
			ultima_trans = 0;
			ultima = false;
			ultima_complete = false;
		}
	}
	

oHelp_Button->update();
	if(oHelp_Button->click() != 0)		//Help Button was clicked...
	{
		GAME.state = PAUSED;
		GAME.audio.stop();
		GAME.MainMenu->change_menu(7);
		GAME.pause_ticks = ticks;
		GAME.pause_system = system_time;
		
	}
	debug("BOARD update() done!\n", 3);
}

void BOARD::board_game_over()
{
	GAME.audio.play_sfx(6);	
	GAME.state = HIGHSCORES;	
	GAME.gHSC->get_online();	
	GAME.high_index = 0;
	GAME.high_pos = 0;
	GAME.score_case = 1;
	draw_sprite(GAME.bTemp, buffer, 0, 0);
	clear_keybuf();
}

void BOARD::input()
{
	if(abs(ticks - input_timer) > 1 && input_lock == false)
	{
		if(gInput.MAP(ACCEPT) || mouse_b & 1)
		{
			use_bonus();
			input_lock = true;	
		}
		
		if(gInput.MAP(ACTION_1) || mouse_b & 2)
		{
			input_lock = true;	
			slide_bonuses();
		}

		
		input_timer = ticks;
		

	}

	if(input_lock == true)
	{
		if(!gInput.MAP(ACCEPT) && !gInput.MAP(ACTION_1) && !(mouse_b & 1) && !(mouse_b & 2))
			input_lock = false;
	}


}

void BOARD::use_bonus()
{
	int i = 0, j = 0;
	while(i < MAX_SLOTS && bSlots[i] == NULL)
		i++;
	if(i >= MAX_SLOTS) return;

	while(j < MAX_BONUSES && bGift[j] != bSlots[i])
		j++;

	if(j >= MAX_BONUSES) return;
	if(bGift[j]->use())
	{
		//bGift[j]->destroy();
		//bGift[j] = NULL;
		bGift[j]->visible = false;
		bSlots[i] = NULL;
		slide_bonuses();
	}
}

int BOARD::tile_size()
{
	return iSize;
}

void BOARD::generate_bonus(int iDifficulty, int x, int y)
{
	int i = 0;
	int moderation = 5;  //Programmer variable to balance bonus-giving system
	int bonus_type;
	while(i < MAX_BONUSES - (GAME.level / CLOCKS_PER_LEVEL))
	{
		if(!bGift[i]->visible)
			break;
		i++;
	}

	if(i >= MAX_BONUSES - (GAME.level / CLOCKS_PER_LEVEL))
		return;
	else
	{
		//Decide if we are even going to get a bonus
		if(rand() % 100 < (iDifficulty / moderation))
		{
			
			bonus_type = rand() % (1000 + (GAME.level * 5));			
			// Adjust
			x = x +(iSize/5);
			y = y +(iSize/5);
			if(bonus_type <= 1000 && bonus_type > 400)
			{
				
				bGift[i]->reset(BOMB, "./data/images/bomb.pcx", x, y, 32, 32, 4, iSize);			
			}
			else if(bonus_type <= 400 && bonus_type > 150)
			{				
				bGift[i]->reset(BOLT, "./data/images/bolt.pcx", x, y, 32, 32, 4, iSize);			
			}
			else if(bonus_type <= 150 && bonus_type > 80)
			{
				//Currently, the Blue Turtle shell isn't in-game :/								
			}
			
			else if(bonus_type <= 80 && bonus_type > 30)
			{
				//Clocks are no longer given as of version 2.0 (given steadily according to CLOCKS_PER_LEVEL)
				//bGift[i]->reset(CLOCK, "./data/images/clock.pcx", x, y, 32, 32, 12, iSize);
			}
			else if(bonus_type <= 30 && bonus_type > 10)
			{
				
				bGift[i]->reset(BPERCENT, "./data/images/percent.pcx", x, y, 32, 32, 8, iSize);			
			}
			else if(bonus_type <= 10)
			{
				
				bGift[i]->reset(ULTIMA, "./data/images/ultima.pcx", x, y, 32, 32, 8, iSize);			
			}
			
		}
				
	}
}

void BOARD::combo(int iAdd)
{
	char msg[30];
	
	iConsecutive += iAdd;	
	if(iConsecutive > iHConsecutive)
		iHConsecutive = iConsecutive;

	GAME.gScore->add(iConsecutive * (GAME.level / 5 + 1));
	if(iConsecutive >= iConsistent + iIncrement)
	{
		
		iConsistent = iConsecutive;
		
		GAME.peCombo->explode(10, GAME.fMX, GAME.fMY, 100, 100, 0.5, 0.28, 5.0, 0.05, 15);					
		GAME.audio.play_sfx(11, 1000 + 25 * iIncrement);
		switch(iIncrement)
		{
		case 10:	strcpy(msg, "Good!");  break;				//10
		case 12:	strcpy(msg, "Nice!");  break;				//22
		case 14:	strcpy(msg, "Sweet!");  break;				//36
		case 16:	strcpy(msg, "Phat!");  break;				//52
		case 18:	strcpy(msg, "Pow!");  break;				//70
		case 20:	strcpy(msg, "Mega!");  break;				//90
		case 22:	strcpy(msg, "Gnarly!!");  break;			//112
		case 24:	strcpy(msg, "Holy Cow!!");  break;			//136
		case 26:	strcpy(msg, "Crazy!!");  break;				//162
		case 28:	strcpy(msg, "Awesome!!");  break;			//190
		case 30:	strcpy(msg, "Killer!!!");  break;			//220
		case 32:	strcpy(msg, "IMPOSSIBLE!!!");  break;		//252
		default:	strcpy(msg, "Uber!!!");  break;				//286
		}

		create_message(msg);
		iIncrement += 2;
	}
	
}

void BOARD::draw()
{
	debug("BOARD draw() called!\n");
	//rectfill(bImage, 0, 0, bImage->w, bImage->h, MASK);	
	stretch_sprite(bImage, GAME.bWater, 0, 0, bImage->w, bImage->h);
	
	for(int j = 0; j < iRow_Count; j++)
		for(int k = 0; k < iRow_Count; k++)
			tToggles[j][k]->draw(bImage);

	pToggle_Progress->draw();
	GAME.sToggles_Screen->set_colors(0, 0, 0);
	GAME.sToggles_Screen->draw_object(2, pToggle_Progress->bDraw(), 0, 0);
	GAME.sToggles_Screen->draw_rectangle(2, 0, 0, 399, 49, SKYBLUE);
	GAME.sToggles_Screen->draw_rectangle(2, 1, 1, 398, 48, LIGHTSKYBLUE);
	GAME.sToggles_Screen->set_colors(GAME.configuration->R, GAME.configuration->G, GAME.configuration->B);
	
	if(ultima)
	{
		set_trans_blender(0,0,0,ultima_trans);		
		drawing_mode(DRAW_MODE_TRANS, bImage, 0,0);
		circlefill(bImage, 200, 200, ultima_size, DARKGREEN);		
		drawing_mode(DRAW_MODE_SOLID, bImage, 0,0);
	}
	debug("BOARD draw() DONE!\n");
}

void BOARD::draw_buttons(BITMAP *bDisplay)
{
	oHelp_Button->draw(bDisplay);
	rect(bDisplay, 440, 410, 630, 470, SKYBLUE);
	rect(bDisplay, 441, 411, 629, 469, LIGHTSKYBLUE);			
}

void BOARD::draw_bonuses(BITMAP *bDisplay)
{
	if(ultima) return;
	for(int i = 0; i < MAX_BONUSES; i++)
		if(bGift[i] != NULL && bGift[i]->visible) 
			bGift[i]->draw(bDisplay, iSize, iSize);

}

BITMAP *BOARD::image()
{
	return bImage;
}



void BOARD::arrange_tiles(int Board_Size, int Padding, int Row_Count)
{
  	int iExtra = 2;
 	int iRemainder = 0, iEmpty = 0;


    if(Row_Count == 0) return;
	iSize = (Board_Size - (Padding * 2)) / (Row_Count + iExtra);  
    iRemainder = (Board_Size - (Padding * 2)) - (iSize * (Row_Count + iExtra));
 	iEmpty = iSize * iExtra + iRemainder;
 	iSpace = iEmpty / (Row_Count + 1);    
	
}

bool BOARD::complete()
{
	return alive;
}

void BOARD::init()
{
	for(int x = 0; x < MAX_ROWS; x++)
		for(int y = 0; y < MAX_COLUMNS; y++)
            tToggles[x][y] = NULL;
	for(int i = 0; i < MAX_BONUSES; i++)
		bGift[i] = NULL;

	for(int z = 0; z < MAX_SLOTS; z++)
	{
		bSlots[z] = NULL;		
		if(z <= 2)
		{
            bSlots_X[z] = 450 + (z * 60) - 5;
			bSlots_Y[z] = 280;
		}
		else
		{
			bSlots_X[z] = 450 + ((z - 3) * 60) - 5;
			bSlots_Y[z] = 280 + 60;
		}
	}

	iRow_Count = 0;
	fPercentage = 0.0;

	iSize = 0;
	iSpace = 0;

	iWidth = 0;
	iHeight = 0;
	iPadding = 0;	
	fTime = 0.0;
	iCurrent_Time = 0;
	iTimer = 0;
	iTimer_Offset = 0;
	iConsecutive = 0;

	input_timer = 0;

	fPCurrent_Max = 0.0;
	fPMax = 0.0;

	alive = false;
	input_lock = false;

	pToggle_Progress = NULL;
	bParticle_Effect = false;

	ultima = false;
	ultima_timer = 0;
	ultima_size = 0;
	ultima_trans = 0;
	ultima_complete = false;

	oHelp_Button = NULL;

	iHConsecutive = 0;
	iConsistent = 0;
	iIncrement = 0;

	bStars = NULL;
}

void BOARD::set_timer(int iTime)
{
	iTimer = iTime;
}

void BOARD::set_progress_max(float fNeeded)
{
	fPCurrent_Max = fNeeded;
	pToggle_Progress->set_bar(fNeeded);
}

float BOARD::progress_max()
{
	return fPCurrent_Max;
}

int BOARD::bsize()
{
	return iRow_Count; 
}	

void BOARD::reset_clock()
{
	iTimer_Offset = ticks;
}


int BOARD::current_slot()
{
	int i = 0;
	while(i < MAX_SLOTS && bSlots[i] != NULL)
		i++;
	if(i >= MAX_SLOTS) return -1;
	return i;
}

void BOARD::set_slot(int i, BONUS *bTemp)
{
	bSlots[i] = bTemp;
}

int BOARD::toggle_x(int mx, int my)
{
	int j = 0, k = 0;
	bool status = false;
	while(j < iRow_Count && status == false)
	{
		k = 0;
		while(k < iRow_Count && status == false)
		{
			status = tToggles[j][k]->loose_mouse_over(mx, my);

			k++;
		}
		j++;
	}
	return j - 1;
}

int BOARD::toggle_y(int mx, int my)
{
	int j = 0, k = 0;
	bool status = false;
	while(j < iRow_Count && status == false)
	{
		k = 0;
		while(k < iRow_Count && status == false)
		{
			status = tToggles[j][k]->loose_mouse_over(mx, my);

			k++;
		}
		j++;
	}
	return k - 1;
}

void BOARD::toggle_down(int i, int j)
{
	if(i >= 0 && i < iRow_Count && j >= 0 && j < iRow_Count)
		tToggles[i][j]->toggle_down();
}