/**************************************************************
*  Name:     allegro_color.h                                  *
*  Date:     4/10/2005                                        *
*  Author:   Steven Silvey                                    *
*  Purpose:  Eases the use of color functionality in the      *
*           allegro gaming library.                           *
**************************************************************/

#ifndef _ALLEGRO_COLOR_H
#define _ALLEGRO_COLOR_H

// This structure is nice in that in packages the 3 different 
// colors that mix to form a single color
typedef struct color
{
	int red;			// The intensity of REDness
	int green;			// The intensity of GREENness
    int blue;			// The intensity of BLUEness
} COLOR;

// The next three functions return the respected color based 
// on a value from the mixed rgb value
int red(int color_value);
int green(int color_value);
int blue(int color_value);

// This function takes the mixed rgb value and splits up the
// main three colors into a COLOR struct
COLOR getColor(int color_value);

// The next two functions return a mixed rgb value based on
// given information.  rgb is the same thing as make_col in
// allegro.
int rgb(int red, int green, int blue);
int rgb(COLOR color_data);

// The following is a list of predefined colors taken from
// the CMUgraphics library.  They can be used in place of
// writing the rgb function.  Disclaimer for rights can 
// be found at the bottom.
/*//******************* WHITES **************************
extern const int WHITE;
extern const int SNOW;
extern const int GHOSTWHITE;
extern const int WHITESMOKE;
extern const int GAINSBORO;
extern const int FLORALWHITE;
extern const int OLDLACE;
extern const int LINEN;
extern const int ANTIQUEWHITE;
extern const int PAPAYAWHIP;
extern const int BLANCHEDALMOND;
extern const int BISQUE;
extern const int PEACHPUFF;
extern const int NAVAJOWHITE;
extern const int MOCCASIN;
extern const int CORNSILK;
extern const int IVORY;
extern const int LEMONCHIFFON;
extern const int SEASHELL;
extern const int HONEYDEW;
extern const int MINTCREAM;

//******************* BLACKS **************************
extern const int BLACK;
extern const int DARKSLATEGRAY;
extern const int DARKSLATEGREY;
extern const int DIMGRAY;
extern const int DIMGREY;
extern const int SLATEGRAY;
extern const int SLATEGREY;
extern const int LIGHTSLATEGRAY;
extern const int LIGHTSLATEGREY;
extern const int GRAY;
extern const int GREY;
extern const int LIGHTGREY;
extern const int LIGHTGRAY;

//******************* BLUES ***************************
extern const int MIDNIGHTBLUE;
extern const int NAVY;
extern const int NAVYBLUE;
extern const int CORNFLOWERBLUE;
extern const int DARKSLATEBLUE;
extern const int SLATEBLUE;
extern const int MEDIUMSLATEBLUE;
extern const int LIGHTSLATEBLUE;
extern const int MEDIUMBLUE;
extern const int ROYALBLUE;
extern const int BLUE;
extern const int DODGERBLUE;
extern const int DEEPSKYBLUE;
extern const int SKYBLUE;
extern const int LIGHTSKYBLUE;
extern const int STEELBLUE;
extern const int LIGHTSTEELBLUE;
extern const int LIGHTBLUE;
extern const int POWDERBLUE;
extern const int PALETURQUOISE;
extern const int DARKTURQUOISE;
extern const int MEDIUMTURQUOISE;
extern const int TURQUOISE;
extern const int CYAN;
extern const int LIGHTCYAN;
extern const int CADETBLUE;
extern const int MEDIUMAQUAMARINE;
extern const int AQUAMARINE;

//******************* GREENS **************************
extern const int DARKGREEN;
extern const int DARKOLIVEGREEN;
extern const int DARKSEAGREEN;
extern const int SEAGREEN;
extern const int MEDIUMSEAGREEN;
extern const int LIGHTSEAGREEN;
extern const int PALEGREEN;
extern const int SPRINGGREEN;
extern const int LAWNGREEN; 
extern const int GREEN; 
extern const int CHARTREUSE; 
extern const int MEDIUMSPRINGGREEN;
extern const int GREENYELLOW; 
extern const int LIMEGREEN; 
extern const int YELLOWGREEN;
extern const int FORESTGREEN;
extern const int OLIVEDRAB;

//******************* YELLOWS *************************
extern const int DARKKHAKI; 
extern const int KHAKI; 
extern const int PALEGOLDENROD; 
extern const int LIGHTGOLDENRODYELLOW; 
extern const int LIGHTYELLOW; 
extern const int YELLOW; 
extern const int GOLD; 
extern const int LIGHTGOLDENROD; 
extern const int GOLDENROD; 
extern const int DARKGOLDENROD;
extern const int ROSYBROWN; 
extern const int INDIAN; 
extern const int INDIANRED; 
extern const int SADDLEBROWN;
extern const int SIENNA; 
extern const int PERU; 

//******************* BROWNS **************************
extern const int BURLYWOOD; 
extern const int BEIGE; 
extern const int WHEAT; 
extern const int SANDYBROWN; 
extern const int TAN; 
extern const int CHOCOLATE; 
extern const int FIREBRICK; 
extern const int BROWN; 
extern const int DARKSALMON; 
extern const int SALMON; 
extern const int LIGHTSALMON;

//******************* ORANGES *************************
extern const int ORANGE; 
extern const int DARKORANGE;
extern const int CORAL; 
extern const int LIGHTCORAL; 

//******************* REDS ****************************
extern const int TOMATO; 
extern const int ORANGERED; 
extern const int RED; 
extern const int HOTPINK; 
extern const int DEEPPINK; 
extern const int PINK; 
extern const int LIGHTPINK; 
extern const int PALEVIOLETRED; 
extern const int MAROON; 
extern const int MEDIUMVIOLETRED; 
extern const int VIOLETRED; 
//extern const int MASK; 



//******************* PURPLES *************************
extern const int VIOLET; 
extern const int PLUM; 
extern const int ORCHID;
extern const int MEDIUMORCHID; 
extern const int DARKORCHID; 
extern const int DARKVIOLET; 
extern const int BLUEVIOLET; 
extern const int PURPLE; 
extern const int MEDIUMPURPLE; 
extern const int THISTLE; 

//******************* OTHER ***************************
extern const int DARKGREY; 
extern const int DARKGRAY; 
extern const int DARKBLUE; 
extern const int DARKCYAN; 
extern const int DARKMAGENTA; 
extern const int DARKRED; 
extern const int LIGHTGREEN;

extern const int AZURE;
extern const int ALICEBLUE;
extern const int LAVENDER;
extern const int LAVENDERBLUSH;
extern const int MISTYROSE;*/


#define SNOW makecol(255, 250, 250)
#define GHOSTWHITE makecol(248, 248, 255)
#define WHITESMOKE makecol(245, 245, 245)
#define GAINSBORO makecol(220, 220, 220)
#define FLORALWHITE makecol(255, 250, 240)
#define OLDLACE makecol(253, 245, 230)
#define LINEN makecol(250, 240, 230)
#define ANTIQUEWHITE makecol(250, 235, 215)
#define PAPAYAWHIP makecol(255, 239, 213)
#define BLANCHEDALMOND makecol(255, 235, 205)
#define BISQUE makecol(255, 228, 196)
#define PEACHPUFF makecol(255, 218, 185)
#define NAVAJOWHITE makecol(255, 222, 173)
#define MOCCASIN makecol(255, 228, 181)
#define CORNSILK makecol(255, 248, 220)
#define IVORY makecol(255, 255, 240)
#define LEMONCHIFFON makecol(255, 250, 205)
#define SEASHELL makecol(255, 245, 238)
#define HONEYDEW makecol(240, 255, 240)
#define MINTCREAM makecol(245, 255, 250)
#define AZURE makecol(240, 255, 255)
#define ALICEBLUE makecol(240, 248, 255)
#define LAVENDER makecol(230, 230, 250)
#define LAVENDERBLUSH makecol(255, 240, 245)
#define MISTYROSE makecol(255, 228, 225)
#define WHITE makecol(255, 255, 255)
#define BLACK makecol(0, 0, 0)
#define DARKSLATEGRAY makecol(47, 79, 79)
#define DARKSLATEGREY makecol(47, 79, 79)
#define DIMGRAY makecol(105, 105, 105)
#define DIMGREY makecol(105, 105, 105)
#define SLATEGRAY makecol(112, 128, 144)
#define SLATEGREY makecol(112, 128, 144)
#define LIGHTSLATEGRAY makecol(119, 136, 153)
#define LIGHTSLATEGREY makecol(119, 136, 153)
#define GRAY makecol(60, 60, 60)
#define GREY makecol(190, 190, 190)
#define LIGHTGREY makecol(211, 211, 211)
#define LIGHTGRAY makecol(211, 211, 211)
#define MIDNIGHTBLUE makecol(25, 25, 112)
#define NAVY makecol(0, 0, 128)
#define NAVYBLUE makecol(0, 0, 128)
#define CORNFLOWERBLUE makecol(100, 149, 237)
#define DARKSLATEBLUE makecol(72, 61, 139)
#define SLATEBLUE makecol(106, 90, 205)
#define MEDIUMSLATEBLUE makecol(123, 104, 238)
#define LIGHTSLATEBLUE makecol(132, 112, 255)
#define MEDIUMBLUE makecol(0, 0, 205)
#define ROYALBLUE makecol(65, 105, 225)
#define BLUE makecol(0, 0, 255)
#define DODGERBLUE makecol(30, 144, 255)
#define DEEPSKYBLUE makecol(0, 191, 255)
#define SKYBLUE makecol(135, 206, 235)
#define LIGHTSKYBLUE makecol(135, 206, 250)
#define STEELBLUE makecol(70, 130, 180)
#define LIGHTSTEELBLUE makecol(176, 196, 222)
#define LIGHTBLUE makecol(173, 216, 230)
#define POWDERBLUE makecol(176, 224, 230)
#define PALETURQUOISE makecol(175, 238, 238)
#define DARKTURQUOISE makecol(0, 206, 209)
#define MEDIUMTURQUOISE makecol(72, 209, 204)
#define TURQUOISE makecol(64, 224, 208)
#define CYAN makecol(0, 255, 255)
#define LIGHTCYAN makecol(224, 255, 255)
#define CADETBLUE makecol(95, 158, 160)
#define MEDIUMAQUAMARINE makecol(102, 205, 170)
#define AQUAMARINE makecol(127, 255, 212)
#define DARKGREEN makecol(0, 100, 0)
#define DARKOLIVEGREEN makecol(85, 107, 47)
#define DARKSEAGREEN makecol(143, 188, 143)
#define SEAGREEN makecol(46, 139, 87)
#define MEDIUMSEAGREEN makecol(60, 179, 113)
#define LIGHTSEAGREEN makecol(32, 178, 170)
#define PALEGREEN makecol(152, 251, 152)
#define SPRINGGREEN makecol(0, 255, 127)
#define LAWNGREEN makecol(124, 252, 0)
#define GREEN makecol(0, 255, 0)
#define CHARTREUSE makecol(127, 255, 0)
#define MEDIUMSPRINGGREEN makecol(0, 250, 154)
#define GREENYELLOW makecol(173, 255, 47)
#define LIMEGREEN makecol(50, 205, 50)
#define YELLOWGREEN makecol(154, 205, 50)
#define FORESTGREEN makecol(34, 139, 34)
#define OLIVEDRAB makecol(107, 142, 35)
#define DARKKHAKI makecol(189, 183, 107)
#define KHAKI makecol(240, 230, 140)
#define PALEGOLDENROD makecol(238, 232, 170)
#define LIGHTGOLDENRODYELLOW makecol(250, 250, 210)
#define LIGHTYELLOW makecol(255, 255, 224)
#define YELLOW makecol(255, 255, 0)
#define GOLD makecol(255, 215, 0)
#define LIGHTGOLDENROD makecol(238, 221, 130)
#define GOLDENROD makecol(218, 165, 32)
#define DARKGOLDENROD makecol(184, 134, 11)
#define ROSYBROWN makecol(188, 143, 143)
#define INDIAN makecol(205, 92, 92)
#define INDIANRED makecol(205, 92, 92)
#define SADDLEBROWN makecol(139, 69, 19)
#define SIENNA makecol(160, 82, 45)
#define PERU makecol(205, 133, 63)
#define BURLYWOOD makecol(222, 184, 135)
#define BEIGE makecol(245, 245, 220)
#define WHEAT makecol(245, 222, 179)
#define SANDYBROWN makecol(244, 164, 96)
#define TAN makecol(210, 180, 140)
#define CHOCOLATE makecol(210, 105, 30)
#define FIREBRICK makecol(178, 34, 34)
#define BROWN makecol(165, 42, 42)
#define DARKSALMON makecol(233, 150, 122)
#define SALMON makecol(250, 128, 114)
#define LIGHTSALMON makecol(255, 160, 122)
#define ORANGE makecol(255, 165, 0)
#define DARKORANGE makecol(255, 140, 0)
#define CORAL makecol(255, 127, 80)
#define LIGHTCORAL makecol(240, 128, 128)
#define TOMATO makecol(255, 99, 71)
#define ORANGERED makecol(255, 69, 0)
#define RED makecol(200, 0, 0)
#define HOTPINK makecol(255, 105, 180)
#define DEEPPINK makecol(255, 20, 147)
#define PINK makecol(255, 192, 203)
#define LIGHTPINK makecol(255, 182, 193)
#define PALEVIOLETRED makecol(219, 112, 147)
#define MAROON makecol(176, 48, 96)
#define MEDIUMVIOLETRED makecol(199, 21, 133)
#define VIOLETRED makecol(208, 32, 144)

#define VIOLET makecol(238, 130, 238)
#define PLUM makecol(221, 160, 221)
#define ORCHID makecol(218, 112, 214)
#define MEDIUMORCHID makecol(186, 85, 211)
#define DARKORCHID makecol(153, 50, 204)
#define DARKVIOLET makecol(148, 0, 211)
#define BLUEVIOLET makecol(138, 43, 226)
#define PURPLE makecol(160, 32, 240)
#define MEDIUMPURPLE makecol(147, 112, 219)
#define THISTLE makecol(216, 191, 216)
#define DARKGREY makecol(169, 169, 169)
#define DARKGRAY makecol(169, 169, 169)
#define DARKBLUE makecol(0, 0, 139)
#define DARKCYAN makecol(0, 139, 139)
#define DARKMAGENTA makecol(139, 0, 139)
#define DARKRED makecol(139, 0, 0)
#define LIGHTGREEN makecol(144, 238, 144)

#define MASK makecol(255, 0, 255)


/* DISCLAIMER

CMUgraphics Library 1.2 
Copyright (c) 1998 and 1999 by Geoff Washburn.  All rights reserved.

  1. Redistribution of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistribution in binary form must reproduce the above 
     copyright notice, this list of conditions and the following 
     disclaimer in the documentation and/or other materials 
     provided with the distribution.
  3. When redistributing a modified version of this library it must 
     carry prominent notices stating the name of individual(s) that 
     altered the files, the nature of the modifications, and the 
     date they were performed.
  4. No fee is charged for redistribution or use without prior 
     written permission from the author.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS 
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;  OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

// MODIFICATIONS - Steven Silvey
// The list was changed to ints instead of the defined color
// class in the CMUgraphics library to better suit its purpose
// here.

#endif /* End of _ALLEGRO_COLOR_H */
