; Toggles.nsi
;
; Thanks to Greg Kennedy, who pointed to this script which he used
; for Euro1943 (gamedev's 4E competition).
;
; From nsis' example2.nsi
;
; This script is based on example1.nsi, but it remember the directory, 
; has uninstall support and (optionally) installs start menu shortcuts.
;
; It will install Toggles.nsi into a directory that the user selects,

;--------------------------------

; The name of the installer
Name "Toggles"

; The file to write
OutFile "Toggles_install.exe"

; The default installation directory
InstallDir $PROGRAMFILES\Toggles

; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM "Software\Toggles" "Install_Dir"

;--------------------------------

; Pages

Page components
Page directory
Page instfiles

UninstPage uninstConfirm
UninstPage instfiles

;--------------------------------

; The stuff to install
Section "Toggles (required)"

  SectionIn RO
  
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ; Put file there
  File /r /x Toggles_install.* *.*
  
  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\Toggles "Install_Dir" "$INSTDIR"
  
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Toggles" "DisplayName" "Toggles"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Toggles" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Toggles" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Toggles" "NoRepair" 1
  WriteUninstaller "uninstall.exe"
  
SectionEnd

; Optional section (can be disabled by the user)
Section "Start Menu Shortcuts"

  CreateDirectory "$SMPROGRAMS\Toggles"
  CreateShortCut "$SMPROGRAMS\Toggles\Readme.lnk" "$INSTDIR\readme.txt" "" "$INSTDIR\readme.txt" 0
  CreateShortCut "$SMPROGRAMS\Toggles\Toggles.lnk" "$INSTDIR\Toggles.exe" "" "$INSTDIR\Toggles.exe" 0
  CreateShortCut "$SMPROGRAMS\Toggles\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0

  
SectionEnd

;--------------------------------

; Uninstaller

Section "Uninstall"
  
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Toggles"
  DeleteRegKey HKLM SOFTWARE\Toggles

  ; Remove files and uninstaller
  Delete $INSTDIR\*.*

  ; Remove shortcuts, if any
  Delete "$SMPROGRAMS\Toggles\*.*"

  ; Remove directories used
  RMDir "$SMPROGRAMS\Toggles"
  RMDir /r "$INSTDIR"

SectionEnd
