#include "main.h"

CIntro *g_pIntro;
CMenu *g_pMenu;
CGame *g_pGame;
COutro *g_pOutro;

EGameState g_GameState = NONE;

BITMAP *g_Screen;

volatile int g_iLogicCount = 0;

void IncrementCounter()
{
 g_iLogicCount++;
}
END_OF_FUNCTION(IncrementCounter)

int ChangeGameState(EGameState NewGameState)
{
 switch(g_GameState)
 {
  case NONE: break;
  case INTRO: delete g_pIntro; break;
  case MENUS: delete g_pMenu; break;
  case GAME:
       if(g_pGame->m_Level.m_pBlocks) delete[] g_pGame->m_Level.m_pBlocks;
       if(g_pGame->m_Level.m_pBlocksBackground) delete[] g_pGame->m_Level.m_pBlocksBackground;
       delete g_pGame;
       break;
  case OUTRO: delete g_pOutro; break;
 }
 g_GameState = NewGameState;

 switch(g_GameState)
 {
  case NONE:
 break;
  case INTRO: g_pIntro = new CIntro; break;
  case MENUS:
       g_pMenu = new CMenu;
       g_pMenu->m_iChoice = 0;
       g_pMenu->m_bDownPressed = false;
       g_pMenu->m_bUpPressed = false;
       break;
  case GAME:
       {
        char buf[256];

        g_pGame = new CGame;

        get_executable_name(buf, sizeof(buf));
        replace_filename(buf, buf, "tiles.bmp", sizeof(buf));
        g_pGame->m_Level.m_pTiles = load_bmp(buf, NULL);

        get_executable_name(buf, sizeof(buf));
        replace_filename(buf, buf, "player.bmp", sizeof(buf));
        g_pGame->m_Player.m_pBitmap = load_bmp(buf, NULL);

        get_executable_name(buf, sizeof(buf));
        replace_filename(buf, buf, "garbage.bmp", sizeof(buf));
        g_pGame->m_GarbageManager.m_pBitmap = load_bmp(buf, NULL);

        get_executable_name(buf, sizeof(buf));
        replace_filename(buf, buf, "garbagetruck.bmp", sizeof(buf));
        g_pGame->m_GarbageTruck.m_pBitmap = load_bmp(buf, NULL);

        g_pGame->m_iViewX = 0;
        g_pGame->m_iViewY = 0;
        g_pGame->m_Player.m_iScore = 0;

        g_pGame->m_bGameOver = false;

        break;
       }
  case OUTRO: g_pOutro = new COutro; break;
 }

 return 0;
}

int main()
{
 srand(time(NULL));

 if(allegro_init() != 0)
 {
  allegro_message("Failed to initialize Allegro. Shutting down...");
  return 0;
 }
 if(install_keyboard() != 0)
 {
  allegro_message("Failed to initialize keyboard. Shutting down...");
  allegro_exit();
  return 0;
 }
 if(install_timer() != 0)
 {
  allegro_message("Failed to initialize timer. Shutting down...");
  allegro_exit();
  return 0;
 }

 set_color_depth(32);
 if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0) != 0)
 {
  set_color_depth(24);
  if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0) != 0)
  {
   set_color_depth(16);
   if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0) != 0)
   {
    allegro_message("Failed to set video mode. Shutting down...");
    allegro_exit();
    return 0;
   }
  }
 }
 LOCK_VARIABLE(g_iLogicCount);
 LOCK_FUNCTION(IncrementCounter);
 install_int_ex(IncrementCounter, BPS_TO_TIMER(100));

 g_Screen = create_bitmap(SCREEN_W, SCREEN_H);
 clear_bitmap(g_Screen);

 ChangeGameState(MENUS);

 while(g_GameState != NONE)
 {
  while(g_iLogicCount)
  {
   switch(g_GameState)
   {
    case INTRO: break;
    case MENUS: g_pMenu->Logic(); break;
    case GAME: g_pGame->Logic(); break;
    case OUTRO: break;
   }
   g_iLogicCount--;
  }

   switch(g_GameState)
   {
    case INTRO: break;
    case MENUS: g_pMenu->Draw(g_Screen); break;
    case GAME: g_pGame->Draw(g_Screen); break;
    case OUTRO: break;
   }

  blit(g_Screen, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  clear_bitmap(g_Screen);
 }

 remove_int(IncrementCounter);
 allegro_exit();

 return 0;
}
END_OF_MAIN()
