#include "main.h"

int CGame::LoadLevel(char *pFileName)
{
 FILE *file;
 int i;
 char buf[256];
 int iTimeLeft;

 get_executable_name(buf, sizeof(buf));
 replace_filename(buf, buf, pFileName, sizeof(buf));
 file = fopen(buf, "rb+");

 if(file == NULL)
  return 1;

 fscanf(file, "%s", buf);

 if(strcmp(buf, "GGCED") != 0)
 {
  fclose(file);
  return 1;
 }

 fscanf(file, "%d %d ", &m_Level.m_iStartX, &m_Level.m_iStartY);

 m_Player.m_fX = (float)m_Level.m_iStartX;
 m_Player.m_fY = (float)m_Level.m_iStartY;
 m_Player.m_bDir = 1;
 m_Player.m_fYSpeed = 0;

 fscanf(file, "%d ", &iTimeLeft);

 fscanf(file, "%d %d ", &m_Level.m_iWidth, &m_Level.m_iHeight);

 m_GarbageTruck.m_fX = m_Player.m_fX + 200;
 m_GarbageTruck.m_fY = m_Level.m_iHeight * 32 - 32 - 80;

 m_Level.m_pBlocks = new int[m_Level.m_iWidth * m_Level.m_iHeight];
 m_Level.m_pBlocksBackground = new int[m_Level.m_iWidth * m_Level.m_iHeight];

 for(i = 0;i < m_Level.m_iWidth * m_Level.m_iHeight;i++)
  fscanf(file, "%d ", &m_Level.m_pBlocks[i]);

 for(i = 0;i < m_Level.m_iWidth * m_Level.m_iHeight;i++)
  fscanf(file, "%d ", &m_Level.m_pBlocksBackground[i]);

 for(i = 0;i < MAXTHROWERS;i++)
 {
  fscanf(file, "%d %d %d ", &m_ThrowerManager.m_Thrower[i].m_iX, &m_ThrowerManager.m_Thrower[i].m_iY, &m_ThrowerManager.m_Thrower[i].m_iType);
  m_ThrowerManager.m_Thrower[i].m_fTimer = -1;
 }

 if(m_GarbageManager.m_fOzoneOMeter - 100 > 0) m_GarbageManager.m_fOzoneOMeter -= 100;
 else m_GarbageManager.m_fOzoneOMeter = 0;

 for(i = 0;i < MAXGARBAGE;i++)
 {
  fscanf(file, "%d %d %d ", &m_GarbageManager.m_Garbage[i].m_iX, &m_GarbageManager.m_Garbage[i].m_iY, &m_GarbageManager.m_Garbage[i].m_iType);
  m_GarbageManager.m_Garbage[i].m_iX += ((rand() % 1000) - 500) / 25;
  m_GarbageManager.m_Garbage[i].m_fTimer = (float)(rand() % 5000) / 1000.f + (float)iTimeLeft;
  m_GarbageManager.m_Garbage[i].m_Fire.m_iX = m_GarbageManager.m_Garbage[i].m_iX + 9;
  m_GarbageManager.m_Garbage[i].m_Fire.m_iY = m_GarbageManager.m_Garbage[i].m_iY - 10;
  m_GarbageManager.m_Garbage[i].m_Fire.m_iState = 0;
  for(int j = 0;j < 32;j++)
   m_GarbageManager.m_Garbage[i].m_Fire.m_iCircleCol[j] = -1;

  for(int k = 0;k < 320;k++)
  {
   m_GarbageManager.m_Garbage[i].m_Fire.m_Smoke.m_fAlpha[k] = (float)(rand() % 40);
   m_GarbageManager.m_Garbage[i].m_Fire.m_Smoke.m_fX[k] = rand() % 40;
   m_GarbageManager.m_Garbage[i].m_Fire.m_Smoke.m_fY[k] = rand() % 20;
   m_GarbageManager.m_Garbage[i].m_Fire.m_Smoke.m_iWidth[k] = rand() % 40 + 1;
   m_GarbageManager.m_Garbage[i].m_Fire.m_Smoke.m_iHeight[k] = rand() % 40 + 1;
  }

  m_GarbageManager.m_Garbage[i].m_Fire.m_Smoke.m_iX = m_GarbageManager.m_Garbage[i].m_iX - 4;
  m_GarbageManager.m_Garbage[i].m_Fire.m_Smoke.m_iY = m_GarbageManager.m_Garbage[i].m_iY - 20;
  m_GarbageManager.m_Garbage[i].m_bBeingCarried = false;
 }

 m_Player.m_State = 0;

 fclose(file);

 return 0;
}

int CGame::Logic()
{
 int i = 0;

 if(m_Level.m_pBlocks == NULL || m_GarbageTruck.m_fX < -200 || key[KEY_S])
 {
  if(++m_iNumLevel < 27)
  {
   char buf[32];

   if(m_Level.m_pBlocks) delete[] m_Level.m_pBlocks;
   if(m_Level.m_pBlocksBackground) delete[] m_Level.m_pBlocksBackground;

   sprintf(buf, "level%d.txt", m_iNumLevel);
   LoadLevel(buf);
  }
  else m_bGameOver = true;

  while(key[KEY_S]);
 }
 if(!m_bGameOver)
  i = m_Player.Logic();

 if(i == 1 && m_Player.m_State == 0)
  for(int j = 0;j < MAXGARBAGE;j++)
   if(m_GarbageManager.m_Garbage[j].m_iType)
    if(m_GarbageManager.m_Garbage[j].m_iY + m_GarbageManager.m_pBitmap->h > m_Player.m_fY &&
       m_GarbageManager.m_Garbage[j].m_iY < m_Player.m_fY + 48 &&
       m_GarbageManager.m_Garbage[j].m_iX + m_GarbageManager.m_pBitmap->w > m_Player.m_fX &&
       m_GarbageManager.m_Garbage[j].m_iX < m_Player.m_fX + 29)
    {
     m_Player.m_State = 1;
     m_Player.m_iIsHolding = j;
     m_Player.m_bDir = (SGN(m_Player.m_fX - m_GarbageTruck.m_fX - 170) == -1);
     m_GarbageManager.m_Garbage[j].m_bBeingCarried = true;
     m_Player.m_fOldX = m_Player.m_fX;
     m_Player.m_fOldY = m_Player.m_fY;
     m_Player.m_fTimer = 0.f;

     break;
    }

 m_Level.Logic();
 m_GarbageManager.Logic();
 m_ThrowerManager.Logic();
 m_GarbageTruck.Logic((int)m_Player.m_fX);

 if(m_GarbageManager.m_fOzoneOMeter > 360)
 {
  m_GarbageManager.m_fOzoneOMeter = 360;
  m_bGameOver = true;
 }

 if(m_Player.m_State == 1)
 {
  if(m_Player.m_bDir == 1)
  {
   m_GarbageManager.m_Garbage[m_Player.m_iIsHolding].m_iX = (int)m_Player.m_fX + 20;
   m_GarbageManager.m_Garbage[m_Player.m_iIsHolding].m_iY = (int)m_Player.m_fY ;
  }
  else if(m_Player.m_fTimer != 3.f)
  {
   m_GarbageManager.m_Garbage[m_Player.m_iIsHolding].m_iX = (int)m_Player.m_fX - 40;
   m_GarbageManager.m_Garbage[m_Player.m_iIsHolding].m_iY = (int)m_Player.m_fY ;
  }

  if(m_Player.m_fTimer == 0.f)
  {
   if(m_Player.m_fY < m_GarbageTruck.m_fY) m_Player.m_fY += 3;
   else
   {
    m_Player.m_fY = m_GarbageTruck.m_fY;
    m_Player.m_fTimer++;
   }
  }
  else if(m_Player.m_fTimer == 1.f)
  {
   if(ABS(m_Player.m_fX - m_GarbageTruck.m_fX - 170) > 3) m_Player.m_fX -= PXSPEED * SGN(m_Player.m_fX - m_GarbageTruck.m_fX - 170);
   else
   {
    m_Player.m_fX = m_GarbageTruck.m_fX + 170;
    m_Player.m_bDir = 0;
    m_Player.m_fTimer++;
   }
  }
  else if(m_Player.m_fTimer == 2.f)
  {
   if(m_Player.m_fY < m_GarbageTruck.m_fY + 20) m_Player.m_fY++;
   else
   {
    m_Player.m_fY = m_GarbageTruck.m_fY + 20;
    m_Player.m_fTimer++;
   }
  }
  else if(m_Player.m_fTimer == 3.f)
  {
   m_GarbageManager.m_Garbage[m_Player.m_iIsHolding].m_iX -= 3;
   m_GarbageManager.m_Garbage[m_Player.m_iIsHolding].m_iY--;

   if(m_GarbageManager.m_Garbage[m_Player.m_iIsHolding].m_iX < m_GarbageTruck.m_fX + 80)
   {
    m_Player.m_fTimer++;
    m_GarbageManager.m_Garbage[m_Player.m_iIsHolding].m_iType = 0;
    m_Player.m_iScore += 1000 - (int)m_GarbageManager.m_fOzoneOMeter * 4;
   }
  }
  else if(m_Player.m_fTimer == 4.f)
  {
   if(m_Player.m_fY > m_GarbageTruck.m_fY) m_Player.m_fY -= 3;
   else
   {
    m_Player.m_fY = m_GarbageTruck.m_fY;
    m_Player.m_fTimer++;
    m_Player.m_bDir = 0;
    if(m_GarbageManager.CheckGarbageLeft() == 0)
    {
     m_Player.m_fTimer = 0;
     m_Player.m_State = 3;
    }
   }
  }
  else if(m_Player.m_fTimer == 5.f)
  {
   if(ABS(m_Player.m_fX - m_Player.m_fOldX) > 3) m_Player.m_fX -= PXSPEED * SGN(m_Player.m_fX - m_Player.m_fOldX);
   else
   {
    m_Player.m_fX = m_Player.m_fOldX;
    m_Player.m_fTimer++;
   }
  }
  else if(m_Player.m_fTimer == 6.f)
  {
   if(m_Player.m_fY > m_Player.m_fOldY) m_Player.m_fY -= 3;
   if(m_Player.m_fY <= m_Player.m_fOldY)
   {
    m_Player.m_fY = m_Player.m_fOldY;
    m_Player.m_State = 0;
    m_Player.m_fTimer = 0;
   }
  }
 }
 else if(m_Player.m_State == 3)
 {
  if(m_Player.m_fTimer == 0.f)
  {
   if(ABS(m_Player.m_fX - m_GarbageTruck.m_fX - 10) > 3) m_Player.m_fX -= PXSPEED * SGN(m_Player.m_fX - m_GarbageTruck.m_fX - 10);
   else
   {
    m_Player.m_fX = m_GarbageTruck.m_fX + 10;
    m_Player.m_fTimer++;
   }
  }
  if(m_Player.m_fTimer == 1.f)
  {
   m_GarbageTruck.m_fX-=2;
   m_Player.m_fX = m_GarbageTruck.m_fX;
  }
 }

 for(i = m_Level.m_iWidth * (m_Level.m_iHeight - 1);i != -m_Level.m_iWidth;i++)
 {
  if(m_Level.m_pBlocks[i] != 0)
  {
   if(m_Player.m_State != 1 && m_Player.m_State != 3)
   {
    // from left
    if(m_Player.m_fX + m_Player.m_pBitmap->w >= (i % m_Level.m_iWidth) * 32.f + 8 &&
       m_Player.m_fX + m_Player.m_pBitmap->w - PXSPEED < (i % m_Level.m_iWidth) * 32.f + 8 &&
       m_Player.m_fY < (i / m_Level.m_iWidth) * 32.f + 40 &&
       m_Player.m_fY + m_Player.m_pBitmap->h > (i / m_Level.m_iWidth) * 32.f + 8)
    {
     m_Player.m_fX -= PXSPEED;
    }
    // from right
    if(m_Player.m_fX <= (i % m_Level.m_iWidth) * 32 + 40 &&
       m_Player.m_fX + PXSPEED > (i % m_Level.m_iWidth) * 32 + 40 &&
       m_Player.m_fY < (i / m_Level.m_iWidth) * 32.f + 48 &&
       m_Player.m_fY + m_Player.m_pBitmap->h > (i / m_Level.m_iWidth) * 32.f + 16)
    {
     m_Player.m_fX += PXSPEED;
    }

    // from top
    if(m_Player.m_fY + m_Player.m_pBitmap->h > (i / m_Level.m_iWidth) * 32.f + 8.f &&
       m_Player.m_fY + m_Player.m_pBitmap->h - PYACCEL / 2.f * 0.0001f - m_Player.m_fYSpeed * 0.01f < (i / m_Level.m_iWidth) * 32 + 8 &&
       m_Player.m_fX + m_Player.m_pBitmap->w > (i % m_Level.m_iWidth) * 32.f + 8.f &&
       m_Player.m_fX < (i % m_Level.m_iWidth) * 32.f + 40.f)
    {
     m_Player.m_fY = (i / m_Level.m_iWidth) * 32.f - m_Player.m_pBitmap->h + 8.f;
     m_Player.m_fYSpeed = 0;
    }
   }
   for(int j = 0;j < MAXTHROWERS;j++)
   {
    if(m_ThrowerManager.m_Thrower[j].m_iType == 1)
    {
     if(m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fY + 8 > (i / m_Level.m_iWidth) * 32.f + 8.f &&
        m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fY + 8 - PYACCEL / 2.f * 0.0001f - m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fYSpeed * 0.01f > (i / m_Level.m_iWidth) * 32.f + 8.f &&
        m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fX + 10 > (i % m_Level.m_iWidth) * 32.f + 8.f &&
        m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fX < (i % m_Level.m_iWidth) * 32.f + 40.f)
     {
      m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fYSpeed = 0;
      m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fY = (i / m_Level.m_iWidth) * 32.f;
     }
     if(m_Player.m_State != 1 && m_Player.m_State != 3)
      if(m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fY + 8 > m_Player.m_fY &&
         m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fY + 8 - PYACCEL / 2.f * 0.0001f - m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fYSpeed * 0.01f< m_Player.m_fY &&
         m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fX + 8 > m_Player.m_fX &&
         m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fX < m_Player.m_fX + m_Player.m_pBitmap->w &&
         !m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_bHasHit)
      {
       m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fY = m_Player.m_fY - 8;
       m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fYSpeed = -200;
       m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_bHasHit = true;
       m_Player.m_State = 2; // Paralyzed
       m_Player.m_fTimer = 0.f;
      }
    }
    else if(m_ThrowerManager.m_Thrower[j].m_iType == 2)
    {
     if(m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fX + 8 >= (i % m_Level.m_iWidth) * 32.f + 8 &&
        m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fX + 8 - m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fXSpeed < (i % m_Level.m_iWidth) * 32.f + 8 &&
        m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fY < (i / m_Level.m_iWidth) * 32.f + 40 &&
        m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fY + m_Player.m_pBitmap->w > (i / m_Level.m_iWidth) * 32.f + 8)
     {
      m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fXSpeed = 0;
     }
     if(m_Player.m_State != 1 && m_Player.m_State != 3 && m_ThrowerManager.m_Thrower[j].m_fTimer > 4)
      if(m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fX + 8 >= m_Player.m_fX &&
         m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fX + 8 - m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fXSpeed < m_Player.m_fX + 8 &&
         m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fY < m_Player.m_fY + 29 &&
         m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_fY + m_Player.m_pBitmap->w > m_Player.m_fY)
      {
       m_ThrowerManager.m_Thrower[j].m_MiniGarbage.m_bHasHit = true;
       m_Player.m_State = 2; // Paralyzed
       m_Player.m_fTimer = 0.f;
      }
    }
   }
  }
  if((i % m_Level.m_iWidth) == (m_Level.m_iWidth - 1)) i -= 2 * m_Level.m_iWidth;
 }
 if(m_Player.m_State == 0)
  if(key[KEY_R])
  {
   m_Player.m_State = 2;
   m_Player.m_fTimer = -3;
   m_Player.m_fX = (float)m_Level.m_iStartX;
   m_Player.m_fY = (float)m_Level.m_iStartY;
  }

 if(m_Level.m_iHeight * 32 - 32 > m_iViewY) m_iViewY = m_Level.m_iHeight * 32 - 32;
 if(m_Player.m_fX + m_iViewX > SCREEN_W * 3 / 4) m_iViewX = (int)(SCREEN_W * 3 / 4 - m_Player.m_fX);
 if(m_Player.m_fX + m_iViewX < SCREEN_W / 4) m_iViewX = (int)(SCREEN_W / 4 - m_Player.m_fX);
 if(m_iViewX > -32) m_iViewX = -32;

 if(key[KEY_ESC])
 {
  while(key[KEY_ESC]);
  ChangeGameState(MENUS);
 }

 return 0;
}

int CGame::Draw(BITMAP *pScreen)
{
 m_Level.Draw(pScreen, m_iViewX, m_iViewY);
 m_ThrowerManager.Draw(pScreen, m_iViewX, m_iViewY);
 if(m_Player.m_State != 3 || m_Player.m_fTimer != 1)
  m_Player.Draw(pScreen, m_iViewX, m_iViewY);

 m_GarbageManager.Draw(pScreen, m_iViewX, m_iViewY);
 m_GarbageTruck.Draw(pScreen, m_iViewX, m_iViewY);

 if(m_iNumLevel < 27)
  textprintf_ex(pScreen, font, 0, 0, makecol(255, 255, 255), -1, "Level: %d", m_iNumLevel);

 textprintf_ex(pScreen, font, 0, 10, makecol(255, 255, 255), -1, "Score: %d", m_Player.m_iScore);
 textprintf_ex(pScreen, font, 0, 20, makecol(255, 255, 255), -1, "Garbage Left: %d", m_GarbageManager.CheckGarbageLeft());
 rect(pScreen, SCREEN_W - 155, 105, SCREEN_W - 105, 305, makecol(255, 255, 255));
 rectfill(pScreen, SCREEN_W - 150, 300, SCREEN_W - 110, 290 - (int)m_GarbageManager.m_fOzoneOMeter / 2, makecol(255, 0, 0));
 textprintf_centre_ex(pScreen, font, SCREEN_W - 130, 80, makecol(255, 255, 255), -1, "Ozone-O-Meter");

 if(m_bGameOver && m_iNumLevel < 27)
  textprintf_centre_ex(pScreen, font, SCREEN_W / 2, 290, makecol(255, 255, 255), -1, "GAME OVER");
 else if(m_bGameOver && m_iNumLevel >= 27)
 {
  textprintf_centre_ex(pScreen, font, SCREEN_W / 2, 290, makecol(255, 255, 255), -1, "YOU HAVE WON!");
  textprintf_centre_ex(pScreen, font, SCREEN_W / 2, 310, makecol(255, 255, 255), -1, "THANKS FOR PLAYING!");
 }

 return 0;
}
