#include "main.h"

int CMenu::Logic()
{
 if(key[KEY_DOWN])
 {
  if(!m_bDownPressed)
  {
   if(++m_iChoice > 3) m_iChoice = 0;
   m_bDownPressed = true;
  }
 }
 else m_bDownPressed = false;

 if(key[KEY_UP])
 {
  if(!m_bUpPressed)
  {
   if(--m_iChoice < 0) m_iChoice = 3;
   m_bUpPressed = true;
  }
 }
 else m_bUpPressed = false;

 if(key[KEY_ENTER])
 {
  while(key[KEY_ENTER]);
  switch(m_iChoice)
  {
   case 0: ChangeGameState(GAME); return 0;
   case 1:
        clear_bitmap(screen);
        textprintf_ex(screen, font, 200, 100, makecol(255, 255, 255), -1, "You are a garbage man in Garbage City");
        textprintf_ex(screen, font, 200, 120, makecol(255, 255, 255), -1, "You have to clean the city.");
        textprintf_ex(screen, font, 200, 140, makecol(255, 255, 255), -1, "Use the left and right arrow keys to move");
        textprintf_ex(screen, font, 200, 160, makecol(255, 255, 255), -1, "and space for jumping.");
        textprintf_ex(screen, font, 200, 180, makecol(255, 255, 255), -1, "Collect garbage with down arrow key.");
        textprintf_ex(screen, font, 200, 200, makecol(255, 255, 255), -1, "Mind the inhabitants of Garbage City,");
        textprintf_ex(screen, font, 200, 220, makecol(255, 255, 255), -1, "they always tend to be throwing");
        textprintf_ex(screen, font, 200, 240, makecol(255, 255, 255), -1, "garbage out of their window.");
        textprintf_ex(screen, font, 200, 260, makecol(255, 255, 255), -1, "If you stuck in a position");
        textprintf_ex(screen, font, 200, 280, makecol(255, 255, 255), -1, "Press R to go to the beginning of the level.");
        textprintf_ex(screen, font, 200, 300, makecol(255, 255, 255), -1, "But mind that you have to wait 5 seconds then!");
        textprintf_ex(screen, font, 200, 320, makecol(255, 255, 255), -1, "Be as fast as possible, if the Ozone-O-Meter");
        textprintf_ex(screen, font, 200, 340, makecol(255, 255, 255), -1, "rises over its border, you lose.");
        textprintf_ex(screen, font, 200, 360, makecol(255, 255, 255), -1, "If you want to skip a level");
        textprintf_ex(screen, font, 200, 380, makecol(255, 255, 255), -1, "be a cheater and press S ;-)");
        textprintf_ex(screen, font, 200, 400, makecol(255, 255, 255), -1, "Always check out my homepage");
        textprintf_ex(screen, font, 200, 420, makecol(255, 255, 255), -1, "http://tonwas.freefronthost.com");
        textprintf_ex(screen, font, 200, 460, makecol(255, 255, 255), -1, "Press enter to return to the main menu.");

        while(!key[KEY_ENTER]);
        while(key[KEY_ENTER]);
        break;
   case 2: allegro_message("Sorry, this feature is disabled."); break;
   case 3: ChangeGameState(NONE); break;
  }
 }

 if(key[KEY_ESC])
 {
  while(key[KEY_ESC]);
  ChangeGameState(NONE);
 }

 return 0;
}

int CMenu::Draw(BITMAP *pScreen)
{
 for(int i = 0;i < 4;i++)
  ellipsefill(pScreen, SCREEN_W / 2, SCREEN_H / 6 * (i + 2), SCREEN_W / 3, SCREEN_H / 16, makecol(128, 128, 128));

 textprintf_centre_ex(pScreen, font, SCREEN_W / 2, SCREEN_H / 6 * 2, (m_iChoice == 0) ? 0 : makecol(255, 255, 255), -1, "Start");
 textprintf_centre_ex(pScreen, font, SCREEN_W / 2, SCREEN_H / 6 * 3, (m_iChoice == 1) ? 0 : makecol(255, 255, 255), -1, "Instructions");
 textprintf_centre_ex(pScreen, font, SCREEN_W / 2, SCREEN_H / 6 * 4, (m_iChoice == 2) ? 0 : makecol(255, 255, 255), -1, "Fullscreen");
 textprintf_centre_ex(pScreen, font, SCREEN_W / 2, SCREEN_H / 6 * 5, (m_iChoice == 3) ? 0 : makecol(255, 255, 255), -1, "Exit");

 return 0;
}
