#include "main.h"

int CGarbage::Logic()
{
 if(!m_bBeingCarried)
 {
  m_fTimer -= 0.01f;

  if(m_fTimer > 20) m_Fire.m_iNumCircles = 0;
  if(m_fTimer < 20 && m_fTimer > 0) m_Fire.m_iNumCircles = (int)(48.f - 48.f * m_fTimer / 20.f);
  if(m_fTimer < 0) m_Fire.m_iNumCircles = 48;
 }
 else
 {
  m_fTimer += 0.01f;

  if(!((int)(m_fTimer * 100) % 5))
   if(m_Fire.m_iNumCircles) m_Fire.m_iNumCircles--;
 }

 return m_Fire.Logic();

 return 0;
}

int CGarbage::Draw(BITMAP *pScreen, BITMAP *pBitmap, int iViewX, int iViewY)
{
 if(!m_bBeingCarried)
  draw_sprite(pScreen, pBitmap, m_iX + iViewX, m_iY + iViewY);
 else
  stretch_sprite(pScreen, pBitmap, m_iX + iViewX, m_iY + iViewY, 40, 50);

 m_Fire.Draw(pScreen, iViewX, iViewY);

 return 0;
}

int CGarbageManager::Logic()
{
 int i;

 for(i= 0;i < MAXGARBAGE;i++)
  if(m_Garbage[i].m_iType != 0)
   m_fOzoneOMeter += (float)(m_Garbage[i].Logic()) / 10.f;

 return 0;
}

int CGarbageManager::Draw(BITMAP *pScreen, int iViewX, int iViewY)
{
 int i;

 for(i = 0;i < MAXGARBAGE;i++)
  if(m_Garbage[i].m_iType != 0)
   if(m_Garbage[i].m_iX + iViewX > -m_pBitmap->w && m_Garbage[i].m_iX + iViewX < SCREEN_W)
    if(m_Garbage[i].m_iY + iViewY > -m_pBitmap->h && m_Garbage[i].m_iY + iViewY < SCREEN_W)
     m_Garbage[i].Draw(pScreen, m_pBitmap, iViewX, iViewY);

 return 0;
}

int CGarbageManager::CheckGarbageLeft()
{
 int iCount = 0;

 for(int i = 0;i < MAXGARBAGE;i++)
  if(m_Garbage[i].m_iType != 0)
   iCount++;

 return iCount;
}
