#include <stdio.h>
#include <string.h>
#include <allegro.h>

#define MAXGARBAGE 100
#define MAXTHROWERS 100

BITMAP *g_Screen;
BITMAP *g_Tileset;

class CLevel
{
public:
 CLevel() {};
 ~CLevel() {};

 int m_iPlayerX, m_iPlayerY;

 int m_iTime;

 int m_iWidth, m_iHeight;
 int *m_pBlocks;
 int *m_pBlocksBackground;

 float m_fTemperature;

 int m_iThrowerX[MAXTHROWERS], m_iThrowerY[MAXTHROWERS];
 int m_iThrowerType[MAXTHROWERS];

 int m_iGarbageX[MAXGARBAGE], m_iGarbageY[MAXGARBAGE];
 int m_iGarbageType[MAXGARBAGE];

 char m_pFilename[32];
};

CLevel g_Level;

int g_iViewX = 0, g_iViewY = 0;
enum
{
 TILES,
 BACKGROUND,
 THROWERS,
 GARBAGE,
 PREVIEW
} EActiveMode = TILES;

int CreateEmptyLevel()
{
 int i;

 printf("Enter level width: ");
 scanf("%d", &g_Level.m_iWidth);
 printf("Enter level Height: ");
 scanf("%d", &g_Level.m_iHeight);


 g_Level.m_pBlocks = new int[g_Level.m_iWidth * g_Level.m_iHeight];
 g_Level.m_pBlocksBackground = new int[g_Level.m_iWidth * g_Level.m_iHeight];

 for(i = 0;i < g_Level.m_iWidth * (g_Level.m_iHeight - 3);i++)
  g_Level.m_pBlocks[i] = 0;

 for(i = g_Level.m_iWidth * (g_Level.m_iHeight - 3);i < g_Level.m_iWidth * (g_Level.m_iHeight - 2);i++)
  g_Level.m_pBlocks[i] = 3;
 for(i = g_Level.m_iWidth * (g_Level.m_iHeight - 2);i < g_Level.m_iWidth * (g_Level.m_iHeight - 1);i++)
  g_Level.m_pBlocks[i] = 8;
 for(i = g_Level.m_iWidth * (g_Level.m_iHeight - 1);i < g_Level.m_iWidth * g_Level.m_iHeight;i++)
  g_Level.m_pBlocks[i] = 3;

 for(i = 0;i < g_Level.m_iWidth * g_Level.m_iHeight;i++)
  g_Level.m_pBlocksBackground[i] = 0;
 for(i = g_Level.m_iWidth * (g_Level.m_iHeight - 8);i < g_Level.m_iWidth * (g_Level.m_iHeight - 3);i++)
  g_Level.m_pBlocksBackground[i] = 5 + (i % 2) * 5;

 for(i = 0;i < MAXTHROWERS;i++)
 {
  g_Level.m_iThrowerX[i] = 0;
  g_Level.m_iThrowerY[i] = 0;
  g_Level.m_iThrowerType[i] = 0;
 }
 for(i = 0;i < MAXGARBAGE;i++)
 {
  g_Level.m_iGarbageX[i] = 0;
  g_Level.m_iGarbageY[i] = 0;
  g_Level.m_iGarbageType[i] = 0;
 }

 strcpy(g_Level.m_pFilename, "noname.txt");

 return 0;
}

int LoadLevel(char *pFileName)
{
 FILE *file = fopen(pFileName, "rb+");
 int i;
 char buf[32];

 if(file == NULL)
  return 1;

 fscanf(file, "%s", buf);

 if(strcmp(buf, "GGCED") != 0)
 {
  fclose(file);
  return 1;
 }

 fscanf(file, "%d %d ", &g_Level.m_iPlayerX, &g_Level.m_iPlayerY);

 fscanf(file, "%d ", &g_Level.m_iTime);

 fscanf(file, "%d %d ", &g_Level.m_iWidth, &g_Level.m_iHeight);

 g_Level.m_pBlocks = new int[g_Level.m_iWidth * g_Level.m_iHeight];
 g_Level.m_pBlocksBackground = new int[g_Level.m_iWidth * g_Level.m_iHeight];

 for(i = 0;i < g_Level.m_iWidth * g_Level.m_iHeight;i++)
  fscanf(file, "%d ", &g_Level.m_pBlocks[i]);

 for(i = 0;i < g_Level.m_iWidth * g_Level.m_iHeight;i++)
  fscanf(file, "%d ", &g_Level.m_pBlocksBackground[i]);

 for(i = 0;i < MAXTHROWERS;i++)
  fscanf(file, "%d %d %d ", &g_Level.m_iThrowerX[i], &g_Level.m_iThrowerY[i], &g_Level.m_iThrowerType[i]);

 for(i = 0;i < MAXGARBAGE;i++)
  fscanf(file, "%d %d %d ", &g_Level.m_iGarbageX[i], &g_Level.m_iGarbageY[i], &g_Level.m_iGarbageType[i]);

 strcpy(g_Level.m_pFilename, pFileName);

 fclose(file);

 return 0;
}

int SaveLevel(char *pFileName)
{
 FILE *file = fopen(pFileName, "wb+");
 int i;

 fprintf(file, "GGCED ");

 fprintf(file, "%d %d ", g_Level.m_iPlayerX, g_Level.m_iPlayerY);

 fprintf(file, "%d ", g_Level.m_iTime);

 fprintf(file, "%d %d ", g_Level.m_iWidth, g_Level.m_iHeight);
 for(i = 0;i < g_Level.m_iWidth * g_Level.m_iHeight;i++)
 {
  if(g_Level.m_pBlocks[i] < 0) g_Level.m_pBlocks[i] = 0;
  fprintf(file, "%d ", g_Level.m_pBlocks[i]);
 }

 for(i = 0;i < g_Level.m_iWidth * g_Level.m_iHeight;i++)
 {
  if(g_Level.m_pBlocksBackground[i] < 0) g_Level.m_pBlocksBackground[i] = 0;
  fprintf(file, "%d ", g_Level.m_pBlocksBackground[i]);
 }

 for(i = 0;i < MAXTHROWERS;i++)
  fprintf(file, "%d %d %d ", g_Level.m_iThrowerX[i], g_Level.m_iThrowerY[i], g_Level.m_iThrowerType[i]);

 for(i = 0;i < MAXGARBAGE;i++)
  fprintf(file, "%d %d %d ", g_Level.m_iGarbageX[i], g_Level.m_iGarbageY[i], g_Level.m_iGarbageType[i]);

 fclose(file);

 return 0;
}

int main(int argc, char *argv[])
{
 int i;

 for(i = 0;i < argc;i++)
  if(LoadLevel(argv[i]) == 0)
   break;

 if(g_Level.m_pBlocks == NULL) CreateEmptyLevel();

 if(allegro_init() != 0)
 {
  allegro_message("Failed to initialize Allegro. Shutting down...");
  return 0;
 }
 if(install_keyboard() != 0)
 {
  allegro_message("Failed to initialize keyboard. Shutting down...");
  allegro_exit();
  return 0;
 }
 if(install_mouse() == -1)
 {
  allegro_message("Failed to initialize mouse. Shutting down...");
  allegro_exit();
  return 0;
 }
 if(install_timer() != 0)
 {
  allegro_message("Failed to initialize timer. Shutting down...");
  allegro_exit();
  return 0;
 }
 set_color_depth(32);
 if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0)
 {
  set_color_depth(24);
  if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0)
  {
   set_color_depth(16);
   if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0)
   {
    allegro_message("Failed to set video mode. Shutting down...");
    allegro_exit();
    return 0;
   }
  }
 }

 g_Screen = create_bitmap(SCREEN_W, SCREEN_H);
 clear_bitmap(g_Screen);

 g_Tileset = load_bmp("Tiles.bmp", NULL);

 show_mouse(screen);

 while(!key[KEY_ESC])
 {
  switch(EActiveMode)
  {
   case TILES:
    if(mouse_b & 1)
    {
     while(mouse_b & 1);

     if(mouse_x < g_Level.m_iWidth * 32 + g_iViewX && mouse_x > g_iViewX &&
        mouse_y < g_Level.m_iHeight * 32 + g_iViewY && mouse_y > g_iViewY)
      g_Level.m_pBlocks[(mouse_x - g_iViewX) / 32 + (mouse_y - g_iViewY) / 32 * g_Level.m_iWidth]++;
    }
    if(mouse_b & 2)
    {
     while(mouse_b & 2);

     if(mouse_x < g_Level.m_iWidth * 32 + g_iViewX && mouse_x > g_iViewX &&
        mouse_y < g_Level.m_iHeight * 32 + g_iViewY && mouse_y > g_iViewY)
      g_Level.m_pBlocks[(mouse_x - g_iViewX) / 32 + (mouse_y - g_iViewY) / 32 * g_Level.m_iWidth]--;
    }
    break;
   case BACKGROUND:
    if(mouse_b & 1)
    {
     while(mouse_b & 1);

     if(mouse_x < g_Level.m_iWidth * 32 + g_iViewX && mouse_x > g_iViewX &&
        mouse_y < g_Level.m_iHeight * 32 + g_iViewY && mouse_y > g_iViewY)
      g_Level.m_pBlocksBackground[(mouse_x - g_iViewX) / 32 + (mouse_y - g_iViewY) / 32 * g_Level.m_iWidth]++;
    }
    if(mouse_b & 2)
    {
     while(mouse_b & 2);

     if(mouse_x < g_Level.m_iWidth * 32 + g_iViewX && mouse_x > g_iViewX &&
        mouse_y < g_Level.m_iHeight * 32 + g_iViewY && mouse_y > g_iViewY)
      g_Level.m_pBlocksBackground[(mouse_x - g_iViewX) / 32 + (mouse_y - g_iViewY) / 32 * g_Level.m_iWidth]--;
    }
    break;
   case THROWERS:
    if(mouse_b & 1)
    {
     while(mouse_b & 1);

     for(i = 0;i < MAXTHROWERS;i++)
     {
      if(g_Level.m_iThrowerType[i] == 0)
      {
       g_Level.m_iThrowerX[i] = ((mouse_x - g_iViewX) / 32) * 32;
       g_Level.m_iThrowerY[i] = ((mouse_y - g_iViewY) / 32) * 32;
       g_Level.m_iThrowerType[i] = 1;
       break;
      }
     }
    }
    if(mouse_b & 2)
    {
     while(mouse_b & 2);

     for(i = 0;i < MAXTHROWERS;i++)
      if(g_Level.m_iThrowerType[i] != 0)
       if(g_Level.m_iThrowerX[i] == ((mouse_x - g_iViewX) / 32) * 32 &&
          g_Level.m_iThrowerY[i] == ((mouse_y - g_iViewY) / 32) * 32)
        g_Level.m_iThrowerType[i] = 0;
    }
    if(mouse_b & 4)
    {
     while(mouse_b & 4);

     for(i = 0;i < MAXTHROWERS;i++)
     {
      if(g_Level.m_iThrowerType[i] == 0)
      {
       g_Level.m_iThrowerX[i] = ((mouse_x - g_iViewX) / 32) * 32;
       g_Level.m_iThrowerY[i] = ((mouse_y - g_iViewY) / 32) * 32;
       g_Level.m_iThrowerType[i] = 2;
       break;
      }
     }
    }
    break;
   case GARBAGE:
    if(mouse_b & 1)
    {
     while(mouse_b & 1);

     for(i = 0;i < MAXGARBAGE;i++)
     {
      if(g_Level.m_iGarbageType[i] == 0)
      {
       g_Level.m_iGarbageX[i] = ((mouse_x - g_iViewX) / 32) * 32;
       g_Level.m_iGarbageY[i] = ((mouse_y - g_iViewY) / 32) * 32;
       g_Level.m_iGarbageType[i] = 1;
       break;
      }
     }
    }
    if(mouse_b & 2)
    {
     while(mouse_b & 2);

     for(i = 0;i < MAXGARBAGE;i++)
      if(g_Level.m_iGarbageType[i] != 0)
       if(g_Level.m_iGarbageX[i] == ((mouse_x - g_iViewX) / 32) * 32 &&
          g_Level.m_iGarbageY[i] == ((mouse_y - g_iViewY) / 32) * 32)
        g_Level.m_iGarbageType[i] = 0;
    }
    if(mouse_b & 4)
    {
     while(mouse_b & 4);

     for(i = 0;i < MAXGARBAGE;i++)
     {
      if(g_Level.m_iGarbageType[i] == 0)
      {
       g_Level.m_iGarbageX[i] = ((mouse_x - g_iViewX) / 32) * 32;
       g_Level.m_iGarbageY[i] = ((mouse_y - g_iViewY) / 32) * 32;
       g_Level.m_iGarbageType[i] = 2;
       break;
      }
     }
    }
    break;
 break;
  }

  if(key[KEY_LEFT]) g_iViewX++;
  if(key[KEY_RIGHT]) g_iViewX--;
  if(key[KEY_UP]) g_iViewY++;
  if(key[KEY_DOWN]) g_iViewY--;
  if(key[KEY_C])
  {
   while(key[KEY_C]);
   switch(EActiveMode)
   {
    case TILES: EActiveMode = BACKGROUND; break;
    case BACKGROUND: EActiveMode = THROWERS; break;
    case THROWERS: EActiveMode = GARBAGE; break;
    case GARBAGE: EActiveMode = PREVIEW; break;
    case PREVIEW: EActiveMode = TILES; break;
   }
  }

  switch(EActiveMode)
  {
   case TILES:
    for(i = g_Level.m_iWidth * (g_Level.m_iHeight - 1);i != -g_Level.m_iWidth;i++)
    {
     if(g_Level.m_pBlocks[i] != 0)
      masked_blit(g_Tileset, g_Screen, ((g_Level.m_pBlocks[i] - 1) % 6) * 48, ((g_Level.m_pBlocks[i] - 1) / 6) * 48,(i % g_Level.m_iWidth) * 32 + g_iViewX, (i / g_Level.m_iWidth) * 32 + g_iViewY, 48, 48);

     if((i % g_Level.m_iWidth) == (g_Level.m_iWidth - 1)) i -= 2 * g_Level.m_iWidth;
    }
    break;
   case BACKGROUND:
    for(i = g_Level.m_iWidth * (g_Level.m_iHeight - 1);i != -g_Level.m_iWidth;i++)
    {
     if(g_Level.m_pBlocksBackground[i] != 0)
      masked_blit(g_Tileset, g_Screen, ((g_Level.m_pBlocksBackground[i] - 1) % 6) * 48, ((g_Level.m_pBlocksBackground[i] - 1) / 6) * 48,(i % g_Level.m_iWidth) * 32 + g_iViewX, (i / g_Level.m_iWidth) * 32 + g_iViewY, 48, 48);

     if((i % g_Level.m_iWidth) == (g_Level.m_iWidth - 1)) i -= 2 * g_Level.m_iWidth;
    }
    break;
   case THROWERS:
    for(i = 0;i < MAXTHROWERS;i++)
    {
     switch(g_Level.m_iThrowerType[i])
     {
      case 0: break;
      case 1: line(g_Screen, g_Level.m_iThrowerX[i] + 16 - 5 + g_iViewX, g_Level.m_iThrowerY[i] + 16 - 5 + g_iViewY,
                   g_Level.m_iThrowerX[i] + 16 + 5 + g_iViewX, g_Level.m_iThrowerY[i] + 16 + 5 + g_iViewY, makecol(255, 255, 255));
              line(g_Screen, g_Level.m_iThrowerX[i] + 16 + 5 + g_iViewX, g_Level.m_iThrowerY[i] + 16 - 5 + g_iViewY,
                   g_Level.m_iThrowerX[i] + 16 - 5 + g_iViewX, g_Level.m_iThrowerY[i] + 16 + 5 + g_iViewY, makecol(255, 255, 255));
              break;
      case 2: circle(g_Screen, g_Level.m_iThrowerX[i] + 16 + g_iViewX, g_Level.m_iThrowerY[i] + 16 + g_iViewY, 8, makecol(255, 255, 255));
              break;
     }
    }
    break;
   case GARBAGE:
    for(i = 0;i < MAXGARBAGE;i++)
     if(g_Level.m_iGarbageType[i])
      textprintf_ex(g_Screen, font, g_Level.m_iGarbageX[i] + g_iViewX + 16, g_Level.m_iGarbageY[i] + g_iViewY + 16,
                    makecol(255, 255, 255), -1, "%d", g_Level.m_iGarbageType[i]);
    break;
   case PREVIEW:
    for(i = g_Level.m_iWidth * (g_Level.m_iHeight - 1);i != -g_Level.m_iWidth;i++)
    {
     if(g_Level.m_pBlocksBackground[i] != 0)
      masked_blit(g_Tileset, g_Screen, ((g_Level.m_pBlocksBackground[i] - 1) % 6) * 48, ((g_Level.m_pBlocksBackground[i] - 1) / 6) * 48,(i % g_Level.m_iWidth) * 32 + g_iViewX, (i / g_Level.m_iWidth) * 32 + g_iViewY, 48, 48);

     if((i % g_Level.m_iWidth) == (g_Level.m_iWidth - 1)) i -= 2 * g_Level.m_iWidth;
    }
    for(i = g_Level.m_iWidth * (g_Level.m_iHeight - 1);i != -g_Level.m_iWidth;i++)
    {
     if(g_Level.m_pBlocks[i] != 0)
      masked_blit(g_Tileset, g_Screen, ((g_Level.m_pBlocks[i] - 1) % 6) * 48, ((g_Level.m_pBlocks[i] - 1) / 6) * 48,(i % g_Level.m_iWidth) * 32 + g_iViewX, (i / g_Level.m_iWidth) * 32 + g_iViewY, 48, 48);

     if((i % g_Level.m_iWidth) == (g_Level.m_iWidth - 1)) i -= 2 * g_Level.m_iWidth;
    }
    for(i = 0;i < MAXTHROWERS;i++)
    {
     switch(g_Level.m_iThrowerType[i])
     {
      case 0: break;
      case 1: line(g_Screen, g_Level.m_iThrowerX[i] + 16 - 5 + g_iViewX, g_Level.m_iThrowerY[i] + 16 - 5 + g_iViewY,
                   g_Level.m_iThrowerX[i] + 16 + 5 + g_iViewX, g_Level.m_iThrowerY[i] + 16 + 5 + g_iViewY, makecol(255, 255, 255));
              line(g_Screen, g_Level.m_iThrowerX[i] + 16 + 5 + g_iViewX, g_Level.m_iThrowerY[i] + 16 - 5 + g_iViewY,
                   g_Level.m_iThrowerX[i] + 16 - 5 + g_iViewX, g_Level.m_iThrowerY[i] + 16 + 5 + g_iViewY, makecol(255, 255, 255));
              break;
      case 2: circle(g_Screen, g_Level.m_iThrowerX[i] + 16 + g_iViewX, g_Level.m_iThrowerY[i] + 16 + g_iViewY, 8, makecol(255, 255, 255));
              break;
     }
    }
    for(i = 0;i < MAXGARBAGE;i++)
     if(g_Level.m_iGarbageType[i])
      textprintf_ex(g_Screen, font, g_Level.m_iGarbageX[i] + g_iViewX + 16, g_Level.m_iGarbageY[i] + g_iViewY + 16,
                    makecol(255, 255, 255), -1, "%d", g_Level.m_iGarbageType[i]);
    break;
  }

  drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
  set_trans_blender(0, 0, 0, 128);

  for(i = 0;i < g_Level.m_iHeight + 1;i++)
   hline(g_Screen, g_iViewX, i * 32 + g_iViewY, g_Level.m_iWidth * 32 + g_iViewX, makecol(255, 255, 255));

  for(i = 0;i < g_Level.m_iWidth + 1;i++)
   vline(g_Screen, i * 32 + g_iViewX, g_iViewY, g_Level.m_iHeight * 32 + g_iViewY, makecol(255, 255, 255));

  drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);

  textprintf_ex(g_Screen, font, SCREEN_W - 200, 0, makecol(255, 255, 255), -1, "C: Change mode");
  textprintf_ex(g_Screen, font, SCREEN_W - 200, 10, makecol(255, 255, 255), -1, "Active mode: %s",
                (EActiveMode == TILES) ? "Foreground" : (EActiveMode == BACKGROUND) ? "Background" :
                (EActiveMode == THROWERS) ? "Throwers" : (EActiveMode == GARBAGE) ? "Garbage" :
                "Preview");
  textprintf_ex(g_Screen, font, SCREEN_W - 200, 20, makecol(255, 255, 255), -1, "Mouse at: (%d|%d)", mouse_x - g_iViewX, mouse_y - g_iViewY);
  blit(g_Screen, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  clear_bitmap(g_Screen);
 }

 SaveLevel(g_Level.m_pFilename);

 destroy_bitmap(g_Tileset);
 destroy_bitmap(g_Screen);
 allegro_exit();

 return 0;
}
END_OF_MAIN()
